var ct;
var flag = true;
var parobj = getParentWindow();
var neid = parobj.neid;
var obj = parobj.obj;

var af1obj;
var af2obj;
var af3obj;
var af4obj;

window.onload = function()
{
    initTable();
    initButtonInfo();
    
    af1obj = ct.getAtom("af1").element;
    af2obj = ct.getAtom("af2").element;
    af3obj = ct.getAtom("af3").element;
    af4obj = ct.getAtom("af4").element;
    
    validateNum(af1obj, 1, 100, 3);
    validateNum(af2obj, 1, 100, 3);
    validateNum(af3obj, 1, 100, 3);
    validateNum(af4obj, 1, 100, 3);
}

function initTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "256");
    ct.addAttrRow("policyId", RESOURCE["policyId"], atom);
    ct.setAttrValue("policyId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("policyId").element.style.width = "32%";
    ct.getAtom("policyId").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    ct.getAtom("policyId").element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("policyName", RESOURCE["policyName"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("af1", RESOURCE["afone"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("af2", RESOURCE["aftwo"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("af3", RESOURCE["afthree"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("af4", RESOURCE["affour"], atom);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["policyId"].element.onkeydown = keydownHandler;
    ct.attrArray["policyName"].element.onkeydown = keydownHandler;
    ct.attrArray["af1"].element.onkeydown = keydownHandler;
    ct.attrArray["af2"].element.onkeydown = keydownHandler;
    ct.attrArray["af3"].element.onkeydown = keydownHandler;
    ct.attrArray["af4"].element.onkeydown = keydownHandler;
}

function handleCheckbox()
{
    var atomPolicyId = ct.getAtom("policyId").element;
    if (checkboxElem.checked) 
    {
        atomPolicyId.disabled = true;
        atomPolicyId.value = "";
    }
    else 
    {
        atomPolicyId.disabled = false;
        atomPolicyId.value = "1";
    }
    $("applybtn").disabled = false;
    flag = false;
}

function initButtonInfo()
{
    $("confirmbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
    $("applybtn").disabled = true;
}

function keydownHandler()
{
    $("applybtn").disabled = false;
    flag = false;
}

function newPolicy(param)
{
    if (param && flag) 
    {
        xcloseDialog();
        return;
    }
    
    var rows = parobj.st0.getDataRowLength();
    for (var i = 0; i < rows; i++) 
    {
        if (ct.getAttrValue("policyId") == parobj.st0.getCellStoreValue(i, "policyId", "policyId")) 
        {
            alert(RESOURCE["pidexistcheck"]);
            return;
        }
    }
    
    if (ct.getAttrValue("policyName") == "") 
    {
        alert(RESOURCE["checkname"]);
        return;
    }
    
    if (!checknumobj(af1obj, 1, 100) || !checknumobj(af2obj, 1, 100) ||
    !checknumobj(af3obj, 1, 100) ||
    !checknumobj(af4obj, 1, 100)) 
    {
        return;
    }
    
    if (parseInt(ct.getAttrValue("af1"), 10) + parseInt(ct.getAttrValue("af2"), 10) +
    parseInt(ct.getAttrValue("af3"), 10) +
    parseInt(ct.getAttrValue("af4"), 10) >
    100) 
    {
        alert(RESOURCE["weightsumcheck"]);
        return;
    }
    
    $("applybtn").disabled = true;
    $("confirmbtn").disabled = true;
    
    var xmldata = createNewXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CRT_WFQ_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackNew, param, "inputdata=" + xmldata);
}

function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked) 
    {
        policyId = "0";
    }
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isAuto");
    param.setAttribute("value", policyId == 0 ? 1 : 0);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "af1");
    param.setAttribute("value", ct.getAttrValue("af1"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "af2");
    param.setAttribute("value", ct.getAttrValue("af2"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "af3");
    param.setAttribute("value", ct.getAttrValue("af3"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "af4");
    param.setAttribute("value", ct.getAttrValue("af4"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyName");
    param.setAttribute("value", ct.getAttrValue("policyName"));
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackNew(doc, param)
{
    $("confirmbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    var errCode = data.getSErrorCode();
    if (param) 
    {
        if (errCode == 0) 
        {
            parobj.queryPolicy();
            xcloseDialog();
        }
    }
    else 
    {
        if (errCode == 0) 
        {
            parobj.queryPolicy();
            flag = true;
        }
    }
    
    showErrorDialog(data);
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    
    var info = RESOURCE["policyId"] + RESOURCE["colon"] + policyId + RESOURCE["semicolon"] +
    RESOURCE["policyName"] +
    RESOURCE["colon"] +
    policyName;
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        
        if (errorObj["policyId"]) 
        {
            info = RESOURCE["policyId"] + RESOURCE["colon"] + errorObj["policyId"] + RESOURCE["semicolon"] + RESOURCE["policyName"] + RESOURCE["colon"] + policyName;
        }
        
        errorObj["operationObj"] = info;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}
