var ct, st, st1;
var flag = true;
var parobj = getParentWindow();
var policyType = parobj.policyType;
var wfqPolicyId = 1;
var selclassifierIndex;

var obj;
var neid = parobj.neid;
var addClassifierList = new Array();
var indexList = new Array();
var checkboxElem;
var count = 0;

var portCosDefault = new Array();
portCosDefault["cir"] = 320;
portCosDefault["pir"] = 320;
portCosDefault["cbs"] = 64;
portCosDefault["pbs"] = 64;

window.onload = function()
{
    if (!isIE) 
    {
        parobj = parobj.frames[0];
    }
    obj = parobj.parobj.obj;
    
    initCTable();
    initSortTable();
    initButtonInfo();
}

function initCTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "2000");
    ct.addAttrRow("policyId", RESOURCE["policyId"], atom);
    ct.setAttrValue("policyId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("policyId").element.style.width = "50%";
    ct.getAtom("policyId").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    ct.getAtom("policyId").element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("policyName", RESOURCE["policyName"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("wfqPolicy", RESOURCE["wfqpolicy"], atom);
    
    var btnElem = document.createElement("button");
    btnElem.style.width = "15%";
    btnElem.className = "buttonstyle0";
    btnElem.value = "...";
    btnElem.onclick = handleWfqSelect;
    ct.getAtom("wfqPolicy").element.value = "1-" + default_wfq_policy_name;
    ct.getAtom("wfqPolicy").element.disabled = true;
    ct.getAtom("wfqPolicy").element.style.width = "85%";
    ct.getAtom("wfqPolicy").element.parentNode.appendChild(btnElem);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["policyId"].element.onkeydown = setButtonStatus;
    ct.attrArray["policyName"].element.onkeydown = setButtonStatus;
}

function handleCheckbox()
{
    var atomPolicyId = ct.getAtom("policyId").element;
    if (checkboxElem.checked) 
    {
        atomPolicyId.disabled = true;
        atomPolicyId.value = "";
    }
    else 
    {
        atomPolicyId.disabled = false;
        atomPolicyId.value = "1";
    }
    $("applybtn").disabled = false;
}

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("185px");
    st.setOnCellEditHandler(cellEditHandler);
    $("costable").appendChild(st.getTable());
    $("costable").oncontextmenu = popupMenuHandler;
    
    var dinterface = new DataInterface();
    for (var i = 0; i < queue_len; i++) 
    {
        var obj = new Object();
        dinterface.rows[dinterface.rows.length] = obj;
        
        var ptag = new ParamTag();
        ptag.value = i + 1;
        obj["queueType"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = 2;
        obj["bwEnable"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["cir"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["pir"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["cbs"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["pbs"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["dropTail"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "";
        obj["dropWred"] = ptag;
    }
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    tagCosTableHandler(st);
    
    st1 = new SortTable();
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    st1.setBodyHeight(120);
    st1.setSingleChoiceFlg(true);
    st1.setOnRowSelectHandler(rowSelectHandler);
    $("classifiertable").appendChild(st1.getTable());
    
    tagClassifierTableHandler(st1);
}

function initButtonInfo()
{
    $("cosconfig").innerHTML = RESOURCE["cosconfig"];
    $("classifierconfig").innerHTML = RESOURCE["classifierconfig"];
    
    $("addbtn").value = RESOURCE["createbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    $("cfgrulebtn").value = RESOURCE["cfgrulebtn"];
    $("advancedbtn").value = RESOURCE["advancedbtn"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    $("advancedbtn").disabled = true;
    $("upbtn").disabled = true;
    $("downbtn").disabled = true;
    $("applybtn").disabled = true;
}

function setButtonStatus()
{
    $("applybtn").disabled = false;
    flag = false;
}

function rowSelectHandler(param)
{
    if (param.length <= 0) 
    {
        setClassifierButtonStatus(true);
        return;
    }
    
    setClassifierButtonStatus(false);
    selclassifierIndex = param[0];
}

function cellEditHandler(param)
{
    $("applybtn").disabled = false;
    flag = false;
    
    var editRow = param.rowindex;
    var colid = param.colid;
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
    }
}

function tagCosTableHandler(st)
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.getCellEdit(i, "bwEnable").element.onchange = handleBwChange0;
        st.getCellEdit(i, "dropTail").element.onfocus = handleDropChange;
        st.getCellEdit(i, "dropWred").element.onmousedown = handleWredSelect;
        st.getCellEdit(i, "dropWred").element.onkeydown = function()
        {
            return false;
        }
        st.getCellEdit(i, "dropWred").element.onkeypress = function()
        {
            return false;
        }
        
        var colary = new Array();
        var bwEnable = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        
        if (bwEnable == bw_disable) //disabled status
        {
            colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
        }
        else 
        {
            var qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
            if (qType >= 4 && qType <= 7) 
            {
                colary = new Array("cir");
                setCellDefault(i, colary, invalid_char);
                
            }
            else if (qType == 8) 
            {
                colary = new Array("cir");
            }
        }
        
        textCheck(st.getCellEdit(i, "cir").element, "320", "10000000");
        textCheck(st.getCellEdit(i, "pir").element, "320", "10000000");
        textCheck(st.getCellEdit(i, "cbs").element, "64", "131072");
        textCheck(st.getCellEdit(i, "pbs").element, "64", "16777216");
        textCheck(st.getCellEdit(i, "dropTail").element, "0", max_serv_drop_tail);
        
        setCellStatus(st, i, colary, 0, "#E8E8E8", null);
    }
}

function tagClassifierTableHandler(st)
{

    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.getCellEdit(i, "bwEnable").element.onchange = handleBwChange1;
        
        var colary = new Array();
        var bwEnable = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        
        if (bwEnable == bw_disable) //disabled status
        {
            colary = new Array("cir", "pir", "cbs", "pbs");
        }
        else 
        {
            checkNumInput(st.getCellEdit(i, "cir").element);
            checkNumInput(st.getCellEdit(i, "pir").element);
            checkNumInput(st.getCellEdit(i, "cbs").element);
            checkNumInput(st.getCellEdit(i, "pbs").element);
        }
        
        setCellStatus(st, i, colary, 0, color_nonedit, null);
    }
}

function handleBwChange0()
{
    var colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
    handleBwChange(this, st, colary);
}

function handleBwChange1()
{
    var colary = new Array("cir", "pir", "cbs", "pbs");
    handleBwChange(this, st1, colary);
}

function handleBwChange(obj, st, colary)
{
    var rowindex = obj.parentNode.parentNode.rowIndex;
    
    if (obj.value == bw_disable) 
    {
        setCellStatus(st, rowindex, colary, 0, color_nonedit, null);
        setCellDefault(st, rowindex, colary, invalid_char);
    }
    else 
    {
        if (colary.length > 4) 
        {
            setCellStatus(st, rowindex, colary, 1, color_desel, cellondbclick);
            setCARCellDefault(rowindex, colary, queue_default);
            colary = new Array("dropWred");
            queryWredPolicy(type_wred_service);
            setCellDefault(st, rowindex, colary, wredPolicy);
            colary = new Array("dropTail");
            setCellDefault(st, rowindex, colary, invalid_char);
            
            var qType = parseInt(st.getCellStoreValue(rowindex, "queueType", "queueType"), 10);
            if (qType >= 4 && qType <= 7) 
            {
                colary = new Array("cir");
                setCellStatus(st, rowindex, colary, 0, "#E8E8E8", null);
                setCellDefault(st, rowindex, colary, invalid_char);
            }
            else if (qType == 8) 
            {
                colary = new Array("cir");
                setCellStatus(st, rowindex, colary, 0, "#E8E8E8", null);
                setCellDefault(st, rowindex, colary, "0");
            }
        }
        else 
        {
            setCellStatus(st, rowindex, colary, 1, color_desel, cellondbclick);
            setCellDefault(st, rowindex, colary, queue_default);
        }
    }
}

function setCARCellDefault(row, colary, defval)
{
    var cell;
    var setValue;
    for (var i = 0; i < colary.length; i++) 
    {
        cell = st.getCell(row, colary[i]);
        
        if (portCosDefault[colary[i]]) 
        {
            setValue = portCosDefault[colary[i]];
        }
        else 
        {
            setValue = defval;
        }
        
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, setValue);
        cell.element.editElement.setValue(setValue);
        st.setCellValue(cell, colary[i], setValue);
    }
}

var wredDialog = null;
function handleWredSelect()
{
    if (0 == count) 
    {
        count = 1;
    }
    else 
    {
        return;
    }
    editWredRow = this.parentNode.parentNode.rowIndex;
    editWredCell = st.getCell(editWredRow, "dropWred");
    
    if (wredDialog) 
    {
        return;
    }
    wredDialog = xshowModalDialog("servicewredselect.html", RESOURCE["wredserv"], 600, 400, "../../../../../images/");
    
    count = 0;
}

function handleWfqSelect()
{
    $("applybtn").disabled = false;
    flag = false;
    
    editWredRow = null;
    editWredCell = this.parentNode.firstChild;
    xshowModalDialog("wfqselect.html?flag=1", RESOURCE["wfqpolicy"], 600, 400, "../../../../../images/");
}

function setCellStatus(st, row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
        st.getCellElement(row, colAry[i]).style.backgroundColor = color;
        st.getCellElement(row, colAry[i]).ondblclick = dbclickFunc;
        st.getCellElement(row, colAry[i]).isEdit = isEdit;
    }
    
    if (0 == isEdit && colAry.contains("colorMode")) 
    {
        st.setAtomValue(st.getCell(row, "colorMode").element.showElement, "");
    }
}

function setCellDefault(st, row, colary, defval)
{
    for (var i = 0; i < colary.length; i++) 
    {
        st.setCellValue(st.getCell(row, colary[i]), colary[i], defval);
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, defval);
    }
}

function setClassifierButtonStatus(flag)
{
    $("delbtn").disabled = flag;
    $("cfgrulebtn").disabled = flag;
    $("advancedbtn").disabled = flag;
    $("upbtn").disabled = flag;
    $("downbtn").disabled = flag;
}

function classifierCreate()
{
    $("applybtn").disabled = false;
    flag = false;
    
    xshowModalDialog("vuniingressclassifiercreate.html", RESOURCE["createclassifier"], 500, 620, "../../../../../images/");
}

function classifierConfig()
{
    var rows = st1.getSelectedRows();
    if (rows.length <= 0) 
    {
        alert(RESOURCE["dataselcheck"]);
        return;
    }
    flag = false;
    xshowModalDialog("classifierconfig.html", RESOURCE["createclassifier"], 500, 400, "../../../../../images/");
}

function classifierDelete()
{
    var selRows = st1.getSelectedRows();
    
    for (var i = 0, len = selRows.length; i < len; i++) 
    {
        st1.deleteRow(selRows[i]);
    }
    st1.adjustDataRows();
    
    if (st1.getDataRowLength() <= 0) 
    {
        setClassifierButtonStatus(true);
    }
}

function classifierUp()
{
    var len = st1.getDataRowLength();
    if (len <= 1) 
    {
        return;
    }
    
    for (var i = 0; i < len; i++) 
    {
        if (st1.getRowSelFlag(i)) 
        {
            if (i == 0) 
            {
                return;
            }
            else 
            {
                swapTableRow(st1, i, i - 1);
                break;
            }
        }
    }
}

function classifierDown()
{
    var len = st1.getDataRowLength();
    if (len <= 1) 
    {
        return;
    }
    
    for (var i = 0; i < len; i++) 
    {
        if (st1.getRowSelFlag(i)) 
        {
            if (i == len - 1) 
            {
                return;
            }
            else 
            {
                swapTableRow(st1, i + 1, i);
                break;
            }
        }
    }
}

function classifierAdvanced()
{
    xshowModalDialog("vuniingressclassifieradvance.html", RESOURCE["advancedbtn"], 450, 250, "../../../../../images/");
}

function newPolicy(param)
{
    if ($("applybtn").disabled) 
    {
        xcloseDialog();
        return;
    }
    
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    if (policyId == null || policyId == "") 
    {
        policyId == "0";
    }
    if (policyName == null || policyName == "") 
    {
        alert(RESOURCE["checkname"]);
        return;
    }
    if (!wfqPolicyId) 
    {
        alert(RESOURCE["checknamewfq"]);
        return;
    }
    
    var superSt = parobj.parobj.st;
    for (var i = 0, len = superSt.getDataRowLength(); i < len; i++) 
    {
        var pId = superSt.getCellStoreValue(i, "policyId", "policyId");
        if (parseInt(policyId, 10) != 0 && policyId == pId) 
        {
            alert(RESOURCE["pidexistcheck"]);
            return;
        }
    }
    
    if (!checkCosTable(st) || !checkClassifierTable(st1)) 
    {
        return;
    }
    
    $("confirmbtn").disabled = true;
    $("cancelbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createNewXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CRT_VUNI_INGRESS_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackNew, param, "inputdata=" + xmldata);
}

function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    var fstRow = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    fstRow.appendChild(param);
    
    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked) 
    {
        policyId = "0";
    }
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "policyName");
    param.setAttribute("value", policyName);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wfqPolicy");
    param.setAttribute("value", wfqPolicyId);
    fstRow.appendChild(param);
    
    business.appendChild(fstRow);
    
    var queueLen = 0;
    
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (st.getCellStoreValue(i, "bwEnable", "bwEnable") == bw_enable) 
        {
            queueLen++;
            
            row = new tagElement("row-params");
            
            var qType = i + 1;
            param = new tagElement("param");
            param.setAttribute("name", "queueType");
            param.setAttribute("value", qType);
            row.appendChild(param);
            
            var cir = st.getCellStoreValue(i, "cir", "cir");
            if (qType >= 4 && qType <= 7) 
            {
                cir = "4294967295";
            }
            param = new tagElement("param");
            param.setAttribute("name", "cir");
            param.setAttribute("value", cir);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "cbs");
            param.setAttribute("value", st.getCellStoreValue(i, "cbs", "cbs"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pir");
            param.setAttribute("value", st.getCellStoreValue(i, "pir", "pir"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pbs");
            param.setAttribute("value", st.getCellStoreValue(i, "pbs", "pbs"));
            row.appendChild(param);
            
            var dropTail = st.getCellStoreValue(i, "dropTail", "dropTail");
            param = new tagElement("param");
            param.setAttribute("name", "dropTail");
            param.setAttribute("value", dropTail.length == "" ? 65535 : dropTail);
            row.appendChild(param);
            
            var dropWred = st.getCellStoreValue(i, "dropWred", "dropWred");
            if (-1 != dropWred.indexOf("-")) 
            {
                dropWred = dropWred.split("-")[0];
            }
            param = new tagElement("param");
            param.setAttribute("name", "dropWred");
            param.setAttribute("value", dropWred == "" ? 4294967295 : dropWred);
            row.appendChild(param);
            
            business.appendChild(row);
        }
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "queueLen");
    param.setAttribute("value", queueLen);
    fstRow.appendChild(param);
    
    len = st1.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var index = st1.getCellStoreValue(i, "index", "index");
        var advancedRow = 0;
        for (var j = 0; j < addClassifierList.length; j++) 
        {
            if (index == addClassifierList[j].index) 
            {
                advancedRow = j;
                break;
            }
        }
        var classifierObj = addClassifierList[advancedRow];
        
        row = new tagElement("row-params");
        
        var classifierId = st1.getCellStoreValue(i, "classifierId", "classifierId");
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", classifierId);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierOrder");
        param.setAttribute("value", i + 1);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierRule");
        param.setAttribute("value", st1.getCellStoreValue(i, "classifierRule", "classifierRule"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierAcl");
        param.setAttribute("value", st1.getCellStoreValue(i, "classifierAcl", "classifierAcl"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "queueType");
        param.setAttribute("value", st1.getCellStoreValue(i, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "bwEnable");
        param.setAttribute("value", st1.getCellStoreValue(i, "bwEnable", "bwEnable"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cir");
        param.setAttribute("value", st1.getCellStoreValue(i, "cir", "cir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pir");
        param.setAttribute("value", st1.getCellStoreValue(i, "pir", "pir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cbs");
        param.setAttribute("value", st1.getCellStoreValue(i, "cbs", "cbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pbs");
        param.setAttribute("value", st1.getCellStoreValue(i, "pbs", "pbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "colorMode");
        param.setAttribute("value", st1.getCellStoreValue(i, "colorMode", "colorMode"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red-handle");
        param.setAttribute("value", classifierObj.red_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red-rCos");
        param.setAttribute("value", classifierObj.red_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red-rColor");
        param.setAttribute("value", classifierObj.red_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel-handle");
        param.setAttribute("value", classifierObj.yel_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel-rCos");
        param.setAttribute("value", classifierObj.yel_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel-rColor");
        param.setAttribute("value", classifierObj.yel_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn-handle");
        param.setAttribute("value", classifierObj.grn_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn-rCos");
        param.setAttribute("value", classifierObj.grn_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn-rColor");
        param.setAttribute("value", classifierObj.grn_rmkcol);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackNew(doc, param)
{
    $("confirmbtn").disabled = false;
    $("cancelbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    showErrorDialog(data);
    
    var errCode = data.getSErrorCode();
    if (errCode == 0 || errCode == 1) 
    {
        parobj.queryPolicy();
        
        if (param && (errCode == 0)) 
        {
            xcloseDialog();
        }
        else 
        {
            flag = true;
            refreshTableState(st, window.tableconf[0], data);
            refreshTableState(st1, window.tableconf[1], data);
            addClassifierList = new Array();
            indexList = new Array();
            st1.clearTableData();
        }
    }
    else 
    {
        $("applybtn").disabled = false;
    }
}

function checkCosTable(stable)
{
    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        var bwStatus = stable.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bwStatus == bw_disable) 
        {
            continue;
        }
        
        var cos = stable.getCellStoreValue(i, "queueType", "queueType");
        var pir = parseInt(stable.getCellStoreValue(i, "pir", "pir"));
        var cir = parseInt(stable.getCellStoreValue(i, "cir", "cir"));
        var dropTail = stable.getCellStoreValue(i, "dropTail", "dropTail");
        var dropWred = stable.getCellStoreValue(i, "dropWred", "dropWred");
        
        if (cos == 1 || cos == 2 || cos == 3) 
        {
            if (pir != cir) 
            {
                alert(RESOURCE["queuevalcheck"]);
                return false;
            }
        }
        else if (pir < cir) 
        {
            alert(RESOURCE["queuevalcheck"]);
            return false;
        }
        
        if (dropTail != "" || dropTail != invalid_char) 
        {
            if (dropWred != "" || dropWred != invalid_char) 
            {
                alert(RESOURCE["dropcheck"]);
                return false;
            }
            else if (parseInt(dropTail, 10) < 0 || parseInt(dropTail, 10) > 4095) 
            {
                alert("The tail drop threshold should between 0 and 4095.");
                return false;
            }
        }
    }
    return true;
}

function checkClassifierTable(stable)
{
    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        var bwStatus = stable.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bwStatus == bw_disable) 
        {
            break;
        }
        
        var pir = parseInt(stable.getCellStoreValue(i, "pir", "pir"));
        var cir = parseInt(stable.getCellStoreValue(i, "cir", "cir"));
        if (pir < cir) 
        {
            alert(RESOURCE["cirpircheck"]);
            return false;
        }
    }
    return true;
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    
    var info = RESOURCE["policyId"] + RESOURCE["colon"] + policyId + RESOURCE["semicolon"] +
    RESOURCE["policyName"] +
    RESOURCE["colon"] +
    policyName;
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        
        if (errorObj["policyId"]) 
        {
            info = RESOURCE["policyId"] + RESOURCE["colon"] + errorObj["policyId"] + RESOURCE["semicolon"] + RESOURCE["policyName"] + RESOURCE["colon"] + policyName;
        }
        
        errorObj["operationObj"] = info;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function handleDropChange()
{
    var rows = this.parentNode.parent.getSelectedRows();
    for (var j = 0; j < rows.length; j++) 
    {
        var wredCell = this.parentNode.parent.getCell(rows[j], "dropWred");
        wredCell.element.showElement.setValue("");
        wredCell.element.editElement.setValue("");
        st.setCellValue(wredCell, "dropWred", "");
    }
}

function checkClassifierCar()
{
    var count = st1.getDataRowLength();
    for (var i = 0; i < count; i++) 
    {
        textCheck(st1.getCellEdit(i, "cir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "pir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(i, "pbs").element, "16000", "10000000");
        st1.getCellEdit(i, "bwEnable").element.onchange = handleBwChangeClass;
    }
}

function handleBwChangeClass()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    
    var colary = new Array("cir", "pir", "cbs", "pbs", "colorMode");
    
    if (this.value == 1) 
    {
        setCellStatus(st1, rowindex, colary, 1, "#ffffff", cellondbclick);
        setCellDefaultEnable(st1, rowindex);
        
        textCheck(st1.getCellEdit(rowindex, "cir").element, "320", "20000000");
        textCheck(st1.getCellEdit(rowindex, "pir").element, "320", "20000000");
        textCheck(st1.getCellEdit(rowindex, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(rowindex, "pbs").element, "16000", "10000000");
    }
    else 
    {
        setCellStatus(st1, rowindex, colary, 0, "#e3e8e6", null);
        setCellDefault(st1, rowindex, colary, invalid_char);
    }
}

function setCellDefaultEnable(st, row)
{
    st.setCellValue(st.getCell(row, "cir"), "cir", "320");
    st.setAtomValue(st.getCell(row, "cir").element.showElement, "320");
    
    st.setCellValue(st.getCell(row, "pir"), "pir", "320");
    st.setAtomValue(st.getCell(row, "pir").element.showElement, "320");
    
    st.setCellValue(st.getCell(row, "cbs"), "cbs", "16000");
    st.setAtomValue(st.getCell(row, "cbs").element.showElement, "16000");
    
    st.setCellValue(st.getCell(row, "pbs"), "pbs", "16000");
    st.setAtomValue(st.getCell(row, "pbs").element.showElement, "16000");
    
    st.setCellValue(st.getCell(row, "colorMode"), "colorMode", "1");
    st.setAtomValue(st.getCell(row, "colorMode").element.showElement, RESOURCE["color-bind"]);
}
