var ct, ct1, st, st1;

var temp = 0;
var flag = true;
var parobj = getParentWindow();

window.onload = function()
{
    if (!isIE) 
    {
        if (parobj.frames.length >= 5) 
        {
            parobj = parobj.frames[3];
        }
        else 
        {
            parobj = parobj.frames[1];
        }
    }
    
    initCTable();
    initSortTable();
    initButtonInfo();
}

function initCTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    ct.addAttrRow("classifierId", RESOURCE["classifierId"], atom);
    checkText(ct.getAtom("classifierId").element, "1", "16");
    
    atom = new Atom("select");
    ct.addAttrRow("classifierAcl", RESOURCE["aclbehavior"], atom);
    
    atom.element.options.add(new Option(RESOURCE["ID_PERMEIT"], "1"));
    atom.element.options.add(new Option(RESOURCE["ID_DENY"], "2"));
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct1 = new CTable();
    atom = new Atom("select");
    ct1.addAttrRow("cos", "CoS", atom);
    atom.element.options.add(new Option("-", "255"));
    atom.element.options.add(new Option("CS7", "1"));
    atom.element.options.add(new Option("CS6", "2"));
    atom.element.options.add(new Option("EF", "3"));
    atom.element.options.add(new Option("AF4", "4"));
    atom.element.options.add(new Option("AF3", "5"));
    atom.element.options.add(new Option("AF2", "6"));
    atom.element.options.add(new Option("AF1", "7"));
    atom.element.options.add(new Option("BE", "8"));
    
    atom = new Atom("select");
    ct1.addAttrRow("bwEnable", RESOURCE["bwEnable"], atom);
    atom.element.options.add(new Option(RESOURCE["ID_ENABLE"], "1"));
    atom.element.options.add(new Option(RESOURCE["ID_DISABLE"], "2"));
    
    atom = new Atom("text");
    ct1.addAttrRow("cir", RESOURCE["cir"], atom);
    checkText(ct1.getAtom("cir").element, "320", "20000000");
    
    atom = new Atom("text");
    ct1.addAttrRow("pir", RESOURCE["pir"], atom);
    checkText(ct1.getAtom("pir").element, "320", "20000000");
    
    atom = new Atom("text");
    ct1.addAttrRow("cbs", RESOURCE["cbs"], atom);
    checkText(ct1.getAtom("cbs").element, "16000", "10000000");
    
    atom = new Atom("text");
    ct1.addAttrRow("pbs", RESOURCE["pbs"], atom);
    checkText(ct1.getAtom("pbs").element, "16000", "10000000");
    
    atom = new Atom("select");
    ct1.addAttrRow("colorMode", RESOURCE["colorMode"], atom);
    atom.element.options.add(new Option(RESOURCE["color-bind"], "1"));
    atom.element.options.add(new Option(RESOURCE["color-aware"], "2"));
    
    document.body.insertBefore(ct1.getTable(), $("test"));
    
    ct1.attrArray["bwEnable"].element.onchange = setBwStatus;
    
    ct.attrArray["classifierId"].element.onkeydown = setButtonStatus;
    ct1.attrArray["cir"].element.onkeydown = setButtonStatus;
    ct1.attrArray["pir"].element.onkeydown = setButtonStatus;
    ct1.attrArray["cbs"].element.onkeydown = setButtonStatus;
    ct1.attrArray["pbs"].element.onkeydown = setButtonStatus;
    
    ct.attrArray["classifierAcl"].element.onchange = setButtonStatus;
    ct1.attrArray["colorMode"].element.onchange = setButtonStatus;
    ct1.attrArray["cos"].element.onchange = setButtonStatus;
}

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("80px");
    st.setOnRowSelectHandler(rowSelectHandler);
    $("ruletable").appendChild(st.getTable());
    
    st1 = new SortTable();
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[1]);
    st1.setBodyHeight("85px");
    st1.setOnCellEditHandler(cellEditHandler);
    $("advancedtable").appendChild(st1.getTable());
    
    var rows = 3;
    var defaultVal = new Array(rows);
    defaultVal[0] = new Array(1, 2, "255", "255");
    defaultVal[1] = new Array(2, 1, "255", "255");
    defaultVal[2] = new Array(3, 1, "255", "255");
    fillSortTable(st1, window.tableconf[1], rows, defaultVal);
    
    for (var i = 0; i < rows; i++) 
    {
        st1.getCellEdit(i, "handleMethod").element.onchange = handleMethodChange;
        var colary = new Array("remarkCos", "remarkColor");
        setCellStatus(i, colary, 0, "#E8E8E8", null);
    }
}

function initButtonInfo()
{
    $("matchrelation").innerHTML = RESOURCE["matchrelation"];
    $("relation").onchange = setButtonStatus;
    
    $("addbtn").value = RESOURCE["addbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("delbtn").disabled = true;
    $("applybtn").disabled = true;
}

function rowSelectHandler(param)
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        setCellColor(st, i, "matchType");
        setCellColor(st, i, "matchValue");
        setCellColor(st, i, "wildcard");
    }
    
    if (param.length <= 0) 
    {
        $("delbtn").disabled = true;
        return;
    }
    
    $("delbtn").disabled = false;
}

function cellEditHandler()
{
    setButtonStatus();
}

function addRule()
{
    $("applybtn").disabled = false;
    flag = false;
    
    var relation = $("relation").value;
    var ruleLen = ruleIds.length;
    
    var len = st.getDataRowLength();
    if (len <= 0 || (temp == ruleLen)) 
    {
        temp = 0;
    }
    
    if ((relation == 1) && (!ruleIds[temp] || len > ruleLen - 1)) 
    {
        return;
    }
    
    if (relation == 2 && len >= ruleLen) 
    {
    }
    else 
    {
        checkAddIndex();
    }
    
    var defaultVal = new Array(ruleIds[temp], "", "");
    if (ruleIds[temp] == "protype") 
    {
        defaultVal = new Array(ruleIds[temp], "tcp", "");
    }
    else if (ruleIds[temp] == "icmp") 
    {
        defaultVal = new Array(ruleIds[temp], "echo", "");
    }
    else if (ruleIds[temp] == "dei") 
    {
        defaultVal = new Array(ruleIds[temp], "", "");
    }
    
    var rowindex = constructRuleRow(st, window.tableconf[0], defaultVal);
    
    if (ruleIds[temp] == "protype" || ruleIds[temp] == "icmp" || ruleIds[temp] == "dei") 
    {
        editElementRemove(st, rowindex, "wildcard");
        
        var opts = new Array();
        if (ruleIds[temp] == "protype") 
        {
            opts = createOptionsProtype();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
        else if (ruleIds[temp] == "icmp") 
        {
            opts = createOptionsIcmp();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
        else if (ruleIds[temp] == "dei") 
        {
            var cell1 = st.getCellElement(rowindex, "matchValue").editElement;
            addInputConstraint(rowindex, ruleIds[temp], "matchValue");
        }
    }
    else 
    {
        var cell1 = st.getCellElement(rowindex, "matchValue").editElement;
        var cell2 = st.getCellElement(rowindex, "wildcard").editElement;
        addInputConstraint(rowindex, ruleIds[temp], "matchValue");
        addInputConstraint(rowindex, ruleIds[temp], "wildcard");
    }
    
    st.getCellElement(rowindex, "matchType").editElement.element.onchange = matchTypeChangeHandler;
    
    if (st.getDataRowLength() <= 1) 
    {
        mozillaSort(st, "wildcard");
    }
    
    temp++;
}

function deleteRule()
{
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        st.deleteRow(selRows[i]);
    }
    st.adjustDataRows();
    
    if (st.getDataRowLength() <= 0) 
    {
        $("delbtn").disabled = true;
    }
}

function matchTypeChangeHandler()
{
    flag = false;
    
    var eventRow = this.parentNode.parentNode.rowIndex;
    var eventVal = st.getCellStoreValue(eventRow, "matchType", "matchType");
    var thisVal = this.value;
    
    if (eventVal != thisVal) 
    {
        st.getCellElement(eventRow, "matchValue").modify = false;
        st.getCellElement(eventRow, "wildcard").modify = false;
    }
    
    var relation = $("relation").value;
    if (relation == 1) 
    {
        var len = st.getDataRowLength();
        for (var i = 0; i < len && (eventRow != i); i++) 
        {
            var mtype = st.getCellStoreValue(i, "matchType", "matchType");
            if (mtype == thisVal) 
            {
                this.value = eventVal;
                alert(RESOURCE["matchtypecheck"]);
                return;
            }
        }
    }
    
    var beforeType = setChangeType(eventVal);
    var afterType = setChangeType(thisVal);
    
    editElementRemove(st, eventRow, "matchValue");
    editElementRemove(st, eventRow, "wildcard");
    if (afterType == 1) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        editElementAdd(st, eventRow, "wildcard", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
        addInputConstraint(eventRow, thisVal, "wildcard");
    }
    else if (afterType == 2) 
    {
        var opts = new Array();
        if (thisVal == "protype") 
        {
            opts = createOptionsProtype();
        }
        else if (thisVal == "icmp") 
        {
            opts = createOptionsIcmp();
        }
        
        editElementAdd(st, eventRow, "matchValue", "select", opts, 0);
    }
    else if (afterType == 3) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
    }
}

function checkAddIndex()
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (ruleIds[temp] == st.getCellStoreValue(i, "matchType", "matchType")) 
        {
            temp++;
            checkAddIndex();
        }
    }
}

function addClassifier(param)
{
    if (param && flag) 
    {
        classifierClose();
        return;
    }
    
    alert(RESOURCE["clickapplydlg"]);
    
    var classifierId = ct.getAttrValue("classifierId");
    var classifierAcl = ct.getAttrValue("classifierAcl")
    
    if (classifierId == null || classifierId == "") 
    {
        alert(RESOURCE["classifierIDCheck"]);
        return;
    }
    
    var parst = parobj.st1;
    for (var i = 0, len = parst.getDataRowLength(); i < len; i++) 
    {
        if (classifierId != 0 && parst.getCellStoreValue(i, "classifierId", "classifierId") == classifierId) 
        {
            alert(RESOURCE["classifierIDExist"]);
            return;
        }
    }
    
    if (!checkBwAttrInput()) 
    {
        return;
    }
    
    var len = st.getDataRowLength();
    if (len <= 0) 
    {
        alert(RESOURCE["addRules"]);
        return;
    }
    
    if (!checkRuleInput(st) || !checkRuleRelation(st)) 
    {
        return;
    }
    
    var relation = $("relation").value;
    if (relation == 1 && !checkRuleRepeated(st)) 
    {
        return;
    }
    
    for (var i = 0, l = st1.getDataRowLength(); i < l; i++) 
    {
        var handle = st1.getCellStoreValue(i, "handleMethod", "handleMethod");
        var rmkCos = st1.getCellStoreValue(i, "remarkCos", "remarkCos");
        var rmkCol = st1.getCellStoreValue(i, "remarkColor", "remarkColor");
        
        if (handle != 3 && (rmkCos != "255" || rmkCol != "255")) 
        {
            alert(RESOURCE["checkInteger"]);
            return;
        }
    }
    
    var classifierRuleVal = st.getCellStoreValue(0, "matchType", "matchType") + ":" +
    			st.getCellStoreValue(0, "matchValue", "matchValue") + ":" +st.getCellStoreValue(0, "wildcard", "wildcard");
    
    var classifierRuleStr = RESOURCE[st.getCellStoreValue(0, "matchType", "matchType")] +
    			":" + st.getCellStoreValue(0, "matchValue", "matchValue") + ":" + st.getCellStoreValue(0, "wildcard", "wildcard");
    
    classifierRuleVal = "{" + trimStringTail(classifierRuleVal, ":") + "}";
    classifierRuleStr = "{" + trimStringTail(classifierRuleStr, ":") + "}";
    
    var relation = $("relation").value == 1 ? "&" : "|";
    
    for (var i = 1; i < len; i++) 
    {
        var mtype = st.getCellStoreValue(i, "matchType", "matchType");
        var mtypeStr = RESOURCE[mtype];
        
        var mval = st.getCellStoreValue(i, "matchValue", "matchValue");
        var wcard = st.getCellStoreValue(i, "wildcard", "wildcard");
        
        var tmpVal = mtype + ":" + mval + ":" + wcard;
        var tmpStr = mtypeStr + ":" + mval + ":" + wcard;
        tmpVal = "{" + trimStringTail(tmpVal, ":") + "}";
        tmpStr = "{" + trimStringTail(tmpStr, ":") + "}";
        
        classifierRuleVal += (relation + tmpVal);
        classifierRuleStr += (relation + tmpStr);
    }
    
    
    var cos = ct1.getAttrValue("cos");
    var cir = ct1.getAttrValue("cir").trim();
    var pir = ct1.getAttrValue("pir").trim();
    var cbs = ct1.getAttrValue("cbs").trim();
    var pbs = ct1.getAttrValue("pbs").trim();
    var colorMode = ct1.getAttrValue("colorMode");
    var parBwenable = ct1.getAttrValue("bwEnable");
    
    if (parseInt(pir) < parseInt(cir)) 
    {
        alert(RESOURCE["cirpircheck"]);
        return;
    }
    
    var idx = getMaxValueFromArray(parobj.indexList) + 1;
    parobj.indexList.push(idx);
    
    var defaultVal = new Array(idx, classifierId, classifierRuleStr, classifierAcl, cos, parBwenable, cir, pir, cbs, pbs, colorMode);
    
    var tc = parobj.window.tableconf.length > 1 ? parobj.window.tableconf[1] : parobj.window.tableconf[0];
    var parRow = constructRow(parst, tc, defaultVal);
    
    parst.headPack.isLayout = true;//dhj add
    adjustTableLayout(parst, tc, parst.getDataRowLength());
    
    
    if (parBwenable == 2) 
    {
        var colary = new Array("cir", "pir", "cbs", "pbs", "colorMode");
        parobj.setCellStatus(parst, parRow, colary, 0, color_nonedit, null);
    }
    
    parobj.st1.getCellElement(parRow, "classifierRule").storeValue["classifierRule"] = classifierRuleVal;
    
    var classifierObj = new Classifier(idx, classifierId, parBwenable, parRow);
    for (var row = 0, l = st1.getDataRowLength(); row < l; row++) 
    {
        var handle = st1.getCellStoreValue(row, "handleMethod", "handleMethod");
        var rmkCos = st1.getCellStoreValue(row, "remarkCos", "remarkCos");
        var rmkCol = st1.getCellStoreValue(row, "remarkColor", "remarkColor");
        
        classifierObj.setAdvancedAttr(row, handle, rmkCos, rmkCol);
    }
    parobj.addClassifierList.push(classifierObj);
    
    if (parobj.st1.getDataRowLength() <= 1) 
    {
        mozillaSort(parobj.st1, "classifierId");
    }
    
    if (param) 
    {
        classifierClose();
    }
    else 
    {
        flag = true;
        $("applybtn").disabled = true;
    }
}

function setButtonStatus()
{
    $("applybtn").disabled = false;
    flag = false;
}

function setBwStatus()
{
    setButtonStatus();
    if (this.value == 1) 
    {
        setCarattrStatus(ct1, false);
    }
    else 
    {
        setCarattrStatus(ct1, true);
    }
}

function setCarattrStatus(ct, flag)
{
    ct.attrArray["cir"].element.disabled = flag;
    ct.attrArray["pir"].element.disabled = flag;
    ct.attrArray["cbs"].element.disabled = flag;
    ct.attrArray["pbs"].element.disabled = flag;
    ct.attrArray["colorMode"].element.disabled = flag;
    
    var colary = new Array("handleMethod", "remarkCos", "remarkColor");
    var borderStyle = "1px solid #999999";
    if (flag) 
    {
        borderStyle = "1px solid #C9C7BA";
        
        ct.setAttrValue("cir", "");
        ct.setAttrValue("pir", "");
        ct.setAttrValue("cbs", "");
        ct.setAttrValue("pbs", "");
        ct.setAttrValue("colorMode", 1);
        
        setCellDefault(st1, 0, new Array("handleMethod"), "2", true);
        setCellDefault(st1, 1, new Array("handleMethod"), "1", true);
        setCellDefault(st1, 2, new Array("handleMethod"), "1", true);
        
        for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
        {
            setCellStatus(i, colary, 0, "#E8E8E8", null);
            setCellDefault(st1, i, new Array("remarkCos", "remarkColor"), "255", true);
        }
    }
    else 
    {
        colary = new Array("handleMethod");
        for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
        {
            setCellStatus(i, colary, 1, "#ffffff", cellondbclick);
        }
    }
    
    ct.attrArray["cir"].element.style.border = borderStyle;
    ct.attrArray["pir"].element.style.border = borderStyle;
    ct.attrArray["cbs"].element.style.border = borderStyle;
    ct.attrArray["pbs"].element.style.border = borderStyle;
}

function checkBwAttrInput()
{
    var bwEnable = ct1.getAttrValue("bwEnable");
    var cir = ct1.getAttrValue("cir").trim();
    var pir = ct1.getAttrValue("pir").trim();
    var cbs = ct1.getAttrValue("cbs").trim();
    var pbs = ct1.getAttrValue("pbs").trim();
    
    if (bwEnable == 1) 
    {
        if (cir == "") 
        {
            alert(RESOURCE["EnterCIRValue"]);
            return false;
        }
        else if (pir == "") 
        {
            alert(RESOURCE["EnterPIRValue"]);
            return false;
        }
        else if (cbs == "") 
        {
            alert(RESOURCE["EnterCBSValue"]);
            return false;
        }
        else if (pbs == "") 
        {
            alert(RESOURCE["EnterPBSValue"]);
            return false;
        }
        
        if (cir != "" && !isNum(cir)) 
        {
            alert(RESOURCE["CirTypeValueCheck"]);
            return false;
        }
        if (pir != "" && !isNum(pir)) 
        {
            alert(RESOURCE["PirTypeValueCheck"]);
            return false;
        }
        if (cbs != "" && !isNum(cbs)) 
        {
            alert(RESOURCE["CbsTypeValueCheck"]);
            return false;
        }
        if (pbs != "" && !isNum(pbs)) 
        {
            alert(RESOURCE["PbsTypeValueCheck"]);
            return false;
        }
    }
    
    return true;
}

function isNum(val)
{
    for (var i = 0; i < val.length; i++) 
    {
        if (val.charCodeAt(i) > 57 || val.charCodeAt(i) < 48) 
        {
            alert(RESOURCE["InputNumber"]);
            return false;
        }
    }
    
    return true;
}

function setCellStatus(row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
        st1.getCellElement(row, colAry[i]).style.backgroundColor = color;
        st1.getCellElement(row, colAry[i]).ondblclick = dbclickFunc;
        st1.getCellElement(row, colAry[i]).isEdit = isEdit;
    }
}

function setCellDefault(st, row, colary, defval, conv)
{
    for (var i = 0; i < colary.length; i++) 
    {
    
        st.setCellValue(st.getCell(row, colary[i]), colary[i], defval);
        
        if (conv) 
        {
            var val = convertMsg(RESOURCE, eval(colary[i]), defval);
        }
        
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, val);
    }
}

function handleMethodChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("remarkCos", "remarkColor");
    
    if (this.value == 3) 
    {
        setCellStatus(rowindex, colary, 1, "#ffffff", cellondbclick);
    }
    else 
    {
        setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
    }
    
    setCellDefault(st1, rowindex, colary, "255", true);
}

function classifierClose()
{
    parobj.checkClassifierCar();
    xcloseDialog();
}
