var st1;
var selclassifierIndex;
var parobj = window.parent;
var obj = parobj.obj;
var neid = parobj.neid;

var classifierList = new Array();
var addClassifierList = new Array();
var delClassifierList = new Array();
var modClassifierList = new Array();

var indexList = new Array();
var orderList = new Array();
var matchList = new Array();

var btnRightArr = new Object();
var querybtnRight = TECMDCODE_GET_VUNI_INGRESS_POLICY_CLASSIFIER;
var addbtnRight = TECMDCODE_CRT_VUNI_INGRESS_POLICY_CLASSIFIER;
var applybtnRight = TECMDCODE_MOD_VUNI_INGRESS_POLICY_CLASSIFIER;
var addClassifier = null;

window.onload = function()
{
    initTable();
    initButtonInfo();
}

function tabSelectHandler()
{
    classifierQuery();
}

function initTable()
{
    st1 = new SortTable();
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[0]);
    st1.setBodyHeight(getComponetHeight($("classifiertable"), 70) + "px");
    st1.setOnRowSelectHandler(rowSelectHandler);
    st1.setOnCellEditHandler(cellEditHandler);
    st1.setSingleChoiceFlg(true);
    $("classifiertable").appendChild(st1.getTable());
    
    checkClassifierCar();
}

function initButtonInfo()
{
    $("querybtn").value = RESOURCE["querybtn"];
    $("addbtn").value = RESOURCE["createbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    $("cfgrulebtn").value = RESOURCE["cfgrulebtn"];
    $("advancedbtn").value = RESOURCE["advancedbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    $("advancedbtn").disabled = true;
    $("upbtn").disabled = true;
    $("downbtn").disabled = true;
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querybtnRight);
    btnRightArr.addbtn = new BtnRightObj("addbtn", addbtnRight);
    btnRightArr.applybtn = new BtnRightObj("applybtn", applybtnRight);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
}

function rowSelectHandler(param)
{
    if (param.length <= 0) 
    {
        setClassifierButtonStatus(true);
        return;
    }
    
    setClassifierButtonStatus(false);
    
    var bw = st1.getCellStoreValue(param[0], "bwEnable", "bwEnable");	
	if  (bw == 2)  //car         Car  
    {
    	$("advancedbtn").disabled = true;
    }
	
    selclassifierIndex = param[0];
}

function cellEditHandler(param)
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        var editRow = param.rowindex;
        var colid = param.colid;
        
        if (colid == "bwEnable") 
        {
            var index = st1.getCellStoreValue(editRow, "index", "index");
            var bw = st1.getCellStoreValue(editRow, "bwEnable", "bwEnable");
            
            for (var i = 0, len = classifierList.length; i < len; i++) 
            {
                if (classifierList[i].index == index) 
                {
                    classifierList[i].setBandwidth(bw);
                    break;
                }
            }
            
            for (var i = 0, len = addClassifierList.length; i < len; i++) 
            {
                if (addClassifierList[i].index == index) 
                {
                    addClassifierList[i].desBw = bw;
                    break;
                }
            }
        }
    }
}

function setClassifierButtonStatus(flag)
{
    $("delbtn").disabled = flag;
    $("cfgrulebtn").disabled = flag;
    $("advancedbtn").disabled = flag;
    $("upbtn").disabled = flag;
    $("downbtn").disabled = flag;
}

function classifierQuery()
{
    $("querybtn").disabled = true;
    $("addbtn").disabled = true;
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    $("advancedbtn").disabled = true;
    $("upbtn").disabled = true;
    $("downbtn").disabled = true;
    $("applybtn").disabled = true;
    
    if (!parobj.selectedRows || parobj.selectedRows.length <= 0) 
    {
        st1.clearTableData();
        return;
    }
    
    var xmldata = createQueryXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_VUNI_INGRESS_POLICY_CLASSIFIER + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", parobj.policyType);
    row.appendChild(param);
    
    var selectedRows = parobj.st.getSelectedRows();
    var policyId = parobj.st.getCellStoreValue(selectedRows[0], "policyId", "policyId")
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "classifierId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("addbtn").disabled = !btnRightArr.addbtn.right;
    
    indexList = new Array();
    orderList = new Array();
    classifierList = new Array();
    addClassifierList = new Array();
    delClassifierList = new Array();
    modClassifierList = new Array();
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() < 2) 
    {
        st1.clearTableData();
        createTableBody(st1, window.tableconf[0], data, RESOURCE);
    }
    
    showErrorDialog(data);
    
    for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
    {
        var index = st1.getCellStoreValue(i, "index", "index");
        var classifierId = st1.getCellStoreValue(i, "classifierId", "classifierId");
        var bwEnable = st1.getCellStoreValue(i, "bwEnable", "bwEnable");
        var order = data.rows[i].classifierOrder.value;
        
        var classifierObj = new Classifier(index, classifierId, bwEnable, i);
        
        var handle = data.rows[i].redHandleMethod.value;
        var rmkCol = data.rows[i].redRemarkColor.value;
        var rmkCos = data.rows[i].redRemarkCos.value;
        classifierObj.setAdvancedAttr(0, handle, rmkCos, rmkCol);
        
        handle = data.rows[i].yellowHandleMethod.value;
        rmkCol = data.rows[i].yellowRemarkColor.value;
        rmkCos = data.rows[i].yellowRemarkCos.value;
        classifierObj.setAdvancedAttr(1, handle, rmkCos, rmkCol);
        
        handle = data.rows[i].greenHandleMethod.value;
        rmkCol = data.rows[i].greenRemarkColor.value;
        rmkCos = data.rows[i].greenRemarkCos.value;
        classifierObj.setAdvancedAttr(2, handle, rmkCos, rmkCol);
        
        indexList.push(index);
        orderList.push(order);
        classifierList.push(classifierObj);
        
        if (bwEnable == 2) 
        {
            var colary = new Array("cir", "pir", "cbs", "pbs", "colorMode");
            setCellStatus(st1, i, colary, 0, color_nonedit, null);
        }
        
        st1.getCellEdit(i, "bwEnable").element.onchange = handleBwChange;
        
        var ruleVal = data.rows[i].classifierRuleVal.value;
        st1.getCell(i, "classifierRule").element.storeValue["classifierRule"] = ruleVal;
        
        textCheck(st1.getCellEdit(i, "cir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "pir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(i, "pbs").element, "16000", "10000000");
    }
    
    matchList = new Array(MAX_CLASSIFIER_NUM);
    for (var i = 0, len = orderList.length; i < len; i++) 
    {
        matchList[orderList[i] - 1] = orderList[i];
    }
}

function classifierCreate()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    xshowModalDialog("vuniingressclassifiercreate.html", RESOURCE["createclassifier"], 500, 605, "../../../../../images/");
}

function classifierDelete()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    var selRows = st1.getSelectedRows();
    
    for (var i = 0, len = selRows.length; i < len; i++) 
    {
        var index = st1.getCellStoreValue(selRows[i], "index", "index");
        var cId = st1.getCellStoreValue(selRows[i], "classifierId", "classifierId");
        var bw = st1.getCellStoreValue(selRows[i], "bwEnable", "bwEnable");
        delClassifierList.push(new Classifier(index, cId, bw, selRows[i]));
        
        st1.deleteRow(selRows[i]);
    }
    st1.adjustDataRows();
    
    if (st1.getDataRowLength() <= 0) 
    {
        setClassifierButtonStatus(true);
    }
}

function classifierConfig()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    var rows = st1.getSelectedRows();
    if (rows.length <= 0) 
    {
        alert(RESOURCE["dataselcheck"]);
        return;
    }
    
    xshowModalDialog("classifierconfig.html", RESOURCE["createclassifier"], 500, 400, "../../../../../images/");
}

function classifierAdvanced()
{
    xshowModalDialog("vuniingressclassifieradvance.html", RESOURCE["advancedbtn"], 450, 250, "../../../../../images/");
}

function classifierUp()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    var len = st1.getDataRowLength();
    if (len <= 1) 
    {
        return;
    }
    
    for (var i = 0; i < len; i++) 
    {
        if (st1.getRowSelFlag(i)) 
        {
            if (i == 0) 
            {
                return;
            }
            else 
            {
                swapTableRow(st1, i, i - 1);
                break;
            }
        }
    }
}

function classifierDown()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    var len = st1.getDataRowLength();
    if (len <= 1) 
    {
        return;
    }
    
    for (var i = 0; i < len; i++) 
    {
        if (st1.getRowSelFlag(i)) 
        {
            if (i == len - 1) 
            {
                return;
            }
            else 
            {
                swapTableRow(st1, i + 1, i);
                break;
            }
        }
    }
}

function resetClassifierObjRow(src, des)
{
    var srcIndex = st1.getCellStoreValue(src, "index", "index");
    var desIndex = st1.getCellStoreValue(des, "index", "index");
    var srcObj, desObj;
    
    for (var k = 0, len = classifierList.length; k < len; k++) 
    {
        if (srcIndex == classifierList[k].index) 
        {
            srcObj = classifierList[k];
            break;
        }
        if (desIndex == classifierList[k].index) 
        {
            desObj = classifierList[k];
            break;
        }
    }
    
    for (var k = 0, len = addClassifierList.length; k < len; k++) 
    {
        if (srcIndex == addClassifierList[k].index) 
        {
            srcObj = addClassifierList[k];
            break;
        }
        if (desIndex == addClassifierList[k].index) 
        {
            desObj = addClassifierList[k];
            break;
        }
    }
    
    srcObj.setRowNumber(des);
    desObj.setRowNumber(src);
}

function classifierModify()
{
    var count = st1.getDataRowLength();
    if (count <= 0 && delClassifierList.length == 0) 
    {
        $("applybtn").disabled = true;
        return;
    }
    for (var i = 0; i < count; i++) 
    {
        if ((parseInt(st1.getCellStoreValue(i, "cir", "cir"))) > (parseInt(st1.getCellStoreValue(i, "pir", "pir")))) 
        {
            alert(RESOURCE["cirpircheck"]);
            return
        }
    }
    
    $("querybtn").disabled = true;
    $("addbtn").disabled = true;
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    $("advancedbtn").disabled = true;
    $("upbtn").disabled = true;
    $("downbtn").disabled = true;
    $("applybtn").disabled = true;
    
    constructClassifierList();
    
    var xmldata = createModifyXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MOD_VUNI_INGRESS_POLICY_CLASSIFIER + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackModify, null, "inputdata=" + xmldata);
}

function createModifyXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", parobj.policyType);
    row.appendChild(param);
    
    
    var parIndex = parobj.st.getSelectedRows()[0];
    var policyId = parobj.st.getCellStoreValue(parIndex, "policyId", "policyId");
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    var dellen = delClassifierList.length;
    param = new tagElement("param");
    param.setAttribute("name", "dellen");
    param.setAttribute("value", dellen);
    row.appendChild(param);
    
    var modlen = modClassifierList.length;
    param = new tagElement("param");
    param.setAttribute("name", "modlen");
    param.setAttribute("value", modlen);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isNoLog");
    param.setAttribute("value", "1");
    row.appendChild(param);
    
    business.appendChild(row);
    
    var opDesc = RESOURCE["policyId"] + ":" + policyId + "--";
    
    for (var i = 0; i < dellen; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", delClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["delClassifier"] + "," + RESOURCE["classifierId"] + ":" + delClassifierList[i].id;
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    for (var i = 0; i < modlen; i++) 
    {
        var rowIndex = modClassifierList[i].desRow;
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", modClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["modifyClassifier"] + "," + RESOURCE["classifierId"] + ":" + modClassifierList[i].id;
        
        param = new tagElement("param");
        param.setAttribute("name", "bwEnable");
        param.setAttribute("value", modClassifierList[i].desBw);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "carStatus");
        param.setAttribute("value", modClassifierList[i].getCarStatus());
        row.appendChild(param);
        
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "classifierOrder");
        param.setAttribute("value", modClassifierList[i].order);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierRule");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "classifierRule", "classifierRule"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierAcl");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "classifierAcl", "classifierAcl"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cir");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "cir", "cir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pir");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "pir", "pir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cbs");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "cbs", "cbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pbs");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "pbs", "pbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "colorMode");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "colorMode", "colorMode"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_handle");
        param.setAttribute("value", modClassifierList[i].red_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_rmkCos");
        param.setAttribute("value", modClassifierList[i].red_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_rmkCol");
        param.setAttribute("value", modClassifierList[i].red_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_handle");
        param.setAttribute("value", modClassifierList[i].yel_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_rmkCos");
        param.setAttribute("value", modClassifierList[i].yel_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_rmkCol");
        param.setAttribute("value", modClassifierList[i].yel_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_handle");
        param.setAttribute("value", modClassifierList[i].grn_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_rmkCos");
        param.setAttribute("value", modClassifierList[i].grn_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_rmkCol");
        param.setAttribute("value", modClassifierList[i].grn_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    var addlen = addClassifierList.length;
    
    for (var i = 0; i < addlen; i++) 
    {
        var bw = addClassifierList[i].desBw;
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", addClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["addClassifier"] + "," + RESOURCE["classifierId"] + ":" + addClassifierList[i].id;
        
        param = new tagElement("param");
        param.setAttribute("name", "carStatus");
        param.setAttribute("value", bw == 1 ? ADD_CAR : NON_CAR);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "index");
        param.setAttribute("value", addClassifierList[i].index);
        row.appendChild(param);
        
        
        
        var rowIndex = addClassifierList[i].desRow;
        param = new tagElement("param");
        param.setAttribute("name", "classifierOrder");
        param.setAttribute("value", addClassifierList[i].order);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierRule");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "classifierRule", "classifierRule"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierAcl");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "classifierAcl", "classifierAcl"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "bwEnable");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "bwEnable", "bwEnable"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cir");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "cir", "cir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pir");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "pir", "pir"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cbs");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "cbs", "cbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pbs");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "pbs", "pbs"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "colorMode");
        param.setAttribute("value", st1.getCellStoreValue(rowIndex, "colorMode", "colorMode"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_handle");
        param.setAttribute("value", addClassifierList[i].red_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_rmkCos");
        param.setAttribute("value", addClassifierList[i].red_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "red_rmkCol");
        param.setAttribute("value", addClassifierList[i].red_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_handle");
        param.setAttribute("value", addClassifierList[i].yel_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_rmkCos");
        param.setAttribute("value", addClassifierList[i].yel_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "yel_rmkCol");
        param.setAttribute("value", addClassifierList[i].yel_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_handle");
        param.setAttribute("value", addClassifierList[i].grn_handle);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_rmkCos");
        param.setAttribute("value", addClassifierList[i].grn_rmkcos);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "grn_rmkCol");
        param.setAttribute("value", addClassifierList[i].grn_rmkcol);
        row.appendChild(param);
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackModify(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("addbtn").disabled = !btnRightArr.addbtn.right;
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() < 2) 
    {
        classifierQuery();
    }
    modClassifierList.clear();
    showErrorDialog(data);
}

function setCellStatus(st, row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
        st.getCellElement(row, colAry[i]).style.backgroundColor = color;
        st.getCellElement(row, colAry[i]).ondblclick = dbclickFunc;
        st.getCellElement(row, colAry[i]).isEdit = isEdit;
    }
    
    if (0 == isEdit && colAry.contains("colorMode")) 
    {
        st.setAtomValue(st.getCell(row, "colorMode").element.showElement, "");
    }
}

function setCellDefault(st, row, colary, defval)
{
    for (var i = 0; i < colary.length; i++) 
    {
        st.setCellValue(st.getCell(row, colary[i]), colary[i], defval);
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, defval);
    }
}

function setCellDefaultEnable(st, row)
{
    st.setCellValue(st.getCell(row, "cir"), "cir", "320");
    st.setAtomValue(st.getCell(row, "cir").element.showElement, "320");
    
    st.setCellValue(st.getCell(row, "pir"), "pir", "320");
    st.setAtomValue(st.getCell(row, "pir").element.showElement, "320");
    
    st.setCellValue(st.getCell(row, "cbs"), "cbs", "16000");
    st.setAtomValue(st.getCell(row, "cbs").element.showElement, "16000");
    
    st.setCellValue(st.getCell(row, "pbs"), "pbs", "16000");
    st.setAtomValue(st.getCell(row, "pbs").element.showElement, "16000");
    
    st.setCellValue(st.getCell(row, "colorMode"), "colorMode", "1");
    st.setAtomValue(st.getCell(row, "colorMode").element.showElement, RESOURCE["color-bind"]);
}

function handleBwChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    
    var colary = new Array("cir", "pir", "cbs", "pbs", "colorMode");
    
    if (this.value == 1) 
    {
        setCellStatus(st1, rowindex, colary, 1, "#ffffff", cellondbclick);
        setCellDefaultEnable(st1, rowindex);
        
        textCheck(st1.getCellEdit(rowindex, "cir").element, "320", "20000000");
        textCheck(st1.getCellEdit(rowindex, "pir").element, "320", "20000000");
        textCheck(st1.getCellEdit(rowindex, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(rowindex, "pbs").element, "16000", "10000000");
    }
    else 
    {
        setCellStatus(st1, rowindex, colary, 0, "#E8E8E8", null);
        setCellDefault(st1, rowindex, colary, invalid_char);
    }
}

window.onresize = function()
{
    if (document.body) 
    {
        st1.setBodyHeight(getComponetHeight($("classifiertable"), 70) + "px");
    }
}

function constructClassifierList()
{
    for (var i = delClassifierList.length - 1; i >= 0; i--) 
    {
        var delFlag = false;
        
        var delObj = delClassifierList[i];
        
        for (var j = addClassifierList.length - 1; j >= 0; j--) 
        {
            var addObj = addClassifierList[j];
            if (delObj.index == addObj.index) 
            {
                addClassifierList.removeAt(j);
                delFlag = true;
                break;
            }
        }
        
        if (delFlag) 
        {
            delClassifierList.removeAt(i);
        }
    }
    
    for (var i = classifierList.length - 1; i >= 0; i--) 
    {
        var modFlag = true;
        
        var cObj = classifierList[i];
        
        for (var j = delClassifierList.length - 1; j >= 0; j--) 
        {
            var delObj = delClassifierList[j];
            if (cObj.index == delObj.index) 
            {
                modFlag = false;
                break;
            }
        }
        
        if (modFlag) 
        {
            modClassifierList.push(cObj);
        }
    }
    
    for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
    {
        var idx = st1.getCellStoreValue(i, "index", "index");
        for (var k = modClassifierList.length - 1; k >= 0; k--) 
        {
            var modObj = modClassifierList[k];
            if (idx == modObj.index) 
            {
                modObj.order = i + 1;
                modObj.desRow = i;
                break;
            }
        }
        
        for (var k = 0; k < addClassifierList.length; k++) 
        {
            var addObj = addClassifierList[k];
            if (idx == addObj.index) 
            {
                addObj.order = i + 1;
                addObj.desRow = i;
                break;
            }
        }
    }
    
}

function calculateOrder(val)
{
    var order = parseInt(val, 10);
    
    if (!matchList[order - 1]) 
    {
        return order;
    }
    else 
    {
        var k = order;
        while (k < MAX_CLASSIFIER_NUM) 
        {
            if (!matchList[k]) 
            {
                matchList[k] = k + 1;
                return k + 1;
            }
            k++;
        }
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = RESOURCE["classifierId"] + ":" + errorObj["classifierId"];
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

var MAX_CLASSIFIER_NUM = 16;

function checkClassifierCar()
{
    var count = st1.getDataRowLength();
    for (var i = 0; i < count; i++) 
    {
        textCheck(st1.getCellEdit(i, "cir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "pir").element, "320", "20000000");
        textCheck(st1.getCellEdit(i, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(i, "pbs").element, "16000", "10000000");
        st1.getCellEdit(i, "bwEnable").element.onchange = handleBwChange;
    }
}

function setApplyBtnStatus(flag)
{
	$("applybtn").disabled = flag;
}
