var ct, st;
var flag = true;
var parobj = getParentWindow();
var policyType = parobj.policyType;
var editWredRow, editWredCell;
var wfqPolicyId = 1;
var count = 0;

var obj;
var neid = parobj.neid;

var commonCosDefault = new Array();
commonCosDefault["cir"] = 0;
commonCosDefault["pir"] = 0;
commonCosDefault["cbs"] = 0;
commonCosDefault["pbs"] = 0;

window.onload = function()
{
    if (!isIE) 
    {
        parobj = parobj.frames[0];
    }
    obj = parobj.parobj.obj;
    
    initCTable();
    initSortTable();
    initButtonInfo();
    initCmdInfo();
}

function initCTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "2000");
    ct.addAttrRow("policyId", RESOURCE["policyId"], atom);
    ct.setAttrValue("policyId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("policyId").element.style.width = "50%";
    ct.getAtom("policyId").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    ct.getAtom("policyId").element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("policyName", RESOURCE["policyName"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("wfqPolicy", RESOURCE["wfqpolicy"], atom);
    
    var btnElem = document.createElement("button");
    btnElem.style.width = "15%";
    btnElem.className = "buttonstyle0";
    btnElem.value = "...";
    btnElem.onclick = handleWfqSelect;
    ct.getAtom("wfqPolicy").element.value = "1-" + default_wfq_policy_name;
    ct.getAtom("wfqPolicy").element.disabled = true;
    ct.getAtom("wfqPolicy").element.style.width = "85%";
    ct.getAtom("wfqPolicy").element.parentNode.appendChild(btnElem);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["policyId"].element.onkeydown = setButtonStatus;
    ct.attrArray["policyName"].element.onkeydown = setButtonStatus;
}

function handleCheckbox()
{
    var atomPolicyId = ct.getAtom("policyId").element;
    if (checkboxElem.checked) 
    {
        atomPolicyId.disabled = true;
        atomPolicyId.value = "";
    }
    else 
    {
        atomPolicyId.disabled = false;
        atomPolicyId.value = "1";
    }
    $("applybtn").disabled = false;
    flag = false;
}

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("180px");
    st.setOnCellEditHandler(cellEditHandler);
    $("costable").appendChild(st.getTable());
    $("costable").oncontextmenu = popupMenuHandler;
    
    var dinterface = new DataInterface();
    for (var i = 0; i < queue_len; i++) 
    {
        var obj = new Object();
        dinterface.rows[dinterface.rows.length] = obj;
        
        var ptag = new ParamTag();
        ptag.value = i + 1;
        obj["queueType"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = 2;
        obj["bwEnable"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["cir"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["pir"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["cbs"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["pbs"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["dropTail"] = ptag;
        
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["dropWred"] = ptag;
    }
    st.clearTableData();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    tagCosTableHandler();
}

function initButtonInfo()
{
    $("cosconfig").innerHTML = RESOURCE["cosconfig"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("applybtn").disabled = true;
}

function setButtonStatus()
{
    $("applybtn").disabled = false;
    flag = false;
}

function cellEditHandler(param)
{
    $("applybtn").disabled = false;
    flag = false;
    
    var editRow = param.rowindex;
    var colid = param.colid;
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
		if (colid == "dropTail") 
		{
			handleDropChange();
		}
    }
}

function tagCosTableHandler()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.getCellEdit(i, "bwEnable").element.onchange = handleBwChange;
        st.getCellEdit(i, "dropWred").element.onmousedown = handleWredSelect;
        st.getCellEdit(i, "dropWred").element.onkeydown = function()
        {
            return false;
        }
        st.getCellEdit(i, "dropWred").element.onkeypress = function()
        {
            return false;
        }
        
        var colary;
        var bwEnable = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        
        if (bwEnable == bw_disable) //disabled status
        {
            colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
        }
        else 
        {
            var qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
            if (qType >= 4 && qType <= 7) 
            {
                colary = new Array("cir");
                setCellDefault(i, colary, "-");
                
            }
            else if (qType == 8) 
            {
                colary = new Array("cir");
            }
        }
        
        textCheckWithStepLenandOtherValue(st.getCellEdit(i, "cir").element, "0", "1000000", 64,"/");
        textCheckWithStepLenandOtherValue(st.getCellEdit(i, "pir").element, "0", "1000000", 64,"/");
        textCheck(st.getCellEdit(i, "cbs").element, "0", "4294967294",0,"/");
        textCheck(st.getCellEdit(i, "pbs").element, "0", "4294967294",0,"/");
        textCheck(st.getCellEdit(i, "dropTail").element, "0", max_serv_drop_tail);
        
        setCellStatus(i, colary, 0, "#E8E8E8", null);
    }
}

function handleBwChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
    
    if (this.value == bw_disable) 
    {
        setCellStatus(rowindex, colary, 0, color_nonedit, null);
        setCellDefault(rowindex, colary, "-");
    }
    else 
    {
        setCellStatus(rowindex, colary, 1, color_desel, cellondbclick);
        setCARCellDefault(rowindex, colary, queue_default);
        colary = new Array("dropWred");
        queryWredPolicy(type_wred_service);
        setCellDefault(rowindex, colary, wredPolicy);
        colary = new Array("dropTail");
        setCellDefault(rowindex, colary, 480);
        
        var qType = parseInt(st.getCellStoreValue(rowindex, "queueType", "queueType"), 10);
        
        if (qType >= 4 && qType <= 7) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "-");
        }
        else if (qType == 8) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "0");
        }
    }
}

function setCARCellDefault(row, colary, defval)
{
    var cell;
    for (var i = 0; i < colary.length; i++) 
    {
        cell = st.getCell(row, colary[i]);
        var setValue;
        if (commonCosDefault[colary[i]]) 
        {
            setValue = commonCosDefault[colary[i]];
        }
        else 
        {
            setValue = defval;
        }
        
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, setValue);
        cell.element.editElement.setValue(setValue);
        st.setCellValue(cell, colary[i], setValue);
    }
}

var wredDialog = null;
function handleWredSelect()
{
    if (0 == count) 
    {
        count = 1;
    }
    else 
    {
        return;
    }
    editWredRow = this.parentNode.parentNode.rowIndex;
    editWredCell = st.getCell(editWredRow, "dropWred");
    
    if (wredDialog) 
    {
        return;
    }
    wredDialog = xshowModalDialog("../policy_v2r8c01/servicewredselect.html?flag=1", RESOURCE["wredserv"], 600, 400, "../../../../../images/");
    
    count = 0;
}

function handleWfqSelect()
{
    $("applybtn").disabled = false;
    flag = false;
    
    editWredRow = null;
    editWredCell = this.parentNode.firstChild;
    xshowModalDialog("../policy_v2r8c01/wfqselect.html?flag=1", RESOURCE["wfqpolicy"], 600, 400, "../../../../../images/");
}

function setCellStatus(row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
		st.setCellIsEdit(st.getCell(row, colAry[i]),isEdit);
    }
}

function setCellDefault(row, colary, defval)
{
    for (var i = 0; i < colary.length; i++) 
    {
        st.setCellValue(st.getCell(row, colary[i]), colary[i], defval);
		st.getCellShow(row,colary[i]).setValue(defval);
    }
}

function newPolicy(param)
{
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    
    if (policyId == null || policyId == "") 
    {
        policyId == "0";
    }
    if (policyName == null || policyName == "") 
    {
        alert(RESOURCE["checkname"]);
        return;
    }
    
    if (param && flag) 
    {
        xcloseDialog();
        return;
    }
    
    if (!wfqPolicyId) 
    {
        alert(RESOURCE["checknamewfq"]);
        return;
    }
    
    var superSt = parobj.parobj.st;
    for (var i = 0, len = superSt.getDataRowLength(); i < len; i++) 
    {
        var pId = superSt.getCellStoreValue(i, "policyId", "policyId");
        if (parseInt(policyId, 10) != 0 && policyId == pId) 
        {
            alert(RESOURCE["pidexistcheck"]);
            return;
        }
    }
    if (!checkCosTable(st)) 
    {
        return;
    }
    
    $("confirmbtn").disabled = true;
    $("cancelbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createNewXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMD_CRT_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackNew, param, "inputdata=" + xmldata);
}

function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    var fstRow = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    fstRow.appendChild(param);
    
    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked) 
    {
        policyId = "0";
    }
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "policyName");
    param.setAttribute("value", policyName);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wfqPolicy");
    param.setAttribute("value", wfqPolicyId);
    fstRow.appendChild(param);
    
    var opDesc = RESOURCE["policyId"] + ":" + policyId + "," + RESOURCE["policyName"] + ":" + policyName;
    
    param = new tagElement("param");
    setOpDesc(param, opDesc);
    fstRow.appendChild(param);
    
    business.appendChild(fstRow);
    
    var queueLen = 0;
    
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (st.getCellStoreValue(i, "bwEnable", "bwEnable") == bw_enable) 
        {
            queueLen++;
            
            row = new tagElement("row-params");
            
            var qType = i + 1;
            param = new tagElement("param");
            param.setAttribute("name", "queueType");
            param.setAttribute("value", qType);
            row.appendChild(param);
            
            var cir = st.getCellStoreValue(i, "cir", "cir");
            if (qType >= 4 && qType <= 7) 
            {
                cir = "4294967295";
            }
            param = new tagElement("param");
            param.setAttribute("name", "cir");
            param.setAttribute("value", cir);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "cbs");
            param.setAttribute("value", st.getCellStoreValue(i, "cbs", "cbs"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pir");
            param.setAttribute("value", st.getCellStoreValue(i, "pir", "pir"));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pbs");
            param.setAttribute("value", st.getCellStoreValue(i, "pbs", "pbs"));
            row.appendChild(param);
            
            var dropTail = st.getCellStoreValue(i, "dropTail", "dropTail");
            param = new tagElement("param");
            param.setAttribute("name", "dropTail");
            param.setAttribute("value", dropTail.length == "" ? 65535 : dropTail);
            row.appendChild(param);
            
            var dropWred = st.getCellStoreValue(i, "dropWred", "dropWred");
            if (-1 != dropWred.indexOf("-")) 
            {
                dropWred = dropWred.split("-")[0];
            }
            param = new tagElement("param");
            param.setAttribute("name", "dropWred");
            param.setAttribute("value", dropWred == "" ? 4294967295 : dropWred);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "isNoLog");
            param.setAttribute("value", "1");
            row.appendChild(param);
            
            business.appendChild(row);
        }
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "queueLen");
    param.setAttribute("value", queueLen);
    fstRow.appendChild(param);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackNew(doc, param)
{
    $("confirmbtn").disabled = false;
    $("cancelbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    showErrorDialog(data);
    
    var errCode = data.getSErrorCode();
    if (errCode == 0 || errCode == 1) 
    {
        refreshTableState(st, window.tableconf[0], data);
        parobj.queryPolicy();
        
        if (param && (errCode == 0)) 
        {
            xcloseDialog();
        }
        else 
        {
            flag = true;
        }
    }
    else 
    {
        $("applybtn").disabled = false;
    }
}

function checkCosTable(stable)
{
    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        var bwStatus = stable.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bwStatus == bw_disable) 
        {
            continue;
        }
        
        var cos = stable.getCellStoreValue(i, "queueType", "queueType");
        var pir = stable.getCellStoreValue(i, "pir", "pir");
        var cir = stable.getCellStoreValue(i, "cir", "cir");
        var dropTail = stable.getCellStoreValue(i, "dropTail", "dropTail");
        var dropWred = stable.getCellStoreValue(i, "dropWred", "dropWred");
        if((i+1)==8 && pir=="/")
        {
        	cir="/";//  BE  CIR     PIR 0xFFFFFFFF  CIR 0xFFFFFFFF DTS2013090902742
        }
        
        if (cos == 1 || cos == 2 || cos == 3) 
        {
            if (pir != cir) 
            {
                alert(RESOURCE["queuevalcheck"]);
                return false;
            }
        }
        else if (pir < cir) 
        {
            alert(RESOURCE["queuevalcheck"]);
            return false;
        }
        
        if (dropTail != "" && dropTail != "-" && dropTail != "/") 
        {
            if (dropWred != "" && dropWred != "-" && dropWred != "/") 
            {
                alert(RESOURCE["dropcheck"]);
                return false;
            }
            else if (parseInt(dropTail, 10) < 0 || parseInt(dropTail, 10) > parseInt(max_serv_drop_tail, 10)) 
            {
                alert(RESOURCE["droptail"]);
                return false;
            }
        }
    }
    return true;
}


var TECMD_CRT_POLICY;
function initCmdInfo()
{
    TECMD_CRT_POLICY = parobj.createbtnRight;
}

function handleDropChange()
{
    var rows = st.getSelectedRows();
    for (var j = 0; j < rows.length; j++) 
    {
		var wredCell = st.getCell(rows[j], "dropWred");
        wredCell.element.showElement.setValue("/");
        wredCell.element.editElement.setValue("/");
        st.setCellValue(wredCell, "dropWred", "/");
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    
    var info = RESOURCE["policyId"] + RESOURCE["colon"] + policyId + RESOURCE["semicolon"] + RESOURCE["policyName"] + RESOURCE["colon"] + policyName;
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        
        if (errorObj["policyId"]) 
        {
            info = RESOURCE["policyId"] + RESOURCE["colon"] + errorObj["policyId"] + RESOURCE["semicolon"] + RESOURCE["policyName"] + RESOURCE["colon"] + policyName;
        }
        
        errorObj["operationObj"] = info;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}
