var st;
var parobj = window.parent;
var obj, neid;
var policyType = parobj.policyType;
var selRows;
var editWredCell, editWredRow;

var btnRightArr = new Object();
var querybtnRight;
var createbtnRight;
var deletebtnRight;
var copybtnRight;
var applybtnRight;
var count = 0;
var INEXISTENCE = "42072";

var bwStatus = new Array();
var createQueueList = new Array();
var deleteQueueList = new Array();
var modifyQueueList = new Array();
var queueDetailsChanged = new Array(queue_len);

var commonCosDefault = new Array();
commonCosDefault["cir"] = 0;
commonCosDefault["pir"] = 0;
commonCosDefault["cbs"] = 0;
commonCosDefault["pbs"] = 0;

window.onload = function()
{
    obj = getNeProperty(self);
    neid = obj["neid"];
    
    initTable();
    initButtonInfo();
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right && parobj.selectedRows && parobj.selectedRows.length > 0) 
    {
        var rowIndex = parobj.st.getSelectedRows()[0];
        var parId = parobj.st.getCellStoreValue(rowIndex, "policyId", "policyId");
        queryPolicyCos(parId);
    }
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getComponetHeight($("costable"), 70) + "px");
    st.setOnCellEditHandler(cellEditHandler);
    $("costable").appendChild(st.getTable());
    $("costable").oncontextmenu = popupMenuHandler;
}

function initButtonInfo()
{
    $("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    $("copybtn").value = RESOURCE["copybtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    initRightCmd();
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_GET_VUNI_INGRESS_POLICY);
    btnRightArr.createbtn = new BtnRightObj("createbtn", createbtnRight);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", deletebtnRight);
    btnRightArr.copybtn = new BtnRightObj("copybtn", copybtnRight);
    btnRightArr.applybtn = new BtnRightObj("applybtn", applybtnRight);
    
    getRightInfo(parobj.obj, btnRightArr);
    initrightbtn(btnRightArr);
    
    initButtonStatus();
}

function initButtonStatus()
{
    $("applybtn").disabled = true;
    
    if (parobj.st.getSelectedRows().length <= 0) 
    {
        $("deletebtn").disabled = true;
        $("copybtn").disabled = true;
    }
}

function cellEditHandler(param)
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    
    var editRow = param.rowindex;
    var colid = param.colid;
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        if (colid != "bwEnable") 
        {
            queueDetailsChanged[editRow] = true;
        }
        if (colid == "dropTail") 
        {
            handleDropChange();
        }
    }
}

function queryPolicy()
{
    parobj.queryPolicy();
}

function queryPolicyCos(policyId)
{
    if (!parobj.selectedRows || parobj.selectedRows.length <= 0) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("copybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createQueryXml(policyId);
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_POLICY_QUEUE + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQueryCos, null, "inputdata=" + xmldata);
}

function createQueryXml(policyId)
{
    var opDesc = "";
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "queueType");
    param.setAttribute("value", 0);
    row.appendChild(param);
	
	param = new tagElement("param","wredType","2");
	row.appendChild(param);
    
    opDesc += RESOURCE["policy" + policyType] + "," + RESOURCE["policyId"] + ":" + policyId;
    
    param = new tagElement("param");
    setOpDesc(param, opDesc);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryCos(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("copybtn").disabled = !btnRightArr.copybtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    
    if (parobj.basicModified) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() < 2) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        bwStatus = new Array();
        
        for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
        {
            var wredName = data.rows[i].wredName;
            var dropWred = data.rows[i].dropWred;
            if (wredName != undefined && wredName.value != null) 
            {
                st.getCellShow(i, "dropWred").setValue(dropWred.value + "-" + wredName.value);
            }
            
            st.getCellEdit(i, "bwEnable").element.onchange = handleBwChange;
            st.getCellEdit(i, "dropWred").element.onmousedown = handleWredSelect;
            st.getCellEdit(i, "dropWred").element.onkeydown = function()
            {
                return false;
            }
            st.getCellEdit(i, "dropWred").element.onkeypress = function()
            {
                return false;
            }
            
            var colary = new Array();
            var bwEnable = st.getCellStoreValue(i, "bwEnable", "bwEnable");
            
            bwStatus[i] = bwEnable;
            
            if (bwEnable == bw_disable) //disabled status
            {
                colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
            }
            else 
            {
                var qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
                if (qType >= 4 && qType <= 7) 
                {
                    colary = new Array("cir");
                    setCellDefault(i, colary, "-");
                    
                }
                else if (qType == 8) 
                {
                    colary = new Array("cir");
                }
            }
            
            textCheckWithStepLenandOtherValue(st.getCellEdit(i, "cir").element, "0", "1000000", 64,"/");
            textCheckWithStepLenandOtherValue(st.getCellEdit(i, "pir").element, "0", "1000000", 64,"/");
            textCheck(st.getCellEdit(i, "cbs").element, "0", "4294967294",0,"/");
            textCheck(st.getCellEdit(i, "pbs").element, "0", "4294967294",0,"/");
            textCheck(st.getCellEdit(i, "dropTail").element, "0", max_serv_drop_tail);
            
            setCellStatus(i, colary, 0, "#E8E8E8", null);
        }
        
        queueDetailsChanged = new Array(queue_len);
    }
    
    showErrorDialog(data);
}

function createPolicy()
{
    var urlstr, titlestr;
    var owidth = 650;
    var oheight = 450;
    
    switch (policyType)
    {
        case type_ingress_policy:
            urlstr = "vuniingresspolicycreate.html";
            titlestr = "createingresspolicy";
            oheight = 620;
            break;
        case type_egress_policy:
            urlstr = "vuniegresspolicycreate.html";
            titlestr = "createegresspolicy";
            break;
        case type_pw_policy:
            urlstr = "pwpolicycreate.html";
            titlestr = "createpwpolicy";
            break;
        case type_qinq_policy:
            urlstr = "qinqpolicycreate.html";
            titlestr = "createqinqpolicy";
            break;
        default:
            break;
    }
    
    xshowModalDialog("../policy_v2r8c01/" + urlstr, RESOURCE[titlestr], owidth, oheight, "../../../../../images/");
}

function copyPolicy()
{
    xshowModalDialog("../policy_v2r8c01/copypolicy.html", RESOURCE["copypolicy"], 400, 180, "../../../../../images/");
}

function handleBwChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
    
    if (this.value == bw_disable) 
    {
        setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
        setCellDefault(rowindex, colary, "-");
    }
    else 
    {
        setCellStatus(rowindex, colary, 1, "#ffffff", cellondbclick);
        setCARCellDefault(rowindex, colary, queue_default);
        colary = new Array("dropWred");
        queryWredPolicy(type_wred_service);
        setCellDefault(rowindex, colary, wredPolicy);
        colary = new Array("dropTail");
        setCellDefault(rowindex, colary, 480);
        
        var qType = parseInt(st.getCellStoreValue(rowindex, "queueType", "queueType"), 10);
        if (qType >= 4 && qType <= 7) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "-");
        }
        else if (qType == 8) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "0");
        }
    }
}

var wredDialog = null;
function handleWredSelect()
{
    if (0 == count) 
    {
        count = 1;
    }
    else 
    {
        return;
    }
    editWredRow = this.parentNode.parentNode.rowIndex;
    editWredCell = st.getCell(editWredRow, "dropWred");
    
    if (wredDialog) 
    {
        return;
    }
    xshowModalDialog("../policy_v2r8c01/servicewredselect.html", RESOURCE["wredserv"], 700, 460, "../../../../../images/");
    
    count = 0;
}

function setCellStatus(row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
		st.setCellIsEdit(st.getCell(row, colAry[i]),isEdit);
    }
}

function setCellDefault(row, colary, defval)
{
    var cell;
    for (var i = 0; i < colary.length; i++) 
    {
        cell = st.getCell(row, colary[i]);
        cell.element.showElement.setValue(defval);
        cell.element.editElement.setValue(defval);
        
        st.setCellValue(cell, colary[i], defval);
    }
}

function setCARCellDefault(row, colary, defval)
{
    var cell;
    for (var i = 0; i < colary.length; i++) 
    {
        cell = st.getCell(row, colary[i]);
        var setValue;
        if (commonCosDefault[colary[i]]) 
        {
            setValue = commonCosDefault[colary[i]];
        }
        else 
        {
            setValue = defval;
        }
        
        cell.element.showElement.setValue(setValue);
        cell.element.editElement.setValue(setValue);
        st.setCellValue(cell, colary[i], setValue);
    }
}

function modifyPolicy()
{
    var parSt = parobj.st;
    
    for (var i = 0, len = parSt.getDataRowLength(); i < len; i++) 
    {
        if (parSt.getModify(i) && parSt.getCellStoreValue(i, "policyName", "policyName") == "") 
        {
            alert(RESOURCE["checkname"]);
            return;
        }
    }
    
    if (!checkCosTable(st)) 
    {
        return;
    }
	
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
		if(!st.getCellModify(i,"dropTail") && !st.getCellModify(i,"dropWred"))
		{
			continue;
		}
        var dropTail = st.getCellStoreValue(i, "dropTail", "dropTail");
        var dropWred = st.getCellStoreValue(i, "dropWred", "dropWred");
        
        if (dropTail && dropWred && dropTail != "" && dropWred != "" && dropTail != "/" && dropWred != "/") 
        {
            alert(RESOURCE["dropcheck"]);
            return;
        }
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("copybtn").disabled = true;
    $("applybtn").disabled = true;
    
    createQueueList = new Array();
    deleteQueueList = new Array();
    modifyQueueList = new Array();
    setQueueList();

    var xmldata = createModifyXml();

    var urlstr = "../../../../../neExlorerServlet?sfid=" + applybtnRight + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackModify, null, "inputdata=" + xmldata);
}

function setQueueList()
{
    for (var i = 0; i < queue_len; i++) 
    {
        var cell = st.getCell(i, "bwEnable");
        var bandwidth = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        
        if (cell.element.modify && bandwidth != bwStatus[i]) 
        {
            if (bandwidth == bw_enable) 
            {
                createQueueList[createQueueList.length] = i;
            }
            else 
            {
                deleteQueueList[deleteQueueList.length] = i;
            }
        }
        else if (queueDetailsChanged[i] && bandwidth == bw_enable) 
        {
            modifyQueueList[modifyQueueList.length] = i;
        }
    }
}

function createModifyXml()
{
    var parSt = parobj.st;
    var row;
    var basicLen = 0;
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var basicRow = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isNoLog");
    param.setAttribute("value", "1");
    basicRow.appendChild(param);
    
    business.appendChild(basicRow);
    var opDesc = "";
    for (var i = 0, len = parSt.getDataRowLength(); i < len; i++) 
    {
        if (parSt.getModify(i)) 
        {
            opDesc = "";
            basicLen++;
            row = new tagElement("row-params");
            
            var policyId = parSt.getCellStoreValue(i, "policyId", "policyId");
            var policyName = "";
            var wfqPolicy = "";
            var classifierSharev = "";
            var modifString = "";
            var splitStr = "";
            if (parSt.getCellModify(i, "policyName")) 
            {
                policyName = parSt.getCellStoreValue(i, "policyName", "policyName");
                param = new tagElement("param");
                param.setAttribute("name", "policyName_setname");
                param.setAttribute("value", policyName);
                row.appendChild(param);
                modifString += RESOURCE["policyName"] + ":" + policyName;
                splitStr = ",";
            }
            if (parSt.element.datarows[i].element.cols["wfqPolicy"] &&
            parSt.getCellModify(i, "wfqPolicy")) 
            {
                wfqPolicy = parSt.getCellStoreValue(i, "wfqPolicy", "wfqPolicy");
                if (-1 != wfqPolicy.indexOf("-")) 
                {
                    wfqPolicy = wfqPolicy.split("-")[0];
                }
                param = new tagElement("param");
                param.setAttribute("name", "wfqPolicy");
                param.setAttribute("value", wfqPolicy);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "auto_setwfq");
                param.setAttribute("value", "0");
                row.appendChild(param);
                
                modifString += splitStr + RESOURCE["wfqpolicy"] + ":" + wfqPolicy + splitStr;
                splitStr = ",";
            }
            
            if (policyType == type_ingress_policy &&
            parSt.element.datarows[i].element.cols["classifierShare"] &&
            parSt.getCellModify(i, "classifierShare")) 
            {
                var classifierSharev = parobj.st.getCellStoreValue(i, "classifierShare", "classifierShare");
                param = new tagElement("param");
                param.setAttribute("name", "classifierShare");
                param.setAttribute("value", classifierSharev);
                row.appendChild(param);
                modifString += splitStr + RESOURCE["classifierShare"] + ":" + RESOURCE[classifierShare[parseInt(classifierSharev)]];
                splitStr = ",";
            }
            
            param = new tagElement("param");
            param.setAttribute("name", "policyId_setname");
            param.setAttribute("value", policyId);
            row.appendChild(param);
            opDesc += RESOURCE["policyId"] + ":" + policyId + "--";
            
            param = new tagElement("param");
            param.setAttribute("name", "policyType");
            param.setAttribute("value", policyType);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "auto_setname");
            param.setAttribute("value", "0");
            row.appendChild(param);
            
            opDesc += modifString;
            param = new tagElement("param");
            setOpDesc(param, opDesc);
            row.appendChild(param);
            
            business.appendChild(row);
        }
    }
    param = new tagElement("param");
    param.setAttribute("name", "basicLen");
    param.setAttribute("value", basicLen);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "crtQueueLen");
    param.setAttribute("value", createQueueList.length);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "delQueueLen");
    param.setAttribute("value", deleteQueueList.length);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "modQueueLen");
    param.setAttribute("value", modifyQueueList.length);
    basicRow.appendChild(param);
    
    var selRows = parobj.st.getSelectedRows();
    var policyId = parobj.st.getCellStoreValue(selRows[0], "policyId", "policyId");
    
    for (var i = 0; i < createQueueList.length; i++) 
    {
        opDesc = "";
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "auto_crtqueue");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyType");
        param.setAttribute("value", policyType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId_crtqueue");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        opDesc += RESOURCE["policyId"] + ":" + policyId + "--";
        
        var qType = parseInt(st.getCellStoreValue(createQueueList[i], "queueType", "queueType"), 10);
        param = new tagElement("param");
        param.setAttribute("name", "type_crtqueue");
        param.setAttribute("value", qType);
        row.appendChild(param);
        opDesc += RESOURCE["createqueue"] + ":" + RESOURCE[remarkCos[qType]];
        
        var cir = st.getCellStoreValue(createQueueList[i], "cir", "cir");
        if (qType >= 4 && qType <= 7) 
        {
            cir = "4294967295";
        }
        param = new tagElement("param");
        param.setAttribute("name", "cir_crtqueue");
        param.setAttribute("value", convertQueueQosValue(cir));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cbs_crtqueue");
        param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(createQueueList[i], "cbs", "cbs")));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pir_crtqueue");
        param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(createQueueList[i], "pir", "pir")));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "pbs_crtqueue");
        param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(createQueueList[i], "pbs", "pbs")));
        row.appendChild(param);
        var tail = st.getCellStoreValue(createQueueList[i], "dropTail", "dropTail");
        var wred = st.getCellStoreValue(createQueueList[i], "dropWred", "dropWred");
        if (-1 != wred.indexOf("-")) 
        {
            wred = wred.split("-")[0];
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "dropTail_crtqueue");
        param.setAttribute("value", tail);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dropWred_crtqueue");
        param.setAttribute("value", wred);
        row.appendChild(param);
        
        if (!tail || tail == "/" || tail == "-") 
        {
            tail = "65535";
        }
        if (!wred || wred == "/" || wred == "-") 
        {
            wred = "4294967295";
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId_setdrop");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "auto_setqueue");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dropTail");
        param.setAttribute("value", tail);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "type_setdrop");
        param.setAttribute("value", qType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "auto_setdrop");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "dropWred");
        param.setAttribute("value", wred);
        row.appendChild(param);
        
        
        param = new tagElement("param");
        setOpDesc(param, opDesc);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    for (var i = 0; i < deleteQueueList.length; i++) 
    {
        opDesc = "";
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId_delqueue");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        opDesc += RESOURCE["policyId"] + ":" + policyId + "--";
        
        param = new tagElement("param");
        param.setAttribute("name", "policyType");
        param.setAttribute("value", policyType);
        row.appendChild(param);
        
        var type = st.getCellStoreValue(deleteQueueList[i], "queueType", "queueType");
        param = new tagElement("param");
        param.setAttribute("name", "type_delqueue");
        param.setAttribute("value", type);
        row.appendChild(param);
        opDesc += RESOURCE["delqueue"] + ":" + RESOURCE[remarkCos[type]];
        
        param = new tagElement("param");
        setOpDesc(param, opDesc);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    for (var i = 0; i < modifyQueueList.length; i++) 
    {
        opDesc = "";
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "auto_setqueue");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyType");
        param.setAttribute("value", policyType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId_setdrop");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "policyId_setqueue");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        
        opDesc += RESOURCE["policyId"] + ":" + policyId + "--";
        
        var qType = parseInt(st.getCellStoreValue(modifyQueueList[i], "queueType", "queueType"), 10);
        param = new tagElement("param");
        param.setAttribute("name", "type_setdrop");
        param.setAttribute("value", qType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "type_setqueue");
        param.setAttribute("value", qType);
        row.appendChild(param);
        
        opDesc += RESOURCE["modifyqueue"] + ":" + RESOURCE[remarkCos[qType]] + ",";
        
        var cir = st.getCellStoreValue(modifyQueueList[i], "cir", "cir");
        if (qType >= 4 && qType <= 7) 
        {
            cir = "4294967295";
        }
        param = new tagElement("param");
        param.setAttribute("name", "cir_setqueue");
        param.setAttribute("value", convertQueueQosValue(cir));
        row.appendChild(param);
        opDesc += RESOURCE["cir"] + ":" + cir + ",";
        
        var cbs = st.getCellStoreValue(modifyQueueList[i], "cbs", "cbs");
        param = new tagElement("param");
        param.setAttribute("name", "cbs_setqueue");
        param.setAttribute("value", convertQueueQosValue(cbs));
        row.appendChild(param);
        opDesc += RESOURCE["cbs"] + ":" + cbs + ",";
        
        var pir = st.getCellStoreValue(modifyQueueList[i], "pir", "pir");
        param = new tagElement("param");
        param.setAttribute("name", "pir_setqueue");
        param.setAttribute("value", convertQueueQosValue(pir));
        row.appendChild(param);
        opDesc += RESOURCE["pir"] + ":" + pir + ",";
        
        var pbs = st.getCellStoreValue(modifyQueueList[i], "pbs", "pbs");
        param = new tagElement("param");
        param.setAttribute("name", "pbs_setqueue");
        param.setAttribute("value", convertQueueQosValue(pbs));
        row.appendChild(param);
        opDesc += RESOURCE["pbs"] + ":" + pbs + ",";
        
        var tail = st.getCellStoreValue(modifyQueueList[i], "dropTail", "dropTail");
        if (!tail || tail == "/" || tail == "-") 
        {
            tail = "65535";
        }
        param = new tagElement("param");
        param.setAttribute("name", "dropTail");
        param.setAttribute("value", tail);
        row.appendChild(param);
        opDesc += RESOURCE["droptail"] + ":" + tail;
        
        param = new tagElement("param");
        param.setAttribute("name", "auto_setdrop");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        var wred = st.getCellStoreValue(modifyQueueList[i], "dropWred", "dropWred");
        if (!wred || wred == "/" || wred == "-") 
        {
            wred = "4294967295";
        }
        else 
        {
            opDesc += "," + RESOURCE["wredserv"] + ":" + wred;
        }
        
        if (-1 != wred.indexOf("-")) 
        {
            wred = wred.split("-")[0];
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "dropWred");
        param.setAttribute("value", wred);
        row.appendChild(param);
        
        param = new tagElement("param");
        setOpDesc(param, opDesc);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackModify(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    $("copybtn").disabled = !btnRightArr.copybtn.right;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshTableState(parobj.st, parobj.window.tableconf[0], data);
        refreshTableState(st, window.tableconf[0], data);
        if (data.getSErrorCode() == 0) 
        {
            refreshBandWidthStatus();
        }
        else 
        {
            tabSelectHandler();
        }
        queueDetailsChanged = new Array(queue_len);
        parobj.basicModified = false;
    }
    else 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function refreshBandWidthStatus()
{
    var curStatus;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        curStatus = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        bwStatus[i] = curStatus;
    }
}

function deletePolicy()
{
    selRows = parobj.st.getSelectedRows();
    if (selRows.length <= 0) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("copybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createDeleteXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + deletebtnRight + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackDelete, null, "inputdata=" + xmldata);
}

function createDeleteXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    selRows = parobj.st.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        var policyId = parobj.st.getCellStoreValue(selRows[i], "policyId", "policyId");
        
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyType");
        param.setAttribute("value", policyType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        
        var opDesc = RESOURCE["policyId"] + ":" + policyId;
        param = new tagElement("param");
        setOpDesc(param, opDesc);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackDelete(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    
    var data = EncapsulateData(doc);
    var globalErr = data.getSErrorCode();
    if (0 != globalErr) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (INEXISTENCE == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (1 == globalErr || 2 == globalErr)) 
        {
            data.errObj.s_error.code = 0;
            globalErr = 0;
        }
    }
    if (globalErr == 0 || globalErr == 1) 
    {
        parobj.queryPolicy();
    }
    else 
    {
    
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("copybtn").disabled = !btnRightArr.copybtn.right;
    }
    
    showErrorDialog(data);
    
    selRows = parobj.st.getSelectedRows();
    if (selRows.length <= 0) 
    {
        st.clearTableData();
    }
}

window.onresize = function()
{
    if (document.body) 
    {
        st.setBodyHeight(getComponetHeight($("costable"), 70) + "px");
    }
}

function showErrorDialog(di)
{
    selRows = parobj.st.getSelectedRows();
    var operObj;
    if (selRows.length <= 0) 
    {
        operObj = obj["nename"];
    }
    else 
    {
        var rowIndex = selRows[0];
        var policyId = parobj.st.getCellStoreValue(rowIndex, "policyId", "policyId");
        var policyName = parobj.st.getCellStoreValue(rowIndex, "policyName", "policyName");
        
        operObj = RESOURCE["policyId"] + RESOURCE["colon"] + policyId + RESOURCE["semicolon"] + RESOURCE["policyName"] + RESOURCE["colon"] + policyName;
    }
    
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = operObj;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function initRightCmd()
{
    copybtnRight = TECMDCODE_COPY_POLICY;
    
    switch (policyType)
    {
        case type_ingress_policy:
            querybtnRight = TECMDCODE_GET_VUNI_INGRESS_POLICY;
            createbtnRight = TECMDCODE_CRT_VUNI_INGRESS_POLICY;
            deletebtnRight = TECMDCODE_DEL_VUNI_INGRESS_POLICY;
            applybtnRight = TECMDCODE_MOD_VUNI_INGRESS_POLICY;
            break;
        case type_egress_policy:
            querybtnRight = TECMDCODE_GET_VUNI_EGRESS_POLICY;
            createbtnRight = TECMDCODE_CRT_VUNI_EGRESS_POLICY;
            deletebtnRight = TECMDCODE_DEL_VUNI_EGRESS_POLICY;
            applybtnRight = TECMDCODE_MOD_VUNI_EGRESS_POLICY;
            break;
        case type_pw_policy:
            querybtnRight = TECMDCODE_GET_PW_POLICY;
            createbtnRight = TECMDCODE_CRT_PW_POLICY;
            deletebtnRight = TECMDCODE_DEL_PW_POLICY;
            applybtnRight = TECMDCODE_MOD_PW_POLICY;
            break;
        case type_qinq_policy:
            querybtnRight = TECMDCODE_GET_QINQ_POLICY;
            createbtnRight = TECMDCODE_CRT_QINQ_POLICY;
            deletebtnRight = TECMDCODE_DEL_QINQ_POLICY;
            applybtnRight = TECMDCODE_MOD_QINQ_POLICY;
            break;
        default:
            break;
    }
}

function handleDropChange()
{
    var rows = st.getSelectedRows();
    for (var j = 0; j < rows.length; j++) 
    {
        var wredCell = st.getCell(rows[j], "dropWred");
        wredCell.element.showElement.setValue("/");
        wredCell.element.editElement.setValue("/");
        st.setCellValue(wredCell, "dropWred", "/");
    }
}

function checkCosTable(stable)
{
    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        if (!stable.getModify(i)) 
        {
            continue;
        }
        var bwStatus = stable.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bwStatus == bw_disable) 
        {
            continue;
        }
        
        var cos = stable.getCellStoreValue(i, "queueType", "queueType");
        var pir = stable.getCellStoreValue(i, "pir", "pir");
        var cir = stable.getCellStoreValue(i, "cir", "cir");
        var dropTail = stable.getCellStoreValue(i, "dropTail", "dropTail");
        var dropWred = stable.getCellStoreValue(i, "dropWred", "dropWred");
        
        if (cos == 1 || cos == 2 || cos == 3) 
        {
            if (pir != cir) 
            {
                alert(RESOURCE["queuevalcheck"]);
                return false;
            }
        }
        else if (pir != "/" && cir != "/" && parseInt(pir) < parseInt(cir)) 
        {
            alert(RESOURCE["queuevalcheck"]);
            return false;
        }

        if (dropTail != undefined && dropTail != "" && dropTail != "/") 
        {
            if (dropWred != undefined && dropWred != "" && dropWred != "/") 
            {
                alert(RESOURCE["dropcheck"]);
                return false;
            }
            else if (parseInt(dropTail, 10) < 0 || parseInt(dropTail, 10) > parseInt(max_serv_drop_tail, 10)) 
            {
                alert(RESOURCE["max_serv_drop_tail"]);
                return false;
            }
        }
    }
    return true;
}

/**
 *          /    FFFFFF 
 * @param {Object} value
 */
function convertQueueQosValue(value)
{
	return value == "/"?"4294967295":value;
}
