var st;
var parobj = window.parent;
var obj = parobj.obj;
var neid = parobj.neid;
var policyType = parobj.policyType;

window.onload = function()
{
    initTable();
    initButtonInfo();
    initCmdInfo();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getComponetHeight($("acttable"), 70) + "px");
    $("acttable").appendChild(st.getTable());
}

function initButtonInfo()
{
    $("querybtn").value = RESOURCE["querybtn"];
}

function tabSelectHandler()
{
    if (!$("querybtn").disabled) 
    {
        queryActPoint();
    }
}

function queryActPoint()
{
    if (!parobj.selectedRows || parobj.selectedRows.length <= 0) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    
    var xmldata = createQueryXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMD_GET_ACTPOINT + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var opDesc = "";
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", parobj.policyType);
    row.appendChild(param);
    
    var selRows = parobj.st.getSelectedRows();
    var policyId = parobj.st.getCellStoreValue(selRows[0], "policyId", "policyId");
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    opDesc += RESOURCE["policyId"] + ":" + policyId;
    
    param = new tagElement("param");
    setOpDesc(param, opDesc);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() < 2) 
    {
        st.clearTableData()
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
    mozillaSort(st, window.tableconf[0].colArray[0].id);
    showErrorDialog(data);
}

window.onresize = function()
{
    if (document.body) 
    {
        st.setBodyHeight(getComponetHeight($("acttable"), 70) + "px");
    }
}

var TECMD_GET_ACTPOINT;
function initCmdInfo()
{
    switch (policyType)
    {
        case type_ingress_policy:
            TECMD_GET_ACTPOINT = TECMDCODE_GET_VUNI_INGRESS_POLICY_ACTPOINT;
            break;
        case type_egress_policy:
            TECMD_GET_ACTPOINT = TECMDCODE_GET_VUNI_EGRESS_POLICY_ACTPOINT;
            break;
        case type_pw_policy:
            TECMD_GET_ACTPOINT = TECMDCODE_GET_PW_POLICY_ACTPOINT;
            break;
        case type_qinq_policy:
            TECMD_GET_ACTPOINT = TECMDCODE_GET_QINQ_POLICY_ACTPOINT;
            break;
        default:
            break;
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    var row = parobj.st.getSelectedRows()[0];
    var policyId = parobj.st.getCellStoreValue(row, "policyId", "policyId");
    var policyName = parobj.st.getCellStoreValue(row, "policyName", "policyName");
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = policyId + "-" + policyName;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}
