var ct, st;

var temp = 0;
var flag = true;
var parobj = getParentWindow();

window.onload = function()
{
    initCTable();
    initSortTable();
    initButtonInfo();
    
    if (!isIE) 
    {
        if (parobj.frames.length >= 5) 
        {
            parobj = parobj.frames[3];
        }
        else 
        {
            parobj = parobj.frames[1];
        }
    }
}

function initCTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    ct.addAttrRow("classifierId", RESOURCE["classifierId"], atom);
    validateNum(ct.getAtom("classifierId").element, 1, 16, 2);
    
    atom = new Atom("select");
    ct.addAttrRow("classifierAcl", RESOURCE["aclbehavior"], atom);
    
    atom.element.options.add(new Option(RESOURCE["ID_PERMEIT"], "1"));
    atom.element.options.add(new Option(RESOURCE["ID_DENY"], "2"));
    atom.element.options.selectedIndex = 1;
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["classifierId"].element.onkeydown = setButtonStatus;
    ct.attrArray["classifierAcl"].element.onchange = setButtonStatus;
    
    checkNumInput(ct.getAtom("classifierId").element);
}

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("180px");
    st.setOnRowSelectHandler(rowSelectHandler);
    
    $("ruletable").appendChild(st.getTable());
}

function initButtonInfo()
{
    $("matchrelation").innerHTML = RESOURCE["matchrelation"];
    $("relation").onchange = setButtonStatus;
    
    $("addbtn").value = RESOURCE["addbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    $("delbtn").disabled = true;
    $("applybtn").disabled = true;
}

function rowSelectHandler(param)
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        setCellColor(st, i, "matchType");
        setCellColor(st, i, "matchValue");
        setCellColor(st, i, "wildcard");
    }
    
    if (param.length <= 0) 
    {
        $("delbtn").disabled = true;
        return;
    }
    
    $("delbtn").disabled = false;
}

function setButtonStatus()
{
    $("applybtn").disabled = false;
    flag = false;
}

function addRule()
{
    $("applybtn").disabled = false;
    flag = false;
    
    var relation = $("relation").value;
    var ruleLen = ruleIds.length;
    
    var len = st.getDataRowLength();
    if (len <= 0 || (temp == ruleLen)) 
    {
        temp = 0;
    }
    
    if ((relation == 1) && (!ruleIds[temp] || len > ruleLen - 1)) 
    {
        return;
    }
    
    if (relation == 2 && len >= ruleLen) 
    {
    }
    else 
    {
        checkAddIndex();
    }
    
    var defaultVal = new Array(ruleIds[temp], "", "");
    if (ruleIds[temp] == "protype") 
    {
        defaultVal = new Array(ruleIds[temp], "tcp", "");
    }
    else if (ruleIds[temp] == "icmp") 
    {
        defaultVal = new Array(ruleIds[temp], "echo", "");
    }
    else if (ruleIds[temp] == "dei") 
    {
        defaultVal = new Array(ruleIds[temp], "", "");
    }
    
    var rowindex = constructRuleRow(st, window.tableconf[0], defaultVal);
    
    if (ruleIds[temp] == "protype" || ruleIds[temp] == "icmp" || ruleIds[temp] == "dei") 
    {
        editElementRemove(st, rowindex, "wildcard");
        
        var opts = new Array();
        if (ruleIds[temp] == "protype") 
        {
            opts = createOptionsProtype();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
        else if (ruleIds[temp] == "icmp") 
        {
            opts = createOptionsIcmp();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
        else if (ruleIds[temp] == "dei") 
        {
            var cell1 = st.getCellElement(rowindex, "matchValue").editElement;
            addInputConstraint(rowindex, ruleIds[temp], "matchValue");
        }
    }
    else 
    {
        var cell1 = st.getCellElement(rowindex, "matchValue").editElement;
        var cell2 = st.getCellElement(rowindex, "wildcard").editElement;
        addInputConstraint(rowindex, ruleIds[temp], "matchValue");
        addInputConstraint(rowindex, ruleIds[temp], "wildcard");
    }
    
    st.getCellElement(rowindex, "matchType").editElement.element.onchange = matchTypeChangeHandler;
    
    if (st.getDataRowLength() <= 1) 
    {
        mozillaSort(st, "wildcard");
    }
    
    temp++;
}

function deleteRule()
{
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        st.deleteRow(selRows[i]);
    }
    st.adjustDataRows();
    
    if (st.getDataRowLength() <= 0) 
    {
        $("delbtn").disabled = true;
    }
}

function matchTypeChangeHandler()
{
    flag = false;
    
    var eventRow = this.parentNode.parentNode.rowIndex;
    var eventVal = st.getCellStoreValue(eventRow, "matchType", "matchType");
    var thisVal = this.value;
    
    if (eventVal != thisVal) 
    {
        st.getCellElement(eventRow, "matchValue").modify = false;
        st.getCellElement(eventRow, "wildcard").modify = false;
    }
    
    var relation = $("relation").value;
    if (relation == 1) 
    {
        var len = st.getDataRowLength();
        for (var i = 0; i < len && (eventRow != i); i++) 
        {
            var mtype = st.getCellStoreValue(i, "matchType", "matchType");
            if (mtype == thisVal) 
            {
                this.value = eventVal;
                alert(RESOURCE["matchtypecheck"]);
                return;
            }
        }
    }
    
    var beforeType = setChangeType(eventVal);
    var afterType = setChangeType(thisVal);
    
    editElementRemove(st, eventRow, "matchValue");
    editElementRemove(st, eventRow, "wildcard");
    if (afterType == 1) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        editElementAdd(st, eventRow, "wildcard", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
        addInputConstraint(eventRow, thisVal, "wildcard");
    }
    else if (afterType == 2) 
    {
        var opts = new Array();
        if (thisVal == "protype") 
        {
            opts = createOptionsProtype();
        }
        else if (thisVal == "icmp") 
        {
            opts = createOptionsIcmp();
        }
        
        editElementAdd(st, eventRow, "matchValue", "select", opts, 0);
    }
    else if (afterType == 3) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
    }
}

function checkAddIndex()
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (ruleIds[temp] == st.getCellStoreValue(i, "matchType", "matchType")) 
        {
            temp++;
            checkAddIndex();
        }
    }
}

function addClassifier(param)
{
    if (param && flag) 
    {
        xcloseDialog();
        return;
    }
    
    var classifierId = ct.getAttrValue("classifierId");
    var classifierAcl = ct.getAttrValue("classifierAcl")
    
    if (classifierId == null || classifierId == "") 
    {
        alert(RESOURCE["classifierIDCheck"]);
        return;
    }
    
    var parst = parobj.st1;
    for (var i = 0, len = parst.getDataRowLength(); i < len; i++) 
    {
        if (classifierId != 0 && parst.getCellStoreValue(i, "classifierId", "classifierId") == classifierId) 
        {
            alert(RESOURCE["classifierIDExist"]);
            return;
        }
    }
    
    var len = st.getDataRowLength();
    if (len <= 0) 
    {
        alert(RESOURCE["addRules"]);
        return;
    }
    
    if (!checkRuleInput(st) || !checkRuleRelation(st)) 
    {
        return;
    }
    
    var relation = $("relation").value;
    if (relation == 1 && !checkRuleRepeated(st)) 
    {
        return;
    }    
    
    var classifierRuleVal = st.getCellStoreValue(0, "matchType", "matchType") + ":" +
    st.getCellStoreValue(0, "matchValue", "matchValue") +
    ":" +
    st.getCellStoreValue(0, "wildcard", "wildcard");
    
    var classifierRuleStr = RESOURCE[st.getCellStoreValue(0, "matchType", "matchType")] + ":" +
    st.getCellStoreValue(0, "matchValue", "matchValue") +
    ":" +
    st.getCellStoreValue(0, "wildcard", "wildcard");
    
    classifierRuleVal = "{" + trimStringTail(classifierRuleVal, ":") + "}";
    classifierRuleStr = "{" + trimStringTail(classifierRuleStr, ":") + "}";
    
    var relation = $("relation").value == 1 ? "&" : "|";
    
    for (var i = 1; i < len; i++) 
    {
        var mtype = st.getCellStoreValue(i, "matchType", "matchType");
        var mtypeStr = RESOURCE[mtype];
        
        var mval = st.getCellStoreValue(i, "matchValue", "matchValue");
        var wcard = st.getCellStoreValue(i, "wildcard", "wildcard");
        
        var tmpVal = mtype + ":" + mval + ":" + wcard;
        var tmpStr = mtypeStr + ":" + mval + ":" + wcard;
        tmpVal = "{" + trimStringTail(tmpVal, ":") + "}";
        tmpStr = "{" + trimStringTail(tmpStr, ":") + "}";
        
        classifierRuleVal += (relation + tmpVal);
        classifierRuleStr += (relation + tmpStr);
    }
    
    
    var idx = getMaxValueFromArray(parobj.indexList) + 1;
    parobj.indexList.push(idx);
    
    var defaultVal = new Array(idx, classifierId, classifierRuleStr, classifierAcl);
    var tc = parobj.window.tableconf.length > 1 ? parobj.window.tableconf[1] : parobj.window.tableconf[0];
    var parRow = constructRow(parst, tc, defaultVal);
    adjustTableLayout(parst, tc, parst.getDataRowLength());
    
    parobj.st1.getCellElement(parRow, "classifierRule").storeValue["classifierRule"] = classifierRuleVal;
    
    var classifierObj = new Classifier(idx, classifierId, "", parRow);
    parobj.addClassifierList.push(classifierObj);
    if (parobj.st1.getDataRowLength() <= 1) 
    {
        mozillaSort(parobj.st1, "classifierId");
    }
    
    if (param) 
    {
        xcloseDialog();
    }
    else 
    {
        flag = true;
    }
}
