var parobj = getParentWindow();
var flag = true;
var policyId, policyName;
var newPortList = new Array();
var oldPortList = new Array();
var obj = parobj.obj;
var neid = parobj.neid;

window.onload = function()
{
    if (!isIE) 
    {
        parobj = parobj.frames[2];
    }
    obj = parobj.parobj.obj;
    
    initPageInfo();
    queryLogicBoard();
}

function initPageInfo()
{
    policyName = parobj.parobj.st.getCellStoreValue(parobj.parobj.selectedRows[0], "policyName", "policyName");
    policyId = parobj.parobj.st.getCellStoreValue(parobj.parobj.selectedRows[0], "policyId", "policyId");
    
    $("policynametxt").innerHTML = RESOURCE["portpolicyname"];
    $("policynameval").value = policyName;
    
    $("actporttxt").innerHTML = RESOURCE["applyport"];
    $("boardtxt").innerHTML = RESOURCE["board"];
    $("leftporttxt").innerHTML = RESOURCE["leftport"];
    $("rightporttxt").innerHTML = RESOURCE["rightport"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    
    $("board").onchange = boardChangeHandler;
    
    var len = parobj.st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var actPoint = parobj.st.getCellStoreValue(i, "actPoint", "actPoint");
        oldPortList[i] = actPoint;
        addOptionToSelect($("rightport"), new Option(actPoint, i));
    }
}

function boardChangeHandler()
{
    flag = false;
    queryPort();
}

function queryLogicBoard()
{
    var xmldata = createBoardXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORT_POLICY_BOARD + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackBoard, null, "inputdata=" + xmldata);
}

function createBoardXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackBoard(doc)
{
    var data = EncapsulateData(doc);
    
    var boardObj = $("board");
    
    if (data.getSErrorCode() < 2) 
    {
        var len = data.getDataRowLength();
        for (var i = 0; i < len; i++) 
        {
            var board = data.getDataRowParam(i, "board");
            var slotId = board.split("-")[0];
            addOptionToSelect(boardObj, new Option(board, slotId));
        }
    }
    
    queryPort();
}

function queryPort()
{
    var xmldata = createPortXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORT_POLICY_PORT + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackPort, null, "inputdata=" + xmldata);
}

function createPortXml()
{
    var selIndex = $("board").selectedIndex;
    if (selIndex < 0) 
    {
        return;
    }
    
    var selBoard = $("board").options[selIndex].text;
    var boardAry = selBoard.split("-");
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "slotId");
    param.setAttribute("value", boardAry[0]);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "subSlotId");
    param.setAttribute("value", boardAry.length > 2 ? boardAry[2] : "");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);

    return root.toString();
}

function callbackPort(doc)
{
    var data = EncapsulateData(doc);
    
    var boardObj = $("board");
    var selBoard = boardObj.options[boardObj.selectedIndex].text;
    
    var leftport = $("leftport");
    leftport.options.length = 0;
    
    if (data.getSErrorCode() < 2) 
    {
        var len = data.getDataRowLength();
        for (var i = 0; i < len; i++) 
        {
            var port = data.getDataRowParam(i, "port");
            var actpoint = selBoard + "-" + port;
            var isAdd = true;
            
            for (var j = 0; j < oldPortList.length; j++) 
            {
                if (actpoint == oldPortList[j]) 
                {
                    isAdd = false;
                    break;
                }
            }
            
            if (isAdd) 
            {
                addOptionToSelect(leftport, new Option(actpoint, i));
            }
        }
    }
}

function moveToRightList()
{
    flag = false;
    var leftobj = $("leftport");
    var rightobj = $("rightport");
    
    var isAdd = true;
    var tempList = new Array();
    
    var len = leftobj.options.length;
    for (var i = len - 1; i >= 0; i--) 
    {
        if (leftobj.options[i].selected) 
        {
            var txt = leftobj.options[i].text;
            
            var rlen = rightobj.options.length;
            for (var j = 0; j < rlen; j++) 
            {
                if (rightobj.options[j].text == txt) 
                {
                    isAdd = false;
                    break;
                }
            }
            
            if (isAdd) 
            {
                tempList.push(new Option(txt, rlen));
            }
            
            leftobj.remove(i);
        }
    }
    
    for (var i = tempList.length - 1; i >= 0; i--) 
    {
        addOptionToSelect(rightobj, tempList[i]);
    }
}

function moveToLeftList()
{
    flag = false;
    var optObj = $("rightport").options;
    var tempList = new Array();
    
    var len = optObj.length;
    for (var i = len - 1; i >= 0; i--) 
    {
        var opt = optObj[i];
        if (opt.selected) 
        {
            selport = opt.text;
            selboard = $("board").options[$("board").selectedIndex].text;
            
            if (selport.indexOf(selboard) > -1) 
            {
                var isAdd = true;
                var opts = $("leftport").options;
                for (var j = 0, llen = opts.length; j < llen; j++) 
                {
                    if (opts[j].text == selport) 
                    {
                        isAdd = false;
                        break;
                    }
                }
                if (isAdd) 
                {
                    tempList.push(new Option(selport, opts.length));
                }
            }
            
            $("rightport").remove(i);
        }
    }
    
    for (var i = tempList.length - 1; i >= 0; i--) 
    {
        addOptionToSelect($("leftport"), tempList[i]);
    }
}

function setPortActpoint()
{
    if (flag) 
    {
        xcloseDialog();
        return;
    }
    
    var nlen = $("rightport").options.length;
    
    for (var i = 0; i < nlen; i++) 
    {
        var tag = newPortList.length;
        newPortList[tag] = $("rightport").options[i].text;
        
        for (var j = 0; j < oldPortList.length; j++) 
        {
            if (oldPortList[j] == newPortList[tag]) 
            {
                oldPortList.removeAt(j);
                newPortList.removeAt(tag);
                break;
            }
        }
    }
    
    var xmldata = createSetXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_MOD_PORT_POLICY_ACTPOINT + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackSet, null, "inputdata=" + xmldata);
}

function createSetXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    for (var i = 0, len = oldPortList.length; i < len; i++) 
    {
    	var portStr = oldPortList[i];    	
     	if(portStr.indexOf("(") > 0)
     	{
     		portStr = portStr.substring(0, oldPortList[i].indexOf("("))
     	} 
     	
         var ary = portStr.split("-");
         var slotid = ary[0];
         var subslotid = ary.length > 4 ? ary[2] : "255";
         var portid = ary.length > 4 ? ary[4] : ary[2];       	
     	
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotId");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subSlotId");
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portId");
        param.setAttribute("value", portid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "isAuto");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId");
        param.setAttribute("value", "4294967295");
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    for (var i = 0, len = newPortList.length; i < len; i++) 
    {
    	var portStr = newPortList[i];    	
    	if(portStr.indexOf("(") > 0)
    	{
    		portStr = portStr.substring(0,newPortList[i].indexOf("("))
    	}     	
        var ary = portStr.split("-");
        var slotid = ary[0];
        var subslotid = ary.length > 4 ? ary[2] : "255";
        var portid = ary.length > 4 ? ary[4] : ary[2];    
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotId");
        param.setAttribute("value", slotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subSlotId");
        param.setAttribute("value", subslotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portId");
        param.setAttribute("value", portid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "isAuto");
        param.setAttribute("value", 0);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);

    return root.toString();
}

function callbackSet(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() < 2) 
    {
        parobj.queryPort();
        xcloseDialog();
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = RESOURCE["policyId"] + RESOURCE["colon"] + policyId + RESOURCE["semicolon"] +
        RESOURCE["policyName"] +
        RESOURCE["colon"] +
        policyName;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}
