function SortTable()
{
    this.element = this.createComponent();
    this.element.cellSpacing = 1;
    this.head = this.createComponent();
    this.head.className = "stheadcontent";
    this.head.cellSpacing = 1;
    this.body = this.createComponent();
    this.body.className = "stbodycontent";
    
    this.body.cellSpacing = 1;
    this.headPack = document.createElement("div");
    this.bodyPack = document.createElement("div");
    this.element.className = "scrolltable";
    
    this.headPack.appendChild(this.head);
    this.headPack.className = "sthead";
    this.bodyPack.appendChild(this.body);
    this.bodyPack.className = "stbody";
    
    this.bodyPack.parent = this;
    this.bodyPack.onscroll = doOnScroll;
    
    var tr = document.createElement("tr");
    var td = document.createElement("td");
    td.appendChild(this.headPack);
    tr.appendChild(td);
    
    this.extratd = document.createElement("td");
    this.element.firstChild.appendChild(tr);
    
    tr = document.createElement("tr");
    td = document.createElement("td");
    td.setAttribute("colSpan", "2");
    tr.appendChild(td);
    td.appendChild(this.bodyPack);
    this.element.childNodes[1].appendChild(tr);
    
    this.element.datarows = new Array();
    this.element.cellsWidth = new Array();
    this.element.colsArray = new Array();
    this.element.colsArray.selectedId = null;
    this.element.colsArray.imgflag = null;
    this.element.headRow = null;
    this.onRowSelect = null;
    this.onCellEdit = null;
    this.singleChoiceFlg = false;
}

function cellondbclick()
{
    mozillaComboboxDiv = 0;
    
    this.style.backgroundColor = "#d0f946";
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none";
    this.editElement.element.style.display = "";
    
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
    
    if (this.editElement.type == "text") 
    {
        if (this.showElement.getValue() == " ") 
        {
            this.editElement.setValue("");
        }
        else 
        {
            this.editElement.setValue(this.showElement.getValue());
        }
        
        this.appendChild(this.editElement.element);
        this.editElement.element.select();
        this.editElement.element.focus();
        return;
    }
    else if (this.editElement.type == "select") 
    {
        for (i = 0; i < this.editElement.element.options.length; i++) 
        {
            if (this.editElement.element.options[i].text == this.showElement.getValue()) 
            {
                this.editElement.element.options[i].selected = true;
                this.editElement.element.focus();
            }
        }
    }
    else if (this.editElement.type == "combobox") 
    {
        window.curEditCell = this.editElement.element;
        
        var comboObj = this.editElement.element.parent;
        var eleTd = this.editElement.element.parentNode;
        var eleTable = eleTd.offsetParent;
        
        var wdt = eleTd.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";
        
        comboObj.txtview.style.width = wdt;
        comboObj.selview.style.width = wdt;
        comboObj.selview.style.clip = clip;
        
        if (isIE) 
        {
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
        }
        else 
        {
            comboObj.txtview.style.position = "fixed";
            
            var theadHeight = eleTable.offsetParent.offsetParent.firstChild.offsetHeight;
            
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
        }
        
        var showVal = this.showElement.getValue();
        var len = comboObj.selview.options.length;
        
        for (var k = 0; k < len; k++) 
        {
            if (comboObj.selview.options[k].value == showVal ||
            comboObj.selview.options[k].text == showVal) 
            {
                comboObj.setSelectedIndex(k);
                comboObj.txtview.focus();
                break;
            }
        }
        comboObj.txtview.focus();
    }
    
    if (this.offsetWidth && this.width != (this.offsetWidth + "")) 
    {
        this.editElement.element.style.width = (this.offsetWidth - 1) + "px";
    }
    
    this.appendChild(this.editElement.element);
    
    this.editElement.element.focus();
}

function cellonblur()
{
    var obj = this;
    var selectedIndexs = null;
    if (arguments.length > 0 && arguments[0].tagName) 
    {
        obj = arguments[0];
    }
    if (arguments[1]) 
    {
        selectedIndexs = arguments[1];
    }
    
    var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);
    
    if (obj.parentNode.editElement.type == "select") 
    {
        if (obj.selectedIndex > -1) 
        {
            if ("span" == obj.parentNode.showElement.type) 
            {
                obj.parentNode.showElement.setValue(obj.options[obj.selectedIndex].text);
            }
            else 
            {
                obj.parentNode.showElement.setValue(obj.options[obj.selectedIndex].value);
            }
            
            obj.parentNode.parent.setTdCellValue(obj.parentNode, hc.element.keys[0], obj.options[obj.selectedIndex].value);
        }
    }
    else if (obj.parentNode.editElement.type == "combobox") 
    {
        if (!isIE && mozillaComboboxDiv == 0) 
        {
            mozillaComboboxDiv++;
            return;
        }
        
        window.curEditCell = null;
        if ("span" == obj.parentNode.showElement.type) 
        {
            obj.parentNode.showElement.setValue(obj.parentNode.editElement.element.parent.txtview.value);
        }
        else 
        {
            obj.parentNode.showElement.setValue(obj.parentNode.editElement.element.parent.value);
        }
        
        obj.parentNode.parent.setTdCellValue(obj.parentNode, hc.element.keys[0], obj.parentNode.editElement.element.parent.value);
    }
    else 
    {
        obj.style.position = "static";
        obj.style.border = "1px solid #999999";
        obj.style.width = obj.parentNode.offsetWidth;
        obj.parentNode.showElement.element.style.display = "";
        var rows = null;
        if (selectedIndexs != null) 
        {
            rows = selectedIndexs;
        }
        else 
        {
            rows = obj.parentNode.parent.getSelectedRows();
        }
        for (var j = 0; j < rows.length; j++) 
        {
            var cell = obj.parentNode.parent.getCell(rows[j], obj.parentNode.colid);
            if (null == cell.element.editElement || cell.element.isEdit == 0) 
            {
                continue;
            }
            cell.element.showElement.setValue(obj.value);
            
            cell.element.modify = true;
            cell.element.parentNode.modify = true;
            cell.element.style.backgroundColor = "#d0f946";
            cell.element.parent.setTdCellValue(cell.element, obj.parentNode.colid, obj.value);
            cell.element.showElement.element.style.display = "";
            handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
        }
    }    
    
    obj.style.display = "none";
    obj.parentNode.showElement.element.style.display = "";
    
    handleCellEdit(obj.parentNode, TABLE_CONSTANT.AFTEREDIT);
}

function constructRow(st, tc, defaultVal)
{
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            st.addCellEdit(cell, atom);
            st.addCell(row, colid, cell);
        }
        
        var cellwidth = tc.getColWidth(j);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

SortTable.prototype.setOnCellEditHandler = function(func)
{
    if (typeof func != "function") 
    {
        alert("argument of setOnCellEditHandler  must be function type");
        return;
    }
    this.onCellEdit = func;
}

SortTable.prototype.createComponent = function()
{
    element = document.createElement("table");
    thead = document.createElement("thead");
    tbody = document.createElement("tbody");
    element.appendChild(thead);
    element.appendChild(tbody);
    return element;
}

SortTable.prototype.getDataRowLength = function()
{
    return this.element.datarows.length;
}

SortTable.prototype.getTable = function()
{
    return this.element;
}

SortTable.prototype.clearTableData = function()
{
    for (var i = this.getDataRowLength() - 1; i >= 0; i--) 
    {
        this.deleteRow(i);
    }
    this.adjustDataRows();
}

SortTable.prototype.setHeadRow = function(row)
{
    this.element.headRow = row;
}

SortTable.prototype.setHeadRowCss = function(css)
{
    this.element.headRow.element.className = css;
}

SortTable.prototype.setImage = function(path)
{
    this.imgpath = path;
}

SortTable.prototype.setSingleChoiceFlg = function(singleFlag)
{
    this.singleChoiceFlg = singleFlag;
}

SortTable.prototype.addHeadCell = function(row, hc)
{
    if ((hc.element.isSort) == 1) 
    {
        var img = new Image();
        img.setAttribute("border", "0px");
        img.setAttribute("align", "absmiddle");
        img.src = this.imgpath + "up.gif";
        img.style.visibility = "hidden";
        
        hc.element.insertBefore(img, hc.element.firstChild);
        hc.element.style.cursor = "pointer";
        hc.element.style.cursor = "hand";
        hc.element.style.textDecoration = "underline";
        hc.element.onclick = sortRow;
    }
    row.element.cols[hc.element.colid] = hc;
    this.element.colsArray[this.element.colsArray.length] = hc.element.colid;
}

SortTable.prototype.addHead = function(row)
{
    this.head.firstChild.appendChild(row.element);
    this.sortCells(row);
    this.element.headRow = row;
    
}

SortTable.prototype.getColumnCount = function()
{
    return this.head.rows[0].cells.length;
}

SortTable.prototype.sortCells = function(row)
{
    for (var m = 0; m < this.element.colsArray.length; m++) 
    {
        row.element.appendChild(row.element.cols[this.element.colsArray[m]].element);
        row.element.cols[this.element.colsArray[m]].element.colid = this.element.colsArray[m];
    }
}

SortTable.prototype.clearSortFlag = function()
{

    for (var key in this.element.headRow.element.cols) 
    {
        var elem = this.element.headRow.element.cols[key];
        elem.element.firstChild.style.visibility = "hidden";
    }
}

SortTable.prototype.sortRows = function(colEle, imgflag)
{
    if (this.element.colsArray.selectedId && this.element.colsArray.selectedId != colEle.colid) 
    {
        if (this.element.headRow.element.cols[this.element.colsArray.selectedId]) 
        {
            this.element.headRow.element.cols[this.element.colsArray.selectedId].element.firstChild.style.visibility = "hidden";
        }
        this.element.colsArray.selectedId = colEle.colid;
        
    }
    else if (!this.element.colsArray.selectedId) 
    {
        this.element.colsArray.selectedId = colEle.colid;
        
        
    }
    
    var img = colEle.firstChild;
    var flag;
    if (imgflag == null) 
    {
        if (img.style.visibility == "hidden") 
        {
            img.style.visibility = "visible";
        }
        if (img.src.lastIndexOf("up.gif") > 0) 
        {
            img.src = this.imgpath + "down.gif";
            flag = true;
            this.element.colsArray.imgflag = 0;
        }
        else 
        {
            img.src = this.imgpath + "up.gif";
            flag = false;
            this.element.colsArray.imgflag = 1;
        }
    }
    else 
    {
        if (imgflag == 1) 
        {
            flag = false;
        }
        else 
        {
            flag = true;
        }
    }
    
    var data = [];
    var sortArray = [];
    
    var datarows = colEle.parent.element.datarows;
    
    if (colEle.isSortShow == 1) 
    {    
        for (var i = 0; i < datarows.length; i++) 
        {
            data[i] = datarows[i].element.cols[colEle.colid].element.showElement.getValue();
            sortArray[i] = i;
        }
    }
    else 
    {    
        for (var i = 0; i < datarows.length; i++) 
        {
            var obj = datarows[i].element.cols[colEle.colid].element.storeValue;
            var arr = colEle.keys;
            var v = '';
            for (var j = 0; j < arr.length; j++) 
            {
                v = v + obj[arr[j]] + "-";
            }
            data[i] = v.substring(0, v.length - 1);
            sortArray[i] = i;
        }
    }
    
    var c_compare = colEle.compare;
    
    if (c_compare && typeof c_compare == "function") 
    {
        for (var i = 0; i < data.length; i++) 
        {
            for (var j = i + 1; j < data.length; j++) 
            {
                if (flag) 
                {
                    if (c_compare(data[i], data[j]) < 0) 
                    {
                        var tmp = data[i];
                        var tflag = sortArray[i];
                        data[i] = data[j];
                        sortArray[i] = sortArray[j];
                        data[j] = tmp;
                        sortArray[j] = tflag;
                    }
                }
                else 
                {
                    if (c_compare(data[i], data[j]) > 0) 
                    {
                        var tmp = data[i];
                        var tflag = sortArray[i];
                        data[i] = data[j];
                        sortArray[i] = sortArray[j];
                        data[j] = tmp;
                        sortArray[j] = tflag;
                    }
                }
            }
        }
    }
    else 
    {
        for (var i = 0; i < data.length; i++) 
        {
            for (var j = i + 1; j < data.length; j++) 
            {
                if (flag) 
                {
                    if (compare(data[i], data[j]) < 0) 
                    {
                        var tmp = data[i];
                        var tflag = sortArray[i];
                        data[i] = data[j];
                        sortArray[i] = sortArray[j];
                        data[j] = tmp;
                        sortArray[j] = tflag;
                    }
                }
                else 
                {
                    if (compare(data[i], data[j]) > 0) 
                    {
                        var tmp = data[i];
                        var tflag = sortArray[i];
                        data[i] = data[j];
                        sortArray[i] = sortArray[j];
                        data[j] = tmp;
                        sortArray[j] = tflag;
                    }
                }
            }
        }
    }
    
    var rows = datarows;
    colEle.parent.element.datarows = new Array()
    for (var ij = 0; ij < sortArray.length; ij++) 
    {
        colEle.parent.addRow(rows[sortArray[ij]]);
    }
}

SortTable.prototype.addRow = function(row)
{
    this.element.datarows[this.element.datarows.length] = row;
    this.sortCells(row);
    this.body.childNodes[1].appendChild(row.element);
    row.element.onclick = rowclick;
}

SortTable.prototype.addRowAt = function(row, index)
{
    index--;
    if (index < 0 || (index >= this.element.datarows.length)) 
    {
        throw new Error("bad row index value:" + (++index));
    }
    
    var tmp = this.element.datarows[index];
    this.element.datarows[index] = row;
    this.element.datarows[this.element.datarows.length] = tmp;
    
    this.sortCells(row);
    this.body.childNodes[1].insertBefore(row.element, this.body.childNodes[1].childNodes[index]);
    row.element.onclick = rowclick;
}

SortTable.prototype.getRowSelFlag = function(index)
{
    return this.element.datarows[index].element.selectFlag;
}

SortTable.prototype.setRowSelect = function(index)
{
    var obj = this.getRow(index).element;
    obj.style.backgroundColor = "#6f99a5";
    obj.parent.selectTr = obj;
    obj.selectFlag = true;
}

SortTable.prototype.setRowNoneSelect = function(index)
{
    var obj = this.getRow(index).element;
    obj.style.backgroundColor = "#E8E8E8";
    obj.parent.selectTr = null;
    obj.selectFlag = false;
}

SortTable.prototype.deleteHeadRow = function()
{
    var row = this.element.headRow;
    
    var cols = row.element.cols;
    for (var key in cols) 
    {
        for (var o in cols[key].element) 
        {
            cols[key].element.removeAttribute(o);
        }
    }
    
    var ele = row.element;
    for (var o in ele) 
    {
        ele.removeAttribute(o);
    }
    
    this.head.childNodes[0].removeChild(row.element);
}

SortTable.prototype.deleteRow = function(index)
{
    var cols = this.element.datarows[index].element.cols;
    
    for (var key in cols) 
    {
        var cell = cols[key];
        
        if (cell.element.editElement) 
        {
            cell.element.ondblclick = null;
            cell.element.editElement.element.onblur = null;
            cell.element.editElement = null;
        }
        cell.element.showElement = null;
        cell.element.storeValue = null;
        cell.element.currentValue = null;
        cell.element.isEdit = null;
        cell.element.modify = null;
        cell.element.ondblclick = null;
        cell.element.onselectstart = null;
    }
    
    var row = this.element.datarows[index];
    row.element.cols = null;
    row.element.modify = null;
    row.element.className = null;
    row.element.parent = null;
    row.element.selectFlag = null;
    row.element.onclick = null;
    this.body.childNodes[1].removeChild(row.element);
    delete this.element.datarows[index];
}

SortTable.prototype.adjustDataRows = function()
{
    var len = this.element.datarows.length;
    var arr = this.element.datarows;
    
    var i = 0;
    while (arr[i]) 
    {
        i++;
    }
    for (var j = i + 1; j < len; j++) 
    {
        if (null == arr[j] || "undefined" == arr[j]) 
        {
            delete arr[j];
        }
        else 
        {
            arr[i] = arr[j];
            i++;
        }
    }
    this.element.datarows.length = i;
}

SortTable.prototype.createRow = function()
{
    var row = new Row();
    row.element.parent = this;
    return row;
}

SortTable.prototype.createHeadCell = function(colid, name, width)
{

    var hc = new HeadCell(colid, name, width);
    hc.element.parent = this;
    return hc;
}

SortTable.prototype.createCell = function(w)
{
    var ce = new Cell(w);
    ce.element.parent = this;
    return ce;
}

SortTable.prototype.createAtom = function(typstr)
{
    return new Atom(typstr);
}

SortTable.prototype.getRow = function(index)
{
    return this.element.datarows[index];
}

SortTable.prototype.addCell = function(row, colid, cell)
{
    row.element.cols[colid] = cell;
}

SortTable.prototype.setRowCss = function(row, css)
{
    row.element.className = css;
}

SortTable.prototype.getModify = function(index)
{
    return this.element.datarows[index].element.modify;
}

SortTable.prototype.getHeadCell = function(colid)
{
    return this.element.headRow.element.cols[colid];
}

SortTable.prototype.setHeadCellKey = function(hc, key)
{
    hc.element.keys[hc.element.keys.length] = key;
}

SortTable.prototype.setHeadCellConvert = function(hc, key, cvtarr)
{
    hc.element.convertObj[key] = cvtarr;
}

SortTable.prototype.setHCAttribute = function(hc, issort, issortshow, cmpare)
{
    hc.element.isSort = issort;
    hc.element.isSortShow = issortshow;
    hc.element.compare = cmpare;
}

SortTable.prototype.setCellIsEdit = function(cell, isedit)
{
    cell.element.isEdit = isedit;
}

SortTable.prototype.getCellStoreValue = function(index, colid, key)
{
    return this.element.datarows[index].element.cols[colid].element.storeValue[key];
}

SortTable.prototype.getCellCurrentValue = function(index, colid, key)
{
    return this.element.datarows[index].element.cols[colid].element.currentValue[key];
}

SortTable.prototype.setTdCellValue = function(tdelement, key, value)
{
    tdelement.storeValue[key] = value;
    tdelement.currentValue[key] = value;
}

SortTable.prototype.setCellValue = function(cell, key, value)
{
    cell.element.storeValue[key] = value;
    cell.element.currentValue[key] = value;
}

SortTable.prototype.addCellShow = function(cell, atom)
{
    cell.element.showElement = atom;
    cell.element.appendChild(atom.element);
}

SortTable.prototype.getCellShow = function(index, colid)
{
    return this.element.datarows[index].element.cols[colid].element.showElement;
}

function stopEventPropagation(e)
{
    if (!e) 
    {
        var e = window.event;
        e.cancelBubble = true;
    }
    if (e.stopPropagation) 
    {
        e.stopPropagation();
    }
}

SortTable.prototype.addCellEdit = function(cell, atom)
{
    if (cell.element.isEdit == 1 && atom.element && cell.element.showElement) 
    {
        cell.element.style.backgroundColor = "#ffffff";
        cell.element.editElement = atom;
        
        atom.element.onclick = stopEventPropagation;
        atom.element.ondblclick = stopEventPropagation;
        atom.element.style.display = "none";
        
        cell.element.appendChild(atom.element);
        cell.element.style.cursor = "pointer";
        cell.element.style.cursor = "hand";
        cell.element.ondblclick = cellondbclick;
        
        atom.element.onblur = cellonblur;
    }
    else 
    {
        cell.element.editElement = atom;
        if (atom.element) 
        {
            atom.element.onclick = stopEventPropagation;
            atom.element.ondblclick = stopEventPropagation;
            atom.element.style.display = "none";
            cell.element.appendChild(atom.element);
            atom.element.onblur = cellonblur;
        }
        
        cell.element.style.cursor = "pointer";
        cell.element.style.cursor = "hand";
        cell.element.ondblclick = null;
    }
}

SortTable.prototype.addCellEditElement = function(cell, atom)
{
    var ce = cell.element;
    if (ce.isEdit == 1) 
    {
    
        ce.style.backgroundColor = "#ffffff";
        cell.element.editElement = atom;
        
        cell.element.style.cursor = "hand";
        ce.ondblclick = cellondbclick;
        
        
        atom.element.onblur = cellonblur;
    }
    
    else 
    {
        cell.element.editElement = atom;        
        cell.element.style.cursor = "hand";
        cell.element.ondblclick = null;
    }
}

SortTable.prototype.getCellEdit = function(index, colid)
{
    return this.element.datarows[index].element.cols[colid].element.editElement;
}

SortTable.prototype.getCellElement = function(index, colid)
{
    return this.element.datarows[index].element.cols[colid].element;
}

SortTable.prototype.getCell = function(index, colid)
{
    return this.element.datarows[index].element.cols[colid];
}

SortTable.prototype.setCellClass = function(cell, css)
{
    cell.element.className = css;
}

SortTable.prototype.getCellModify = function(index, colid)
{
    return this.element.datarows[index].element.cols[colid].element.modify;
}

SortTable.prototype.setAtomValue = function(atom, value)
{
    if (atom.type == "span") 
    {
        atom.setValue(value);
    }
    else 
    {
        atom.element.value = value;
    }
}

SortTable.prototype.getAtomValue = function(atom)
{
    if (atom.type == "span") 
    {
        return atom.element.innerText;
    }
    else 
    {
        return atom.element.value;
    }
}

SortTable.prototype.setAtomCalss = function(atom, css)
{
    atom.element.className = css;
}

SortTable.prototype.setBodyHeight = function(h)
{
    this.bodyPack.style.height = h;
	this.bodyPack.clip = "rect(0 auto   " + h + " 0)";
}

SortTable.prototype.setPageWidth = function()
{
    var percent = "100%";
    this.element.style.width = percent;
    this.headPack.firstChild.style.width = percent;
    this.bodyPack.firstChild.style.width = percent;
}

SortTable.prototype.setBodyWidth = function(width, percent, num)
{
    if (arguments.length != 3) 
    {
        return;
    }
    if (isIE) 
    {
        if (num != 0) 
        {
            this.element.style.width = "100%";
            this.headPack.firstChild.style.width = percent;
            this.bodyPack.firstChild.style.width = percent;
        }
        else 
        {
            this.headPack.firstChild.style.width = "100%";
            this.bodyPack.firstChild.style.width = "100%";
            this.element.style.width = "100%";
        }
    }
    else 
    {
        this.element.style.width = "100%";
        this.headPack.firstChild.style.width = width;
        this.bodyPack.firstChild.style.width = width;
        
    }
}

SortTable.prototype.setWidth = function(width)
{
    this.element.style.width = width;
}

SortTable.prototype.setOnRowSelectHandler = function(func)
{
    if (typeof func != "function") 
    {
        alert("argument of setOnRowSelectHandler must be function type");
        return;
    }
    this.onRowSelect = func;
    
}

SortTable.prototype.getSelectedRowCount = function()
{
    var rowSelectedCount = 0;
    for (var i = 0, rowLength = this.getDataRowLength(); i < rowLength; i++) 
    {
        if (this.getRowSelFlag(i)) 
        {
            rowSelectedCount++;
        }
    }
    return rowSelectedCount;
}

SortTable.prototype.getSelectedRows = function()
{
    var rowindex = [];
    for (var i = 0, rowLength = this.getDataRowLength(); i < rowLength; i++) 
    {
        if (this.getRowSelFlag(i)) 
        {
            rowindex.push(i);
        }
    }
    return rowindex;
}
