var TECMDCODE_GET_PORT_POLICY = TECMDCODE_GET_PORT_POLICY_QOSINFO;
var TECMDCODE_GET_POLICY_QUEUE = TECMDCODE_GET_PORT_POLICY_QUEUE_QOSINFO;

var invalid_char = "";

var ruleColon = ":";
var ruleSemicolon = "|";

var bw_enable = 1; //mean's enable
var bw_disable = 2; //mean's disable
var queue_len = 8;
var policy_name_max_len = 64;
var default_wfq_policy_name = "1-WFQ Default Scheduling";

/**
 * sort table's row color
 */
var color_select = "#6f99a5"; //dark green
var color_desel = "#ffffff"; //white
var color_nonedit = "#E8E8E8"; //grey
var color_edited = "#d0f946"; //green
/**
 * policy type
 */
var type_port_policy = 1; //port policy
var type_ingress_policy = 2; //vuni-ingress policy
var type_egress_policy = 3; //vuni-egress policy
var type_pw_policy = 4; //pw policy
var type_atm_policy = 5; //atm policy
var type_qinq_policy = 6; //qinq policy
var type_wred_port = 1; //port wred policy
var type_wred_service = 2; //service wred policy
var color_wred_red = 1; //color red
var color_wred_yellow = 2; //color yellow
var color_wred_green = 3; //color green
var tab_id_cos = "cos"; //cos configuration
var tab_id_classifier = "classifier"; //classifier configuration
var tab_id_actpoint = "actpoint"; //apply point
var queue_type_all = 0;
var queue_type_cs7 = 1;
var queue_type_cs6 = 2;
var queue_type_ef = 3;
var queue_type_af4 = 4;
var queue_type_af3 = 5;
var queue_type_af2 = 6;
var queue_type_af1 = 7;
var queue_type_be = 8;

var queue_default_tail = 0;
var queue_default_wred = invalid_char;
var queue_default = 0;

var max_port_drop_tail = "480";
var max_serv_drop_tail = "4095";

var wredPolicy = "";
var wredType;
var TECMD_GET_WRED_POLICY;

/**
 * convert info
 */
var enableStatus = new Array();
enableStatus[1] = "ID_ENABLE";
enableStatus[2] = "ID_DISABLE";

var classifierShare = new Array();
classifierShare[1] = "ID_DISABLE";
classifierShare[2] = "ID_ENABLE";

var colorMode = new Array();
colorMode[255] = "none";
colorMode[1] = "color-bind";
colorMode[2] = "color-aware";

var aclStatus = new Array();
aclStatus[0] = "ID_NULL";
aclStatus[1] = "ID_PERMEIT";
aclStatus[2] = "ID_DENY";

var queueType = new Array();
queueType[1] = "queue_cs7";
queueType[2] = "queue_cs6";
queueType[3] = "queue_ef";
queueType[4] = "queue_af4";
queueType[5] = "queue_af3";
queueType[6] = "queue_af2";
queueType[7] = "queue_af1";
queueType[8] = "queue_be";

var remarkCos = new Array();
remarkCos[255] = "none";
remarkCos[1] = "queue_cs7";
remarkCos[2] = "queue_cs6";
remarkCos[3] = "queue_ef";
remarkCos[4] = "queue_af4";
remarkCos[5] = "queue_af3";
remarkCos[6] = "queue_af2";
remarkCos[7] = "queue_af1";
remarkCos[8] = "queue_be";

var handleMethod = new Array();
handleMethod["255"] = "none"
handleMethod[1] = "pass";
handleMethod[2] = "discard";
handleMethod[3] = "remark";

var remarkColor = new Array();
remarkColor["255"] = "none"
remarkColor[1] = "wredred";
remarkColor[2] = "wredyellow";
remarkColor[3] = "wredgreen";

var wredColor = new Array();
wredColor[1] = "wredred";
wredColor[2] = "wredyellow";
wredColor[3] = "wredgreen";

var matchType = new Array();
matchType["sip"] = "sip";
matchType["dip"] = "dip";
matchType["smac"] = "smac";
matchType["dmac"] = "dmac";
matchType["protype"] = "protype";
matchType["sport"] = "sport";
matchType["dport"] = "dport";
matchType["icmp"] = "icmp";
matchType["dscp"] = "dscp";
matchType["ipprec"] = "ipprec";
matchType["cvlanid"] = "cvlanid";
matchType["cvlanpri"] = "cvlanpri";
matchType["svlanid"] = "svlanid";
matchType["svlanpri"] = "svlanpri";
matchType["dei"] = "dei";

var error_time_out = 131080;

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = errorObj["policyId"] + "-" + errorObj["policyName"];
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function fillSortTable(st, tc, rows, defVal)
{
    for (var i = 0; i < rows; i++) 
    {
        constructRow(st, tc, defVal[i]);
    }
    
    adjustTableLayout(st, tc, rows);
}

function constructRow(st, tc, defaultVal)
{
    if (st.element.isAppendEmptyTr) 
    {
        var tBody = st.bodyPack.firstChild.lastChild;
        tBody.removeChild(tBody.firstChild);
        st.element.isAppendEmptyTr = false;
    }
    
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEdit(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            atom.element.onclick = stopEventPropagation;
            atom.element.ondblclick = stopEventPropagation;
            st.editdom[colid] = atom;
            
            st.addCellEditElement(cell, st.editdom[colid]);
            st.addCell(row, colid, cell);
        }
        
        var cellwidth = tc.getColWidth(j);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

function editElementRemove(st, row, colid)
{
    var cell = st.getCell(row, colid);
    cell.element.modify = false;
    st.setCellIsEdit(cell, 0);
    
    if (!st.getRowSelFlag(row)) 
    {
        cell.element.style.backgroundColor = "#E8E8E8";
    }
    st.setCellValue(cell, colid, "");
    cell.element.showElement.setValue("");
}

function editElementAdd(st, row, colid, type, opts, val)
{
    var cell = st.getCell(row, colid);
    var atom = st.createAtom(type);
    if (type == "select") 
    {
        for (var i = 0; i < opts.length; i++) 
        {
            atom.addOptionObj(opts[i]);
        }
        
        st.setCellValue(cell, colid, opts[val].value);
        cell.element.showElement.setValue(opts[val].text);
    }
    else 
    {
    	if (val==null)
        {
    		st.setCellValue(cell, colid, "");
            cell.element.showElement.setValue("");
        }
    	else
    	{
    		st.setCellValue(cell, colid, val);
            cell.element.showElement.setValue(val);
    	}
    }
    
    if (cell.element.childNodes.length > 1) 
    {
        cell.element.removeChild(cell.element.childNodes[1]);
    }
    
    st.setCellIsEdit(cell,1);
    cell.element.modify = false;
    cell.element.editElement = atom;
    
    atom.element.onclick = stopEventPropagation;
    atom.element.ondblclick = stopEventPropagation;
    atom.element.style.display = "none";
    
    cell.element.appendChild(atom.element);
    cell.element.style.cursor = "pointer";
    cell.element.style.cursor = "hand";
    cell.element.ondblclick = ptnCellondbclick;
    
    atom.element.onblur = ptnCellonblur;
}

function ptnCellondbclick()
{
    mozillaComboboxDiv = 0;
    
    this.style.backgroundColor = "#d0f946";
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none";
    this.editElement.element.style.display = "";
    
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
    
    if (this.editElement.type == "text") 
    {
        if (this.showElement.getValue() == " ") 
        {
            this.editElement.setValue("");
        }
        else 
        {
            this.editElement.setValue(this.showElement.getValue());
        }
        
        this.appendChild(this.editElement.element);
        this.editElement.element.select();
        this.editElement.element.focus();
    }
    else if (this.editElement.type == "select") 
    {
        for (i = 0; i < this.editElement.element.options.length; i++) 
        {
            if (this.editElement.element.options[i].text == this.showElement.getValue()) 
            {
                this.editElement.element.options[i].selected = true;
                this.editElement.element.focus();
            }
        }
    }
    else if (this.editElement.type == "combobox") 
    {
        window.curEditCell = this.editElement.element;
        
        var comboObj = this.editElement.element.parent;
        var eleTd = this.editElement.element.parentNode;
        var eleTable = eleTd.offsetParent;
        
        var wdt = eleTd.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";
        
        comboObj.txtview.style.width = wdt;
        comboObj.selview.style.width = wdt;
        comboObj.selview.style.clip = clip;
        
        if (isIE) 
        {
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + 1;
        }
        else 
        {
            comboObj.txtview.style.position = "fixed";
            
            var theadHeight = eleTable.offsetParent.offsetParent.firstChild.offsetHeight;
            
            comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
            comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
        }
        
        var showVal = this.showElement.getValue();
        var len = comboObj.selview.options.length;
        
        for (var k = 0; k < len; k++) 
        {
            if (comboObj.selview.options[k].value == showVal ||
            comboObj.selview.options[k].text == showVal) 
            {
                comboObj.setSelectedIndex(k);
                comboObj.txtview.focus();
                break;
            }
        }
        
        comboObj.txtview.focus();
    }
}

/*
 Onblur handler for editElement of cell
 */
function ptnCellonblur()
{
    var hc = this.parentNode.parent.getHeadCell(this.parentNode.colid);
    
    if (this.parentNode.editElement.type == "select") 
    {
        if (this.selectedIndex > -1) 
        {
            if ("span" == this.parentNode.showElement.type) 
            {
                this.parentNode.showElement.setValue(this.options[this.selectedIndex].text);
            }
            else 
            {
                this.parentNode.showElement.setValue(this.options[this.selectedIndex].value);
            }
            
            this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.options[this.selectedIndex].value);
        }
    }
    else if (this.parentNode.editElement.type == "combobox") 
    {
        if (!isIE && mozillaComboboxDiv == 0) 
        {
            mozillaComboboxDiv++;
            return;
        }
        
        window.curEditCell = null;
        if ("span" == this.parentNode.showElement.type) 
        {
            this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.txtview.value);
        }
        else 
        {
            this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.value);
        }
        
        this.parentNode.parent.setTdCellValue(this.parentNode, hc.element.keys[0], this.parentNode.editElement.element.parent.value);
    }
    else 
    {
        this.style.position = "static";
        this.style.border = "1px solid #999999";
        this.style.width = this.parentNode.offsetWidth;
        this.parentNode.showElement.element.style.display = "";
        var rows = this.parentNode.parent.getSelectedRows();
        for (var j = 0; j < rows.length; j++) 
        {
            var cell = this.parentNode.parent.getCell(rows[j], this.parentNode.colid);
            if (null == cell.element.editElement || cell.element.isEdit == 0) 
            {
                continue;
            }
            cell.element.showElement.setValue(this.value);
            
            cell.element.modify = true;
            cell.element.parentNode.modify = true;
            cell.element.style.backgroundColor = "#d0f946";
            cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);
            cell.element.showElement.element.style.display = "";
            handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
        }
    }
    
    this.style.display = "none";
    this.parentNode.showElement.element.style.display = "";
    
    handleCellEdit(this.parentNode, TABLE_CONSTANT.AFTEREDIT);
}

function swapTableRow(st, src, des)
{
    var srcRow = st.getRow(src);
    var desRow = st.getRow(des);
    
    st.element.datarows[des] = srcRow;
    st.element.datarows[src] = desRow;
    
    srcRow.element.swapNode(desRow.element);
}

function setCellColor(st, row, colid)
{
    var cell = st.getCellElement(row, colid);
    var color = color_desel;
    
    if (st.getRowSelFlag(row)) 
    {
        color = color_select;
    }
    else if (cell.isEdit == 0) 
    {
        color = color_nonedit;
    }
    else if (cell.modify) 
    {
        color = color_edited;
    }
    
    cell.style.backgroundColor = color;
}

function checkNumInput(obj)
{
    var oedit = obj;
    oedit.style.imeMode = "disabled";
    oedit.onpaste = function()
    {
        return false;
    }
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        
        if (code == 13) 
        {
            event.srcElement.blur();
            return;
        }
        
        if (code == 8) 
        {
            return true;
        }
        
        if (code < 48 || code > 57) 
        {
            return false;
        }
        
        var numobj = event.srcElement;
        var position = digitalTag_getPos(numobj);
        if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
        {
            return false;
        }
        
        if (numobj.value == '0' && position > 0) 
        {
            return false;
        }
    }
    
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var numobj = event.srcElement;
        
        if (event.keyCode != 37 && event.keyCode != 39 && numobj.value &&
        numobj.value.length > 0 &&
        numobj.value.substring(0, 1) == '0') 
        {
            numobj.value = parseInt(numobj.value, 10);
        }
    }
}

function setTabsHeight(tab, tabodyheight)
{
    for (var key in tab.tabNodes) 
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

function mozillaSort(st, key)
{
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = key;
        st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    st.sortRows(td, st.element.colsArray.imgflag);
}

String.prototype.trim = function()
{
    return this.replace(/(^\s*)|(\s*$)/g, "");
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
}

var c_invalid_char = "/";

var worktype = new Array();
worktype["1"] = "UBR";
worktype["2"] = "CBR";
worktype["3"] = "RT-VBR";
worktype["4"] = "NRT-VBR";

var flowtype = new Array();
flowtype["1"] = "NoTrafficDescriptor";
flowtype["2"] = "NoClpNoScr";
flowtype["3"] = "ClpNoTaggingNoScr";
flowtype["4"] = "ClpTaggingNoScr";
flowtype["5"] = "NoClpScr";
flowtype["6"] = "ClpNoTaggingScr";
flowtype["7"] = "ClpTaggingScr";
flowtype["9"] = "ClpTransparentNoScr";
flowtype["10"] = "ClpTransparentScr";
flowtype["11"] = "NoClpTaggingNoScr";
flowtype["12"] = "NoClpNoScrCdvt";
flowtype["13"] = "NoClpScrCdvt";
flowtype["14"] = "ClpNoTaggingScrCdvt";
flowtype["15"] = "ClpTaggingScrCdvt";

var isclosed = new Array();
isclosed["0"] = "no";
isclosed["1"] = "yes";

var atmenableStatus = new Array();
atmenableStatus[0] = "ID_DISABLE";
atmenableStatus[1] = "ID_ENABLE";


var UBR = "1";
var CBR = "2";
var RT_VBR = "3";
var NRT_VBR = "4";

var flowtypevalue = new Array();
flowtypevalue["NoTrafficDescriptor"] = "1";
flowtypevalue["NoClpNoScr"] = "2";
flowtypevalue["ClpNoTaggingNoScr"] = "3";
flowtypevalue["ClpTaggingNoScr"] = "4";
flowtypevalue["NoClpScr"] = "5";
flowtypevalue["ClpNoTaggingScr"] = "6";
flowtypevalue["ClpTaggingScr"] = "7";
flowtypevalue["ClpTransparentNoScr"] = "9";
flowtypevalue["ClpTransparentScr"] = "10";
flowtypevalue["NoClpTaggingNoScr"] = "11";
flowtypevalue["NoClpNoScrCdvt"] = "12";
flowtypevalue["NoClpScrCdvt"] = "13";
flowtypevalue["ClpNoTaggingScrCdvt"] = "14";
flowtypevalue["ClpTaggingScrCdvt"] = "15";

var NoTrafficDescriptor = "1";
var NoClpNoScr = "2";
var ClpNoTaggingNoScr = "3";
var ClpTaggingNoScr = "4";
var NoClpScr = "5";
var ClpNoTaggingScr = "6";
var ClpTaggingScr = "7";
var ClpNoTaggingMcr = "8";
var ClpTransparentNoScr = "9";
var ClpTransparentScr = "10";
var NoClpTaggingNoScr = "11";
var NoClpNoScrCdvt = "12";
var NoClpScrCdvt = "13";
var ClpNoTaggingScrCdvt = "14";
var ClpTaggingScrCdvt = "15";


var item = new Array();

item[1] = new Array();
item[1][1] = new scell("Clp01Pcr", true);
item[1][2] = new scell("Clp01Scr", true);
item[1][3] = new scell("Clp0Pcr", true);
item[1][4] = new scell("Clp0Scr", true);
item[1][5] = new scell("xytfcc", true);
item[1][6] = new scell("xyycbhrx", true);

item[2] = new Array();
item[2][1] = new scell("Clp01Pcr", false);
item[2][2] = new scell("Clp01Scr", true);
item[2][3] = new scell("Clp0Pcr", true);
item[2][4] = new scell("Clp0Scr", true);
item[2][5] = new scell("xytfcc", true);
item[2][6] = new scell("xyycbhrx", true);

item[3] = new Array();
item[3][1] = new scell("Clp01Pcr", false);
item[3][2] = new scell("Clp01Scr", true);
item[3][3] = new scell("Clp0Pcr", false);
item[3][4] = new scell("Clp0Scr", true);
item[3][5] = new scell("xytfcc", true);
item[3][6] = new scell("xyycbhrx", true);

item[4] = new Array();
item[4][1] = new scell("Clp01Pcr", false);
item[4][2] = new scell("Clp01Scr", true);
item[4][3] = new scell("Clp0Pcr", false);
item[4][4] = new scell("Clp0Scr", true);
item[4][5] = new scell("xytfcc", true);
item[4][6] = new scell("xyycbhrx", true);

item[5] = new Array();
item[5][1] = new scell("Clp01Pcr", false);
item[5][2] = new scell("Clp01Scr", false);
item[5][3] = new scell("Clp0Pcr", true);
item[5][4] = new scell("Clp0Scr", true);
item[5][5] = new scell("xytfcc", false);
item[5][6] = new scell("xyycbhrx", true);

item[6] = new Array();
item[6][1] = new scell("Clp01Pcr", false);
item[6][2] = new scell("Clp01Scr", true);
item[6][3] = new scell("Clp0Pcr", true);
item[6][4] = new scell("Clp0Scr", false);
item[6][5] = new scell("xytfcc", false);
item[6][6] = new scell("xyycbhrx", true);

item[7] = new Array();
item[7][1] = new scell("Clp01Pcr", false);
item[7][2] = new scell("Clp01Scr", true);
item[7][3] = new scell("Clp0Pcr", true);
item[7][4] = new scell("Clp0Scr", false);
item[7][5] = new scell("xytfcc", false);
item[7][6] = new scell("xyycbhrx", true);

item[8] = new Array();
item[8][1] = new scell("Clp01Pcr", true);
item[8][2] = new scell("Clp01Scr", true);
item[8][3] = new scell("Clp0Pcr", true);
item[8][4] = new scell("Clp0Scr", true);
item[8][5] = new scell("xytfcc", true);
item[8][6] = new scell("xyycbhrx", true);

item[9] = new Array();
item[9][1] = new scell("Clp01Pcr", false);
item[9][2] = new scell("Clp01Scr", true);
item[9][3] = new scell("Clp0Pcr", true);
item[9][4] = new scell("Clp0Scr", true);
item[9][5] = new scell("xytfcc", true);
item[9][6] = new scell("xyycbhrx", false);

item[10] = new Array();
item[10][1] = new scell("Clp01Pcr", false);
item[10][2] = new scell("Clp01Scr", false);
item[10][3] = new scell("Clp0Pcr", true);
item[10][4] = new scell("Clp0Scr", true);
item[10][5] = new scell("xytfcc", false);
item[10][6] = new scell("xyycbhrx", false);

item[11] = new Array();
item[11][1] = new scell("Clp01Pcr", false);
item[11][2] = new scell("Clp01Scr", true);
item[11][3] = new scell("Clp0Pcr", true);
item[11][4] = new scell("Clp0Scr", true);
item[11][5] = new scell("xytfcc", true);
item[11][6] = new scell("xyycbhrx", false);

item[12] = new Array();
item[12][1] = new scell("Clp01Pcr", false);
item[12][2] = new scell("Clp01Scr", true);
item[12][3] = new scell("Clp0Pcr", true);
item[12][4] = new scell("Clp0Scr", true);
item[12][5] = new scell("xytfcc", true);
item[12][6] = new scell("xyycbhrx", false);

item[13] = new Array();
item[13][1] = new scell("Clp01Pcr", false);
item[13][2] = new scell("Clp01Scr", false);
item[13][3] = new scell("Clp0Pcr", true);
item[13][4] = new scell("Clp0Scr", true);
item[13][5] = new scell("xytfcc", false);
item[13][6] = new scell("xyycbhrx", false);

item[14] = new Array();
item[14][1] = new scell("Clp01Pcr", false);
item[14][2] = new scell("Clp01Scr", true);
item[14][3] = new scell("Clp0Pcr", true);
item[14][4] = new scell("Clp0Scr", false);
item[14][5] = new scell("xytfcc", false);
item[14][6] = new scell("xyycbhrx", false);

item[15] = new Array();
item[15][1] = new scell("Clp01Pcr", false);
item[15][2] = new scell("Clp01Scr", true);
item[15][3] = new scell("Clp0Pcr", true);
item[15][4] = new scell("Clp0Scr", false);
item[15][5] = new scell("xytfcc", false);
item[15][6] = new scell("xyycbhrx", false);

function scell(scellname, disable)
{

    this.scellname = scellname;
    this.disable = disable;
    
    this.getScellname = function()
    {
    }
}

var worktypechangeitem = new Array();

worktypechangeitem[1] = new Array();
worktypechangeitem[1][1] = "NoTrafficDescriptor";
worktypechangeitem[1][2] = "NoClpNoScr";
worktypechangeitem[1][3] = "NoClpTaggingNoScr";
worktypechangeitem[1][4] = "NoClpNoScrCdvt";

worktypechangeitem[2] = new Array();
worktypechangeitem[2][1] = "NoClpNoScr";
worktypechangeitem[2][2] = "ClpNoTaggingNoScr";
worktypechangeitem[2][3] = "ClpTaggingNoScr";
worktypechangeitem[2][4] = "ClpTransparentNoScr";
worktypechangeitem[2][5] = "NoClpNoScrCdvt";

worktypechangeitem[3] = new Array();
worktypechangeitem[3][1] = "ClpTransparentScr";
worktypechangeitem[3][2] = "NoClpScrCdvt";
worktypechangeitem[3][3] = "ClpNoTaggingScrCdvt";
worktypechangeitem[3][4] = "ClpTaggingScrCdvt";

worktypechangeitem[4] = new Array();
worktypechangeitem[4][1] = "NoClpScr";
worktypechangeitem[4][2] = "ClpNoTaggingScr";
worktypechangeitem[4][3] = "ClpTaggingScr";

atmDirection = new Array();
atmDirection[1] = "ingress";
atmDirection[2] = "egress";
atmDirection[255] = "none";

sigType = new Array();
sigType[1] = "static";
sigType[2] = "dynamic";

pwType = new Array();
pwType[1] = "pwtype1";
pwType[2] = "pwtype2";
pwType[3] = "pwtype3";
pwType[4] = "pwtype4";
pwType[5] = "pwtype5";
pwType[6] = "pwtype6";
pwType[7] = "pwtype7";
pwType[8] = "pwtype8";
pwType[9] = "pwtype9";
pwType[10] = "pwtype10";
pwType[11] = "pwtype11";
pwType[12] = "pwtype12";
pwType[13] = "pwtype13";
pwType[14] = "pwtype14";
pwType[15] = "pwtype15";
pwType[16] = "pwtype16";
pwType[17] = "pwtype17";
pwType[18] = "pwtype18";
pwType[19] = "pwtype19";
pwType[20] = "pwtype20";
pwType[21] = "pwtype21";
pwType[22] = "pwtype21";
pwType[23] = "pwtype21";
pwType[24] = "pwtype21";
pwType[25] = "pwtype21";

pwDir = new Array();
pwDir[1] = "bidirectional";
pwDir[2] = "unbidirectional";

var isDemo = false;

function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    if (elem == null || elem.tagName != 'TD' || null == elem.parent || elem.editElement == null) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    
    if (colid == "dropWred") 
    {
        return;
    }
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
    }
}

function setOpDesc(param, value)
{
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", value);
}

function queryWredPolicy(param)
{
    wredType = param;
    if (wredType == type_wred_port) 
    {
        wredPolicy = "1-default port wred";
        TECMD_GET_WRED_POLICY = TECMDCODE_GET_PORT_WRED_POLICY;
    }
    else 
    {
        wredPolicy = "1-default serv wred";
        TECMD_GET_WRED_POLICY = TECMDCODE_GET_SERVICE_WRED_POLICY;
    }
    
    var xmldata = createQueryWredXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMD_GET_WRED_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQueryWred, null, "inputdata=" + xmldata);
}

function createQueryWredXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "wredType");
    param.setAttribute("value", wredType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryWred(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        if (data.getDataRowLength() > 0) 
        {
            wredPolicy = data.rows[0].policyId.value + "-" + data.rows[0].policyName.value;
        }
        else 
        {
            wredPolicy = "1-default serv wred";
        }
    }
}

SortTable.prototype.addCellEditElement = function(cell, atom)
{
    var ce = cell.element;
    if (ce.isEdit == 1) 
    {
        ce.style.backgroundColor = "#ffffff";
        cell.element.editElement = atom;
        ce.childNodes[0].style.color = "#000000";
        
        cell.element.style.cursor = "hand";
        ce.ondblclick = cellondbclick;
        
        atom.element.onblur = cellonblur;
    }
    else 
    {
        cell.element.editElement = atom;
        cell.element.style.cursor = "hand";
        cell.element.ondblclick = null;
    }
}

/*
 Cell dblclick handler
 */
function cellondbclick()
{
    mozillaComboboxDiv = 0;
    
    this.style.backgroundColor = "#d0f946";
    if (isIE) 
    {
        this.onselectstart = null;
    }
    else 
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none";
    this.editElement.element.style.display = "";
    var colid = this.colid;
    var editdom = this.parent.editdom[colid];
    editdom.element.style.display = "";
    
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
    
    if (editdom.type == "text") 
    {
        if (this.showElement.getValue() == " " || this.showElement.getValue() == "\xA0") 
        {
            editdom.setValue("");
        }
        else 
        {
            editdom.setValue(this.showElement.getValue());
        }
    }
    else if (editdom.type == "select") 
    {
    
        for (i = 0; i < editdom.element.options.length; i++) 
        {
            if (editdom.element.options[i].text == this.showElement.getValue()) 
            {
                editdom.element.options[i].selected = true;
                editdom.element.focus();
            }
        }
    }
    else if (this.editElement.type == "combobox") 
    {
        this.appendChild(editdom.element);
        window.curEditCell = this.editElement.element;
        
        var comboObj = this.editElement.element.parent;
        var eleTd = this.editElement.element.parentNode;
        var eleTable = eleTd.offsetParent;
        
        var wdt = eleTd.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";
        
        comboObj.txtview.style.width = wdt;
        comboObj.selview.style.width = wdt;
        comboObj.selview.style.clip = clip;
        
        if (isIE) 
        {
            var absCellY = getPosY(eleTd);
            var absTableY = getPosY(eleTable);
            comboObj.txtview.style.top = absCellY - absTableY + 1;
            comboObj.selview.style.top = absCellY - absTableY + 1;
        }
        else 
        {
            comboObj.txtview.style.position = "fixed";
            comboObj.selview.style.position = "fixed";
            
            var absCellY = getPosY(eleTd);
            var scrollTop = document.body.scrollTop; // scrollbar scroll length
            comboObj.txtview.style.top = absCellY - scrollTop;
            comboObj.selview.style.top = absCellY - scrollTop;
        }
        
        var showVal = this.showElement.getValue();
        var len = comboObj.selview.options.length;
        
        for (var k = 0; k < len; k++) 
        {
            if (comboObj.selview.options[k].value == showVal ||
            comboObj.selview.options[k].text == showVal) 
            {
                comboObj.setSelectedIndex(k);
                comboObj.txtview.focus();
                break;
            }
        }
        
        comboObj.txtview.focus();
        return;
    }
    
    if (this.offsetWidth && this.width != (this.offsetWidth + "")) 
    {
        editdom.element.style.width = (this.offsetWidth - 1) + "px";
    }
    
    this.appendChild(editdom.element);
    
	  if (editdom.element.style.display != "")
	  {
	  	  editdom.element.style.display = "";
	  }
    editdom.element.focus();
}
