var st;
var parobj = getParentWindow();
var parIndex;
var flag = true;
var temp = 0;

window.onload = function()
{
    if (!isIE) 
    {
        if (parobj.frames.length >= 5) 
        {
            parobj = parobj.frames[3];
        }
        else 
        {
            parobj = parobj.frames[1];
        }
    }
    
    initTable();
    initButtonInfo();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("230px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("ruletable").appendChild(st.getTable());
    
    parIndex = parobj.st1.getSelectedRows()[0];
    
    var parSt = parobj.st1;
    var classifierRule = parSt.getCellStoreValue(parIndex, "classifierRule", "classifierRule");
    
    if (!classifierRule) 
    {
        return;
    }
    
    var relationStr = classifierRule.indexOf("|") >= 0 ? "|" : "&";
    var relation = relationStr == "&" ? 1 : 2;
    
    var ary = classifierRule.split(relationStr);
    var len = ary.length;
    
    for (var i = 0; i < len; i++) 
    {
        var tmp = trimString(ary[i]);
        if (tmp == "") 
        {
            continue;
        }
        var ruleAry = tmp.split(":");
        constructRow(st, window.tableconf[0], ruleAry);
        
        tmp = st.getCellStoreValue(i, "matchType", "matchType");
        if (tmp == "protype") 
        {
            var opts = createOptionsProtype();
            var k;
            for (k = 0; k < opts.length; k++) 
            {
                if (opts[k].value == ruleAry[1]) 
                {
                    break;
                }
            }
            editElementAdd(st, i, "matchValue", "select", opts, k);
        }
        else if (tmp == "icmp") 
        {
            var opts = createOptionsIcmp();
            var k;
            for (k = 0; k < opts.length; k++) 
            {
                if (opts[k].value == ruleAry[1]) 
                {
                    break;
                }
            }
            editElementAdd(st, i, "matchValue", "select", opts, k);
        }
        else 
        {
            var cell1 = st.getCellElement(i, "matchValue").editElement;
            addInputConstraint(i, tmp, "matchValue");
            var cell2 = st.getCellElement(i, "wildcard").editElement;
            addInputConstraint(i, tmp, "wildcard");
        }
        
        if (ruleAry.length < 3) 
        {
            editElementRemove(st, i, "wildcard");
        }
        
        st.getCellEdit(i, "matchType").element.onchange = matchTypeChangeHandler;
    }
    
    $("relation").value = relation;
}

function trimString(val)
{
    return val.substring(1, val.length - 1);
}

function initButtonInfo()
{
    $("matchrelation").innerHTML = RESOURCE["matchrelation"];
    $("relation").onchange = setFlag;
    
    $("addbtn").value = RESOURCE["addbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    
    $("confirmbtn").value = RESOURCE["confirmbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    
    $("delbtn").disabled = true;
}

function rowSelectHandler(param)
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        setCellColor(st, i, "matchType");
        setCellColor(st, i, "matchValue");
        setCellColor(st, i, "wildcard");
    }
    
    if (param.length <= 0) 
    {
        $("delbtn").disabled = true;
        return;
    }
    
    $("delbtn").disabled = false;
}

function cellEditHandler()
{
    setFlag();
}

function setFlag()
{
    flag = false;
}

function checkAddIndex()
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (ruleIds[temp] == st.getCellStoreValue(i, "matchType", "matchType")) 
        {
            temp++;
            checkAddIndex();
        }
    }
}

function addRule()
{
    setFlag();
    
    var relation = $("relation").value;
    var ruleLen = ruleIds.length;
    var len = st.getDataRowLength();
    if (len <= 0 || (temp == ruleLen)) 
    {
        temp = 0;
    }
    
    if ((relation == 1) && (!ruleIds[temp] || len > ruleLen - 1)) 
    {
        return;
    }
    
    if (relation == 2 && len >= ruleLen) 
    {
    }
    else 
    {
        checkAddIndex();
    }
    
    var defaultVal = new Array(ruleIds[temp], "", "");
    if (ruleIds[temp] == "protype") 
    {
        defaultVal = new Array(ruleIds[temp], "tcp", "");
    }
    else if (ruleIds[temp] == "icmp") 
    {
        defaultVal = new Array(ruleIds[temp], "echo", "");
    }
    else if (ruleIds[temp] == "dei") 
    {
        defaultVal = new Array(ruleIds[temp], "", "");
    }
    
    var rowindex = constructRow(st, window.tableconf[0], defaultVal);
    
    if (ruleIds[temp] == "protype" || ruleIds[temp] == "icmp" || ruleIds[temp] == "dei") 
    {
        editElementRemove(st, rowindex, "wildcard");
        
        var opts = new Array();
        if (ruleIds[temp] == "protype") 
        {
            opts = createOptionsProtype();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
        else if (ruleIds[temp] == "icmp") 
        {
            opts = createOptionsIcmp();
            editElementAdd(st, rowindex, "matchValue", "select", opts, 0);
        }
    }
    else 
    {
        if (ruleIds[temp] == "dei") 
        {
            editElementRemove(st, rowindex, "wildcard");
        }
        var cell1 = st.getCellElement(rowindex, "matchValue").editElement;
        var cell2 = st.getCellElement(rowindex, "wildcard").editElement;
        addInputConstraint(rowindex, ruleIds[temp], "matchValue");
        addInputConstraint(rowindex, ruleIds[temp], "wildcard");
    }
    
    st.getCellEdit(rowindex, "matchType").element.onchange = matchTypeChangeHandler;
    
    mozillaSort(st, "wildcard");
    
    temp++;
}

function deleteRule()
{
    setFlag();
    
    var selRows = st.getSelectedRows();
    for (var i = 0; i < selRows.length; i++) 
    {
        st.deleteRow(selRows[i]);
    }
    st.adjustDataRows();
    
    if (st.getDataRowLength() <= 0) 
    {
        $("delbtn").disabled = true;
    }
}

function matchTypeChangeHandler()
{
    setFlag();
    
    var eventRow = this.parentNode.parentNode.rowIndex;
    var eventVal = st.getCellStoreValue(eventRow, "matchType", "matchType");
    var thisVal = this.value;
    
    if (eventVal != thisVal) 
    {
        st.getCellElement(eventRow, "matchValue").modify = false;
        st.getCellElement(eventRow, "wildcard").modify = false;
    }
    
    var relation = $("relation").value;
    if (relation == 1) 
    {
        var len = st.getDataRowLength();
        for (var i = 0; i < len; i++) 
        {
            var mtype = st.getCellStoreValue(i, "matchType", "matchType");
            if (mtype == thisVal) 
            {
                this.value = eventVal;
                alert(RESOURCE["matchtypecheck"]);
                return;
            }
        }
    }
    
    var beforeType = setChangeType(eventVal);
    var afterType = setChangeType(thisVal);
    
    var beforeType = setChangeType(eventVal);
    var afterType = setChangeType(thisVal);
    
    editElementRemove(st, eventRow, "matchValue");
    editElementRemove(st, eventRow, "wildcard");
    if (afterType == 1) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        editElementAdd(st, eventRow, "wildcard", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
        addInputConstraint(eventRow, thisVal, "wildcard");
    }
    else if (afterType == 2) 
    {
        var opts = new Array();
        if (thisVal == "protype") 
        {
            opts = createOptionsProtype();
        }
        else if (thisVal == "icmp") 
        {
            opts = createOptionsIcmp();
        }
        
        editElementAdd(st, eventRow, "matchValue", "select", opts, 0);
    }
    else if (afterType == 3) 
    {
        editElementAdd(st, eventRow, "matchValue", "text", null, null);
        addInputConstraint(eventRow, thisVal, "matchValue");
    }
}

function configClassifier()
{
    if (flag) 
    {
        xcloseDialog();
        return;
    }
    
	/**
	 *     OK          
	 */
	alert(RESOURCE["clickapplydlg"]);
	
	
    var len = st.getDataRowLength();
    
    if (len <= 0 || !checkRuleInput(st) || !checkRuleRelation(st)) 
    {
        return;
    }
    
    var relation = $("relation").value;
    if (relation == 1 && !checkRuleRepeated(st)) 
    {
        return;
    }
    
    var classifierRuleVal = st.getCellStoreValue(0, "matchType", "matchType") + ":" +
    		st.getCellStoreValue(0, "matchValue", "matchValue") + ":" + st.getCellStoreValue(0, "wildcard", "wildcard");
    
    var classifierRuleStr = RESOURCE[st.getCellStoreValue(0, "matchType", "matchType")] + ":" +
    		st.getCellStoreValue(0, "matchValue", "matchValue") + ":" + st.getCellStoreValue(0, "wildcard", "wildcard");

    classifierRuleVal = "{" + trimStringTail(classifierRuleVal, ":") + "}";
    classifierRuleStr = "{" + trimStringTail(classifierRuleStr, ":") + "}";
    
    var relation = $("relation").value == 1 ? "&" : "|";    
    
    for (var i = 1; i < len; i++) 
    {
        var mtype = st.getCellStoreValue(i, "matchType", "matchType");
        var mtypeStr = RESOURCE[mtype];
        
        var mval = st.getCellStoreValue(i, "matchValue", "matchValue");
        var wcard = st.getCellStoreValue(i, "wildcard", "wildcard");
        
        var tmpVal = mtype + ":" + mval + ":" + wcard;
        var tmpStr = mtypeStr + ":" + mval + ":" + wcard;
        tmpVal = "{" + trimStringTail(tmpVal, ":") + "}";
        tmpStr = "{" + trimStringTail(tmpStr, ":") + "}";
        
        classifierRuleVal += (relation + tmpVal);
        classifierRuleStr += (relation + tmpStr);
    }
    
    parobj.st1.setCellValue(parobj.st1.getCell(parIndex, "classifierRule"), "classifierRule", classifierRuleStr);
    parobj.st1.setAtomValue(parobj.st1.getCellShow(parIndex, "classifierRule"), classifierRuleStr);
    parobj.st1.getCellElement(parIndex, "classifierRule").storeValue["classifierRule"] = classifierRuleVal;
    parobj.st1.element.datarows[parIndex].element.modify = true;
    
    xcloseDialog();
}
