
var default_wrr_policy_name = "1-WRR Default Scheduling";
var policy = [];
policy[1] = "SP";
policy[2] = "WRR";
var commonCosDefault = new Array();
commonCosDefault["cir"] = c_invalid_char;
commonCosDefault["pir"] = c_invalid_char;
commonCosDefault["cbs"] = c_invalid_char;
commonCosDefault["pbs"] = c_invalid_char;

function initCTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("text");
    checkText(atom.element, "1", "2000");
    ct.addAttrRow("policyId", RESOURCE["policyId"], atom);
    ct.setAttrValue("policyId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type", "checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    ct.getAtom("policyId").element.style.width = "50%";
    ct.getAtom("policyId").element.parentNode.appendChild(checkboxElem);
    
    var span = document.createElement("span");
    span.innerText = RESOURCE["auto"];
    ct.getAtom("policyId").element.parentNode.appendChild(span);
    
    atom = new Atom("text");
    atom.element.maxLength = policy_name_max_len;
    checkInputData(atom.element, policy_name_max_len);
    ct.addAttrRow("policyName", RESOURCE["policyName"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    ct.addAttrRow("wrrShowName", RESOURCE["wrrShowName"], atom);
    
    var elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "wrrid";
    elem.value = "1";
    ct.getAtom("wrrShowName").element.style.width = "50%";
    ct.getAtom("wrrShowName").element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.name = "2";
    elem.id = "tunnelBtn2";
    elem.onclick = handleWrrSelect;
    ct.getAtom("wrrShowName").element.parentNode.appendChild(elem);
    
    ct.getAtom("wrrShowName").element.value = default_wrr_policy_name;
    ct.getAtom("wrrShowName").element.disabled = true;
    ct.getAtom("wrrShowName").element.style.width = "85%";
    ct.getAtom("wrrShowName").element.parentNode.appendChild(elem);
    
    document.body.insertBefore(ct.getTable(), document.body.firstChild);
    
    ct.attrArray["policyId"].element.onkeydown = setButtonStatus;
    ct.attrArray["policyName"].element.onkeydown = setButtonStatus;
}

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("180px");
    st.setOnCellEditHandler(cellEditHandler);
    $("costable").appendChild(st.getTable());
    $("costable").oncontextmenu = popupMenuHandler;
    var dinterface = new DataInterface();
    for (var i = 0; i < queue_len; i++) 
    {
        var obj = new Object();
        dinterface.rows[dinterface.rows.length] = obj;
        var ptag = new ParamTag();
        ptag.value = i + 1;
        obj["queueType"] = ptag;
		if (i > 2 && i < 7) 
        {
            ptag = new ParamTag();
            ptag.value = 2;
            obj["policy"] = ptag;
            ptag = new ParamTag();
            ptag.value = 25;
            obj["policyRate"] = ptag;
        }
        else 
        {
            ptag = new ParamTag();
            ptag.value = 1;
            obj["policy"] = ptag;
        }
        var ptag = new ParamTag();
        ptag.value = 2;
        obj["bwEnable"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["cir"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["pir"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["cbs"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["pbs"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["dropTail"] = ptag;
        var ptag = new ParamTag();
        ptag.value = "-";
        obj["dropWred"] = ptag;
    }
    st.clearTableData();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    tagCosTableHandler();
}

function newPolicy(param)
{
    var policyId = ct.getAttrValue("policyId");
    var policyName = ct.getAttrValue("policyName");
    
    if (policyId == null || policyId == "") 
    {
        policyId == "0";
    }
    if (policyName == null || policyName == "") 
    {
        alert(RESOURCE["checkname"]);
        return;
    }
    
    if (param && flag) 
    {
        xcloseDialog();
        return;
    }
    
    if ($("wrrid").value.trim() == '') 
    {
        alert(RESOURCE["checknamewrr"]);
        return;
    }
    
    var superSt = parobj.parobj.st;
    for (var i = 0, len = superSt.getDataRowLength(); i < len; i++) 
    {
        var pId = superSt.getCellStoreValue(i, "policyId", "policyId");
        if (parseInt(policyId, 10) != 0 && policyId == pId) 
        {
            alert(RESOURCE["pidexistcheck"]);
            return;
        }
    }
    
    if (!checkCosTable(st)) 
    {
        return;
    }
    
    $("confirmbtn").disabled = true;
    $("cancelbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createNewXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMD_CRT_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackNew, param, "inputdata=" + xmldata);
}

function handleWrrSelect()
{
    $("applybtn").disabled = false;
    flag = false;
    
    editWredRow = null;
    editWredCell = this.parentNode.firstChild;
    
    xshowModalDialog("../policy_u2kv1r8c00/selectWrrPolicy.html?isCreate=1",RESOURCE["title"],520,300,"../../../../../images/");
}


function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    var fstRow = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    fstRow.appendChild(param);
    
    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked) 
    {
        policyId = "0";
    }
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "policyName");
    param.setAttribute("value", policyName);
    fstRow.appendChild(param);
    
    fstRow.appendChild(new tagElement("param","wrr",getWrrInfo()));
    fstRow.appendChild(new tagElement("param","mode",getMode()));
    param = new tagElement("param");
    param.setAttribute("name", "wrrPolicy");
    param.setAttribute("value", $("wrrid").value);
    fstRow.appendChild(param);
    
    var opDesc = RESOURCE["policyId"] + ":" + policyId + "," + RESOURCE["policyName"] + ":" + policyName;
    
    param = new tagElement("param");
    setOpDesc(param, opDesc);
    fstRow.appendChild(param);
    
    business.appendChild(fstRow);
    
    var queueLen = 0;
    var delLen = 0;
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        if (st.getCellStoreValue(i, "bwEnable", "bwEnable") == bw_enable) 
        {
            queueLen++;
            
            row = new tagElement("row-params");
            
            var qType = i + 1;
            param = new tagElement("param");
            param.setAttribute("name", "queueType");
            param.setAttribute("value", qType);
            row.appendChild(param);
            row.appendChild(new tagElement("param","policy",st.getCellStoreValue(i, "policy", "policy")));
            row.appendChild(new tagElement("param","type_setqueue",parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10)));
            
            var cir = st.getCellStoreValue(i, "cir", "cir");
            if (qType >= 4 && qType <= 7) 
            {
                cir = "4294967295";
            }
            if(qType==8 && st.getCellStoreValue(i, "pir", "pir")=="/")
            {
            	cir="4294967295";//  BE  CIR     PIR 0xFFFFFFFF  CIR 0xFFFFFFFF DTS2013090902742
            }
            param = new tagElement("param");
            param.setAttribute("name", "cir");
            param.setAttribute("value", convertQueueQosValue(cir));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "cbs");
            param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(i, "cbs", "cbs")));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pir");
            param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(i, "pir", "pir")));
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "pbs");
            param.setAttribute("value", convertQueueQosValue(st.getCellStoreValue(i, "pbs", "pbs")));
            row.appendChild(param);
            
            var dropTail = st.getCellStoreValue(i, "dropTail", "dropTail");
            param = new tagElement("param");
            param.setAttribute("name", "dropTail");
            param.setAttribute("value", dropTail.length == "" ? 65535 : dropTail);
            row.appendChild(param);
            
            var dropWred = st.getCellStoreValue(i, "dropWred", "dropWred");
            if (-1 != dropWred.indexOf("-")) 
            {
                dropWred = dropWred.split("-")[0];
            }
            param = new tagElement("param");
            param.setAttribute("name", "dropWred");
            param.setAttribute("value", dropWred == "" ? 4294967295 : dropWred);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "isNoLog");
            param.setAttribute("value", "1");
            row.appendChild(param);
            
            business.appendChild(row);
        }
    }
	for (var i = 0; i < len; i++) 
	{
		row = new tagElement("row-params");
		if (st.getCellStoreValue(i, "bwEnable", "bwEnable") == bw_disable) 
		{
			delLen++;
			param = new tagElement("param");
		    param.setAttribute("name", "policyType");
		    param.setAttribute("value", policyType);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "policyId_delqueue");
		    param.setAttribute("value", policyId);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "type_delqueue");
		    param.setAttribute("value", i+1);
		    row.appendChild(param);
		    
		    business.appendChild(row);
		}
	}
    param = new tagElement("param");
    param.setAttribute("name", "queueLen");
    param.setAttribute("value", queueLen);
    fstRow.appendChild(param);
	param = new tagElement("param");
    param.setAttribute("name", "delLen");
    param.setAttribute("value", delLen);
    fstRow.appendChild(param);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function handleBwChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("cir", "pir", "cbs", "pbs", "dropTail", "dropWred");
    
    if (this.value == bw_disable) 
    {
        setCellStatus(rowindex, colary, 0, color_nonedit, null);
        setCellDefault(rowindex, colary, "-");
    }
    else 
    {
        setCellStatus(rowindex, colary, 1, color_desel, cellondbclick);
        setCARCellDefault(rowindex, colary, queue_default);
        colary = new Array("dropWred");
        setCellDefault(rowindex, colary, "/");
        colary = new Array("dropTail");
        setCellDefault(rowindex, colary, 480);
        
        var qType = parseInt(st.getCellStoreValue(rowindex, "queueType", "queueType"), 10);
        
        if (qType >= 4 && qType <= 7) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "-");
        }
        else if (qType == 8) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "0");
        }
    }
}
function getWrrInfo()
{
    var res = '';
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var policy = st.getCellStoreValue(i, "policy", "policy");
        if (policy == '2') 
        {
            var policyRate = st.getCellStoreValue(i, "policyRate", "policyRate");
            if (policyRate == '') 
            {
                continue;
            }
            res = res + i + ',' + policyRate + ';'
        }
    }
	return (res.length > 0)?res.substr(0, res.length - 1):res;
}
function getMode()
{
    var res = '';
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var policy = st.getCellStoreValue(i, "policy", "policy");
        res = res + policy + ',';
    }
	return (res.length > 0)?res.substr(0, res.length - 1):res;
}

/**
 *          /    FFFFFF 
 * @param {Object} value
 */
function convertQueueQosValue(value)
{
	return value == "/"?"4294967295":value;
}
