var selectRow = null;
var selWredId = null;
var DEFAULT_0xFFFFFFFF_VALUE = "4294967295";
var DEFAULT_0xFFFF_VALUE = "65535";
var modifyDropList = new Array();
var INVALID_VALUE = "/";
var NON_VALUE = "-";
var DEFAULT_TAIL = "480";
var portCosDefault = new Array();
portCosDefault["cir"] = INVALID_VALUE;
portCosDefault["pir"] = INVALID_VALUE;
portCosDefault["cbs"] = INVALID_VALUE;
portCosDefault["pbs"] = INVALID_VALUE;
portCosDefault["dropWred"] = INVALID_VALUE;
portCosDefault["dropTail"] = "480";
var mgrflag = false;

function initSortTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("190px");
    st.setOnCellEditHandler(cellEditHandler);
    st.setOnRowSelectHandler(cosTblRowSelected);
    $("costable").appendChild(st.getTable());
    $("costable").oncontextmenu = popupMenuHandler;
    
    var dinterface  = constructDinterface();
    st.clearTableData();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    tagCosTableHandler();
}

function constructDinterface()
{
	  var dinterface = new DataInterface();
	    for (var i = 0; i < queue_len; i++) 
	    {
	        var obj = new Object();
	        dinterface.rows[dinterface.rows.length] = obj;
	        
	        var ptag = new ParamTag();
	        ptag.value = i + 1;
	        obj["queueType"] = ptag;
	        
	        if (i > 2 && i < 7) 
	        {
	            ptag = new ParamTag();
	            ptag.value = 2;
	            obj["policy"] = ptag;
	            
	            ptag = new ParamTag();
	            ptag.value = 25;
	            obj["policyRate"] = ptag;
	        }
	        else 
	        {
	            ptag = new ParamTag();
	            ptag.value = 1;
	            obj["policy"] = ptag;
	        }
	        
	        ptag = new ParamTag();
	        ptag.value = 2;
	        obj["bwEnable"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["cir"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["pir"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["cbs"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["pbs"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["dropTail"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = NON_VALUE;
	        obj["dropWred"] = ptag;
	        
	        ptag = new ParamTag();
	        ptag.value = "";
	        obj["dropWredID"] = ptag;
	    }
	    
	    return dinterface;
}

function tagCosTableHandler()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        st.getCellEdit(i, "bwEnable").element.onchange = handleBwChange;

        var colary = new Array("cir","pir","cbs","pbs", "dropWred", "dropTail");					

        setCellStatus(i, colary, 0, "#E8E8E8", null);
        
        var qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
        if (qType == 8) 
        {
            colary = new Array("cir");
            setCellStatus(i, colary, 0, "#E8E8E8", null);
        }	
                                
        textCheckWithStepLenandOtherValue(st.getCellEdit(i, "cir").element,"0","1000000", 64,"/");
        textCheckWithStepLenandOtherValue(st.getCellEdit(i, "pir").element,"0","1000000", 64,"/");	
		/**
		 *      TRANSSCRIPTEXPORT-962
		 *	    q00119080
		 *	       PBS CBS      
		 */
		if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0310') ||
		        ( isOSN5X0NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510'))
			{
			    textCheck(st.getCellEdit(i, "cbs").element,"0","4294967294",0,"/");
			    textCheck(st.getCellEdit(i, "pbs").element,"0","4294967294",0,"/");
			} else {
			    textCheck(st.getCellEdit(i, "cbs").element,"0","512000");
			    textCheck(st.getCellEdit(i, "pbs").element,"0","512000");
			}	    
        
        textCheck(st.getCellEdit(i, "dropTail").element,"0",DEFAULT_TAIL);
		st.getCellEdit(0, "dropTail").element.onchange = handleDropTailChange;
    }    
    
    addCellListener();
}

/**
 *        
 * @return
 */
function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell= st.getCell(i,"dropWred");	
        var wredID = st.getCellStoreValue(i, "dropWredID", "dropWredID");
		if(null != cell)
		{
			cell.element["ondblclick"] = function()
			{	
				if(this.isEdit)
				{
					this.modify = true;  
	                this.parentNode.modify = true;
	                doOpenWredCfg(wredID);
				}
			}
			
			cell.element.oncontextmenu = function()
			{
				if(this.isEdit)
				{
					this.modify = true;  
	                this.parentNode.modify = true;
	                doOpenWredCfg(wredID);
				}
			}
		} 	
    }
    
}

function handleDropTailChange()
{
	var rowindex = this.parentNode.parentNode.rowIndex;
	if(st.getCellStoreValue(rowindex, "dropTail", "dropTail") == NON_VALUE)
	{
		return;
	}  
	
   var cell = st.getCell(rowindex, "dropWred");
   cell.element.showElement.setValue(INVALID_VALUE);   
   st.setCellValue(cell, "dropWred", INVALID_VALUE);
   
   cell = st.getCell(rowindex, "dropWredID");
   cell.element.showElement.setValue(DEFAULT_0xFFFFFFFF_VALUE);  
   st.setCellValue(cell, "dropWredID", DEFAULT_0xFFFFFFFF_VALUE);
   
   addCellListener();
}

/**
 * WRED              WRED   
 * @return
 */
function doOpenWredCfg(selWredId)
{	
    xshowModalDialog("cfgwred.html", RESOURCE["ConfigurationWRED"], 600, 400, "../../../../../images/");
}

/**
 *   Cos        
 * @return
 */
function cosTblRowSelected(rows)
{
	if(rows.length > 0)
	{
		selectRow = rows[0];
		selWredId = st.getCellStoreValue(selectRow, "dropWredID", "dropWredID");
	}
}

/**
 *   QOS   WRED ID
 * @return
 */
function getBandWredId()
{
	var indexes = st.getSelectedRows();
	if(indexes.length > 0)
	{		
		return st.getCellStoreValue(indexes[0], "dropWredID", "dropWredID");
	}
	return null;
}

/**
 *  WRED          dropWred  
 * @param wredID
 * @return
 */
function setWredInfo(wredID,wredName)
{    
	var cell = st.getCell(selectRow, "dropWredID");
    cell.element.showElement.setValue(wredID);
    st.setCellValue(cell, "dropWredID", wredID);
    st.setCellModify(selectRow,"dropWredID",true);
    cell = st.getCell(selectRow, "dropWred");
    cell.element.showElement.setValue(wredID+"-"+wredName);
    st.setCellValue(cell, "dropWred", wredID+"-"+wredName);
    st.setCellModify(selectRow,"dropWred",true);
    $("applybtn").disabled = false;
    
    if(wredID == "")
    {
 	   return;
    }
    var cell = st.getCell(selectRow, "dropTail");
    cell.element.showElement.setValue(INVALID_VALUE);  
    st.setCellValue(cell, "dropTail", INVALID_VALUE);
}

function checkCosTable(stable)
{
    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        var bwStatus = stable.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bwStatus == bw_disable) 
        {
            continue;
        }
        
        if((st.getCell(i, "pir").element.modify)|| (st.getCell(i, "cir").element.modify)|| (st.getCell(i, "pbs").element.modify)|| (st.getCell(i, "cbs").element.modify))
        {
        	var cos = stable.getCellStoreValue(i, "queueType", "queueType");
        	var pir1=stable.getCellStoreValue(i, "pir", "pir") ;
        	var cir1=stable.getCellStoreValue(i, "cir", "cir") ;
        	if(((pir1==INVALID_VALUE) && ( cir1 == INVALID_VALUE))||(((pir1==DEFAULT_0xFFFFFFFF_VALUE) && ( cir1 == DEFAULT_0xFFFFFFFF_VALUE))))
        	{
        		continue;
        	}
            var pir = parseInt(stable.getCellStoreValue(i, "pir", "pir"));
            var cir = parseInt(stable.getCellStoreValue(i, "cir", "cir"));
            
            if (cos == 1 || cos == 2 || cos == 3) 
            {
                if (pir != cir) 
                {
                    alert(RESOURCE["queuevalcheck"]);
                    return false;
                }
            }
            else if (pir < cir) 
            {
                alert(RESOURCE["queuevalcheck"]);
                return false;
            }            
        }        
    }
    return true;
}

function createNewXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    var fstRow = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    fstRow.appendChild(param);
    
    var policyId = ct.getAttrValue("policyId");
    if (checkboxElem.checked) 
    {
        policyId = "0";
    }
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "wrrid");
    param.setAttribute("value", $("wrrid").value);
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "policyName");
    param.setAttribute("value", policyName);
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "wrr");
    param.setAttribute("value", getWrrInfo());
    fstRow.appendChild(param);
    
    var policyName = ct.getAttrValue("policyName");
    param = new tagElement("param");
    param.setAttribute("name", "mode");
    param.setAttribute("value", getMode());
    fstRow.appendChild(param);
    
    var strPolicyId = policyId;
    if(policyId == "0")
    {
    	strPolicyId = RESOURCE["auto"];
    }
    var opDesc = RESOURCE["policyId"] + ":" + strPolicyId + "," +
    RESOURCE["policyName"] +
    ":" +
    policyName;
    
    param = new tagElement("param");
    setOpDesc(param, opDesc);
    fstRow.appendChild(param);
    
    business.appendChild(fstRow);
    
    var len = st.getDataRowLength();
    var queueLen = 0;
    var dropLen = 0;
    var delLen = 0;
    var lastChar;
    var changeTimes = 0;
    var firstChar;
    var dropTail;
    var dropWred;
    var qType;
    var wrrModifyFlag = false;
    var bdvalue;
    for (var i = 0; i < len; i++) 
    {
        row = new tagElement("row-params");
        var bandwidth = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bandwidth == bw_enable) 
        {
            if (st.getCell(i, "pir").element.modify || st.getCell(i, "cir").element.modify || st.getCell(i, "pbs").element.modify || st.getCell(i, "cbs").element.modify) 
            {
                queueLen++;
                param = new tagElement("param");
                param.setAttribute("name", "queueType");
                param.setAttribute("value", i + 1);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "policy");
                param.setAttribute("value", st.getCellStoreValue(i, "policy", "policy"));
                row.appendChild(param);
                
                qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
                param = new tagElement("param");
                param.setAttribute("name", "type_setqueue");
                param.setAttribute("value", qType);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "cir");
                bdvalue = st.getCellStoreValue(i, "cir", "cir");
                if (bdvalue == INVALID_VALUE) 
                {
                    bdvalue = DEFAULT_0xFFFFFFFF_VALUE;
                }
            
                if((i+1)==8 && st.getCellStoreValue(i, "pir", "pir")=="/")
                {
                    bdvalue=DEFAULT_0xFFFFFFFF_VALUE;//  BE  CIR     PIR 0xFFFFFFFF  CIR 0xFFFFFFFF DTS2013090902742
                }
                param.setAttribute("value", bdvalue);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "cbs");
                bdvalue = st.getCellStoreValue(i, "cbs", "cbs");
                if (bdvalue == INVALID_VALUE) 
                {
                    bdvalue = DEFAULT_0xFFFFFFFF_VALUE;
                }
                param.setAttribute("value", bdvalue);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "pir");
                bdvalue = st.getCellStoreValue(i, "pir", "pir");
                if (bdvalue == INVALID_VALUE) 
                {
                    bdvalue = DEFAULT_0xFFFFFFFF_VALUE;
                }
                param.setAttribute("value", bdvalue);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "pbs");
                bdvalue = st.getCellStoreValue(i, "pbs", "pbs");
                if (bdvalue == INVALID_VALUE) 
                {
                    bdvalue = DEFAULT_0xFFFFFFFF_VALUE;
                }
                param.setAttribute("value", bdvalue);
                row.appendChild(param);
                business.appendChild(row);
            }
        }
    }
    
    for (var i = 0; i < len; i++) 
    {
        row = new tagElement("row-params");
        var bandwidth = st.getCellStoreValue(i, "bwEnable", "bwEnable");
        if (bandwidth == bw_enable) 
        {
        
            if (st.getCell(i, "dropTail").element.modify || st.getCell(i, "dropWred").element.modify) 
            {
                dropLen++;
                param = new tagElement("param");
                param.setAttribute("name", "auto_setqueue");
                param.setAttribute("value", 0);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "policyType");
                param.setAttribute("value", policyType);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "policyId_setdrop");
                param.setAttribute("value", policyId);
                row.appendChild(param);
                
                qType = parseInt(st.getCellStoreValue(i, "queueType", "queueType"), 10);
                param = new tagElement("param");
                param.setAttribute("name", "type_setdrop");
                param.setAttribute("value", qType);
                row.appendChild(param);
                
                dropTail = st.getCellStoreValue(i, "dropTail", "dropTail");
                dropWred = st.getCellStoreValue(i, "dropWredID", "dropWredID");
                if (dropTail == INVALID_VALUE) 
                {
                    dropTail = DEFAULT_0xFFFF_VALUE;
		}
		else 
		{
		    dropWred = DEFAULT_0xFFFFFFFF_VALUE;
		}
				
		param = new tagElement("param");
		param.setAttribute("name", "dropTail");
		param.setAttribute("value", dropTail);
		row.appendChild(param);
				
		param = new tagElement("param");
		param.setAttribute("name", "auto_setdrop");
		param.setAttribute("value", 0);
		row.appendChild(param);
				
		param = new tagElement("param");
		param.setAttribute("name", "dropWred");
		param.setAttribute("value", dropWred);
		row.appendChild(param);
				
		business.appendChild(row);
	     }
	}
    }
		
                  
        
        for (var i = 0; i < len; i++) 
        {
        	row = new tagElement("row-params");
            if (st.getCellStoreValue(i, "bwEnable", "bwEnable") == bw_disable) 
            {
            	delLen++;
            	param = new tagElement("param");
                param.setAttribute("name", "policyType");
                param.setAttribute("value", policyType);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "policyId_delqueue");
                param.setAttribute("value", policyId);
                row.appendChild(param);
                
                param = new tagElement("param");
                param.setAttribute("name", "type_delqueue");
                param.setAttribute("value", i+1);
                row.appendChild(param);
                
                business.appendChild(row);
            }
       
        
        var curChar = st.getCellStoreValue(i, "policy", "policy");
		if( i == 0)
		{
			 lastChar = st.getCellStoreValue(i, "policy", "policy");
			 firstChar = lastChar;
		}
		else if(lastChar != curChar)
		{
			 changeTimes++;
			 lastChar = curChar;
		}
    }
        
    if( (firstChar == 2 &&changeTimes >= 2)||(firstChar == 1 &&changeTimes > 2))
    {
  		return false;
  	}
    
    param = new tagElement("param");
    param.setAttribute("name", "queueLen");
    param.setAttribute("value", queueLen);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "dropLen");
    param.setAttribute("value", dropLen);
    fstRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "delLen");
    param.setAttribute("value", delLen);
    fstRow.appendChild(param);
    
    len = 0;
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackNew(doc, param)
{
    $("confirmbtn").disabled = false;
    $("cancelbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    showErrorDialog(data);
    
    var errCode = data.getSErrorCode();
    if (errCode == 0 || errCode == 1) 
    {
        refreshTableState(st, window.tableconf[0], data);
        parobj.queryPolicy();
        
        if (param && (errCode == 0)) 
        {
            xcloseDialog();
        }
        else 
        {
            flag = true;
            addClassifierList = new Array();
            indexList = new Array();
            
            st.clearTableData();
            var dinterface  = constructDinterface();            
            createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
            tagCosTableHandler();
        }
	}else
	{
		$("applybtn").disabled = false;
    }		
}

function handleBwChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("cir","pir","cbs","pbs", "dropWred", "dropTail");
    
    if (this.value == bw_disable) 
    {
    	 
        setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
        setCellDefault(rowindex, colary, NON_VALUE);
    }
    else 
    {
        setCellStatus(rowindex, colary, 1, "#ffffff", cellondbclick);
        setCARCellDefault(rowindex, colary, queue_default);
        setBdwidthCellModify(rowindex, colary);
        
        var qType = parseInt(st.getCellStoreValue(rowindex, "queueType", "queueType"), 10);
        if (qType == 8) 
        {
            colary = new Array("cir");
            setCellStatus(rowindex, colary, 0, "#E8E8E8", null);
            setCellDefault(rowindex, colary, "0");
			colary = new Array("pir");
        }
        addCellListener();
    }
}

function setBdwidthCellModify(rowindex, colary)
{
	for (var i = 0; i < colary.length; i++) 
    {
		st.setCellModify(rowindex, colary[i], true);
    }	 
}
function setBdwidthCellUnModify(rowindex, colary)
{
	for (var i = 0; i < colary.length; i++) 
    {
		st.setCellUnModify(rowindex, colary[i], false);
    }	 
}

function cellEditHandler(param)
{
    
    var editRow = param.rowindex;
    var colid = param.colid;
 
    var qType = parseInt(st.getCellStoreValue(editRow, "queueType", "queueType"), 10);
    if (qType == 8) 
    {    	
		var pir = st.getCellStoreValue(qType-1, "pir", "pir");
		var cbs = st.getCellStoreValue(qType-1, "cbs", "cbs");
		var pbs = st.getCellStoreValue(qType-1, "pbs", "pbs");
		if (colid == "pir"||colid == "cbs"||colid == "pbs")
		{		 
			if(pir== DEFAULT_0xFFFFFFFF_VALUE && cbs==DEFAULT_0xFFFFFFFF_VALUE && pbs==DEFAULT_0xFFFFFFFF_VALUE)
			{
				var cell = st.getCell(qType-1, "cir");
				cell.element.showElement.setValue(DEFAULT_0xFFFFFFFF_VALUE);  
				st.setCellValue(cell, "cir", DEFAULT_0xFFFFFFFF_VALUE);
			}else
			{
				var bwEnable = st.getCellStoreValue(qType-1, "bwEnable", "bwEnable");		
				if(bwEnable!=bw_disable)
				{	 
					var cell = st.getCell(qType-1, "cir");
					cell.element.showElement.setValue(0);  
			        st.setCellValue(cell, "cir", 0);
			    }
		     }
		}               
	}
   
}
