var selectedRowID_pre = -1;
var st;
var tab;
var policyType = type_port_policy;
var selectedRows;
var basicModified = false;
var gl_PolicyId;

var obj, neid, nmUser;

window.onload = function()
{
    initTable();
    initTabPanel();
    
    var hc = st.getHeadCell("policyId");
    st.setHCAttribute(hc, 1, 1, compareNum);
    
    $("totalrow").innerHTML = RESOURCE["totalrow"];
    $("selrow").innerHTML = RESOURCE["selectedrow"];
    
    obj = getNeProperty(self);
    
    neid = obj["neid"];
    
    nmUser = obj["nmUser"];
    
    queryPolicy();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getComponetHeight($("policytable"), 360) + "px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("policytable").appendChild(st.getTable());
}

function setTabsHeight(tab, tabodyheight)
{
    for (var key in tab.tabNodes) 
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

function initTabPanel()
{
    tab = new Tabs();
    tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    tab.addTab(tab_id_cos, RESOURCE["cosconfig"], "portcos.html");
    tab.addTab(tab_id_classifier, RESOURCE["classifierconfig"], "../policy_u2kv1r2c00/vuniingressclassifier.html");
    tab.addTab(tab_id_actpoint, RESOURCE["actpoint"], "../policy_u2kv1r2c00/portactpoint.html");
    setTabsHeight(tab, getComponetHeight($("policytab"), 70) + "px");
    $("policytab").appendChild(tab.getTabs());
    tab.selectTab(tab_id_cos);
}

function rowSelectHandler()
{
    selectedRows = st.getSelectedRows();
    if (selectedRows.contains(selectedRowID_pre)) 
    {
        $("selrownum").innerHTML = selectedRows.length;
        return;
    }
    if (selectedRows.length <= 0) 
    {
        this.frames[0].$("deletebtn").disabled = true;
        $("selrownum").innerHTML = 0;
        return;
    }
    
    this.frames[0].$("deletebtn").disabled = !this.frames[0].btnRightArr.deletebtn.right;
    this.frames[0].$("copybtn").disabled = !this.frames[0].btnRightArr.copybtn.right;
    $("totalrownum").innerHTML = st.getDataRowLength();
    $("selrownum").innerHTML = selectedRows.length;
    
    var policyId = st.getCellStoreValue(selectedRows[0], "policyId", "policyId");
    
    selectedRowID_pre = selectedRows[0];
    
    switch (tab.selectTabid)
    {
        case tab_id_cos:
            this.frames[0].queryPolicyCos(policyId);
            break;
        case tab_id_classifier:
            this.frames[1].classifierQuery();
            break;
        case tab_id_actpoint:
            this.frames[2].queryPort();
            break;
    }
}

function cellEditHandler()
{
    this.frames[0].$("applybtn").disabled = !this.frames[0].btnRightArr.applybtn.right;
    basicModified = true;
}

function queryPolicy()
{
    if (isDemo) 
    {
        loadXMLdoc("../port_query_st.xml", "POST", false, callbackQuery, null);
    }
    else 
    {
        var xmldata = createQueryXml();
        var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORT_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
        loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
    }
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() < 2) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
    
    basicModified = false;
    
    var len = st.getDataRowLength();
    $("totalrownum").innerHTML = len;
    $("selrownum").innerHTML = len > 0 ? 1 : 0;
    
    if (len > 0) 
    {
        for (var i = 0; i < len; i++) 
        {
            var cell = st.getCellElement(i, "policyName");
            cell.editElement.element.maxLength = policy_name_max_len;
            checkInputData(cell.editElement.element, policy_name_max_len);
            
            setPolicyNameListerner(i, 'policyName');
            
            setKeyListerner(i, 'wrrPolicy');
        }
        
        st.setRowSelect(0);
        selectedRowID_pre = 0;
        selectedRows = st.getSelectedRows();
        
        gl_PolicyId = st.getCellStoreValue(0, "policyId", "policyId");
        if (isIE) 
        {
            queryPolicyCos();
				    queryApplyObj();
        }
        else 
        {
            window.setTimeout(queryPolicyCos, 1000);
				    window.setTimeout(queryApplyObj, 1000);			    
        }
    }
    else 
    {
        if (this.frames[0] && this.frames[0].st) 
        {
            this.frames[0].st.clearTableData();
        }
        if (selectedRows) 
        {
            selectedRows.clear();
        }
    }
    
    showErrorDialog(data);
	if (isDuplicatePName())
	{
		alert(RESOURCE["getDuplicatePName"]);
	}
}

function setPolicyNameListerner(k, pkey)
{
	cell = st.getCell(k,pkey);
	if(null != cell)
    {
    	cell.element.oncontextmenu = popupMenuHandler;
    }
}

function setKeyListerner(i, key)
{
    cell = st.getCell(i,key);
		
    if(null != cell)
    {	
        cell.element["ondblclick"] = function()
        {	
        	this.modify = true;  
            this.parentNode.modify = true;
            
        	showWrrDialog(this, key);	
        }
	    		
        cell.element.oncontextmenu = function()
        {
            this.modify = true;  
            this.parentNode.modify = true;
            
		    showWrrDialog(this, key);
        }
    }
}

function showWrrDialog(cellElement,key)
{
	var i;
	var evt = EventUtil.getEvent();
    var elem = evt.target;
    if(elem.parent||elem.parentNode.parent)
    {
       	var rowid;
       	var rows;
       	if(elem.parent)
       	{
       	   	rowid = elem.parentNode.rowIndex;
       	   	rows = elem.parent.getSelectedRows();
       	}
       	else
       	{
       	   	rowid = elem.parentNode.parentNode.rowIndex;
       	   	rows = elem.parentNode.parent.getSelectedRows();
       	}
       
       	if (rows.length > 1)
       	{
			return;
       	}

       	if(!rows.contains(rowid))
       	{
          	return;
       	}
       
        if(rows.length == 1)
	    {
	    	i = rows[0];
	    }
	    else
	    {
	    	i = rowid;
	    }
    }

	if(null == i)
	{
		return;
	}
	
	xshowModalDialog("selectWrrPolicy.html?isCreate=0",RESOURCE["title"],520,300,"../../../../../images/");
}

function queryPolicyCos()
{
    if (this.frames[0] && this.frames[0].document && this.frames[0].document.body) 
    {
        if (st.getDataRowLength() == 0) 
        {
            tab.getTabWindow(tab_id_cos).st.clearTableData();
            return;
        }
        else 
        {
            tab.getTabWindow(tab_id_cos).queryPolicyCos(gl_PolicyId);
        }
    }
    else 
    {
        window.setTimeout(queryPolicyCos, 500);
    }
}

function queryApplyObj()
{
		if (this.frames[2] && this.frames[2].document && this.frames[2].document.body)
		{
				if (st.getDataRowLength() == 0)
				{
						return;
				}
				else
				{
						tab.getTabWindow(tab_id_actpoint).queryPort();
				}
		}
		else
		{
				window.setTimeout(queryApplyObj, 500);
		}			
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        
        if (errorObj["policyId"] && errorObj["policyName"]) 
        {
            errorObj["operationObj"] = RESOURCE["policyId"] + RESOURCE["colon"] + errorObj["policyId"] + RESOURCE["semicolon"] +
            RESOURCE["policyName"] +
            RESOURCE["colon"] +
            errorObj["policyName"];
        }
        else 
        {
            errorObj["operationObj"] = errorObj["nename"]
        }
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

