var st, tab;

var policyType = type_ingress_policy;
var editWredCell, editWredRow;
var basicModified = false;

var gl_PolicyId;
var selectedRows;
var obj = getNeProperty(self);
var neid;

var btnRightArr = new Object();
var querybtnRight;
var createbtnRight;
var deletebtnRight;
var copybtnRight;
var applybtnRight;

var neType = obj.neType;
var nevr = obj.neversion.split('.');
var needToHideCopyBtn = false;
if( obj.domain == "rtn" )
{
	if( (nevr[2] == "01" && nevr[3] >= "40") || (nevr[2] >= "03" && nevr[3] >= "30") )
	{
		needToHideCopyBtn = true;
	}
}

window.onload = function()
{
    neid = obj["neid"];
    
    initTable();
    initTabPanel();
    initButtonInfo();
    
    if( needToHideCopyBtn == true )
    {
    	$("copybtn").style.display = "none";
    }
    
    var hc = st.getHeadCell("policyId");
    st.setHCAttribute(hc, 1, 1, compareNum);
    
    $("totalrow").innerHTML = RESOURCE["totalrow"];
    $("selrow").innerHTML = RESOURCE["selectedrow"];    
}

function tabSelectHandler()
{
    if (this.frames[0] && btnRightArr.querybtn.right) 
    {
        queryPolicy();
    }
}

function initTable()
{
    st = new SortTable();
    st.head.setAttribute("id", "htmlTableVuniingressPolicyTHead");
    st.body.setAttribute("id", "htmlTableVuniingressPolicyTBody");
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight("120px");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    $("policytable").appendChild(st.getTable());
    $("policytable").oncontextmenu = popupMenuHandler;
}

function initTabPanel()
{
    tab = new Tabs();
    tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    tab.addTab(tab_id_classifier, RESOURCE["classifierconfig"], "vuniingressclassifier.html?neid=" + neid);
    tab.addTab(tab_id_actpoint, RESOURCE["actpoint"], "vuniactpoint.html?neid=" + neid);
    setTabsHeight(tab, "190px");
    $("policytab").appendChild(tab.getTabs());
    tab.selectTab(tab_id_classifier);
}

function initButtonInfo()
{
    $("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    $("copybtn").value = RESOURCE["copybtn"];
    $("applybtn").value = RESOURCE["applybtn"];
    
    initRightCmd();
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querybtnRight);
    btnRightArr.createbtn = new BtnRightObj("createbtn", createbtnRight);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", deletebtnRight);
    btnRightArr.copybtn = new BtnRightObj("copybtn", copybtnRight);
    btnRightArr.applybtn = new BtnRightObj("applybtn", applybtnRight);
    
    getRightInfo(obj, btnRightArr);
    initrightbtn(btnRightArr);
    
    initButtonStatus();
}

function initRightCmd()
{
    copybtnRight = TECMDCODE_COPY_POLICY;
    
    switch (policyType)
    {
        case type_ingress_policy:
            querybtnRight = TECMDCODE_GET_VUNI_INGRESS_POLICY;
            createbtnRight = TECMDCODE_CRT_VUNI_INGRESS_POLICY;
            deletebtnRight = TECMDCODE_DEL_VUNI_INGRESS_POLICY;
            applybtnRight = TECMDCODE_MOD_VUNI_INGRESS_POLICY;
            break;
        case type_egress_policy:
            querybtnRight = TECMDCODE_GET_VUNI_EGRESS_POLICY;
            createbtnRight = TECMDCODE_CRT_VUNI_EGRESS_POLICY;
            deletebtnRight = TECMDCODE_DEL_VUNI_EGRESS_POLICY;
            applybtnRight = TECMDCODE_MOD_VUNI_EGRESS_POLICY;
            break;
        case type_pw_policy:
            querybtnRight = TECMDCODE_GET_PW_POLICY;
            createbtnRight = TECMDCODE_CRT_PW_POLICY;
            deletebtnRight = TECMDCODE_DEL_PW_POLICY;
            applybtnRight = TECMDCODE_MOD_PW_POLICY;
            break;
        case type_qinq_policy:
            querybtnRight = TECMDCODE_GET_QINQ_POLICY;
            createbtnRight = TECMDCODE_CRT_QINQ_POLICY;
            deletebtnRight = TECMDCODE_DEL_QINQ_POLICY;
            applybtnRight = TECMDCODE_MOD_QINQ_POLICY;
            break;
        default:
            break;
    }
}

function initButtonStatus()
{
    $("applybtn").disabled = true;
    
    if (st.getSelectedRows().length <= 0) 
    {
        $("deletebtn").disabled = true;
        $("copybtn").disabled = true;
    }
}

function rowSelectHandler()
{
    var selectedRows = st.getSelectedRows();
    if (selectedRows.length <= 0) 
    {
        $("deletebtn").disabled = true;
        $("copybtn").disabled = true;
        this.frames[0].$("addbtn").disabled = true;
        this.frames[0].$("delbtn").disabled = true;
        this.frames[0].$("cfgrulebtn").disabled = true;
        $("selrownum").innerHTML = 0;
        return;
    }
    
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    $("copybtn").disabled = !btnRightArr.copybtn.right;
    $("totalrownum").innerHTML = st.getDataRowLength();
    $("selrownum").innerHTML = selectedRows.length;
    
    var policyId = st.getCellStoreValue(selectedRows[0], "policyId", "policyId");
    
    switch (tab.selectTabid)
    {
        case tab_id_classifier:
            this.frames[0].classifierQuery();
            break;
        case tab_id_actpoint:
            this.frames[1].queryActPoint();
            break;
        default:
            break;
    }
}

function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    basicModified = true;
}

function queryPolicy()
{
    var xmldata = createQueryXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_VUNI_INGRESS_POLICY + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() < 2) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        for (var i = 0, len = data.rows.length; i < len; i++) 
        {
            var cell = st.getCellElement(i, "policyName");
            cell.editElement.element.maxLength = policy_name_max_len;
            checkInputData(cell.editElement.element, policy_name_max_len);
        }
    }
    
    mozillaSort(st, "policyId");
    
    basicModified = false;
    
    var len = st.getDataRowLength();
    $("totalrownum").innerHTML = len;
    $("selrownum").innerHTML = len > 0 ? 1 : 0;
    if (len > 0) 
    {
        st.setRowSelect(0);
        selectedRows = st.getSelectedRows();
        gl_PolicyId = st.getCellStoreValue(0, "policyId", "policyId");
    }
    else if (this.frames[0] && this.frames[0].st1) 
    {
        this.frames[0].st1.clearTableData();
    }
    rowSelectHandler();
    
    $("applybtn").disabled = true;
    
    showErrorDialog(data);
}

function queryPolicyClassifier()
{
    if (this.frames[0] && this.frames[0].document && this.frames[0].document.body) 
    {
        this.frames[0].classifierQuery(gl_PolicyId)
    }
    else 
    {
        window.setTimeout(queryPolicyClassifier, 500);
    }
}

function createPolicy()
{
    var urlstr, titlestr;
    var owidth = 650;
    var oheight = 450;
    
    switch (policyType)
    {
        case type_ingress_policy:
            urlstr = "vuniingresspolicycreate.html";
            titlestr = "createingresspolicy";
            oheight = 620;
            break;
        case type_egress_policy:
            urlstr = "vuniegresspolicycreate.html";
            titlestr = "createegresspolicy";
            break;
        case type_pw_policy:
            urlstr = "pwpolicycreate.html";
            titlestr = "createpwpolicy";
            break;
        case type_qinq_policy:
            urlstr = "qinqpolicycreate.html";
            titlestr = "createqinqpolicy";
            break;
        default:
            break;
    }
    
    urlstr += "?neName=" + getNeProperty(top)["neName"];
    xshowModalDialog(urlstr, RESOURCE[titlestr], owidth, oheight, "../../../../../images/");    
}

function copyPolicy()
{
    xshowModalDialog("vunicopypolicy.html", RESOURCE["copypolicy"], 400, 180, "../../../../../images/");
}

function modifyPolicy()
{
    var parSt = st;
    
    for (var i = 0, len = parSt.getDataRowLength(); i < len; i++) 
    {
        if (parSt.getModify(i) && parSt.getCellStoreValue(i, "policyName", "policyName") == "") 
        {
            alert(RESOURCE["checkname"]);
            return;
        }
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("copybtn").disabled = true;
    $("applybtn").disabled = true;
    
    frames[0].constructClassifierList();
    var xmldata = createModifyXml();

    var urlstr = "../../../../../neExlorerServlet?sfid=" + applybtnRight + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackModify, null, "inputdata=" + xmldata);
}

function createModifyXml()
{
    var parSt = st;
    var row;
    var basicLen = 0;
    
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var basicRow = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    basicRow.appendChild(param);
    
    var selectedPolicyID = parSt.getSelectedRows()[0];
    var policyId = parSt.getCellStoreValue(selectedPolicyID, "policyId", "policyId");
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    basicRow.appendChild(param);
    
    var dellen = frames[0].delClassifierList.length;
    param = new tagElement("param");
    param.setAttribute("name", "dellen");
    param.setAttribute("value", dellen);
    basicRow.appendChild(param);
    
    var modlen = frames[0].modClassifierList.length;
    param = new tagElement("param");
    param.setAttribute("name", "modlen");
    param.setAttribute("value", modlen);
    basicRow.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isNoLog");
    param.setAttribute("value", "1");
    basicRow.appendChild(param);
    
    business.appendChild(basicRow);
    
    var opDesc = "";
    for (var i = 0, len = parSt.getDataRowLength(); i < len; i++) 
    {
        if (parSt.getModify(i)) 
        {
            opDesc = "";
            basicLen++;
            row = new tagElement("row-params");
            
            var policyId = parSt.getCellStoreValue(i, "policyId", "policyId");
            var policyName = "";
            var modifString = "";
            var splitStr = "";
            if (parSt.getCellModify(i, "policyName")) 
            {
                policyName = parSt.getCellStoreValue(i, "policyName", "policyName");
                param = new tagElement("param");
                param.setAttribute("name", "policyName_setname");
                param.setAttribute("value", policyName);
                row.appendChild(param);
                modifString += RESOURCE["policyName"] + ":" + policyName;
                splitStr = ",";
            }
            
            if (parSt.getCellModify(i, "classifierShare")) 
            {
                var classifierSharev = parSt.getCellStoreValue(i, "classifierShare", "classifierShare");
                param = new tagElement("param");
                param.setAttribute("name", "classifierShare");
                param.setAttribute("value", classifierSharev);
                row.appendChild(param);
                modifString += splitStr + RESOURCE["classifierShare"] + ":" + RESOURCE[classifierShare[parseInt(classifierSharev)]];
                splitStr = ",";
            }
            
            param = new tagElement("param");
            param.setAttribute("name", "policyId_setname");
            param.setAttribute("value", policyId);
            row.appendChild(param);
            opDesc += RESOURCE["policyId"] + ":" + policyId + "--";
            
            param = new tagElement("param");
            param.setAttribute("name", "policyType");
            param.setAttribute("value", policyType);
            row.appendChild(param);
            
            param = new tagElement("param");
            param.setAttribute("name", "auto_setname");
            param.setAttribute("value", "0");
            row.appendChild(param);
            
            opDesc += modifString;
            param = new tagElement("param");
            setOpDesc(param, opDesc);
            row.appendChild(param);
            
            business.appendChild(row);
        }
    }
    
    param = new tagElement("param");
    param.setAttribute("name", "basicLen");
    param.setAttribute("value", basicLen);
    basicRow.appendChild(param);
    
    for (var i = 0; i < dellen; i++) 
    {
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", frames[0].delClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["delClassifier"] + "," + RESOURCE["classifierId"] + ":" + frames[0].delClassifierList[i].id;
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    for (var i = 0; i < modlen; i++) 
    {
        var rowIndex = frames[0].modClassifierList[i].desRow;
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", frames[0].modClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["modifyClassifier"] + "," + RESOURCE["classifierId"] + ":" + frames[0].modClassifierList[i].id;
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "classifierOrder");
        param.setAttribute("value", frames[0].modClassifierList[i].order);
        row.appendChild(param);
        
        param = new tagElement("param");
        var classifierRuleLowerCase = frames[0].st1.getCellStoreValue(rowIndex, "classifierRule", "classifierRule").toLowerCase().replace(" ", "");
        param.setAttribute("name", "classifierRule");
        param.setAttribute("value", classifierRuleLowerCase);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", frames[0].st1.getCellStoreValue(rowIndex, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", frames[0].st1.getCellStoreValue(rowIndex, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierAcl");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        var car = frames[0].st1.getCellStoreValue(rowIndex, "car", "car");
        if ("-" == car) 
        {
            car = "4294967295";
        }
        else 
        {
            car = car.split("-")[0];
        }
        param = new tagElement("param");
        param.setAttribute("name", "car");
        param.setAttribute("value", car);
        row.appendChild(param);        
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    var addlen = frames[0].addClassifierList.length;
    for (var i = 0; i < addlen; i++) 
    {
        var bw = frames[0].addClassifierList[i].desBw;
        
        row = new tagElement("row-params");
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierId");
        param.setAttribute("value", frames[0].addClassifierList[i].id);
        row.appendChild(param);
        var opDesc1 = RESOURCE["addClassifier"] + "," + RESOURCE["classifierId"] + ":" + frames[0].addClassifierList[i].id;
        
        param = new tagElement("param");
        param.setAttribute("name", "index");
        param.setAttribute("value", frames[0].addClassifierList[i].index);
        row.appendChild(param);
        
        var rowIndex = frames[0].addClassifierList[i].desRow;
        param = new tagElement("param");
        param.setAttribute("name", "classifierOrder");
        param.setAttribute("value", frames[0].addClassifierList[i].order);
        row.appendChild(param);
        
        
        param = new tagElement("param");
        var classifierRuleLowerCase = frames[0].st1.getCellStoreValue(rowIndex, "classifierRule", "classifierRule").toLowerCase().replace(" ", "");
        param.setAttribute("name", "classifierRule");
        param.setAttribute("value", classifierRuleLowerCase);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "cos");
        param.setAttribute("value", frames[0].st1.getCellStoreValue(rowIndex, "queueType", "queueType"));
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "relation");
        param.setAttribute("value", frames[0].addClassifierList[i].relation);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "classifierAcl");
        param.setAttribute("value", "0");
        row.appendChild(param);
        
        var car = frames[0].st1.getCellStoreValue(rowIndex, "car", "car");
        if ("-" != car) 
        {
            car = car.split("-")[0];
        }
        param = new tagElement("param");
        param.setAttribute("name", "car");
        param.setAttribute("value", car);
        row.appendChild(param);
        
        param = new tagElement("param");
        setOpDesc(param, opDesc + opDesc1);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    
    root.getRoot().appendChild(business);

    return root.toString();
}

function callbackModify(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    $("copybtn").disabled = !btnRightArr.copybtn.right;
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshTableState(st, window.tableconf[0], data); //refresh basic info 
        queueDetailsChanged = new Array(queue_len);
        basicModified = false;
        
        frames[0].classifierQuery();
    }
    else 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    
    showErrorDialog(data);
}

function showErrorDialog(di)
{
    if (st.getDataRowLength() <= 0) 
    {
        return;
    }
    
    var errArr = [];
    var errorObj = null;
    var policyId = -1;
    var policyName = "";
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        policyId = errorObj["policyId"];
        policyName = getPolicyName(policyId);
        operObj = RESOURCE["policyId"] + RESOURCE["colon"] + policyId;
        if (policyName != null) 
        {
            operObj += RESOURCE["semicolon"] +
            RESOURCE["policyName"] +
            RESOURCE["colon"] +
            policyName;
        }
        errorObj["operationObj"] = operObj;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function deletePolicy()
{
    selRows = st.getSelectedRows();
    if (selRows.length <= 0) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("copybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmldata = createDeleteXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + deletebtnRight + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackDelete, null, "inputdata=" + xmldata);
}

function createDeleteXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row, param;
    
    selRows = st.getSelectedRows();
    
    for (var i = 0; i < selRows.length; i++) 
    {    
        var policyId = st.getCellStoreValue(selRows[i], "policyId", "policyId");
        var policyName = st.getCellStoreValue(selRows[i], "policyName", "policyName");
        
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyType");
        param.setAttribute("value", policyType);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyId");
        param.setAttribute("value", policyId);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "policyName");
        param.setAttribute("value", policyName);
        row.appendChild(param);
        
        var opDesc = RESOURCE["policyId"] + ":" + policyId;
        param = new tagElement("param");
        setOpDesc(param, opDesc);
        row.appendChild(param);
        
        business.appendChild(row);
    }
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackDelete(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("copybtn").disabled = !btnRightArr.copybtn.right;
    var data = EncapsulateData(doc);
    var NO_DATA = "42072";
    var errCode = data.getSErrorCode();
    if (0 != errCode) 
    {
        var len = data.getBErrLength();
        for (var i = len - 1; i >= 0; i--) 
        {
            if (NO_DATA == data.errObj.rowErrors[i].error.code) 
            {
                data.errObj.rowErrors.removeAt(i);
                len--;
            }
        }
        if (0 == len && (1 == errCode || 2 == errCode)) 
        {
            data.errObj.s_error.code = 0;
        }
    }
    var globalErr = data.getSErrorCode();
    if (globalErr == 0 || globalErr == 1) 
    {
        queryPolicy();
    }
    else 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    
    showErrorDialog(data);
}


function getPolicyName(policyID)
{
    var selectedRows = st.getSelectedRows();
    var policyId;
    for (var index = 0; index < selectedRows.length; index++) 
    {
        policyId = st.getCellStoreValue(selectedRows[index], "policyId", "policyId");
        if (policyId != null && policyId == policyID) 
        {
            return st.getCellStoreValue(selectedRows[index], "policyName", "policyName");
        }
    }
    return null;
}
