
var st1;
var selclassifierIndex;
var parobj = window.parent;
var obj = parobj.obj;
var neid = parobj.neid;

var classifierList = new Array();
var addClassifierList = new Array();
var delClassifierList = new Array();
var modClassifierList = new Array();

var indexList = new Array();
var orderList = new Array();
var matchList = new Array();

var btnRightArr = new Object();
var querybtnRight = TECMDCODE_GET_VUNI_INGRESS_POLICY_CLASSIFIER;
var addbtnRight = TECMDCODE_CRT_VUNI_INGRESS_POLICY_CLASSIFIER;
var addClassifier = null;
var MAX_CLASSIFIER_NUM = 16;

window.onload = function()
{
    initTable();
    initButtonInfo();
    if (btnRightArr.querybtn.right) 
    {
        parobj.queryPolicy();
    }
}

function tabSelectHandler()
{
    if (!parobj.$("querybtn").disabled) 
    {
        classifierQuery();
    }
}

function initTable()
{
    st1 = new SortTable();
    st1.head.setAttribute("id", "htmlTablevuniingressClsifiTHead");
    st1.body.setAttribute("id", "htmlTablevuniingressClsifiTBody");
    st1.setImage("../../../../../images/");
    createTableHead(st1, window.tableconf[0]);
    st1.setBodyHeight(getComponetHeight($("classifiertable"), 70) + "px");
    st1.setOnRowSelectHandler(rowSelectHandler);
    st1.setOnCellEditHandler(cellEditHandler);
    $("classifiertable").appendChild(st1.getTable());
    
    checkClassifierCar();
}

function initButtonInfo()
{
    $("addbtn").value = RESOURCE["createbtn"];
    $("delbtn").value = RESOURCE["deletebtn"];
    $("cfgrulebtn").value = RESOURCE["cfgrulebtn"];
    
    $("addbtn").disabled = true;
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querybtnRight);
    btnRightArr.addbtn = new BtnRightObj("addbtn", addbtnRight);
    
    getRightInfo(obj, btnRightArr);
    
}

function rowSelectHandler(param)
{
    if (param.length <= 0) 
    {
        setClassifierButtonStatus(true);
        return;
    }
    
    setClassifierButtonStatus(false);
    
    var bw = st1.getCellStoreValue(param[0], "bwEnable", "bwEnable");	
	if  (bw == 2)  //car         Car  
    {
    	$("advancedbtn").disabled = true;
    }

    selclassifierIndex = param[0];
}

function cellEditHandler(param)
{
    parobj.$("applybtn").disabled = !parobj.btnRightArr.applybtn.right;
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        var editRow = param.rowindex;
        var colid = param.colid;
        
        if (colid == "bwEnable") 
        {
            var index = st1.getCellStoreValue(editRow, "index", "index");
            var bw = st1.getCellStoreValue(editRow, "bwEnable", "bwEnable");
            
            for (var i = 0, len = classifierList.length; i < len; i++) 
            {
                if (classifierList[i].index == index) 
                {
                    classifierList[i].setBandwidth(bw);
                    break;
                }
            }
            
            for (var i = 0, len = addClassifierList.length; i < len; i++) 
            {
                if (addClassifierList[i].index == index) 
                {
                    addClassifierList[i].desBw = bw;
                    break;
                }
            }
        }
    }
}

function setClassifierButtonStatus(flag)
{
    $("delbtn").disabled = flag;
    $("cfgrulebtn").disabled = flag;
}

function classifierQuery()
{
    if (parobj.st.getSelectedRows().length <= 0) 
    {
        return;
    }
    
    $("addbtn").disabled = true;
    $("delbtn").disabled = true;
    $("cfgrulebtn").disabled = true;
    
    var xmldata = createQueryXml();
    var urlstr = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_VUNI_INGRESS_POLICY_CLASSIFIER + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", parobj.policyType);
    row.appendChild(param);
    
    var selectedRows = parobj.st.getSelectedRows();
    var policyId = parobj.st.getCellStoreValue(selectedRows[0], "policyId", "policyId")
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "classifierId");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackQuery(doc)
{
    $("addbtn").disabled = !btnRightArr.addbtn.right;
    
    indexList = new Array();
    orderList = new Array();
    classifierList = new Array();
    addClassifierList = new Array();
    delClassifierList = new Array();
    modClassifierList = new Array();
    
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() < 2) 
    {
        st1.clearTableData()
        createTableBody(st1, window.tableconf[0], data, RESOURCE);
    }
    
    showErrorDialog(data);
    
    for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
    {
        var index = st1.getCellStoreValue(i, "index", "index");
        var classifierId = st1.getCellStoreValue(i, "classifierId", "classifierId");
        var order = data.rows[i].classifierOrder.value;
        
        var classifierObj = new Classifier(index, classifierId, "1", i);
        
        indexList.push(index);
        orderList.push(order);
        classifierList.push(classifierObj);
        
        var ruleVal = data.rows[i].classifierRuleVal.value;
        st1.getCell(i, "classifierRule").element.storeValue["classifierRule"] = ruleVal;
        
        st1.getCellEdit(i, "car").element.onmousedown = handleCarSelect;
        st1.getCellEdit(i, "car").element.onkeydown = handleCarSelect;
        
    }
    
    matchList = new Array(MAX_CLASSIFIER_NUM);
    for (var i = 0, len = orderList.length; i < len; i++) 
    {
        matchList[orderList[i] - 1] = orderList[i];
    }
}

var carDialog = null;
function handleCarSelect()
{
    this.onkeydown = function()
    {
        return false;
    }; //avoid too many dialogs.
    editWredRow = this.parentNode.parentNode.rowIndex;
    editWredCell = st1.getCell(editWredRow, "car");
    if (carDialog) 
    {
        return;
    }
    carDialog = xshowModalDialog("carselect.html", RESOURCE["carPolicy"], 600, 400, "../../../../../images/");
    this.onkeydown = handleCarSelect;
    return false;
}

function classifierCreate()
{
    xshowModalDialog("vuniingressclassifiercreate.html?flag=1", RESOURCE["createclassifier"], 500, 605, "../../../../../images/");
}

function classifierDelete()
{
    var selRows = st1.getSelectedRows();
    
    for (var i = 0, len = selRows.length; i < len; i++) 
    {
        var index = st1.getCellStoreValue(selRows[i], "index", "index");
        var cId = st1.getCellStoreValue(selRows[i], "classifierId", "classifierId");
        delClassifierList.push(new Classifier(index, cId, "0", selRows[i]));
        
        st1.deleteRow(selRows[i]);
        parobj.$("applybtn").disabled = !parobj.btnRightArr.applybtn.right;
    }
    st1.adjustDataRows();
    
    if (st1.getDataRowLength() <= 0) 
    {
        setClassifierButtonStatus(true);
    }
    alert(RESOURCE["pressApply"]);
}

function classifierConfig()
{
    var rows = st1.getSelectedRows();
    if (rows.length <= 0) 
    {
        alert(RESOURCE["dataselcheck"]);
        return;
    }
    
    xshowModalDialog("classifierconfig.html", RESOURCE["createclassifier"], 500, 400, "../../../../../images/");
}

function classifierAdvanced()
{
    xshowModalDialog("vuniingressclassifieradvance.html", RESOURCE["advancedbtn"], 450, 250, "../../../../../images/");
}


function resetClassifierObjRow(src, des)
{
    var srcIndex = st1.getCellStoreValue(src, "index", "index");
    var desIndex = st1.getCellStoreValue(des, "index", "index");
    var srcObj, desObj;
    
    for (var k = 0, len = classifierList.length; k < len; k++) 
    {
        if (srcIndex == classifierList[k].index) 
        {
            srcObj = classifierList[k];
            break;
        }
        if (desIndex == classifierList[k].index) 
        {
            desObj = classifierList[k];
            break;
        }
    }
    
    for (var k = 0, len = addClassifierList.length; k < len; k++) 
    {
        if (srcIndex == addClassifierList[k].index) 
        {
            srcObj = addClassifierList[k];
            break;
        }
        if (desIndex == addClassifierList[k].index) 
        {
            desObj = addClassifierList[k];
            break;
        }
    }
    
    srcObj.setRowNumber(des);
    desObj.setRowNumber(src);
}




function setCellStatus(st, row, colAry, isEdit, color, dbclickFunc)
{
    for (var i = 0; i < colAry.length; i++) 
    {
        st.setCellIsEdit(st.getCellElement(row, colAry[i]), isEdit);
    }
}

function setCellDefault(st, row, colary, defval)
{
    for (var i = 0; i < colary.length; i++) 
    {
        st.setCellValue(st.getCell(row, colary[i]), colary[i], defval);
        st.setAtomValue(st.getCell(row, colary[i]).element.showElement, defval);
    }
}

window.onresize = function()
{
    if (document.body) 
    {
        st1.setBodyHeight(getComponetHeight($("classifiertable"), 70) + "px");
    }
}

function constructClassifierList()
{
    for (var i = delClassifierList.length - 1; i >= 0; i--) 
    {
        var delFlag = false;
        
        var delObj = delClassifierList[i];
        
        for (var j = addClassifierList.length - 1; j >= 0; j--) 
        {
            var addObj = addClassifierList[j];
            if (delObj.index == addObj.index) 
            {
                addClassifierList.removeAt(j);
                delFlag = true;
                break;
            }
        }
        
        if (delFlag) 
        {
            delClassifierList.removeAt(i);
        }
    }
    
    for (var i = classifierList.length - 1; i >= 0; i--) 
    {
        var modFlag = true;
        
        var cObj = classifierList[i];
        
        for (var j = delClassifierList.length - 1; j >= 0; j--) 
        {
            var delObj = delClassifierList[j];
            if (cObj.index == delObj.index) 
            {
                modFlag = false;
                break;
            }
        }
        
        if (modFlag) 
        {
            modClassifierList.push(cObj);
        }
    }
    
    for (var i = 0, len = st1.getDataRowLength(); i < len; i++) 
    {
        var idx = st1.getCellStoreValue(i, "index", "index");
        for (var k = modClassifierList.length - 1; k >= 0; k--) 
        {
            var modObj = modClassifierList[k];
            if (idx == modObj.index) 
            {
                modObj.order = i + 1;
                modObj.desRow = i;
                break;
            }
        }
        
        for (var k = 0; k < addClassifierList.length; k++) 
        {
            var addObj = addClassifierList[k];
            if (idx == addObj.index) 
            {
                addObj.order = i + 1;
                addObj.desRow = i;
                break;
            }
        }
    }
    
}

/**
 * @param val              
 */
function calculateOrder(val)
{
    var order = parseInt(val, 10);
    
    if (!matchList[order - 1]) 
    {
        return order;
    }
    else 
    {
        var k = order;
        while (k < MAX_CLASSIFIER_NUM) 
        {
            if (!matchList[k]) 
            {
                matchList[k] = k + 1;
                return k + 1;
            }
            k++;
        }
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) 
    {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = RESOURCE["classifierId"] + ":" + errorObj["classifierId"];
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../page/", di.getError(), errArr);
}

function checkClassifierCar()
{
    var count = st1.getDataRowLength();
    for (var i = 0; i < count; i++) 
    {
        textCheck(st1.getCellEdit(i, "cir").element, "64", "20000000");
        textCheck(st1.getCellEdit(i, "pir").element, "64", "20000000");
        textCheck(st1.getCellEdit(i, "cbs").element, "16000", "10000000");
        textCheck(st1.getCellEdit(i, "pbs").element, "16000", "10000000");
        st1.getCellEdit(i, "cir").element.onblur = cellonblur;
        st1.getCellEdit(i, "pir").element.onblur = cellonblur;
        st1.getCellEdit(i, "cbs").element.onblur = cellonblur;
        st1.getCellEdit(i, "pbs").element.onblur = cellonblur;
    }
}

function addCellEvent()
{
    st1.getCellEdit(0, "car").element.onmousedown = handleCarSelect;
    st1.getCellEdit(0, "car").element.onkeydown = handleCarSelect;
}

function setApplyBtnStatus(flag)
{
	parobj.$("applybtn").disabled = flag;
}
