
var NON_CAR = 0;
var ADD_CAR = 1;
var DEL_CAR = 2;
var MOD_CAR = 3;
var VLANID_MAX = "4095";
/**
 * @param index
 * @param id
 * @param bw
 * @param row
 * @param order
 * @param relation
 */
function Classifier(index, id, bw, row, order, relation)
{
    this.index = index;
    this.id = id;
    this.order = order;
    this.srcBw = bw;
    this.desBw = bw;
    
    this.relation = relation;
    this.srcRow = row;
    this.desRow = row;
    
    this.red_handle = null;
    this.red_rmkcos = null;
    this.red_rmkcol = null;
    this.yel_handle = null;
    this.yel_rmkcos = null;
    this.yel_rmkcol = null;
    this.grn_handle = null;
    this.grn_rmkcos = null;
    this.grn_rmkcol = null;
    
    this.setRelation = function(rel)
    {
        this.relation = rel;
    }
    
    this.setRowNumber = function(num)
    {
        this.desRow = num;
    }
    
    this.setBandwidth = function(desbw)
    {
        this.desBw = desbw;
    }
    
    this.setAdvancedAttr = function(i, handle, rmkcos, rmkcol)
    {
        switch (i)
        {
            case 0:
				this.red_handle = handle;
                this.red_rmkcos = rmkcos;
                this.red_rmkcol = rmkcol;
                break;
            case 1:
                this.yel_handle = handle;
                this.yel_rmkcos = rmkcos;
                this.yel_rmkcol = rmkcol;
                break;
            case 2:
                this.grn_handle = handle;
                this.grn_rmkcos = rmkcos;
                this.grn_rmkcol = rmkcol;
                break;
            default:
                break;
        }
    }
    
    this.getBwChangedFlag = function()
    {
        if (this.desBw == this.srcBw) 
        {
            return false;
        }
        return true;
    }
    
    this.getCarStatus = function()
    {
        if (this.getBwChangedFlag()) 
        {
            if (this.desBw == 1) 
            {
                return ADD_CAR;
            }
            else if (this.desBw == 2) 
            {
                return DEL_CAR;
            }
        }
        else 
        {
            if (this.desBw == 1) 
            {
                return MOD_CAR;
            }
            else
            {
                return NON_CAR;
            }
        }
    }
}

var ruleIds = new Array("cvlanid","svlanid");

function checkRuleInput(st)
{
	var mtype, mval, wcard, ruleval, retval;
	
	var len = st.getDataRowLength();
	for (var i=0; i<len; i++)
	{
		mtype = st.getCellStoreValue(i, "matchType", "matchType");
		mval = st.getCellStoreValue(i, "matchValue", "matchValue");
		wcard = st.getCellStoreValue(i, "wildcard", "wildcard");
		
		switch (mtype)
		{
			case "sip":
			case "dip":
				if (!checkIpFormat(mval) || !checkIpFormat(wcard))
				{
					return false;
				}
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "smac":
			case "dmac":
				if (!checkMacFormat(mval) || !checkMacFormat(wcard))
				{
					return false;
				}
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "protype":
				if (!checkWildcard(wcard))
				{
					return false;
				}
				ruleval = "mtype"+":"+mval;
				break;
			case "sport":
			case "dport":
				if (!checkNumFormat(mval, 0, 65535) || !checkNumFormat(wcard, 0, 65535))
					return false;
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "icmp":								
					break;
			case "dscp":
				if (!checkNumFormat(mval, 0, 63) || !checkNumFormat(wcard, 0, 63))
					return false;
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "ipprec":
			case "cvlanpri":
			case "svlanpri":
				if (!checkNumFormat(mval, 0, 7) || !checkNumFormat(wcard, 0, 7))
					return false;
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "cvlanid":
			case "svlanid":
				if (!checkNumFormat(mval, 0, parseInt(VLANID_MAX)) || !checkNumFormat(wcard, 0, parseInt(VLANID_MAX)))
					return false;
				ruleval = mtype+":"+mval+":"+wcard;
				break;
			case "dei":
				if (!checkNumFormat(mval, 0, 1) || !checkWildcard(wcard))
					return false;
				ruleval = "mtype"+":"+mval;
				break;
			default:
				break;
		}
	}
	return true;
}

function checkRuleRepeated(st)
{
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var srcVal = st.getCellStoreValue(i, "matchType", "matchType");
        
        for (var j = i + 1; j < len; j++) 
        {
            var desVal = st.getCellStoreValue(j, "matchType", "matchType");
            if (srcVal == desVal) 
            {
                alert(RESOURCE["andrulecheck1"]);
                return false;
            }
        }
    }
    return true;
}

function checkRuleRelation(st)
{
    var sport, dport, icmp, ipprec, dscp = false;
    
    var protypeAry = new Array();
    
    var len = st.getDataRowLength();
    for (var i = 0; i < len; i++) 
    {
        var srcVal = st.getCellStoreValue(i, "matchType", "matchType");
        
        if (srcVal == "sport") 
        {
            sport = true;
        }
        else if (srcVal == "dport") 
        {
            dport == true;
        }
        else if (srcVal == "icmp") 
        {
            icmp = true;
        }
        else if (srcVal == "protype") 
        {
            protypeAry[protypeAry.length] = st.getCellStoreValue(i, "matchValue", "matchValue");
        }
        else if (srcVal == "ipprec") 
        {
            ipprec = true;
        }
        else if (srcVal == "dscp") 
        {
            dscp = true;
        }
    }
    
    var portSupp, icmpSupp = false;
    if (sport || dport) 
    {
        for (var i = 0; i < protypeAry.length; i++) 
        {
            if (protypeAry[i] == "tcp" || protypeAry[i] == "udp") 
            {
                portSupp = true;
                break;
            }
        }
    }
    
    if (icmp) 
    {
        for (var i = 0; i < protypeAry.length; i++) 
        {
            if (protypeAry[i] == "icmp") 
            {
                icmpSupp = true;
                break;
            }
        }
    }
    
    if ((sport || dport) && !portSupp) 
    {
        alert(RESOURCE["rulecheck1"]);
        return false;
    }
    
    if (icmp && !icmpSupp) 
    {
        alert(RESOURCE["rulecheck2"]);
        return false;
    }
    
    var rel = $("relation").value;
    if (rel == 1 && dscp && ipprec) 
    {
        alert(RESOURCE["andrulecheck2"]);
        return false;
    }
    
    return true;
}

function checkIpFormat(val)
{
    var regex = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/ig;
    if (val.match(regex) == null) 
    {
        alert(RESOURCE["checkip"]);
        return false;
    }
    
    var ary = val.split(".");
    for (var i = 0; i < ary.length; i++) 
    {
        if (parseInt(ary[i], 10) > 255 || parseInt(ary[0], 10) < 0) 
        {
            alert(RESORUCE["checkip"]);
            return false;
        }
    }
    return true;
}

function checkMacFormat(val)
{
    var regex = /^([a-fA-F0-9]{2}\-){5}[a-fA-F0-9]{2}$/ig;
    if (val.match(regex) == null) 
    {
        alert(RESOURCE["checkmac"]);
        return false;
    }
    return true;
}

function checkWildcard(val)
{
    if (val != null && val != "") 
    {
        alert(RESOURCE["checkwildcard"]);
        return false;
    }
    return true;
}

function checkNumFormat(val, minval, maxval)
{
	var regex = /^\d+$/ig;
		
	if (val.match(regex) == null || parseInt(val, 10) > maxval || parseInt(val, 10) < minval)
	{
		alert(RESOURCE["checkInteger"]);
		return false;
	}
		
	return true;
}

function trimStringTail(val, chr)
{
    if (val.charAt(val.length - 1) == chr) 
    {
        val = val.substring(0, val.length - 1);
    }
    return val;
}

function setChangeType(val)
{
    var ret;
    if (val == "protype" || val == "icmp" || val == "dei") 
    {
        if (val == "dei") 
        {
            ret = 3;
        }
        else 
        {
            ret = 2;
        }
    }
    else 
    {
        ret = 1;
    }
    
    return ret;
}

function createOptionsProtype()
{
    var opts = new Array();
    
    opts[0] = new Option("tcp", "tcp");
    opts[1] = new Option("udp", "udp");
    opts[2] = new Option("icmp", "icmp");
    opts[3] = new Option("igmp", "igmp");
    
    return opts;
}

function createOptionsIcmp()
{
    var opts = new Array();
    
    opts[0] = new Option("echo", "echo");
    opts[1] = new Option("echo-reply", "echo-reply");
    opts[2] = new Option("fragmentneed-DFset", "fragmentneed-DFset");
    opts[3] = new Option("host-redirect", "host-redirect");
    opts[4] = new Option("host-tos-redirect", "host-tos-redirect");
    opts[5] = new Option("host-unreachable", "host-unreachable");
    opts[6] = new Option("information-reply", "information-reply");
    opts[7] = new Option("information-request", "information-request");
    opts[8] = new Option("net-redirect", "net-redirect");
    opts[9] = new Option("net-tos-redirect", "net-tos-redirect");
    opts[10] = new Option("net-unreachable", "net-unreachable");
    opts[11] = new Option("parameter-problem", "parameter-problem");
    opts[12] = new Option("port-unreachable", "port-unreachable");
    opts[13] = new Option("protocol-unreachable", "protocol-unreachable");
    opts[14] = new Option("reassembly-timeout", "reassembly-timeout");
    opts[15] = new Option("source-quench", "source-quench");
    opts[16] = new Option("source-route-failed", "source-route-failed");
    opts[17] = new Option("timestamp-reply", "timestamp-reply");
    opts[18] = new Option("timestamp-request", "timestamp-request");
    opts[19] = new Option("ttl-exceeded", "ttl-exceeded");
    
    return opts;
}

/**
 * @param numList: Array
 */
function getMaxValueFromArray(numList)
{
    var len = numList.length;
    if (len == 0) 
    {
        return 0;
    }
    else if (len == 1) 
    {
        return numList[0];
    }
    
    var i = 0;
    var j = i + 1;
    
    while (j < len) 
    {
        val1 = parseInt(numList[i], 10);
        val2 = parseInt(numList[j], 10);
        
        if (val1 < val2) 
        {
            i = j;
            j = i + 1;
        }
        else 
        {
            j++;
        }
    }
    
    return numList[i];
}

/**
 * add key press handler for each edit cell
 * @param keyVal:   match type's value
 * @param editcell: target editElement
 */
function addKeyHandler(keyVal, editcell)
{
    var cell = editcell;
    var matchType = keyVal;
    
    if (matchType.indexOf("ip") >= 0) 
    {
        validateIp(cell, true);
    }
    else if (matchType.indexOf("mac") >= 0) 
    {
        validateMac(cell, true);
    }
    else if (matchType.indexOf("port") != -1) 
    {
        textCheck(cell, "0", "65536");
    }
    else if (matchType == "dscp") 
    {
        textCheck(cell, "0", "63");
    }
    else if (matchType.indexOf("vlanid") != -1) 
    {
        textCheck(cell, "0", VLANID_MAX);
    }
    else if (matchType == "dei") 
    {
        textCheck(cell, "0", "1");
    }
    else 
    {
        textCheck(cell, "0", "7");
    }
}

function addInputConstraint(eventRow, matchType, col)
{
}

function cellondbclick_new(cell1, matchType)
{
    if (matchType == "sip" || matchType == "dip") 
    {
        validateIp(cell1.element, true);
    }
    else if (matchType == "smac" || matchType == "dmac") 
    {
        validateMac(cell1.element, true);
    }
    else if (matchType == "sport" || matchType == "dport") 
    {
        textCheck(cell1.element, "0", "65535", 0);
    }
    else if (matchType == "dscp") 
    {
        textCheck(cell1.element, "0", "63", 0);
    }
    else if (matchType == "ipprec") 
    {
        textCheck(cell1.element, "0", "7", 0);
    }
    else if (matchType == "cvlanid") 
    {
        textCheck(cell1.element, "0", VLANID_MAX, 0);
    }
    else if (matchType == "cvlanpri") 
    {
        textCheck(cell1.element, "0", "7", 0);
    }
    else if (matchType == "svlanid") 
    {
        textCheck(cell1.element, "0", VLANID_MAX, 0);
    }
    else if (matchType == "svlanpri") 
    {
        textCheck(cell1.element, "0", "7", 0);
    }
    else if (matchType == "dei") 
    {
        textCheck(cell1.element, "0", "1", 0);
    }
}

/*
 Cell dblclick handler
 */
function cellondbclickForRule()
{
    mozillaComboboxDiv = 0;
    
    this.style.backgroundColor = "#d0f946";
    if (isIE) 
    {
        this.onselectstart = null;
    }
    else 
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none";
    
    var colid = this.colid;
    var editdom = this.parent.editdom[colid];
    
    var rowindex = this.parentNode.rowIndex;
    var matchType = st.getCellStoreValue(rowindex, "matchType", "matchType");
    if ("matchType" != colid) 
    {
        cellondbclick_new(editdom, matchType)
    }
    
    if (typeof(handleLinkageAction) != 'undefined') 
    {
        var editdomclone = new Object();
        for (var member in editdom) 
        {
            editdomclone[member] = editdom[member];
        }
        editdomclone.element = editdom.element.cloneNode(true);
        editdom = handleLinkageAction(this.parentNode.rowIndex, editdomclone);
        editdom.element.onblur = cellonblur;
    }
    
    handleCellEdit(this, TABLE_CONSTANT.BEFOREEDIT);
    
    if (editdom.type == "text") 
    {
        if (this.showElement.getValue() == " " || this.showElement.getValue() == "\xA0") 
        {
            editdom.setValue("");
        }
        else 
        {
            editdom.setValue(this.showElement.getValue());
        }
    }
    else if (editdom.type == "select") 
    {    
        for (i = 0; i < editdom.element.options.length; i++) 
        {
            if (editdom.element.options[i].text == this.showElement.getValue()) 
            {
                editdom.element.options[i].selected = true;
                editdom.element.focus();
            }
        }
    }
    else if (this.editElement.type == "combobox") 
    {
        this.appendChild(editdom.element);
        window.curEditCell = this.editElement.element;
        
        var comboObj = this.editElement.element.parent;
        var eleTd = this.editElement.element.parentNode;
        var eleTable = eleTd.offsetParent;
        
        var wdt = eleTd.offsetWidth - 2;
        var clip = "rect(1px," + (wdt - 1) + "px,19," + (wdt - 18) + "px)";
        
        comboObj.txtview.style.width = wdt;
        comboObj.selview.style.width = wdt;
        comboObj.selview.style.clip = clip;
        
        if (isIE) 
        {
            var absCellY = getPosY(eleTd);
            var absTableY = getPosY(eleTable);
            comboObj.txtview.style.top = absCellY - absTableY + 1;
            comboObj.selview.style.top = absCellY - absTableY + 1;
        }
        else 
        {
            comboObj.txtview.style.position = "fixed";
            comboObj.selview.style.position = "fixed";
            
            var absCellY = getPosY(eleTd);
            var scrollTop = document.body.scrollTop; // scrollbar scroll length
            comboObj.txtview.style.top = absCellY - scrollTop;
            comboObj.selview.style.top = absCellY - scrollTop;
        }
        
        var showVal = this.showElement.getValue();
        var len = comboObj.selview.options.length;
        
        for (var k = 0; k < len; k++) 
        {
            if (comboObj.selview.options[k].value == showVal ||
            comboObj.selview.options[k].text == showVal) 
            {
                comboObj.setSelectedIndex(k);
                comboObj.txtview.focus();
                break;
            }
        }
        
        comboObj.txtview.focus();
        return;
    }
    
    if (this.offsetWidth) 
    {
        editdom.element.style.width = (this.offsetWidth - 1) + "px";
    }
    
    this.appendChild(editdom.element);
    
    editdom.element.focus();
}

function constructRuleRow(st, tc, defaultVal)
{
    if (st.element.isAppendEmptyTr) 
    {
        var tBody = st.bodyPack.firstChild.lastChild;
        tBody.removeChild(tBody.firstChild);
        st.element.isAppendEmptyTr = false;
    }
    
    var row = st.createRow();
    var colnum = tc.colArray.length;
    var val;
    
    if (st.editdom == null) 
    {
        st.editdom = new Array();
    }
    
    for (var j = 0; j < colnum; j++) 
    {
        var colid = tc.getColId(j);
        var coledit = tc.getIsEdit(j);
        cell = st.createCell(tc.getColWidth(j));
        atom = st.createAtom("span");
        
        var conv = tc.getColKeyArray(j)[0].getConvert();
        if (conv) 
        {
            val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
            st.setCellValue(cell, colid, defaultVal[j]);
        }
        else 
        {
            val = defaultVal[j];
            st.setCellValue(cell, colid, val);
        }
        
        atom.setValue(val);
        
        st.setCellIsEditForRule(cell, coledit);
        st.addCellShow(cell, atom);
        st.addCell(row, colid, cell);
        
        if (coledit == 1) 
        {
            var editType = tc.getColEditType(j);
            atom = st.createAtom(editType);
            
            if (editType == "select") 
            {
                var ops = tc.getColEditOptions(j);
                if (ops.length > 0) 
                {
                    for (var k = 0; k < ops.length; k++) 
                    {
                        atom.addOption(ops[k].getName(), ops[k].getValue());
                    }
                }
            }
            
            atom.element.onclick = stopEventPropagation;
            atom.element.ondblclick = stopEventPropagation;
            st.editdom[colid] = atom;
            
            st.addCellEditElementForRule(cell, st.editdom[colid]);
            st.addCell(row, colid, cell);
        }
        
        var cellwidth = tc.getColWidth(j);
        if (cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%") 
        {
            cell.element.style.display = "none";
        }
    }
    
    st.addRow(row);
    
    return row.element.rowIndex;
}

SortTable.prototype.setCellIsEditForRule = function(cell, isedit)
{
    cell.element.isEdit = isedit;
    
    if (isedit.toString() == "0" || !isedit) 
    {
        cell.element.style.backgroundColor = "";
        cell.element.ondblclick = null;
    }
    else 
    {
        cell.element.style.backgroundColor = "#FFFFFF";
        cell.element.ondblclick = cellondbclickForRule;
    }
    
    if (cell.element.parentElement && cell.element.parentElement.selectFlag) 
    {
        if (isedit.toString() == "0") 
        {
            cell.element.children[0].style.color = "";
        }
        else 
        {
            cell.element.children[0].style.color = "#000000";
        }
    }
}

SortTable.prototype.addCellEditElementForRule = function(cell, isedit)
{
    var ce = cell.element;
    if (ce.isEdit == 1) 
    {
        ce.style.backgroundColor = "#ffffff";
			  if (ce.childNodes[0])
				{
					ce.childNodes[0].style.color = "#000000";
				}
        cell.element.editElement = atom;
        
        cell.element.style.cursor = "hand";
        ce.ondblclick = cellondbclickForRule;
        atom.element.onblur = cellonblur;
    }    
    else 
    {
				ce.style.backgroundColor = "";
				if (ce.childNodes[0])
				{
					ce.childNodes[0].style.color = "";
				}
        cell.element.editElement = atom;
        cell.element.style.cursor = "hand";
        cell.element.ondblclick = null;
    }
}
