var gencfgObj = gencfg;
var url = self.location.search;

var byfunFlag = false;

var hasQueryRight = true;

var hasApplyRight = true;

var obj = getNeProperty(self);
var isNeedDisable = false;
var neType = obj["neType"];
var neVersion = obj["neversion"];

if(isNeedDisable == false 
	&& SpecialAttrMgr.isNESupport(obj.neid,"TE_FUNC_PTN_CFG_E1_PORTATTR","E1_ATTR_SUPPORT_DISABLED_L3"))
{
	isNeedDisable = true;
}

var PORTNAME_MAX_LENGTH = 64;//        
var interruptFlag = false;//                
var modifyIpFlag = false;
var MAX_MAXPKTLEN = '9600';//           
var MIN_MAXPKTLEN = '46';//           
var MIN_VLANID = "1";
var ENABLED = 1;//  
var DISABLED = 0;//   
var MIN_TE = '0';//TE     
var MAX_TE = '4294967295';//TE     
var MAX_VLANID = "4094";
var INVALID_IP = 0xFFFFFFFF;
var INVALID_SLOTID = 0xFFFF;
var PDH_INTERFACE_FUNID = "8518";//   PDH     ID
var BOARD_NOT_EXIST = 1090596479;//        
var INVALID_SLOT_ID = "65535";//      
var sfid;
var borrowedPorts = new Array();
var CES_MODE = 1;

function initpage()
{
    $("selectBdText").innerHTML = RESOURCE["selectBdText"];
    
    
    var selectobj = document.getElementById("selectObj");
    
    selectobj["onchange"] = function()
    {
        refreshInnerPage(this);
    }

    if (isBoardFunc()) 
    {
        $("scrolltable").style.display = "none";
    }
    getAttribute();
}


function getAttribute()
{
    var xml = createGetAttributeXML();
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_NTF_CREATECIRCUITPACK;
    var params = new Array();
    params[0] = gencfgObj;
    params[1] = url;
    loadXMLdoc(urlreq, "POST", false, initGenCfgPage, params, "inputdata=" + xml);
}

function createGetAttributeXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neidvalue = getNeProperty(self).neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "funid");
    param.setAttribute("value", PDH_INTERFACE_FUNID);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = getNeProperty(self).slotid;
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}


/**
 *          
 * @param doc:     XML   params     
 * @return  
 */
function initGenCfgPage(doc, params)
{
    gencfgObj = params[0];
    var urlStr = params[1];
    var unFilterComponetArr = params[2];

    filterAttr(doc, gencfgObj, unFilterComponetArr);
    init(gencfgObj, urlStr);
    
    if (!isBoardFunc())//     
    {
        fillBDInfo(doc);
    }
    
}

function fillBDInfo(doc)
{
    var bdSelect = document.getElementById("selectObj");
    bdSelect.options.length = 0;
    bdSelect.options[0] = new Option(RESOURCE["allBoard"], 0);
    var allData = EncapsulateData(doc);
    if (allData.getDataRowLength() <= 0) 
    {
        return;
    }
    
    var bdInfo = allData.getDataRowParam(0, "bdInfo");
    var bdArr = bdInfo.split(",");
    for (var i = 0; i < bdArr.length; i++) 
    {
        bdSelect.options[bdSelect.options.length] = new Option(bdArr[i], bdArr[i].split("-")[0]);
    }
}

/**
 *         
 * @param doc:     XML   gencfgObj       
 * @return  
 */
function filterAttr(doc, gencfgObj, unFilterComponetArr)
{
    var data = EncapsulateData(doc);
    var allSupportAttr = getAllSupportAttrAsSet(data);
    var supportAttr = "";
    var bdInfo = data.getDataRowParam(0, "bdInfo");
    var beforSupportAttr = gencfgObj.getSupportAttr().split(",");
    for (var index = 0; index < beforSupportAttr.length; index++) 
    {
        if ((!isBoardFunc() && bdInfo == null) 
			|| beforSupportAttr[index] in allSupportAttr) 
        {
            if (supportAttr != "") 
            {
                supportAttr += ",";
            }
            supportAttr += beforSupportAttr[index];
        }
    }
    gencfgObj.supportAttr = supportAttr;
    filterComponent(gencfgObj.getChilds(), supportAttr.split(","), unFilterComponetArr);
    return;
}


function refreshInnerPage(selectObj)
{
    var slotId = selectObj.value.toString();
    var tab = window.tabs[0];
    var selTab = tab.getTabWindow(tab.selectTabid);
    selTab.queryPDHInterface(selTab.sfid, slotId);
}

/**
 *             
 */
function getSupportAttrByfun()
{
    var supportAttrByboard = gencfgObj.getSupportAttr().split(",");
    var supportAttriByfun = [];
    
    var flag = false;
    for (var i = supportAttrByboard.length - 1; i >= 0; i--) 
    {
        supportAttriByfun[supportAttriByfun.length] = supportAttrByboard[i];
    }
    
    for (var i = 0, len = supportAttriByfun.length; i < len; i++) 
    {
        for (j = supportAttriByfun.length - 1; j > i; j--) 
        {
            if (supportAttriByfun[i] == supportAttriByfun[j]) 
            {
                supportAttriByfun.removeAt(j);
            }
        }
    }
    
    return supportAttriByfun;
}

function initBody(funid)
{
    sfid = funid;
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("printBtn").value = RESOURCE["printbutton"];
    $("saveAsFileBtn").value = RESOURCE["savefile"];
    
    neid = obj["neid"];
    
    slotid = obj["slotid"];
    
    st = new SortTable();
    
    st.setImage("../../../../../images/");
    
    tableconfObj = window.tableconf[0];
    
    var attrArr = obj["supportAttr"].split(",");
    
    filterAttrCol(tableconfObj, attrArr, ["slotid"],window.parent.genCfgAttrList);
    if (tableconfObj.colArray.length > 1) 
    {
        var tmpid = tableconfObj.colArray[2].id;
        if (tmpid.indexOf("VCG") != -1) 
        {
            portType = 0;
        }
        else 
        {
            portType = 1;
        }
    }
    
    st.setOnCellEditHandler(cellEditHandler);
    st.setKeyColID("port");
    st.setCellEditRangeFunc(gencfgEditRangeFunc);
    
    createTableHead(st, tableconfObj);
    
    document.getElementById("tablecomponent").appendChild(st.getTable());
    
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 95) + "px");
    
    window.onresize = function()
    {
        st.setBodyHeight(getComponetHeight($("tablecomponent"), 95) + "px");
    }
    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    pageloaded = true;
}

function cellEditHandler(param)
{
    if (param.colid == "PTNIF_PORT_ATTR_IPPARAPORT" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var rowIndex = param.rowindex;
        var cell = st.getCellEdit(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
        cell.element.options.length = 0;
        var boardValue = st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML;
        if (!boardValue) 
        {
            return;
        }
        for (var j = 0, n = borrowedPorts.length; j < n; j++) 
        {
			var lastIndex = borrowedPorts[j].lastIndexOf("#");
            var portNo = borrowedPorts[j].substring(lastIndex + 1, borrowedPorts[j].length);
            var port = borrowedPorts[j].substring(0, lastIndex);
            var arr = port.split("-");
            var bd = arr[0] + "-" + arr[1];
            if (parseInt(portNo) >= 0x1000 && parseInt(portNo) <= 0x17FF) 
            {
                bd = "ML-PPP";
                port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
            }
            else if (parseInt(portNo) >= 0x2800 && parseInt(portNo) <= 0x2FFF) 
            {
                bd = "Virtual Ethernet";
                port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
            }
            
            if (boardValue == bd) 
            {
                cell.addOption(port, borrowedPorts[j]);
            }
        }
    }

	if (st != null) 
	{
		for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
		{
			if (param.colid == "PTNIF_PORT_ATTR_MODE") 
			{
				var portmode = st.getCellEdit(i, "PTNIF_PORT_ATTR_MODE");
				
				var boardname=st.getCellStoreValue(i, "port", "boardname");
				if (("MP1" == boardname)) 
				{
					portmode.clearOptions();
					portmode.addOption(RESOURCE["LAYER1"], "1");
					portmode.addOption(RESOURCE["LAYER3"], "3");
				}
			}
		}
	}
	/**
	 *      DTS2012122903486 
	 *               
	 */
	if (param.colid == "PTNIF_PORT_ATTR_MODE" && param.stage == TABLE_CONSTANT.AFTEREDIT) 
	{
		var rowIndex = param.rowindex;
		var cell = st.getCellEdit(rowIndex, "PTNIF_PORT_ATTR_MODE");
		 var portMode = st.getCellStoreValue(rowIndex, "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE");
		var mtuColid = "PTNIF_ETHPORT_ATTR_MTU";//       
	    var encapTypeColid = "PTNIF_PORT_ATTR_ENCAPTYPE";//    
	    var mtuCell = st.getCell(rowIndex, mtuColid);
	    var encapTypeCell = st.getCell(rowIndex, encapTypeColid);
	    if (portMode == 1 || portMode == 2) 
	    {
	        if (portMode == 1) 
	        {
	            setCellEdit(encapTypeCell, encapTypeColid, "0", "NULL", DISABLED);
	        }
	        else//           ATM 	
	         {
	            setCellEdit(encapTypeCell, encapTypeColid, "4", "ATM", DISABLED);
	        }
	        setCellEdit(mtuCell, mtuColid, "-1", "-", DISABLED);
	    }
	    else //        
	     {
	        setCellEdit(encapTypeCell, encapTypeColid, "5", "PPP", ENABLED);
	        setCellEdit(mtuCell, mtuColid, "1620", "1620", ENABLED);
			
	    }
	}
    if (hasApplyRight) 
    {
        $("applybtn").disabled = false;
    }
}

function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
            else 
            {
                createPPPMenu(rows, evt);
                return;
            }
        }
        
    }
}

function createPPPMenu(rows, evt)
{
    removejsDOMmenu();
    var portMode;
    var encapType;
    var menuEnabled = false;
    for (var i = 0; i < rows.length; i++) 
    {
		if(st.getCell(rows[i],"PTNIF_PORT_ATTR_MODE") == null && st.getCell(rows[i],"PTNIF_PORT_ATTR_ENCAPTYPE") == null)
		{
			return;
		}
        portMode = st.getCellStoreValue(rows[i], "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE");
        encapType = st.getCellStoreValue(rows[i], "PTNIF_PORT_ATTR_ENCAPTYPE", "PTNIF_PORT_ATTR_ENCAPTYPE");
        if (portMode == "3" && encapType == "5") 
        {
            menuEnabled = true;
            break;
        }
    }
    
    menuEnabled = isNeedDisable == true ? false : menuEnabled;
    
    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPPPRunStat"], "", queryPPPRunStat, rows, menuEnabled));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["resetPPP"], "", resetPPP, rows, menuEnabled));
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

function queryPPPRunStat(rows)
{
    removejsDOMmenu();
    xshowModalDialog("ppprunstatdlg.html", RESOURCE["pppRunStat"], 700, 420, "../../../../../images/");
}


function resetPPP(rows)
{
    removejsDOMmenu();
    if (!confirm(RESOURCE["resetPPPTips"])) 
    {
        return;
    }
    var xml = createResetPPPXML();
    urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_SP_RESET_PPP;
    var params = new Array();
    loadXMLdoc(urlreq, "POST", false, resetHandleBack, params, "inputdata=" + xml);
}

/**
 *       PPP xml  
 * @return    xml  
 */
function createResetPPPXML()
{
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    
    var selectRows = st.getSelectedRows();
    for (var i = 0; i < selectRows.length; i++) 
    {
        var portMode = st.getCellStoreValue(selectRows[i], "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE");
        var encapType = st.getCellStoreValue(selectRows[i], "PTNIF_PORT_ATTR_ENCAPTYPE", "PTNIF_PORT_ATTR_ENCAPTYPE");
        if (portMode != "3" || encapType != "5") 
        {
            continue;//     PPP    
        }
        
        var secondlevel = new tagElement("row-params");
        
        var thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "neid");
        thirdlevel.setAttribute("value", obj["neid"]);
        secondlevel.appendChild(thirdlevel);
        
        var slotid = st.getCellStoreValue(selectRows[i], "slotid", "slotid");
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "slotid");
        thirdlevel.setAttribute("value", slotid);
        secondlevel.appendChild(thirdlevel);
        
        var portName = st.getCellStoreValue(selectRows[i], "port", "portname");
        var portid = portName.substring(0, portName.indexOf("("));
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "port");
        thirdlevel.setAttribute("value", portid);
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

/**
 *   PPP     
 * @param doc        
 */
function resetHandleBack(doc)
{
    $("closebtn").disabled = false;
    var resetResult = EncapsulateData(doc);
    var errorCode = resetResult.getSErrorCode();
    
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    errArr[3] = "portname";
    openErrPage("../../../../../page/", resetResult.getError(), errArr);
}

function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    var thirdlevel = null;
    secondlevel = new tagElement("row-params");
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", TECMDCODE_GET_SDHETHPORTATTRIB);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    secondlevel = new tagElement("row-params");
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", TECMDCODE_SET_SDHETHPORTATTRIB);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function sendQueryRightReq()
{
    var url = "../../../../../securityServlet?neID=" + obj["neid"] + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var right = data.getDataRowParam(i, "right");
        var sfid = data.getDataRowParam(i, "sfid");
        if (0 == right) 
        {
            if (sfid == TECMDCODE_GET_PDHPATHATTRIB) 
            {
                hasQueryRight = false;
            }
            else 
            {
                hasApplyRight = false;
            }
        }
    }
    $("querybtn").disabled = !hasQueryRight;
    $("applybtn").disabled = true;
}

function tabSelectHandler()
{
    if (!sfid) 
    {
        return;
    }
    sendQueryRightReq();
    queryPDHInterface(sfid);
}

function queryPDHInterface(sfid)
{
    if (!hasQueryRight) 
    {
        return;
    }
    
    var selectobj = parent.document.getElementById("selectObj");
    
    var slotid = [];
    if (isBoardFunc()) 
    {
        slotid.push(obj["slotid"]);
    }
    else 
    {
        if (selectobj.options.length == 1)//                    
        {
            return;
        }
        
        if (selectobj.selectedIndex == 0)//        
        {
            for (var i = 1; i < selectobj.options.length; i++) 
            {
                slotid.push(selectobj.options[i].value);
            }
        }
        else 
        {
            var selectBD = selectobj.options[selectobj.selectedIndex].value;
            slotid.push(selectBD);
        }
    }
    
        $("applybtn").disabled = true;
	$("printBtn").disabled = true;
    
    selectobj.disabled = true;//              
    var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PDHPATHATTRIB + "&nmUser=" + obj["nmUser"];
    var inputData = createQueryXML(obj["neid"], slotid, window.tableconf[0]);
    setButtonState(true);
    
    loadXMLdoc(urlreq, "POST", true, handleQueryPDHInterface, null, "inputdata=" + inputData);
}

function handleQueryPDHInterface(doc)
{
    $("querybtn").disabled = false;
    $("applybtn").disabled = false;
    $("printBtn").disabled = false
    
    var data = EncapsulateData(doc);
    
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        processData(data);
        
        createGenCfgTableBody(st, tableconfObj, data, true);
        addCellEvent();
    }
    
    showErrorPage(data, "query");
    parent.document.getElementById("selectObj").disabled = false;
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetRequestXML(neid, st, tc)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null;
    var param = null;
    var rowData = null;
    var colid = null;
    var key = null;
    var colkeyarray = null;
    var cellModifyFlag = false;
    interruptFlag = false;
    modifyIpFlag = false;
    
    var rowArry = new Array();
    
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        rowData = st.getRow();
        row = new tagElement("row-params");
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        
        for (var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++) 
        {
            colid = tc.getColId(colindex);
            cellModifyFlag = st.getCellModify(rowindex, colid);
            colkeyarray = tc.getColKeyArray(colindex);
            for (var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++) 
            {
                key = colkeyarray[keyindex].name;
                if ("portname" == key) 
                {
                    param = new tagElement("param");
                    param.setAttribute("name", "port");
                    var portName = st.getCellStoreValue(rowindex, colid, key);
                    var portid = portName.substring(0, portName.indexOf("("));
                    param.setAttribute("value", portid);
                    param.setAttribute("modifyFlag", cellModifyFlag);
                    row.appendChild(param);
                }
                if ("PTNIF_PORT_ATTR_IPPARA" == key || "PTNIF_PORT_ATTR_IPPARAT" == key) 
                {
                    param = new tagElement("param");
                    param.setAttribute("name", key);
                    var ip = st.getCellStoreValue(rowindex, colid, key);
                    if (!ip || ip == "-1") 
					{
						ip = "255.255.255.255";
					}
                        if (cellModifyFlag) 
                        {
                            modifyIpFlag = true;
                        }
                        var ipValue = parseInt("0x" + convertIpaddrToHexcode(ip));
                        param.setAttribute("value", ipValue);
                        param.setAttribute("modifyFlag", cellModifyFlag);
                        row.appendChild(param);
                        continue;
                }
                if ("PTNIF_PORT_ATTR_IPPARABORD" == key) 
                {
                    param = new tagElement("param");
                    param.setAttribute("name", key);
                    var paramValue = st.getCellStoreValue(rowindex, colid, key);
                    if (!paramValue) 
                    {
                        continue;
                    }
                    
                    paramValue = "" + paramValue;
                    if (paramValue != "-1") 
                    {
                        if (cellModifyFlag) 
                        {
                            modifyIpFlag = true;
                        }
                        
                        if (paramValue.indexOf("-") != -1) 
                        {
                            paramValue = paramValue.substring(0, paramValue.indexOf("-"));
                        }
                        
                        param.setAttribute("value", paramValue);
                        param.setAttribute("modifyFlag", cellModifyFlag);
                        row.appendChild(param);
                        continue;
                    }
                }
                if ("PTNIF_PORT_ATTR_IPPARAPORT" == key) 
                {
                    param = new tagElement("param");
                    param.setAttribute("name", key);
                    var paramValue = st.getCellStoreValue(rowindex, colid, key);
                    if (!paramValue) 
                    {
                        continue;
                    }
                    
                    paramValue = "" + paramValue;
                    if (paramValue != "-1") 
                    {
                        if (cellModifyFlag) 
                        {
                            modifyIpFlag = true;
                        }
                        
                        if (paramValue.indexOf("#") != -1) 
                        {
                            var paramValueArr = paramValue.split("#");
                            paramValue = paramValueArr[paramValueArr.length - 1];
                        }
                        
                        param.setAttribute("value", paramValue);
                        param.setAttribute("modifyFlag", cellModifyFlag);
                        row.appendChild(param);
                        continue;
                    }
                }
                if ("PDHPATH_ATTR_RETIMEMODE" == key) 
                {
                	continue;
                }
                var values = st.getCellStoreValue(rowindex, colid, key);
                if ("PDHPATH_ATTR_RETIMEMODE_EX2" == key) 
                {
                	var retimemode = st.getCellStoreValue(rowindex,"PDHPATH_ATTR_RETIMEMODE","PDHPATH_ATTR_RETIMEMODE");
                	if(typeof(retimemode) != "undefined" && retimemode != null && retimemode != "")
                	{
                		key = "PDHPATH_ATTR_RETIMEMODE";
                	}
                }
                
                param = new tagElement("param");
                param.setAttribute("name", key);
                param.setAttribute("value", values);
                param.setAttribute("modifyFlag", cellModifyFlag);
                row.appendChild(param);
            }
        }
        bussiness.appendChild(row);
    }
    if (0 == bussiness.childNodes.length) 
    {
        alert(RESOURCE["osinochange"]);
        return null;
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function setPDHInterface()
{
    var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PDHPATHATTRIB + "&nmUser=" + obj["nmUser"];
    var inputData = createSetRequestXML(neid, st, tableconfObj);
    
    if (interruptFlag) 
    {
        if (!confirm(RESOURCE["confirmSet"])) 
        {
            return;
        }
    }
    if (modifyIpFlag) 
    {
        if (!confirm(RESOURCE["modifyIPTips"])) 
        {
            return;
        }
    }
    if (null != inputData) 
    {
        setButtonState(true);
        loadXMLdoc(urlreq, "POST", true, handleSetPDHInterface, null, "inputdata=" + inputData);
    }
}

function handleSetPDHInterface(doc)
{
    var data = EncapsulateData(doc);
    
    $("querybtn").disabled = false;
    
    if (0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = false;
    }
    
    refreshTableState(st, tableconfObj, data);
    
    showErrorPage(data, "set");
    
    if (0 != data.getSErrorCode()) 
    {
        return;
    }
    
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    var ipAdrrColid = "PTNIF_PORT_ATTR_IPPARA";
    var ipRatColid = "PTNIF_PORT_ATTR_IPPARAT";
    var ipParaBoardColid = "PTNIF_PORT_ATTR_IPPARABORD";
    var ipParaPortColid = "PTNIF_PORT_ATTR_IPPARAPORT";
    var portNameColid = "PTNIF_PORT_ATTR_PORTNAME_PDH";
    var borrowedPortsColid = "borrowedports";
    for (var i = data.getDataRowLength() - 1; i >= 0; i--) 
    {
	if(null != data.getDataRowParam(i, "srvmode"))
	{
		var srvmode = data.getDataRowParam(i, "srvmode");
		if(srvmode != CES_MODE)
		{
			data.removeDataRowAt(i);
			continue;
		}
	}
        if (null != data.getDataRowParam(i, portNameColid)) 
        {
            var portName = data.getDataRowParam(i, portNameColid);
            var port = data.getDataRowParam(i, "port");
            data.rows[i]["portname"].value = convertPortName(port, portName);
        }
        if (null != data.getDataRowParam(i, ipAdrrColid)) 
        {
            var ipAddrValue = data.getDataRowParam(i, ipAdrrColid);
            var ipRatValue = data.getDataRowParam(i, ipRatColid);
            if (ipAddrValue == INVALID_IP) 
            {
                data.rows[i][ipAdrrColid].value = null;
                data.rows[i][ipRatColid].value = null;
            }
            else 
            {
                data.rows[i][ipAdrrColid].value = convertNumToIpaddr(ipAddrValue);
                data.rows[i][ipRatColid].value = convertNumToIpaddr(ipRatValue);
            }
        }
        
        if (null != data.getDataRowParam(i, ipParaPortColid)) 
        {
            var ipParaBoardValue = data.getDataRowParam(i, ipParaBoardColid);
            var ipParaPortValue = data.getDataRowParam(i, ipParaPortColid);
            if (parseInt(ipParaPortValue) >= 0x1000 && parseInt(ipParaPortValue) <= 0x17FF) 
            {
                data.rows[i][ipParaBoardColid].value = "ML-PPP";
            }
            else if (parseInt(ipParaPortValue) >= 0x2800 && parseInt(ipParaPortValue) <= 0x2FFF) 
            {
                data.rows[i][ipParaBoardColid].value = "Virtual Ethernet";
            }
            else if (ipParaPortValue == INVALID_SLOTID) 
            {
                data.rows[i][ipParaBoardColid].value = null;
                data.rows[i][ipParaPortColid].value = null;
            }
            else 
            {
                var boardName = data.getDataRowParam(i, "borrowedBDName");
                if (boardName != null) 
                {
                    data.rows[i][ipParaBoardColid].value = boardName;
                }
            }
        }
        
        if (null != data.getDataRowParam(i, borrowedPortsColid)) 
        {
            borrowedPorts = [];
            var borrowedPortsOptions = data.getDataRowOptions(i, borrowedPortsColid);
            for (var j = 0; j < borrowedPortsOptions.length; j++) 
            {
                borrowedPorts[borrowedPorts.length] = borrowedPortsOptions[j];
            }
            
            data.rows.splice(i, 1);//               
        }
    }
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCell(i, "PTNIF_PORT_ATTR_PORTNAME_PDH");
        if (null != cell) 
        {
            cell.element.editElement.element.maxLength = PORTNAME_MAX_LENGTH;
        }
        
        cell = st.getCell(i, "PTNIF_ETHPORT_ATTR_MTU");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_MAXPKTLEN, MAX_MAXPKTLEN);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_MODE");
        if (null != cell) 
        {
            portModeCellEvent(cell);
            var encapTypeColid = "PTNIF_PORT_ATTR_ENCAPTYPE";//    
            var mtuColid = "PTNIF_ETHPORT_ATTR_MTU";//       
            var encapTypeCell = st.getCell(i, encapTypeColid);
            var mtuCell = st.getCell(i, mtuColid);
            var portMode = st.getCellStoreValue(i, "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE");
            if (portMode == 1 || portMode == 2) 
            {
                st.getCell(i, encapTypeColid).element.style.backgroundColor = "";
                st.setCellIsEdit(st.getCell(i, encapTypeColid), 0);
                st.getCell(i, encapTypeColid).element.ondblclick = null;
                
                if (portMode == 1) 
                {
                    setCellEdit(encapTypeCell, encapTypeColid, "0", "NULL", DISABLED);
                }
            }
            else if (portMode == 3)
            {
            	st.setCellIsEdit(st.getCell(i, encapTypeColid), 1);

            }
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_TEMETRIC");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_TE, MAX_TE);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_ADMINGROUP");
        if (null != cell) 
        {
            textCheck(cell.element.editElement.element, MIN_TE, MAX_TE);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_ENCAPTYPE");
        if (null != cell && cell.element.isEdit == 1) 
        {
            encapTypeCellEvent(cell);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARATYPE");
        if (null != cell) 
        {
            ipFRMCellEvent(cell, i);
        }
        cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARA");
        if (null != cell) 
        {
            validateIp(cell.element, true);
        }
        cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARAT");
        if (null != cell) 
        {
            validateIp(cell.element, true);
        }
        cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARABORD");
        if (null != cell) 
        {
            cell.element["onchange"] = function()
            {
                borrowBDChanged(this);
            }
        }
        cell = st.getCellEdit(i, "PTNIF_E1PORT_ATTR_E1FRM");
        if (null != cell) 
        {
            cell.element["onchange"] = function()
            {
                e1FrmChanged(this);
            }
        }
        

        cell = st.getCell(i, "PTNIF_PORT_ATTR_MPLSEN");
        if (null != cell && isNeedDisable ) 
        {
						st.setCellIsEdit(cell,false);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARATYPE");
        if (null != cell && isNeedDisable ) 
        {
						st.setCellIsEdit(cell,false);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARA");
        if (null != cell && isNeedDisable ) 
        {
						st.setCellIsEdit(cell,false);
        }
        cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAT");
        if (null != cell && isNeedDisable ) 
        {
						st.setCellIsEdit(cell,false);
        }
    }
}

/**
 *          
 * @param cell    
 * @return  
 */
function portModeCellEvent(cell)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        tabCellEditHandler(this);
    }
}

function encapTypeCellEvent(cell)
{
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        encapTypeEditHandler(this);
    }
}

/**
 * IP            
 * @param {Object} cell
 */
function ipFRMCellEvent(cell, rowindex)
{
    var borrowedBD = st.getCellStoreValue(rowindex, "PTNIF_PORT_ATTR_IPPARABORD", "PTNIF_PORT_ATTR_IPPARABORD");
    var borrowedPortNo = st.getCellStoreValue(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT", "PTNIF_PORT_ATTR_IPPARAPORT");
    var boardElem = st.getCellEdit(rowindex, "PTNIF_PORT_ATTR_IPPARABORD");
    boardElem.element.options.length = 0;
    var portElem = st.getCellEdit(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT");
    portElem.element.options.length = 0;
    var tmp = new Array();
    for (var j = 0, n = borrowedPorts.length; j < n; j++) 
    {
        var arr = borrowedPorts[j].split("#");
        var port = borrowedPorts[j].substring(0, borrowedPorts[j].lastIndexOf("#"));
        var portNo = arr[arr.length - 1];//   
        var tmpArr = port.split("-");
        var bd = tmpArr[0] + "-" + tmpArr[1];
        var portName = port;
        if (tmpArr[0] == INVALID_SLOT_ID) //             
        {
            if (parseInt(portNo) >= 0x1000 && parseInt(portNo) <= 0x17FF) 
            {
                bd = "ML-PPP";
            }
            else if (parseInt(portNo) >= 0x2800 && parseInt(portNo) <= 0x2FFF) 
            {
                bd = "Virtual Ethernet";
            }
            portName = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
        }
        
        if (borrowedBD == bd && portNo == borrowedPortNo) 
        {
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = portName;
            var boardCell = st.getCell(rowindex, "PTNIF_PORT_ATTR_IPPARABORD");
            st.setCellValue(boardCell, "PTNIF_PORT_ATTR_IPPARABORD", tmpArr[0]);
        }
        
        if (!tmp.contains(bd)) 
        {
            tmp[tmp.length] = bd;
            boardElem.addOption(bd, port + "-" + portNo);
        }
    }
    
    var atom = cell.element.editElement;
    atom.element["onchange"] = function()
    {
        ipFrmEditHandler(this);
    }
}

/**
 *             
 * @param  
 * @return  
 */
function tabCellEditHandler(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
    
    var mtuColid = "PTNIF_ETHPORT_ATTR_MTU";//       
    var encapTypeColid = "PTNIF_PORT_ATTR_ENCAPTYPE";//    
    var mtuCell = st.getCell(rowindex, mtuColid);
    var encapTypeCell = st.getCell(rowindex, encapTypeColid);
    if (value == 1 || value == 2) 
    {
        if (value == 1) 
        {
            setCellEdit(encapTypeCell, encapTypeColid, "0", "NULL", DISABLED);
        }
        else//           ATM 	
         {
            setCellEdit(encapTypeCell, encapTypeColid, "4", "ATM", DISABLED);
        }
        setCellEdit(mtuCell, mtuColid, "-1", "-", DISABLED);
    }
    else //        
     {
        setCellEdit(encapTypeCell, encapTypeColid, "5", "PPP", ENABLED);
        setCellEdit(mtuCell, mtuColid, "1620", "1620", ENABLED);
		
    }
}

/**
 *             
 * @param  
 * @return  
 */
function encapTypeEditHandler(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
    
    var mtuColid = "PTNIF_ETHPORT_ATTR_MTU";//       
    var mtuCell = st.getCell(rowindex, mtuColid);
    if (value != 5) 
    {
        setCellEdit(mtuCell, mtuColid, -1, "-", DISABLED);
    }
    else //        
     {
        setCellEdit(mtuCell, mtuColid, "1620", "1620", ENABLED);
    }
}

/**
 *             
 * @param  
 * @return  
 */
function ipFrmEditHandler(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var colid = atom.parentNode.colid;
    var value = atom.value;
    
    var ipAddrColid = "PTNIF_PORT_ATTR_IPPARA";//IP  
    var ipRatColid = "PTNIF_PORT_ATTR_IPPARAT";//IP  
    var ipBDColid = "PTNIF_PORT_ATTR_IPPARABORD";//  IP       
    var ipPortColid = "PTNIF_PORT_ATTR_IPPARAPORT";//  IP       
    var ipAddrCell = st.getCell(rowindex, ipAddrColid);
    var ipRatCell = st.getCell(rowindex, ipRatColid);
    var ipBDCell = st.getCell(rowindex, ipBDColid);
    var ipPortCell = st.getCell(rowindex, ipPortColid);
    if (value == 1 || value == 2) 
    {
        setCellEdit(ipAddrCell, ipAddrColid, "255.255.255.255", "-", DISABLED);
        setCellEdit(ipRatCell, ipRatColid, "255.255.255.255", "-", DISABLED);
        setCellEdit(ipBDCell, ipBDColid, INVALID_SLOTID, "-", DISABLED);
        setCellEdit(ipPortCell, ipPortColid, INVALID_SLOTID, "-", DISABLED);
    }
    else if (value == 4)//    
    {
        setCellEdit(ipAddrCell, ipAddrColid, "0.0.0.0", "0.0.0.0", ENABLED);
        setCellEdit(ipRatCell, ipRatColid, "255.255.255.252", "255.255.255.252", ENABLED);
        setCellEdit(ipBDCell, ipBDColid, INVALID_SLOTID, "-", DISABLED);
        setCellEdit(ipPortCell, ipPortColid, INVALID_SLOTID, "-", DISABLED);
    }
    else //    IP  
     {
        setCellEdit(ipAddrCell, ipAddrColid, "255.255.255.255", "-", DISABLED);
        setCellEdit(ipRatCell, ipRatColid, "255.255.255.255", "-", DISABLED);
        st.setCellIsEdit(ipBDCell, 1);
        st.setCellIsEdit(ipPortCell, 1);
        
        if (borrowedPorts.length > 0) 
        {
            var ipPort = borrowedPorts[0].split("#");
            var portNo = ipPort[ipPort.length - 1];//           
            var port = borrowedPorts[0].substring(0, borrowedPorts[0].lastIndexOf("#"));
            var arr = port.split("-");
            var bd = arr[0] + "-" + arr[1];
            st.setCellValue(st.getCell(rowindex, "PTNIF_PORT_ATTR_IPPARABORD"), "PTNIF_PORT_ATTR_IPPARABORD", bd);
            st.setCellValue(st.getCell(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT"), "PTNIF_PORT_ATTR_IPPARAPORT", borrowedPorts[0]);
            
            if (arr[0] == INVALID_SLOT_ID) //    
            {
                if (parseInt(portNo) >= 0x1000 && parseInt(portNo) <= 0x17FF) 
                {
                    bd = "ML-PPP";
                }
                else if (parseInt(portNo) >= 0x2800 && parseInt(portNo) <= 0x2FFF) 
                {
                    bd = "Virtual Ethernet";
                }
                port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
            }
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = bd;
            st.setCellValue(ipBDCell, ipBDColid, borrowedPorts[0]);
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = port;
            st.setCellValue(ipPortCell, ipPortColid, portNo);
        }
        else 
        {
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "";
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "";
        }
        ipBDCell.element.modify = true;
        ipBDCell.element.ondblclick = cellondbclick;
        ipBDCell.element.style.backgroundColor = "#d0f946";//        
        ipPortCell.element.modify = true;
        ipPortCell.element.ondblclick = cellondbclick;
        ipPortCell.element.style.backgroundColor = "#d0f946";//        
    }
}

/**
 *              
 * @param {Object} atom
 * @param {Object} rowindex
 */
function borrowBDChanged(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var portElem = st.getCellEdit(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT");
    var board = atom.options[atom.options.selectedIndex].text;
    for (var j = 0, n = borrowedPorts.length; j < n; j++) 
    {
        var lastIndex = borrowedPorts[j].lastIndexOf("#");
        var portNo = borrowedPorts[j].substring(lastIndex + 1, borrowedPorts[j].length);
        var port = borrowedPorts[j].substring(0, lastIndex);
        var arr = port.split("-");
        var bd = arr[0] + "-" + arr[1];
        if (parseInt(portNo) >= 0x1000 && parseInt(portNo) <= 0x17FF) 
        {
            bd = "ML-PPP";
            port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
        }
        else if (parseInt(portNo) >= 0x2800 && parseInt(portNo) <= 0x2FFF) 
        {
            bd = "Virtual Ethernet";
            port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
        }
        
        if (board == bd) 
        {
            st.setCellValue(st.getCell(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT"), "PTNIF_PORT_ATTR_IPPARAPORT", borrowedPorts[j]);
            st.getCellShow(rowindex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = port;
            break;
        }
    }
}

function e1FrmChanged(atom)
{
    var rowindex = atom.parentNode.parentNode.rowIndex;
    var e1FrmModeCell = st.getCell(rowindex, "PTNIF_E1PORT_ATTR_E1FRMMODE");//      
    var e1FrmMode = atom.value;//   
    if (e1FrmMode == 0)//               - 
    {
        setCellEdit(e1FrmModeCell, "PTNIF_E1PORT_ATTR_E1FRMMODE", "255", "-", false);
    }
    else 
    {
        setCellEdit(e1FrmModeCell, "PTNIF_E1PORT_ATTR_E1FRMMODE", "31", "31", true);
    }
}


function setButtonState(diabledFlag)
{
    $("querybtn").disabled = diabledFlag;
    $("applybtn").disabled = diabledFlag;
}

function showErrorPage(data, flag)
{
    if (data.getSErrorCode() == BOARD_NOT_EXIST && !isBoardFunc())//                      
    {
        for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
        {
            st.deleteRow(rowindex);
        }
        st.adjustDataRows();
        return;
    }
    var errArr = [];
    var attrID = "";
    var portName = "";
    var errObjArr = [];
    var errorObj = null;
    for (var i = data.getBErrLength() - 1; i >= 0; i--) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        attrID = data.getError().getRowKey(i, "attrId");
        portName = portToPortName(data.getError().getRowKey(i, "port"));
        errorObj["attrId"] = getAttrName(tableconfObj, attrID);
        errorObj["port"] = portName;
        
        errorObj["operationObj"] = errorObj["slotid"] + "-" + errorObj["boardname"] + "-" + errorObj["portname"] + "-" + errorObj["attrId"];
        
        if (errorObj["attrId"] == attrID || errObjArr.contains(errorObj["operationObj"])) 
        {
            data.getError().rowErrors.removeAt(i);
            continue;
        }
        errObjArr.push(errorObj["operationObj"]);
    }
    errArr[0] = "operationObj"
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function isBoardFunc()
{
    return obj["funnodeid"] == PDH_INTERFACE_FUNID;
}

/**
 *      
 * @param {Object} cell      
 * @param {Object} colId  ID
 * @param {Object} defaultValue       
 * @param {Object} defaultShow       
 */
function setCellEdit(cell, colId, defaultValue, defaultShow, isEdit)
{
    st.setCellIsEdit(cell, isEdit);
    if (isEdit == 0) 
    {
        cell.element.modify = false;
        cell.element.ondblclick = null;
        cell.element.style.backgroundColor = "";//        
    }
    else 
    {
        cell.element.modify = true;
        cell.element.ondblclick = cellondbclick;
        cell.element.style.backgroundColor = "#d0f946";//        
    }
    
    st.setCellValue(cell, colId, defaultValue);
    st.setAtomValue(cell.element.showElement, defaultShow);
}

function convertPortName(port, portName)
{
    if (!portName || portName == "") 
    {
        portName = "PORT-" + port;
    }
    return port + "(" + portName + ")";
}

function print()
{
    if(0 == st.getDataRowLength())
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    var par = window.parent; 
    var curTabs = par.tabs[par.tabs.length - 1];
    openPrintPage('../../../../../page/', curTabs.getTab(curTabs.getSelectedTabID()).head.innerText,'st');
}

function save()
{
    if(st.getDataRowLength()<=0)
    {
    	alert(RESOURCE["nodata"]);
    	return;
    }
    
    var par = window.parent; 
    var curTabs = par.tabs[par.tabs.length - 1];
    openSaveAsPage("../../../../../page/", curTabs.getTab(curTabs.getSelectedTabID()).head.innerText, "st");
}
function comparePortNumA(str1, str2)
{
	var str1Array = str1.split("-");
	var str2Array = str2.split("-");
	
	var str1PortCompound = str1Array[2];
	var str2PortCompound = str2Array[2];
	
	var port1 = parseInt( str1PortCompound.split("(")[0] );
	var port2 = parseInt( str2PortCompound.split("(")[0] );
	
	var result =  port1 >= port2 ? -1 : 1;
	return result;
}
