var OPERATE_SUCCESS = 0;

var OPERATE_PART_SUCCESS = 1;

var OPERATE_FAIL = 2;



var ZERO=0;
var ONE_BYTE_VALUE=0xFF;
var TWO_BYTE_VALUE=0xFFFF;



var PORT_ID_UNVALID = 65535;

var VCTRUNK_FLAG = 32768;

var DES_MAC_ADDR_DEFALT_VALUE = "00-00-00-00-00-00";

var IP_ADDR_DEFALT_VALUE = "0.0.0.0";

var WILDCARD_DEFAULT_VALUE = "0";
/**********************************
 *       convertMsg   
 *                                
***********************************/
function convertMsg(resobj,	cvtobj,	cvtvalue)
{
	if("function" == typeof cvtobj)
	{
	    return cvtobj(cvtvalue);
	}
	
	if(cvtvalue == "-")
	{
      return cvtvalue;
	}
	return resobj[cvtobj[cvtvalue]];
}

/**********************************
 *Mac   convert                 
***********************************/
function convertMacAddr(macAddrStr)
{
	var showMACStr = "";
    for(var i = 0, len = 12; i < len;)
    {
        if(showMACStr != "")
        {
            showMACStr += "-";
        }
        showMACStr += macAddrStr.substring(i, i + 2);
        i += 2; 
    }
    return showMACStr;
}

/**********************************
 * Mac                        
***********************************/
function neMacAddr(macAddrStr)
{
	var macStr = "";
    for(var i = 0, len = 17; i < len; i += 3)
    {
        macStr += macAddrStr.substring(i, i + 2);
    }
    return macStr;
}

/**
 *     ID       
 */
function convertPort(portid)
{
    if (null == portid)
    {
        return;
    }
    var portName = null;
    if (portid > VCTRUNK_FLAG)
    {
        if (portid == PORT_ID_UNVALID)
        {
            portName = "-";
        }
        else
        {
            portName = "VCTRUNK" + (portid - VCTRUNK_FLAG);
        }
    }
    else
    {
       portName = "PORT" + portid;
    }
    return portName;
}

/*   0xFFFFFFFF      ip        127.0.0.1    ip  
*/
function ipToString(ip)
{
     var ip1 = (ip >> 24) & 255;
     var ip2 = (ip >> 16) & 255;
     var ip3 = (ip >> 8) & 255;
     var ip4 = ip & 255;
     return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
}

/*IP     IP      
*/
function convertIPStrToLong(ipstr)
{
     if (null == ipstr)
     {
         return 0;
     }
     var result = 0;
     var sum = 0;
     var TCount = 0;
     var frontIsPoint = true;
     var firstConvert = 16777216;
     var secondConvert = 65536;
     var thirdConvert = 256;
     var firstMax = 255;
     var secondMax = 255;
     var thirdMax = 255;
     var fourthMax = 255;
     
     var T = new Array(firstConvert, secondConvert, thirdConvert);
     var nMax = new Array(firstMax, secondMax, thirdMax, fourthMax);
     for (i = 0; i < ipstr.length; i++)
     {
        var ipchar = ipstr.charAt(i);
        if ((ipchar>= '0') && (ipchar <= '9'))
         {
             sum = (sum * 10) + (ipchar - '0');
             frontIsPoint = false;
         }
        else if (ipchar == '.')
        {
            if (frontIsPoint)
            {
                return 0;
            }
            frontIsPoint = true;
            if (TCount >= 3)
            {
                 return 0;
             }
             if (sum > nMax[TCount])
             {
                  return 0;
             }
             result = result + (sum * T[TCount++]);
             sum = 0;
         }
         else if (ipchar != ' ') //    IP    
         {
             return 0; //   129.  9.  0.  1        
         }
     }
     if (frontIsPoint)
     {
          return 0;
     }
     if (TCount != 3)
     {
          return 0;
     }
     if (sum > nMax[TCount])
     {
          return 0;
     }
     return (result + sum);
}

var INVALID_VLAN_ID = 0xFFFF;

var INVALID_IP = 0;//  IP  
var INVALID_IP_255 = 4294967295;// 255  
var INVALID_VALUE = "-";//      
var INVALID_NUMBER = 4294967295;//     


function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function onblurHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = ZERO;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || numobj.value < ZERO) 
    {
        alert(RESOURCE["wrong65535"]);
        numobj.value = ZERO;
        return;
    }
}

function keyupHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > TWO_BYTE_VALUE) 
    {
        alert(RESOURCE["wrong65535"]);
        numobj.value = TWO_BYTE_VALUE;
        return;
    }
}

function keypressHandler(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong65535"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > TWO_BYTE_VALUE) 
    {
        alert(RESOURCE["wrong65535"]);
        numobj.value = TWO_BYTE_VALUE;
        return false;
    }
}

function keyupHandler1(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > ONE_BYTE_VALUE) 
    {
        alert(RESOURCE["wrong255"]);
        numobj.value = ONE_BYTE_VALUE;
        return;
    }
}

function keypressHandler1(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong255"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > ONE_BYTE_VALUE) 
    {
        alert(RESOURCE["wrong255"]);
        numobj.value = ONE_BYTE_VALUE;
        return false;
    }
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP || param == INVALID_IP_255) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}


/**
 *     
 */
function checkText1(obj, min, max, decimalCount)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
	}

	obj.onblur = function()
	{ 
		if(obj.value == "")
	       {
		    return;
	        }
		blurValidate(obj, min, max, decimalCount);
		if((typeof obj.doAfterBlur)=="function")
		{
			obj.doAfterBlur();
		}
	}

	obj.onkeypress = function()
	{	
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount, null, evt);
	}
}

/*******************************************************************************
 * MAC           
       
 ******************************************************************************/
function checkMACFormat1(obj, castFlag)
{
	obj.style.imeMode = "disabled";
	obj.maxLength = "17";


	obj.onkeypress = function()
	{
		return validateMACAddr(obj);
	}
	
	obj.onblur = function()
    {
		if(obj.value == "")
	    {
		    return;//       
	    }
		if(obj.value == DES_MAC_ADDR_DEFALT_VALUE)
	    {
		    return;//       0 MAC
	    }
		blurFormat(obj, castFlag);
    }
}
/*******************************************************************************
 * MAC           
       
 ******************************************************************************/
function checkMACFormat2(obj, castFlag)
{
	obj.style.imeMode = "disabled";
	obj.maxLength = "17";


	obj.onkeypress = function()
	{
		return validateMACAddr(obj);
	}
	
	obj.onblur = function()
    {
		if(obj.value == DES_MAC_ADDR_DEFALT_VALUE)
	    {
		    return;//         
	    }
		blurFormat(obj, castFlag);
    }
}
    
function validateIp1(obj)
{	
	var stCall = false;
	if (arguments.length > 1)
	{
			stCall = arguments[1];
	}
	
	var oedit = obj
	oedit.maxLength = maxbyte;
	oedit.style.imeMode = "disabled"; //     

	oedit.onpaste = function()
	{
	}

	oedit.ondrop = function()
	{
		return false;
	}

	oedit.onkeypress = function()
	{
	  var event=EventUtil.getEvent();
	  var code = (event.keyCode!=0?event.keyCode:event.charCode);
	  
	  if(code ==8 || (event.ctrlKey && code == 118))
	  {
	    return true;
	  }
		
		var objIp       = oedit;
		var existstring = objIp.value;                 
		var curInput    = String.fromCharCode(code);
		if(event.keyCode == 13)
		{
			objIp.onblur();
		}
		
		
		if (((code < 48 || code > 57) && code != splitcharcode)
			|| (code == splitcharcode && existstring.charCodeAt(existstring.length-1) == splitcharcode )
			|| (code == splitcharcode && existstring.length == 0))
		{
			return false;
		}
		var tagPosition = digitalTag_getPos(objIp);
	
		var str1 = existstring.substring(0, tagPosition);
		var str2 = existstring.substring(tagPosition, existstring.length);		
		existstring = str1 + curInput + str2;
			
		var aryIp = existstring.split(splitchar);

		if (aryIp.length > 4)
		{
			return false;	
		}
			
		/* a.b.c.d              .  */
		var dot1 = existstring.indexOf(splitchar);
		var dot2 = existstring.indexOf(splitchar,dot1+1);
		var dot3 = existstring.indexOf(splitchar,dot2+1);
		var dot4 = existstring.indexOf(splitchar,dot3+1);			
				
		if (dot1 < 0)
		{
			if (existstring.length == 3)
			{
				objIp.value = existstring + splitchar;
				return false;
			}
			else if (existstring.length > 3 &&(selectionLen(objIp)==0) )
			{
				return false;
			}
		}
		else if (dot2 < 0)
		{
			tagPosition = digitalTag_getPos(objIp);			
			if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3
			    && (selectionLen(objIp)==0))
			{
				return false;
			}
			
			if (existstring.length == dot1+4)
			{
				objIp.value = existstring + splitchar;
				return false;
			}
			else if (existstring.length > dot1+4 && (selectionLen(objIp)==0))
			{				
				return false;
			}			
		}
		else if (dot3 < 0)
		{
			tagPosition = digitalTag_getPos(objIp);
			if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3
			    && (selectionLen(objIp)==0))
			{				
				return false;
			}
			else if (tagPosition < dot2 && existstring.substring(dot1+1, dot2).length > 3
			    && (selectionLen(objIp)==0))
			{				
				return false;
			}
			
			if (existstring.length == dot2+4)
			{
				objIp.value = existstring + splitchar;				
				return false;
			}
			else if (existstring.length > dot2+4 && (selectionLen(objIp)==0))
			{				
				return false;
			}
		}
		else if (dot4 < 0)
		{
			tagPosition = digitalTag_getPos(objIp);
			if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3
			    && (selectionLen(objIp)==0))
			{				
				return false;
			}
			else if (tagPosition < dot2 && existstring.substring(dot1+1, dot2).length > 3
			    && (selectionLen(objIp)==0))
			{
				return false;
			}
			else if (tagPosition < dot3 && existstring.substring(dot2+1, dot3).length > 3
				  && (selectionLen(objIp)==0))
			{				
				return false;
			}
				
			if (existstring.length > maxbyte)
			{
				if ((selectionLen(objIp)==0))
				{					
					return;
				}
			}
			else if (existstring.length == dot3+5)
			{
				tagPosition = digitalTag_getPos(objIp);
				if (tagPosition > dot3 && (selectionLen(objIp)==0))
				{					
				  return;
				}
			}			
		}	
	}
	
  /**
   *   IP                  255       255
   */
	oedit.onkeyup = function()
	{
		var event=EventUtil.getEvent();
		var objIp = event.srcElement;
		var aryIp = objIp.value.split(splitchar);
		var errFlg = false;
		var i = 0;
		for (i = 0; i < aryIp.length; ++ i)
		{
			if (aryIp[i] != "")
			{
				aryIp[i] = parseInt(aryIp[i], 10);
			}
			if (aryIp[i] > maxvalue)
			{
				aryIp[i] = maxvalue;
				errFlg = true;
			}
		}
		if (errFlg)
		{
			objIp.value = aryIp[0];
			for (i = 1; i < aryIp.length; ++ i)
			{
				objIp.value += (splitchar + aryIp[i]);
			}
		}
	}

	oedit.onblur = function()
	{
		var event=EventUtil.getEvent();
		
		var objIp = event.srcElement;
		if (objIp.value == "")
		{				
				if (stCall)
				{
						cellonblur(objIp);
				}				
				return;
		}
		var fulladdr = formFullAddr(objIp.value);
		if(fulladdr == false)
		{
			alert(RESOURCE["format"]);
			objIp.value = "0.0.0.0";
			if (stCall)
			{
				cellonblur(objIp);
			}
			return;
		}
		else
		{
			objIp.value = fulladdr;
		}
		
		var aryIp = objIp.value.split(splitchar);
		var errFlg = false;
		var i = 0;
		for (i = 0; i < aryIp.length; ++ i)
		{
			if (aryIp[i] > maxvalue)
			{
				aryIp[i] = maxvalue
				errFlg = true;
			}
		}
		if (errFlg)
		{
			objIp.value = aryIp[0];
			for (i = 1; i < aryIp.length; ++ i)
			{
				objIp.value += (splitchar + aryIp[i]);
			}
		}
		
		if (stCall)
		{
				cellonblur(objIp);
		}
	}
}
function CTable3()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid)
    {
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index)
    {
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value)
    {
        if (this.attrArray[attrid][index]) 
        {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index)
    {
        if (this.attrArray[attrid][index]) 
        {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function()
    {
        return this.element;
    }
}

EventUtil.addEventHandler(window,"resize",resizeComponentWidth);
function resizeComponentWidth()
{
	if(ComboBoxDIVID.length > 0)
	{
		for (var i = 0, len = ComboBoxDIVID.length; i < len; i++) 
		{			
			var comboboxDiv = document.getElementById(ComboBoxDIVID[i]).parent;
			if (comboboxDiv && comboboxDiv.view.parentNode && comboboxDiv.view.parentNode.offsetWidth > 0) 
			{
			     var wdt = comboboxDiv.view.parentNode.offsetWidth - 1;					
			     var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
                 comboboxDiv.txtview.style.width = wdt;
                 comboboxDiv.selview.style.width = wdt;
                 comboboxDiv.txtview.style.top = getPosY(comboboxDiv.view.parentNode);
                 comboboxDiv.selview.style.top = getPosY(comboboxDiv.view.parentNode);
                 comboboxDiv.selview.style.clip = clip;
			 }		
		}
	}
}
ComboBox.prototype.initComboBox = function(ops, str, index, flag)
{
    this.setOptions(ops);
    this.name = str;
    this.id = str;
    this.dispval = flag;
    this.setSelectedIndex(index);

    if (this.view.parentNode && this.view.parentNode.offsetWidth > 0) 
    {
        var wdt = this.view.parentNode.offsetWidth - 1;		
        var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
        
        this.txtview.style.width = wdt;
        this.selview.style.width = wdt;
        this.txtview.style.top = getPosY(this.view.parentNode);
        this.selview.style.top = getPosY(this.view.parentNode);
        this.selview.style.clip = clip;
    }
}
function onblurHandlerWildCard(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = "00 00";
        return;
    }
}
