
window.curEditCell=null;

window.ComboBoxDIVID = [];
function ComboBox()
{
	this.view = document.createElement("DIV");
	var id = "combobox_div_" + ComboBoxDIVID.length;
	this.view.setAttribute("id",id);
	ComboBoxDIVID[ComboBoxDIVID.length] = id;
	this.view.className = "combo-outerdiv";
	this.view.parent = this;
	
	this.txtview = document.createElement("INPUT");
	this.txtview.type ="text";
	this.txtview.className = "combo-input";
	
	this.selview = document.createElement("SELECT");
	this.selview.className = "combo-select";
		
	this.view.appendChild(this.txtview);
	this.view.appendChild(this.selview);
	
	this.dispval = false;
	
	this.txtview.onkeydown = inputKeydownHandler;
	this.selview.onchange = selvalueChangeHandler;
	this.selview.onclick = clickHandler;
	
	if (isIE)
	{
		document.onmousedown = ComboBox_mouseDown;
	}
	else if (document.addEventListener) 
	{
		document.addEventListener("mousedown", ComboBox_mouseDown, true);
	}	
	
	
	
	return this.view;
}

function selvalueChangeHandler(args)
{	
	var obj;
	if(args) {
		obj = args.target;
 	} else {
		obj = this;	
	}
	if (arguments.length > 0 && arguments[0].tagName=="SELECT")
	{
		obj = arguments[0];
	}
	
	var selval = obj.value;
	
	if (!obj.parentNode.parent.dispval)
	{
		for (var i=0,len=obj.options.length; i<len; i++)
		{
			if (obj.options[i].value == selval)
			{
				selval = obj.options[i].text;
				break;
			}
		}
	}
	
	obj.parentNode.parent.txtview.value = selval;
	obj.parentNode.parent.value = selval;
}

function clickHandler(args)
{	
	if(isIE)
	{
		if(event.offsetY < 21)
		{
			return;
		}
	}
	var obj;
	if(args) {
		obj = args
 	} else {
		obj = this;	
	}
	if (arguments.length > 0 && arguments[0].tagName=="SELECT")
	{
		obj = arguments[0];
	}
	
	var selval;
	
	if (isIE)
	{
		selval = obj.value;
		if (!obj.parentNode.parent.dispval)
		{
			for (var i=0,len=obj.options.length; i<len; i++)
			{
				if (obj.options[i].value == selval)
				{
					selval = obj.options[i].text;
					break;
				}
			}
		}
		obj.parentNode.parent.txtview.value = selval;
		obj.parentNode.parent.value = selval;
	}
	else
	{
		selval = obj.target.value;
		if (!this.parentNode.parent.dispval)
		{
			for (var i=0,len=obj.options.length; i<len; i++)
			{
				if (this.options[i].value == selval)
				{
					selval = this.options[i].text;
					break;
				}
			}
		}
		this.parentNode.parent.txtview.value = selval;
		this.parentNode.parent.value = selval;
	}
}

function inputKeydownHandler(e)
{
	this.parentNode.parent.value = this.value;
	this.parentNode.parent.selview.value = this.value;
	
	var event = EventUtil.getEvent();
	var code = (event.keyCode!=0?event.keyCode:event.charCode);
  if(code == 13)
  {
	  var el = event.target ? event.target : event.srcElement;
	 
	  if (window.curEditCell)
	  {
	   	if (isIE)
    	{
	   		window.curEditCell.focus();
	   		window.curEditCell.blur();
	   	}
	   	else
	   	{
	   		window.curEditCell.parent.selview.focus();
	   		window.curEditCell.parent.selview.blur();
	   		window.curEditCell.parent.txtview.focus();
	   		window.curEditCell.parent.txtview.blur();
			window.curEditCell.onblur();
	   	}
	  }
  }
}

function inputBlurHandler()
{
	this.parentNode.parentNode.parent.selview.focus();
}


function ComboBox_mouseDown(e)
{
	if (!e)
	{
		e = window.event;
	}
  var obj,len,el,i;
  el = e.target ? e.target : e.srcElement;

  if (window.curEditCell)
  {
  	if(window.curEditCell.contains(el))
  	{
    }
    else
    {
    	if (isIE)
    	{
	   		window.curEditCell.focus();
	   		window.curEditCell.blur();
	   	}
	   	else
	   	{
	   		window.curEditCell.parent.selview.focus();
	   		window.curEditCell.parent.selview.blur();
			if(el != window.curEditCell.parent.txtview
				&& el != window.curEditCell.parent.selview
				&& el.parentNode != window.curEditCell.parent.selview)
			{
				window.curEditCell.onblur();
			}
	   	}
   	}
  }
}

ComboBox.prototype.removeAll = function()
{
	while(this.selview.options.length > 0)
	{
		this.selview.remove(0);
	}
}

ComboBox.prototype.addOption = function(name,value)
{
	this.selview.options[this.selview.options.length] = new Option(name,
				value);
}

ComboBox.prototype.getValue = function()
{
	return this.txtview.value;
}

ComboBox.prototype.setValue = function(value)
{
	this.txtview.value = value;
}

ComboBox.prototype.getLength = function()
{
	return this.selview.options.length;
}

ComboBox.prototype.getOption = function(i)
{
	return this.selview.options[i];
}

ComboBox.prototype.setOptions = function(optionsAry)
{	
	for (var i=0; i<optionsAry.length; i++)
	{
		if (isIE)
		{
			this.selview.add(optionsAry[i]);
		}
		else
		{
			this.selview.appendChild(optionsAry[i]);
		}
	}
}

ComboBox.prototype.remove = function(index)
{
	this.selview.remove(index);
}

ComboBox.prototype.setSelectedIndex = function(index)
{
	if(index == -1)
	{
		this.selview.selectedIndex = -1;
		return;
	}
	
	if (this.dispval)
	{
		this.txtview.value = this.selview.options[index].value;
	}
	else
	{
		this.txtview.value = this.selview.options[index].text;
	}
	this.selview.selectedIndex = index;
}

ComboBox.prototype.getTextElement = function()
{
	return this.txtview;
}

/**
 * @param ops   Option[]
 * @param str   component's id
 * @param index selected option's index
 * @param flag  display value/text of the selected option
 */
ComboBox.prototype.initComboBox = function(ops,str,index,flag)
{	
	this.setOptions(ops);
	this.setSelectedIndex(index);
	this.init(str,flag);
	this.adjustWidth();
}

ComboBox.prototype.init = function(strId,dispval)
{
	this.name = strId;
	this.id = strId;
	this.dispval = dispval;
}

ComboBox.prototype.adjustWidth = function()
{
	if (this.view.parentNode && this.view.parentNode.offsetWidth > 0)
	{
		var wdt = this.view.parentNode.offsetWidth-2;
		var clip = "rect(1px,"+ (wdt-1) + "px,19px," + (wdt-18) + "px)";
		this.txtview.style.width = wdt;
		this.selview.style.width = wdt;
		this.txtview.style.top = getPosY(this.view.parentNode) 
			- getPosY(this.view.parentNode.parentNode.parentNode.parentNode)+1;
		this.selview.style.top = getPosY(this.view.parentNode) 
			- getPosY(this.view.parentNode.parentNode.parentNode.parentNode)+1;
		this.selview.style.clip = clip;
		/*}
		else
		{
			var wdt = this.view.parentNode.offsetWidth-2;
		  var clip = "rect(1px,"+ (wdt-1) + "px,19px," + (wdt-18) + "px)";
		  
		  this.txtview.style.width = wdt;
		  this.selview.style.width = wdt;
		  this.txtview.style.top = getPosY(this.view.parentNode) 
		  				- getPosY(this.view.parentNode.parentNode.parentNode.parentNode)+this.view.parentNode.offsetHeight;
			this.selview.style.top = getPosY(this.view.parentNode) 
		  				- getPosY(this.view.parentNode.parentNode.parentNode.parentNode)+this.view.parentNode.offsetHeight;
			this.selview.style.clip = clip;
		}*/
	}
}


function setComboboxCompStyle()
{
	this.selview.style.width = this.view.parentNode.offsetWidth;
	this.txtview.style.width = this.view.parentNode.offsetWidth;
	
	var rightclip = this.view.parentNode.offsetWidth;
	window.status = rightclip;
	var clip = 'rect(1px,'+ rightclip-1 + 'px,19px,' + rightclip-18 + 'px)';
	this.selview.style.clip = clip;	
}
