function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (colid == "reversetunnel") 
    {
        return;
    }
    
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
        createPopupMenu(rows, evt);
        showMenu(evt);
    }
}

function createPopupMenu(rows)
{
	removejsDOMmenu();
    var pro1711Menu = true;//      
    var pro1731Menu = true;//      
    for (var i = 0; i < rows.length; i++) 
    {
    	var nodetype = st.getCellStoreValue(rows[i], "nodetype", "nodetype");//    
    	if (nodetype == "2")
    	{
    		pro1711Menu = false;
    		pro1731Menu = false;
    		break;
    	}
    }
    
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        menuSize = 200;
    }
    
    var cursorMenu1 = new jsDOMenu(menuSize);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["res1711menu"], "", doSwitchStandard, "1", pro1711Menu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["res1731menu"], "", doSwitchStandard, "2", pro1731Menu));
    setPopUpMenu(cursorMenu1); 
}

function doSwitchStandard(oamstr)
{
	removejsDOMmenu();
	
	var rows = st.getSelectedRows();
	var param = [];
    param[0] = rows;
    param[1] = oamstr;
    
    var xml = createSwitchXML(param, "1");
    
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SWITCH_MPLSTPOAM_STANDARD + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, switchCallBack, param, "inputdata=" + xml);
}

function switchCallBack(doc, param)
{
	var data = EncapsulateData(doc);
    showErrorDialog(data);
}

function createSwitchXML(param, megtype)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rows = param[0];
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        
        row.appendChild(createTagElement("megtype", megtype));
        
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("megindex", tunnelIndex));
        
        row.appendChild(createTagElement("oamstandard", param[1]));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "name");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
        var nType = parseInt(st.getCellCurrentValue(i, "nodetype", "nodetype"));
        
        cell = st.getCell(i, "enablestatus");
        st.setCellIsEdit(cell, 0);
        
        switch (nType)
        {
            case NODE_TYPE_EGRESS:
            	var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
                cell = st.getCell(i, "outport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "outlabel");
				st.setCellValue(cell, "outlabel", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "rinlabel");
				st.setCellValue(cell, "rinlabel", INVALID_LABEL_VALUE);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "nexthopaddr");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "snknode");
				st.setCellValue(cell, "snknode", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";
                
                if (direction == 0)
                {
                    cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 0);
    				st.setCellValue(cell, "bandwidth", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                    
                    cell = st.getCell(i, "bandwidthremain");
                    cell.element.showElement.element.innerHTML = "-";
                    
                    cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                	
                	cell = st.getCell(i, "vlanid");
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                
                	cell = st.getCell(i, "enablestatus");
                	st.setCellIsEdit(cell, 0);
                	cell.element.showElement.element.innerHTML = "-";
                
                	cell = st.getCell(i, "routlabel");
					st.setCellValue(cell, "routlabel", INVALID_LABEL_VALUE);
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rnexthopaddr");
					st.setCellValue(cell, "rnexthopaddr", INVALID_IP);
                    cell.element.showElement.element.innerHTML = "-";
                    
                    cell = st.getCell(i, "exp");
					st.setCellValue(cell, "exp", INVALID_VALUE_NUM);
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
				else
				{
					cell = st.getCell(i, "vlanid");
					var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                	cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 1);
                    var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                    if (bw == 0) 
                    {
                    	cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    	st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                    }
                    else
                    {
                    	st.setCellValue(cell, "bandwidth", bw);
                        cell.element.showElement.element.innerHTML = bw;  
                        st.getCellShow(i, "bandwidthremain").element.innerHTML = bw;
                    }
                    
                    if(isSupportPirEditFlag)
                    {
	                    cell = st.getCell(i, "pir");
	                    st.setCellIsEdit(cell, 1);
	                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
	                    if (pirvalue == 0) 
	                    {
	                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
	                    }
	                    else
	                    {
	                        st.setCellValue(cell, "pir", pirvalue);
	                        cell.element.showElement.element.innerHTML = pirvalue;  
	                    }
                    }
                    else
                    {
                    	cell = st.getCell(i, "pir");
                        st.setCellIsEdit(cell, 0);
          			    st.setCellValue(cell, "pir", INVALID_VALUE);
                        cell.element.showElement.element.innerHTML = "-";
                    }
				}
			
		if(!isAfterRTN900R5C01())
		{		
                    if (neversion >= "5.76.03.10" || winobj.neType == "114")
                    {
                        cell = st.getCell(i, "lspmode");
                        cell.element.showElement.element.innerHTML = "-";
                        st.setCellIsEdit(cell, 0);
                    }
                }
                
                refactorPortName(i, 'in');
                break;
            case NODE_TYPE_TRANSIT:
            	var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
            	var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                
                if(isSupportPirEditFlag)
                {
                    cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 1);
                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
                    if (pirvalue == 0) 
                    {
                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    }
                }
                else
                {
                	cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "enablestatus");
                st.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "lspmode");
		st.setCellValue(cell, "lspmode", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                
                cell = st.getCell(i, "exp");
                st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, "exp", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                if (direction == 0)
                {
                	cell = st.getCell(i, "routlabel");
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rinlabel");
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rnexthopaddr");
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "vlanid");
                if (neversion < "5.76.02.10" && winobj.neType != "114")  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
	            	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                }
                
                refactorPortName(i, 'in');
                refactorPortName(i, 'out');
                break;
            case NODE_TYPE_INGRESS:
                var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                
                if(isSupportPirEditFlag)
                {
                    cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 1);
                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
                    if (pirvalue == 0) 
                    {
                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    }
                }
                else
                {
                	cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "inport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "inlabel");
				st.setCellValue(cell, "inlabel", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "routlabel");
				st.setCellValue(cell, "routlabel", INVALID_LABEL_VALUE);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "rnexthopaddr");
				st.setCellValue(cell, "rnexthopaddr", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";

                cell = st.getCell(i, "srcnode");
				st.setCellValue(cell, "srcnode", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";
                if (direction == 0) //  Tunnel
                {
                	cell = st.getCell(i, "rinlabel");
					st.setCellValue(cell, "rinlabel", INVALID_LABEL_VALUE);
                	cell.element.showElement.element.innerHTML = "-";
                	
                	cell = st.getCell(i, "lspmode");
			st.setCellValue(cell, "lspmode", INVALID_VALUE_NUM);
                        cell.element.showElement.element.innerHTML = "-";
                        st.setCellIsEdit(cell, 0);
                }
                
                cell = st.getCell(i, "vlanid");
                
                if (neversion < "5.76.02.10" && winobj.neType != "114")  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
                	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                }
                
                if(!isAfterRTN900R5C01())
                {
                    if (neversion >= "5.76.03.10" || winobj.neType == "114")
                    {
                        cell = st.getCell(i, "lspmode");
                        cell.element.showElement.element.innerHTML = "-";
                        st.setCellIsEdit(cell, 0);
                    }
                }
                
                refactorPortName(i, 'out');
                break;
            default:
                break;
        }
        
        var apsId = st.getCellCurrentValue(i, "apsid", "apsid");
        if (apsId == null) 
        {
            st.getCellShow(i, "apsid").element.innerHTML = "-";
        }
    }
}


function refactorPortName(index, prefix)
{
    var slotid = st.getCellCurrentValue(index, prefix + "port", prefix + "slotid");
    var cellShow = st.getCellShow(index, prefix + "port");
    if(slotid == '65535' || slotid == '0')
    {
        var bdName = st.getCellCurrentValue(index, prefix + "port", prefix + "boardname");
        var portName = st.getCellCurrentValue(index, prefix + "port", prefix + "portname");
        cellShow.element.innerText = bdName + '-' + portName;
    }
}

function isAfterRTN900R5C01()
{
    if (winobj.neType == "114") 
    {
        return true;
    }
    
    var verArr = winobj.neversion.split('.');
    
    if (verArr[2] + "." + verArr[3] >= '05.20') 
    {
        return true;
    }
    else 
    {
        return false;
    }
}
