var cosType = new Array();
cosType[1] = "BE";
cosType[2] = "AF1";
cosType[3] = "AF2";
cosType[4] = "AF3";
cosType[5] = "AF4";
cosType[6] = "EF";
cosType[7] = "CS6";
cosType[8] = "CS7";
cosType[255] = "-";

function createjsDOMenu()
{
    removejsDOMmenu();
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") {
        menuSize = 200;
    }
    var cursorMenu1 = new jsDOMenu(menuSize);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["unitunnel"], "", doCreateUniTunnel, "", ""));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["bitunnel"], "", doCreateBitTunnel, "", ""));
    setPopUpMenu(cursorMenu1);
}

function doCreateUniTunnel()
{
	removejsDOMmenu();
    getPortRes();
    if (portRes.length <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }
    var tmppath = "../mpls/createunicasttunnel.html";
	var neType = winobj.neType;
	var vers = neversion.split(".");
	if((neType == "76" || neType == "77") && ((vers[2] + "." + vers[3]) < "03.10"))
	{
		tmppath = "../mpls/createunicasttunnel.html";
	}
	else
	{
		tmppath = "../mpls/createunicasttunnel_u2kv1r3c00.html";
	}
    xshowModalDialog(tmppath, RESOURCE["createunicasttunnel"], 650, 650, "../../../../../images/");
}

function doCreateBitTunnel()
{
	removejsDOMmenu();
	getPortRes();
    if (portRes.length <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }
    xshowModalDialog("createbicasttunnel.html", RESOURCE["createbicasttunnel"], 650, 670, "../../../../../images/");
}

function doModify()
{
	getPortRes();
	var indexes = st.getSelectedRows();
	var index = st.getCellCurrentValue(indexes[0], "direction", "direction");
	var direction = parseInt(index);
	switch (direction)
	{
		case DIRECTION_UNI:
			xshowModalDialog("modifyunicasttunnel_u2kv1r3c00.html", RESOURCE["modifytunnel"], 500, 620, "../../../../../images/");
			break;
		case DIRECTION_BI:
			xshowModalDialog("modifybicasttunnel_u2kv1r3c00.html", RESOURCE["modifytunnel"], 500, 670, "../../../../../images/");
			break;
		default:
			alert("Direction Error!");
			break;
	}
}

function addCellListener()
{
	var bNotEditVlanid = isNotSupportVlanId();
	var bEditLSPMode = isSupportEditLSPMode();
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "name");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
        var nType = parseInt(st.getCellCurrentValue(i, "nodetype", "nodetype"));
        
        cell = st.getCell(i, "enablestatus");
        st.setCellIsEdit(cell, 0);
        
        switch (nType)
        {
            case NODE_TYPE_EGRESS:
            	var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));

                
                cell = st.getCell(i, "outport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "outlabel");
				st.setCellValue(cell, "outlabel", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "rinlabel");
				st.setCellValue(cell, "rinlabel", INVALID_LABEL_VALUE);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "nexthopaddr");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "snknode");
				st.setCellValue(cell, "snknode", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";
                
                if (direction == 0)
                {
                	
                	cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 0);
    				st.setCellValue(cell, "bandwidth", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                    
                    cell = st.getCell(i, "bandwidthremain");
                    cell.element.showElement.element.innerHTML = "-";
                	
                	cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                	
                	cell = st.getCell(i, "vlanid");
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                
                	cell = st.getCell(i, "enablestatus");
                	st.setCellIsEdit(cell, 0);
                	cell.element.showElement.element.innerHTML = "-";
                
                	cell = st.getCell(i, "routlabel");
					st.setCellValue(cell, "routlabel", INVALID_LABEL_VALUE);
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rnexthopaddr");
					st.setCellValue(cell, "rnexthopaddr", INVALID_IP);
                    cell.element.showElement.element.innerHTML = "-";
                    
                    cell = st.getCell(i, "exp");
					st.setCellValue(cell, "exp", INVALID_VALUE_NUM);
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
				else
				{
					cell = st.getCell(i, "vlanid");
					var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                	
                	cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 1);
                    var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                    if (bw == 0) 
                    {
                    	cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    	st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                    }
                    else
                    {
                    	st.setCellValue(cell, "bandwidth", bw);
                        cell.element.showElement.element.innerHTML = bw;  
                        st.getCellShow(i, "bandwidthremain").element.innerHTML = bw;
                    }
                	
                	 if(isSupportPirEditFlag)
                     {
 	                    cell = st.getCell(i, "pir");
 	                    st.setCellIsEdit(cell, 1);
 	                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
 	                    if (pirvalue == 0) 
 	                    {
 	                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
 	                    }
 	                    else
 	                    {
 	                        st.setCellValue(cell, "pir", pirvalue);
 	                        cell.element.showElement.element.innerHTML = pirvalue;  
 	                    }
                     }
                     else
                     {
                     	cell = st.getCell(i, "pir");
                         st.setCellIsEdit(cell, 0);
           			    st.setCellValue(cell, "pir", INVALID_VALUE);
                         cell.element.showElement.element.innerHTML = "-";
                     }
				}
				
                if (bEditLSPMode)
                {
                    cell = st.getCell(i, "lspmode");
                    cell.element.showElement.element.innerHTML = "-";
                    st.setCellIsEdit(cell, 0);
                }

                break;
            case NODE_TYPE_TRANSIT:
            	var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
            	var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                
                if(isSupportPirEditFlag)
                {
                    cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 1);
                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
                    if (pirvalue == 0) 
                    {
                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    }
                }
                else
                {
                	cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "enablestatus");
                st.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "lspmode");
				st.setCellValue(cell, "lspmode", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                
                cell = st.getCell(i, "exp");
                st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, "exp", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                if (direction == 0)
                {
                	cell = st.getCell(i, "routlabel");
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rinlabel");
               	    cell.element.showElement.element.innerHTML = "-";
               	    
               	    cell = st.getCell(i, "rnexthopaddr");
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "vlanid");
                if (bNotEditVlanid)  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
	            	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                }
                break;
            case NODE_TYPE_INGRESS:
                var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                
                if(isSupportPirEditFlag)
                {
                    cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 1);
                    var pirvalue = parseInt(st.getCellCurrentValue(i, "pir", "pir"));
                    if (pirvalue == 0) 
                    {
                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                    }
                }
                else
                {
                	cell = st.getCell(i, "pir");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "pir", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                }
                
                cell = st.getCell(i, "inport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "inlabel");
				st.setCellValue(cell, "inlabel", INVALID_VALUE_NUM);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "routlabel");
				st.setCellValue(cell, "routlabel", INVALID_LABEL_VALUE);
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "rnexthopaddr");
				st.setCellValue(cell, "rnexthopaddr", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";

                cell = st.getCell(i, "srcnode");
				st.setCellValue(cell, "srcnode", INVALID_IP);
                cell.element.showElement.element.innerHTML = "-";
                if (direction == 0) //  Tunnel
                {
                	cell = st.getCell(i, "rinlabel");
					st.setCellValue(cell, "rinlabel", INVALID_LABEL_VALUE);
                	cell.element.showElement.element.innerHTML = "-";
                	
                	cell = st.getCell(i, "lspmode");
					st.setCellValue(cell, "lspmode", INVALID_VALUE_NUM);
                    cell.element.showElement.element.innerHTML = "-";
                    st.setCellIsEdit(cell, 0);
                }
                
                cell = st.getCell(i, "vlanid");
                
                if (bNotEditVlanid)  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
                	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
                    }
                }
                
                if (!bEditLSPMode)
                {
                    cell = st.getCell(i, "lspmode");
                    cell.element.showElement.element.innerHTML = "-";
                    st.setCellIsEdit(cell, 0);
                }

                break;
            default:
                break;
        }
        
        var apsId = st.getCellCurrentValue(i, "apsid", "apsid");
        if (apsId == null) 
        {
            st.getCellShow(i, "apsid").element.innerHTML = "-";
        }
    }
}
/**
 *      LSPMode  
 */
function isSupportEditLSPMode()
{
	var neType = winobj.neType;
	var vers = neversion.split(".");
	if(((neType == "76" || neType == "77") && ((vers[2] + "." + vers[3]) < "03.10") || ((vers[2] + "." + vers[3]) >= '05.20')) || neType == "114")
	{
		return true;
	}
	if(SpecialAttrMgr.isNESupport(winobj.neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_SUPPORT_LSPMODE"))
	{
		return true;
	}
	return false;
}

