var ct = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var portRes = win.portRes;

var INVALID_SLOT = 0xFFFF;
var tunnelIndex = 0;

function init()
{
    initTable();
    initText();
	initData();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    atom1.element.disabled = true;
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1);
    
    atom1 = new Atom("select");
	atom1.element.disabled = true;
    atom1.addOption(RESOURCE["ingress"], 1);
    atom1.addOption(RESOURCE["transit"], 2);
    atom1.addOption(RESOURCE["egress"], 3);
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["bidirectional"], 1);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1);
    
    atom1 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["bandwidth"], atom1);
    atom1.element.parent.selview.disabled = true;
    atom1.element.parent.txtview.disabled = true;
	
	var ops = getDataArr();
	ops.push(new Option(RESOURCE["INVALID_VALUE"], INVALID_VALUE));
    atom1.element.parent.initComboBox(ops, "dm0", 16, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue(RESOURCE["INVALID_VALUE"]);
    ct.addAttrRow("pir", RESOURCE["pir"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue(RESOURCE["INVALID_VALUE"]);
    ct.addAttrRow("cbs", RESOURCE["cbs"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue(RESOURCE["INVALID_VALUE"]);
    ct.addAttrRow("pbs", RESOURCE["pbs"], atom1);
    /************************************************************************/
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changeBoard("inboard", "outboard", "inport", "outport");
    };
    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    ct.addAttrRow("inport", RESOURCE["inport"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("inlabel", RESOURCE["positiveinlabel"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("routlabel", RESOURCE["negativeoutlabel"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changeBoard("outboard", "inboard", "outport", "inport");
    };
    ct.addAttrRow("outboard", RESOURCE["outboard"], atom1);
    
    atom1 = new Atom("select");
    ct.addAttrRow("outport", RESOURCE["outport"], atom1);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("outlabel", RESOURCE["positiveoutlabel"], atom1);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("rinlabel", RESOURCE["negativeinlabel"], atom1);
    
    atom1 = new Atom("text");
    validateIp(atom1.element);
    ct.addAttrRow("nexthopaddr", RESOURCE["positivenexthopaddr"], atom1);
    
    atom1 = new Atom("text");
    atom1.setValue("-");
    validateIp(atom1.element);
    atom1.element.disabled = true;
    ct.addAttrRow("rnexthopaddr", RESOURCE["negativenexthopaddr"], atom1);
    /************************************************************************/
	
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue(RESOURCE["INVALID_VALUE"]);
    validateNode(atom1.element, false, "snknode");
    ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1);
    
    atom1 = new Atom("text");
	atom1.element.disabled = true;
    validateNode(atom1.element, false, "srcnode");
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["elsp"], 0);
	atom1.addOption(RESOURCE["llsp"], 1);
	atom1.addOption(RESOURCE["INVALID_VALUE"], INVALID_VALUE_NUM);
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1);
    
    atom1 = new Atom("select");
	atom1.element.disabled = true;
    atom1.addOption(RESOURCE["exp0"], 0);
    atom1.addOption(RESOURCE["exp1"], 1);
    atom1.addOption(RESOURCE["exp2"], 2);
    atom1.addOption(RESOURCE["exp3"], 3);
    atom1.addOption(RESOURCE["exp4"], 4);
    atom1.addOption(RESOURCE["exp5"], 5);
    atom1.addOption(RESOURCE["exp6"], 6);
    atom1.addOption(RESOURCE["exp7"], 7);
    atom1.addOption(RESOURCE["exp255"], 255);
	atom1.addOption(RESOURCE["INVALID_VALUE"], INVALID_VALUE_NUM);
    ct.addAttrRow("exp", RESOURCE["exp"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["INVALID_VALUE"], INVALID_VALUE_NUM);
    if(isAfterRTN900R5C01())
    {
        atom1.addOption(RESOURCE["lspmode_2"], 2);
    }
    ct.addAttrRow("lspmode", RESOURCE["lspmode"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue(RESOURCE["INVALID_VALUE"]);
    ct.addAttrRow("mtu", "MTU", atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
	atom1 = new Atom("select");
	atom1.element.disabled = true;
	atom1.addOption("-", "255");
	atom1.addOption("BE", "1");
	atom1.addOption("AF1", "2");
	atom1.addOption("AF2", "3");
	atom1.addOption("AF3", "4");
	atom1.addOption("AF4", "5");
	atom1.addOption("EF", "6");
	atom1.addOption("CS6", "7");
	atom1.addOption("CS7", "8");
	ct.addAttrRow("cos", "CoS", atom1);
}

function initText()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initData()
{
	var wintable = win.st;
	var index = wintable.getSelectedRows()[0];
	if(isNaN(index))
	{
		return;
	}
    var tunnelindex = wintable.getCellStoreValue(index, "tunnelindex", "tunnelindex");
	tunnelIndex = tunnelindex;
	var tunnelid = wintable.getCellStoreValue(index, "tunnelid", "tunnelid");
	ct.getAtom("tunnelid").setValue(tunnelid);
    var tunnelname = wintable.getCellStoreValue(index, "name", "name");
    if (!tunnelname) 
    {
        tunnelname = "";
    }
    ct.getAtom("tunnelname").setValue(tunnelname);
    
	var nodetype = wintable.getCellStoreValue(index, "nodetype", "nodetype");
	ct.getAtom("nodetype").element.selectedIndex = searchSelectedIndex(ct.getAtom("nodetype").element,nodetype);
	
	switch (parseInt(nodetype))
	{
	    case NODE_TYPE_INGRESS:
	        fillBoard("outboard");
			changeBoard("outboard", "inboard", "outport", "inport");
	        break;
	    case NODE_TYPE_TRANSIT:
	    fillBoard("inboard");
	    changeBoard("inboard", "outboard", "inport", "outport");
	    fillBoard("outboard");
	    changeBoard("outboard", "inboard", "outport", "inport");
	        break;
	    case NODE_TYPE_EGRESS:
			fillBoard("inboard");
			changeBoard("inboard", "outboard", "inport", "outport");
	        break;
	    default:
	        break;
	}

	var inslotid = wintable.getCellStoreValue(index, "inporthidden", "inslotid");
	if(INVALID_SLOT == inslotid) //      MLPPP             DTS2013010802297 
	{
	    ct.getAtom("inboard").element.selectedIndex = searchVBoardSelectedIndex(ct.getAtom("inboard").element, wintable.getCellStoreValue(index, "inporthidden", "inport"));
	} else {
	    ct.getAtom("inboard").element.selectedIndex = searchSelectedIndex(ct.getAtom("inboard").element,inslotid);
	}
	
	changeBoard("inboard", "outboard", "inport", "outport");
	
	var inportid = wintable.getCellStoreValue(index, "inporthidden", "inport");
	ct.getAtom("inport").element.selectedIndex = searchSelectedIndex(ct.getAtom("inport").element,inportid);
	
	var outslotid = wintable.getCellStoreValue(index, "outporthidden", "outslotid");
	if(INVALID_SLOT == outslotid)//      MLPPP             DTS2013010802297 
	{
	    ct.getAtom("outboard").element.selectedIndex = searchVBoardSelectedIndex(ct.getAtom("outboard").element, wintable.getCellStoreValue(index, "outporthidden", "outport"));
	} else {
	    ct.getAtom("outboard").element.selectedIndex = searchSelectedIndex(ct.getAtom("outboard").element,outslotid);
	}
	
	changeBoard("outboard", "inboard", "outport", "inport");
	
	var outportid = wintable.getCellStoreValue(index, "outporthidden", "outport");
	ct.getAtom("outport").element.selectedIndex = searchSelectedIndex(ct.getAtom("outport").element,outportid);
	
	var tempParam = wintable.getCellStoreValue(index, "bandwidth", "bandwidth");
	if(0 == tempParam)
	{
		ct.getAtom("bandwidth").element.parent.setSelectedIndex(16);//;
	}
	else
	{
		ct.getAtom("bandwidth").element.parent.setSelectedIndex(searchSelectedIndex(ct.getAtom("bandwidth").element.parent.selview,tempParam,17));//;
	}
	
	tempParam = wintable.getCellStoreValue(index, "srcnode", "srcnode");
	ct.getAtom("srcnode").setValue(convertIP(tempParam));
	
	tempParam = wintable.getCellStoreValue(index, "snknode", "snknode");
	ct.getAtom("snknode").setValue(convertIP(tempParam));
	
	tempParam = wintable.getCellStoreValue(index, "nexthopaddr", "nexthopaddr");
	ct.getAtom("nexthopaddr").setValue(convertIP(tempParam));
	
	tempParam = wintable.getCellStoreValue(index, "rnexthopaddr", "rnexthopaddr");
	ct.getAtom("rnexthopaddr").setValue(convertIP(tempParam));
	
	tempParam = wintable.getCellStoreValue(index, "tunneltype", "tunneltype");
	ct.getAtom("tunneltype").element.selectedIndex = searchSelectedIndex(ct.getAtom("tunneltype").element,tempParam);
	
	tempParam = wintable.getCellStoreValue(index, "exp", "exp");
	ct.getAtom("exp").element.selectedIndex = searchSelectedIndex(ct.getAtom("exp").element,tempParam);
	
	tempParam = wintable.getCellStoreValue(index, "lspmode", "lspmode");
	ct.getAtom("lspmode").element.selectedIndex = searchSelectedIndex(ct.getAtom("lspmode").element,tempParam);
	
	tempParam = wintable.getCellStoreValue(index, "inlabel", "inlabel");
	ct.getAtom("inlabel").setValue(tempParam);
		
	tempParam = wintable.getCellStoreValue(index, "outlabel", "outlabel");
	if(tempParam >=16)
	{
		ct.getAtom("outlabel").setValue(tempParam);
	}
	else
	{
		ct.getAtom("outlabel").setValue("-");
	}
	
	tempParam = wintable.getCellStoreValue(index, "rinlabel", "rinlabel");
	if(tempParam >=16)
	{
		ct.getAtom("rinlabel").setValue(tempParam);
	}
	else
	{
		ct.getAtom("rinlabel").setValue("-");
	}
	
	tempParam = wintable.getCellStoreValue(index, "routlabel", "routlabel");
	ct.getAtom("routlabel").setValue(tempParam);
	
	tempParam = wintable.getCellStoreValue(index, "cos", "cos");
	ct.getAtom("cos").setValue(tempParam);
	
	changeNodeType(nodetype);
	
	tempParam = wintable.getCellStoreValue(index, "cos", "cos");
	if(255 == tempParam)
	{
		ct.getAtom("cos").element.selectedIndex = 0;
	}
	else
	{
		ct.getAtom("cos").element.selectedIndex = tempParam;
	}
}

function changeNodeType(nodeTypeValue)
{
    var atom = null;
    var tmpAtom = null;
    var selView = null;
    var sIndex = -1;
    var option = null;
    switch (parseInt(nodeTypeValue))
    {
        case NODE_TYPE_INGRESS:
            atom = ct.getAtom("inboard");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue(RESOURCE["INVALID_VALUE"]);
			}
            atom.element.disabled = true;
            
            atom = ct.getAtom("routlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue(RESOURCE["INVALID_VALUE"]);
			}
            atom.element.disabled = true;
            atom = ct.getAtom("outboard");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue("");
			}
            atom.element.disabled = false;
            
            atom = ct.getAtom("rinlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue("");
			}
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr");
			if(INVALID_IP != atom.getValue() && RESOURCE["INVALID_VALUE"] != atom.getValue())
			{
				atom.element.disabled = false;
			}
            
            atom = ct.getAtom("rnexthopaddr");
			if(INVALID_IP != atom.getValue() && RESOURCE["INVALID_VALUE"] != atom.getValue())
			{
				atom.element.disabled = false;
			}
            
            break;
        case NODE_TYPE_TRANSIT:
        		atom = ct.getAtom("inboard");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("rnexthopaddr");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel");
            atom.element.disabled = false;
            
            atom = ct.getAtom("routlabel");
            atom.element.disabled = false;
             break;
             
        case NODE_TYPE_EGRESS:
            atom = ct.getAtom("inboard");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue("");
			}
			atom.element.disabled = false;
            
            atom = ct.getAtom("routlabel");
            if(INVALID_VALUE_NUM == atom.getValue() || INVALID_LABEL_VALUE == atom.getValue())
			{
				atom.setValue("");
			}
			atom.element.disabled = false;
            atom = ct.getAtom("outboard");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel");
            atom.element.disabled = true;
            
            atom = ct.getAtom("rinlabel");
            atom.element.disabled = true;
            
            atom = ct.getAtom("nexthopaddr");
            atom.element.disabled = true;
            
            atom = ct.getAtom("rnexthopaddr");
			if(INVALID_IP != atom.getValue() && RESOURCE["INVALID_VALUE"] != atom.getValue())
			{
				atom.element.disabled = false;
			}
            
            break;
        default:
            break;
    }
}

function changeBoard(b1, b2, p1, p2)
{
    var atom = ct.getAtom(b1);
    var index = atom.element.options.selectedIndex;
    if (index < 0) 
    {
        return;
    }
    var option = atom.element.options[index];
    var slotId = option.value;
    var board = option.text;
    
    var bdName = null;
    atom = ct.getAtom(p1);
    atom.element.options.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        if (board == bdName) 
        {
            atom.addOption(portObj.portName, portObj.portId);
        }
    }
}

function fillBoard(board)
{
    var atom = ct.getAtom(board);
    atom.element.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.addOption(bdName, portObj.slotId);
        }
    }
}

function validate()
{
    var atom = ct.getAtom("tunnelid");
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    atom = ct.getAtom("inlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("rinlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("routlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    atom = ct.getAtom("outlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    
    atom = ct.getAtom("nexthopaddr");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
    }
    
    atom = ct.getAtom("rnexthopaddr");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
    }
    
    atom = ct.getAtom("srcnode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsrcnode"]);
            return false;
        }
    }
    
    atom = ct.getAtom("snknode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
    }
    
    return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("tunnelindex", tunnelIndex));
    var nodeType = parseInt(ct.getAtom("nodetype").getValue());
    
    var slotId = -1;
    var atom = null;
	var temp = INVALID_IP;
	var nextHopAddr = ct.getAtom("nexthopaddr").getValue();
    var iOptions = ct.getAtom("inboard").element.options;
    var oOptions = ct.getAtom("outboard").element.options;
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("inslotid", 0));
			rowparams.appendChild(createTagElement("insubslotid", 0));//    0
            rowparams.appendChild(createTagElement("inport", 0));
			rowparams.appendChild(createTagElement("inlabel", INVALID_LABEL_VALUE));
			
			slotId = parseInt(oOptions[oOptions.selectedIndex].value);
			rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport");
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
			rowparams.appendChild(createTagElement("outslotid", 255));//    255
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel").getValue()));
			
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            
			temp = ct.getAtom("rinlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rinlabel", temp));
			temp = ct.getAtom("routlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("routlabel", temp));
			temp = ct.getAtom("rnexthopaddr").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rnexthopaddr", temp));
			    
            break;
        case NODE_TYPE_TRANSIT:
         slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport");
			rowparams.appendChild(createTagElement("insubslotid", 255));//    255
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel").getValue()));
            
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
			rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport");
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
			rowparams.appendChild(createTagElement("outslotid", 255));//    255
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel").getValue()));
            
            	temp = ct.getAtom("rinlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rinlabel", temp));
			temp = ct.getAtom("routlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("routlabel", temp));
			temp = ct.getAtom("rnexthopaddr").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rnexthopaddr", parseInt("0x" + convertIpaddrToHexcode(temp))));
			rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
        
            break;
        case NODE_TYPE_EGRESS:
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport");
			rowparams.appendChild(createTagElement("insubslotid", 255));//    255
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel").getValue()));
			
			rowparams.appendChild(createTagElement("outslotid", 0));
            rowparams.appendChild(createTagElement("outsubslotid", 0));//    0
			rowparams.appendChild(createTagElement("outport", 0));
			rowparams.appendChild(createTagElement("outlabel", INVALID_LABEL_VALUE));
			
			rowparams.appendChild(createTagElement("nexthopaddr", INVALID_IP));
			
			temp = ct.getAtom("rinlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rinlabel", temp));
			temp = ct.getAtom("routlabel").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("routlabel", temp));
			temp = ct.getAtom("rnexthopaddr").getValue();
			temp = (RESOURCE["INVALID_VALUE"] == temp ? INVALID_LABEL_VALUE: temp)
			rowparams.appendChild(createTagElement("rnexthopaddr", parseInt("0x" + convertIpaddrToHexcode(temp))));
			
            break;
        default:
            break;
    }
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doModify(param)
{
    if (!validate()) 
    {
        return;
    }
    var xml = createTunnelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_SET_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, modifyCallBack, param, "inputdata=" + xml);
}

function modifyCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (param && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
        else 
        {
            
        }
    }
}

function validateNode(obj)
{
    var stCall = false;
    var nodeType = "";
    if (arguments.length > 1) 
    {
        stCall = arguments[1];
        nodeType = arguments[2];
    }
    
    var oedit = obj;
    oedit.maxLength = maxbyte;
    oedit.style.imeMode = "disabled"; //     
    oedit.onpaste = function()
    {
        return false;
    }
    
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        if (code == 8) 
        {
            return true;
        }
        
        var objIp = oedit;
        var existstring = objIp.value;
        var curInput = String.fromCharCode(code);
        if (event.keyCode == 13) 
        {
            objIp.onblur();
        }
        if (((code < 48 || code > 57) && code != splitcharcode) ||
        (code == splitcharcode && existstring.charCodeAt(existstring.length - 1) == splitcharcode) ||
        (code == splitcharcode && existstring.length == 0)) 
        {
            return false;
        }
        
        var tagPosition = digitalTag_getPos(objIp);
        
        var str1 = existstring.substring(0, tagPosition);
        var str2 = existstring.substring(tagPosition, existstring.length);
        existstring = str1 + curInput + str2;
        
        var aryIp = existstring.split(splitchar);
        
        if (aryIp.length > 4) 
        {
            return false;
        }
        
        /* a.b.c.d              .  */
        var dot1 = existstring.indexOf(splitchar);
        var dot2 = existstring.indexOf(splitchar, dot1 + 1);
        var dot3 = existstring.indexOf(splitchar, dot2 + 1);
        var dot4 = existstring.indexOf(splitchar, dot3 + 1);
        
        if (dot1 < 0) 
        {
            if (existstring.length == 3) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > 3 && (selectionLen(ojbIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot2 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot1 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot1 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot3 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot2 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot2 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot4 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot3 && existstring.substring(dot2 + 1, dot3).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length > maxbyte) 
            {
                if ((selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
            else if (existstring.length == dot3 + 5) 
            {
                tagPosition = digitalTag_getPos(objIp);
                if (tagPosition > dot3 && (selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
        }
    }
    
    /**
     *   IP                  255       255
     */
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var objIp = event.srcElement;
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] != "") 
            {
                aryIp[i] = parseInt(aryIp[i], 10);
            }
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue;
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
    }
    
    oedit.onblur = function()
    {
        var event = EventUtil.getEvent();
        
        var objIp = event.srcElement;
        if (objIp.value == "") 
        {
            alert(RESOURCE["format"]);
            objIp.value = "0.0.0.0";
            if (stCall) 
            {
                cellonblur(objIp);
            }
            return;
        }
        
        objIp.value = formFullAddr(objIp.value);
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
        
        if (stCall) 
        {
            cellonblur(objIp);
        }
    }
}


var searchSelectedIndex = function(optionObj,value,defaultIndex)
{
	if(!optionObj)
	{
		return -1;
	}
	var tempOption = optionObj.options;
	
	if(0 == tempOption.length)
	{
		return -1;
	}
	
	var selectedIndex = 0;

	for(var index = 0,len = tempOption.length;index<len;index++)
	{
		if(value == tempOption[index].value)
		{
			selectedIndex = index;
			return selectedIndex;
		}
	}
	if(defaultIndex)
	{
		selectedIndex = defaultIndex;
	}
	return selectedIndex;
}

function isAfterRTN900R5C01()
{
    if(win.neType == "114")
    {
        return true;
    }
    
    var verArr = win.neversion.split('.');

    if(verArr[2] >= '05' && verArr[3] >= '20')
    {
        return true;
    } else {
        return false;
    }
}

/**
 **        MLPPP         65535                 
 **/
function searchVBoardSelectedIndex(optionObj, port)
{
    var pObj, tempPort;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        pObj = portRes[i];
        tempPort = pObj.portId;
        
        if(port == tempPort)
        {
            break;
        }
    }    
        
    if(!pObj || !optionObj)
    {
    	return -1;
    }
    var tempOption = optionObj.options;
    
    if(0 == tempOption.length)
    {
    	return -1;
    }
    
    var selectedIndex = 0;
    
    for(var index = 0,len = tempOption.length;index<len;index++)
    {
    	if(pObj.boardName == tempOption[index].text)
    	{
    		selectedIndex = index;
    		return selectedIndex;
    	}
    }
  
    return selectedIndex;
}
