function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"], RESOURCE["negativevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "65535");
    var atom2 = new Atom("text");
    checkText(atom2.element, "1", "65535");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkTextData(atom1.element, 64);
    atom2 = new Atom("text");
    checkTextData(atom2.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["ingress"], 1);
    atom1.addOption(RESOURCE["transit"], 2);
    atom1.addOption(RESOURCE["egress"], 3);
    atom1.element.onchange = changeNodeType;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["ingress"], 1);
    atom2.addOption(RESOURCE["transit"], 2);
    atom2.addOption(RESOURCE["egress"], 3);
    atom2.element.onchange = changeNodeType;
    atom2.element.options.selectedIndex = 2;
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["unidirectional"], 0);
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["unidirectional"], 0);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1, atom2);
    
   
    atom1 = new Atom("combobox");
    atom2 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["cir"], atom1, atom2);
    
    
    
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom2.element.parent.selview.disabled = true;
    atom2.element.parent.txtview.disabled = true;
    atom2.element.parent.initComboBox(getDataArr(), "dm1", 0, true);
    addOptionToSelect(atom2.element.parent.selview, new Option("-", "-"));
    atom2.element.parent.setSelectedIndex(18);
    atom2.element.parent.txtview.onkeypress = keypressHandler;
    atom2.element.parent.txtview.onkeyup = keyupHandler;
    atom2.element.parent.txtview.onblur = onblurHandler;
    atom2.element.parent.txtview.style.imeMode = "disabled";
    atom2.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom1 = new Atom("combobox");
    atom2 = new Atom("combobox");
    ct.addAttrRow("pir", RESOURCE["pir"], atom1, atom2);
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    if(!isSupportPirEditFlag)
    {
    	atom1.element.parent.selview.disabled = true;
        atom1.element.parent.txtview.disabled = true;
    	addOptionToSelect(atom1.element.parent.selview, new Option("-", "-"));
    	atom1.element.parent.setSelectedIndex(18);
    }
    
    atom2.element.parent.selview.disabled = true;
    atom2.element.parent.txtview.disabled = true;
    atom2.element.parent.initComboBox(getDataArr(), "dm1", 0, true);
    addOptionToSelect(atom2.element.parent.selview, new Option("-", "-"));
    atom2.element.parent.setSelectedIndex(18);
    atom2.element.parent.txtview.onkeypress = keypressHandler;
    atom2.element.parent.txtview.onkeyup = keyupHandler;
    atom2.element.parent.txtview.onblur = onblurHandler;
    atom2.element.parent.txtview.style.imeMode = "disabled";
    atom2.element.parent.txtview.onpaste = function()
    {
        return false;
    };

    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
		atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
		atom2.setValue("-");
    ct.addAttrRow("cbs", RESOURCE["cbs"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
		atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
		atom2.setValue("-");
    ct.addAttrRow("pbs", RESOURCE["pbs"], atom1, atom2);
    
     
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changeBoard("inboard", "outboard", "inport", "outport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changePort("inport", "outport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("inport", RESOURCE["inport"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("inlabel", RESOURCE["inlabel"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changeBoard("outboard", "inboard", "outport", "inport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("outboard", RESOURCE["outboard"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changePort("outport", "inport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("outport", RESOURCE["outport"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("outlabel", RESOURCE["outlabel"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateIp(atom1.element);
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
	validateIp(atom2.element);
    ct.addAttrRow("nexthopaddr", RESOURCE["nexthopaddr"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    validateNode(atom1.element, false, "snknode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateNode(atom1.element, false, "srcnode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        tunneltypeChanged();
    };
    
    atom1.addOption(RESOURCE["elsp"], 0);
	var notSupport = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTSUPPORT_LLSP");
    if( !isR3C03 && !notSupport)
    {
	 atom1.addOption(RESOURCE["llsp"], 1);
    }
    atom2 = new Atom("select");
    atom2.addOption(RESOURCE["elsp"], 0);
    if( !isR3C03 && !notSupport)
    {
	  atom2.addOption(RESOURCE["llsp"], 1);
    }
	atom2.element.disabled = true;
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["exp0"], 0);
    atom1.addOption(RESOURCE["exp1"], 1);
    atom1.addOption(RESOURCE["exp2"], 2);
    atom1.addOption(RESOURCE["exp3"], 3);
    atom1.addOption(RESOURCE["exp4"], 4);
    atom1.addOption(RESOURCE["exp5"], 5);
    atom1.addOption(RESOURCE["exp6"], 6);
    atom1.addOption(RESOURCE["exp7"], 7);
    atom1.addOption(RESOURCE["exp255"], 255);
    atom1.element.options.selectedIndex = 8;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["exp0"], 0);
    atom2.addOption(RESOURCE["exp1"], 1);
    atom2.addOption(RESOURCE["exp2"], 2);
    atom2.addOption(RESOURCE["exp3"], 3);
    atom2.addOption(RESOURCE["exp4"], 4);
    atom2.addOption(RESOURCE["exp5"], 5);
    atom2.addOption(RESOURCE["exp6"], 6);
    atom2.addOption(RESOURCE["exp7"], 7);
    atom2.addOption(RESOURCE["exp255"], 255);
    atom2.addOption("-", 0);
    atom2.element.options.selectedIndex = 9;
    ct.addAttrRow("exp", RESOURCE["exp"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
	atom1.addOption("-", "-");
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["lspmode_2"], 2);
    ct.addAttrRow("lspmode", RESOURCE["lspmode"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("mtu", "MTU", atom1, atom2);
        
    atom1 = new Atom("select");
    atom1.element.disabled = true;
	atom1.addOption("-", "-");
	atom1.element.onchange = function()
    {
        cosChanged();
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption("-", "-");
    ct.addAttrRow("cos", "CoS", atom1, atom2);
}

function cosChanged()
{
	ct.getAtom("cos", 1).element.options.selectedIndex = ct.getAtom("cos", 0).element.options.selectedIndex;
}

function tunneltypeChanged()
{
	 switch (parseInt(ct.getAtom("tunneltype", 0).element.value))
	 {
	 	 case 0:
	 	 {
	 	 	 var atom1 = ct.getAtom("cos", 0);
	 	 	 atom1.element.options.length = 0;
	 	 	 atom1.addOption("-", "-");
	 	 	 atom1.element.disabled = true;
	 	 	 
	 	 	 var atom2 = ct.getAtom("cos", 1);
	 	 	 atom2.element.options.length = 0;
	 	 	 atom2.addOption("-", "-");
	 	 	 
	 	 	 var tunnelTypeAtom = ct.getAtom("tunneltype", 1);	 
	 	 	 tunnelTypeAtom.element.options.selectedIndex = 0;
	 	 	 break;
	 	 }
	 	 
	 	 case 1:
	 	 {
	 	 	 atom1 = ct.getAtom("cos", 0);
	 	 	 atom1.element.options.length = 0;
	 	 	 atom1.addOption("BE", "1");
	 	 	 atom1.addOption("AF1", "2");
	 	 	 atom1.addOption("AF2", "3");
	 	 	 atom1.addOption("AF3", "4");
	 	 	 atom1.addOption("AF4", "5");
	 	 	 atom1.addOption("EF", "6");
	 	 	 atom1.addOption("CS6", "7");
	 	 	 atom1.addOption("CS7", "8");
	 	 	 atom1.element.disabled = false;
	 	 	 
	 	 	 atom2 = ct.getAtom("cos", 1);
	 	 	 atom2.element.options.length = 0;
	 	 	 atom2.addOption("BE", "1");
	 	 	 atom2.addOption("AF1", "2");
	 	 	 atom2.addOption("AF2", "3");
	 	 	 atom2.addOption("AF3", "4");
	 	 	 atom2.addOption("AF4", "5");
	 	 	 atom2.addOption("EF", "6");
	 	 	 atom2.addOption("CS6", "7");
	 	 	 atom2.addOption("CS7", "8");
	 	 	 var tunnelTypeAtom = ct.getAtom("tunneltype", 1);	 
	 	 	 tunnelTypeAtom.element.options.selectedIndex = 1;
	 	 	 break;
	 	 }
	 }
}

function changeNodeType()
{
    var atom = null;
    var tmpAtom = null;
    var selView = null;
    var sIndex = -1;
    var option = null;
    switch (parseInt(this.value))
    {
        case NODE_TYPE_INGRESS:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 0);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("outboard", 0);
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp", 0);
            atom.element.options.length -= 1;
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = false;
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 2;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
            atom = ct.getAtom("pir", 1);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("lspmode", 0);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;
   	
            atom = ct.getAtom("lspmode", 1);
            atom.element.options.length = 0;
            atom.addOption(RESOURCE["lspmode_2"], 2);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;
            
            break;
        case NODE_TYPE_TRANSIT:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 0);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 0);
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 0);
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp", 0);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 1;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 1);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 1);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("lspmode", 0);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;
   	
            atom = ct.getAtom("lspmode", 1);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;
            break;
        case NODE_TYPE_EGRESS:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            
            atom = ct.getAtom("inboard", 0);
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 0);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 0;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 1);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 1);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            atom.element.options.length -= 1;
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = false;
            
            atom = ct.getAtom("lspmode", 0);
            atom.element.options.length = 0;
            if(isAfterRTN900R5C01())
            {
                atom.addOption(RESOURCE["lspmode_2"], 2);
                atom.element.disabled = false;
            } else {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
   		    	
            atom = ct.getAtom("lspmode", 1);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;

            break;
        default:
            break;
    }
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("auto", 1));
    rowparams.appendChild(createTagElement("autoassign", 2));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    rowparams.appendChild(createTagElement("tunnelid", ct.getAtom("tunnelid", index).getValue()));
    var tunnelName = ct.getAtom("tunnelname", index).getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction", index).getValue()));
	var tunneltype = parseInt(ct.getAtom("tunneltype", index).getValue());
	rowparams.appendChild(createTagElement("tunneltype", tunneltype));
    if(0 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 255));//   e-lsp,    (0xFF)
	}
	else if(1 == tunneltype)
	{
        rowparams.appendChild(createTagElement("cos", ct.getAtom("cos", index).getValue()));//lsp,1 be,2 af1,3 af2,4 af3,5 af4,6 ef,7 cs6,8 cs7
	}
	
    var nodeType = parseInt(ct.getAtom("nodetype", index).getValue());
    rowparams.appendChild(createTagElement("nodetype", nodeType));
    
    var slotId = -1;
    var atom = null;
    var bandwidth = ct.getAtom("bandwidth", index).getValue();
    var pir = ct.getAtom("pir", index).getValue();
    var nextHopAddr = ct.getAtom("nexthopaddr", index).getValue();
    var srcNode = ct.getAtom("srcnode", index).getValue();
    var snkNode = ct.getAtom("snknode", index).getValue();
    var iOptions = ct.getAtom("inboard", index).element.options;
    var oOptions = ct.getAtom("outboard", index).element.options;
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            rowparams.appendChild(createTagElement("insubslotid", 0));
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport", index);
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp", index).getValue()));       
            break;
        case NODE_TYPE_TRANSIT:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport", index);
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel", index).getValue()));
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport", index);
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            break;
        case NODE_TYPE_EGRESS:
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport", index);
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel", index).getValue()));
            rowparams.appendChild(createTagElement("outsubslotid", 0));
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            break;
        default:
            break;
    }
    return rowparams;
}

function isAfterRTN900R5C01()
{
    var verArr = win.neversion.split('.');

    if(verArr[2] >= '05' && verArr[3] >= '20')
    {
        return true;
    } else {
        return false;
    }
}
