
loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);

var win = getParentWindow();
var neid = win.winobj.neid;
var ct = null;
var ismspwmip = win.ismspwmip;

function init()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);

	var atom = new Atom("span");
	var idres = RESOURCE["tunnelres"];
	if (ismspwmip)
	{
		idres = RESOURCE["mspw"];
	}
	ct.addAttrRow("tunnel", idres, atom);
	var elem = document.createElement("input");
	elem.type = "text";
    elem.id = "selectedtunnel";
    elem.disabled = true;
    elem.style.width = "92%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.name = "";
    elem.id = "tunnelBtn";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
	
	atom = new Atom("select");
	atom.addOption(RESOURCE["iccbased"], "2");
    atom.addOption(RESOURCE["customerbased"], "3");
    atom.element.onchange = changeMegidType;
	ct.addAttrRow("megidtype", RESOURCE["megidtyperes"], atom);
	

	atom = new Atom("text");
	atom.element.maxLength = 13;
	atom.element.onblur = function()
	{
		if ("" == this.value)
		{
			alert(RESOURCE["megidicc"]);
			return false;
		}
	}
	ct.addAttrRow("megid", RESOURCE["megidres"], atom);

	atom = new Atom("text");
	textCheck(atom.element, "1", "8191");
	ct.addAttrRow("mepormipid", RESOURCE["mepormipidres"], atom);

	document.getElementById("tunnelmip").appendChild(ct.getTable());
	initBtn();
	
	if (ct.getAttrValue("megidtype") == "2")
	{
		getDefaultMEGID();
	}
}

function changeMegidType()
{
	var megidtype = this.value;
	var megidobj = ct.getAtom("megid").element;
	if (megidtype == "2")
	{
		getDefaultMEGID();
		megidobj.maxLength = 13;
		megidobj.onblur = function()
		{
			if ("" == this.value)
			{
				alert(RESOURCE["megidicc"]);
				return;
			}
		}
		
	}
	else if (megidtype == "3")
	{
		ct.setAttrValue("megid","");
		megidobj.maxLength = 96;
		checkMegidtype(megidobj, "crt");
	}
	
}

function initBtn()
{
	$("ok").value = RESOURCE["okbutton"];
	$("cancel").value = RESOURCE["cancelbutton"];
	$("apply").value = RESOURCE["applybutton"];
}

function doCreate(isClose)
{
	var megidtype = ct.getAttrValue("megidtype");
    var megid = ct.getAttrValue("megid");
    var mepormipid = ct.getAttrValue("mepormipid");
    
    if ($("tunnelindex").value == "")
    {
    	alert(RESOURCE["notunnel"]);
    	return;
    }
    
    if (megid == "")
	{
		var alertstr = "megidcustomer";
		if (megidtype == "2")//ICC
		{
			alertstr = "megidalert";
		}
		alert(RESOURCE[alertstr]);
    	return;
	}
	
	if (mepormipid == "")
	{
		alert(RESOURCE["mipidalert"]);
    	return;
	}
    
	var xmlstr = doCreateXML();
	var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_CRT_MPLSTPOAM_MIP + "&nmUser=" + win.nmUser;

	loadXMLdoc(urlreq, "POST", false, createCallback, isClose, "inputdata="
			+ xmlstr);
}

function createCallback(doc, closeFlag)
{
	var dinterface = EncapsulateData(doc);
	
	if (0 != dinterface.getSErrorCode())
	{
		showErrorDialog(dinterface);
		return;
	}
	
	win.doQueryMip();
	
	if (closeFlag)
	{
		closeClick();
	}
}

function doCreateXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	var megidtype = ct.getAttrValue("megidtype");
	param = new tagElement("param");
	param.setAttribute("name", "megidtype");
	param.setAttribute("value", megidtype);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "megtype");
	if (ismspwmip)
	{
		param.setAttribute("value", "4");
	}
	else
	{
		param.setAttribute("value", "1");
	}
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "tunnelindex");
	param.setAttribute("value", $("tunnelindex").value);
	row.appendChild(param);
	
	var megid = ct.getAttrValue("megid");
	param = new tagElement("param");
	param.setAttribute("name", "megid");
	param.setAttribute("value", megid);
	row.appendChild(param);
	
	var mepormipid = ct.getAttrValue("mepormipid");
	param = new tagElement("param");
	param.setAttribute("name", "mepormipid");
	param.setAttribute("value", mepormipid);
	row.appendChild(param);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../../page/", dinterface.getError(), errArr);
}

function closeClick()
{
	xcloseDialog();
}

function doSelectTunnel()
{
	if (ismspwmip)
	{
		xshowModalDialog("selecttunnel_mplstp.html?tunnelType=" + TE_F_CMD_PTN_PW_QUERY_MSPW + "&nodetype=2", RESOURCE["resourceselected"], 580, 250, "../../../../../images/");
	}
	else
	{
		xshowModalDialog("selecttunnel_mplstp.html?tunnelType=" + TECMDCODE_MPLSTPOAM_GET_AVAILABLE_TUNNEL + "&nodetype=2", RESOURCE["resourceselected"], 580, 250, "../../../../../images/");
	}
	
}


function getExistTunnelID()
{
	if(win.getExistTunnelID)
	{
		return win.getExistTunnelID();
	}
	return [];
}


function getDefaultMEGID()
{
	var xml = createQueryMEGIDXml();
    var url = "../../../../../neExlorerServlet?sfid=2012051011&nmUser=" + win.nmUser;
    loadXMLdoc(url, "POST", false, queryMEGIDCallBack, null, "inputdata=" + xml);
}

function queryMEGIDCallBack(doc)
{
    var data = EncapsulateData(doc);
	
	var carrierid = "";	
    if (null != data.getDataRowParam(0, "carrierid")
    	&& null != data.rows[0]["carrierid"].value
    	&& "" != data.rows[0]["carrierid"].value)
    {
    	carrierid = data.rows[0]["carrierid"].value;
    }
	ct.setAttrValue("megid",carrierid)
}

function createQueryMEGIDXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    rowparams.appendChild(thirdlevel);
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
