var st = null;
var mipst = null;
var tab = null;
var countObj = null;
var tableConfMep, tableConfMip;
var INDEX_ATTR_NAME = "tunnelindex";////Tunnel Index         Ping      
var START_PING = TE_CMD_MPLSTUNNEL_LSPPING;//  LSP Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//  Ping        
var STOP_PING = TE_IPPTN_STOP_PWPING;//  Ping      

var START_LB = TECMDCODE_START_MPLSTPOAM_LBTEST;//  LB      
var STOP_LB = TECMDCODE_STOP_MPLSTPOAM_LBTEST;//  LB      

var TEST_TYPE = "lspPing";//     LSP Ping
var INDEX_ATTR_ID_NAME = "tunnelid";
var INDEX_ATTR_ID_RES_NAME = "tunnelidPing";

var btnRightArr = new Object();
var memberInterface = new Array();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var INVALID_TUNNLE_INDEX = 4294967295;//   Tunnel Index 
var MIN_SDSF_VALUE = 0;//SD/SF      
var MAX_SDSF_VALUE = 100;//SD/SF      
var DISABLED = 0;//   
var ENABLED = 1;//  
var ismspwmip = false;//MIP            tunnel  PW  

/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
	initTable();
    initTabs();
    initButton();
    initRight();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    tableConfMep = window.tableconf[0];
    createTableHead(st, tableConfMep);
	st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    $("mepTbl").oncontextmenu = popupMenuHandlermep;
    $("mepTbl").appendChild(st.getTable());

    mipst = new SortTable();
    mipst.setImage("../../../../../images/");
    mipst.setOnRowSelectHandler(rowSelectHandlerMip);
    mipst.setOnCellEditHandler(cellEditHandler);
    tableConfMip = window.tableconf[1];
    createTableHead(mipst, tableConfMip);
	mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    $("mipTbl").oncontextmenu = popupMenuHandler;
    $("mipTbl").appendChild(mipst.getTable());
}

function setSelectedEmbedTab(id)
{
	if ("tab1div" == id)
	{
		mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
		st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
		doQueryMep();
	}
	if ("tab2div" == id)
	{
		st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
		mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
		doQueryMip();
	}
	
	for (var key in tabList)
	{
		if (!tabList[key] || !tabList[key].tagName || tabList[key].tagName.toLowerCase() != "div")
		{
			continue;
		}
		
		if (key == id)
		{
			tabHeadList[key].className = "tabs_head_select";
			tabList[key].style.display = "";
		}
		else
		{
			tabHeadList[key].className = "tabs_head";
			tabList[key].style.display = "none";
		}
	}
	
	if (window.embedTabSelectHandler)
	{
		embedTabSelectHandler(id);
	}
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["mplstpoammep"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["mplstpoammip"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedTab").appendChild(tab.getEmbedTabs());
}

/**
 *      
 */
function initButton()
{
    $("queryMepBtn").value = RESOURCE["querybutton"];
    $("oambtn").value = RESOURCE["oambtnbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
    $("queryMipBtn").value = RESOURCE["querybutton"];
    $("createMipBtn").value = RESOURCE["newbutton"];
    $("deleteMipBtn").value = RESOURCE["deletebutton"];
    $("applyMipBtn").value = RESOURCE["applybutton"];
}


/**
 *        
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_MPLSTUNNEL_QUERY_OAMSTATE);
    btnRightArr.oambtn = new BtnRightObj("oambtn", TE_IPPTN_DEL_PW);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_MPLSTUNNEL_SET_TUNNELOAM);
    
    getRightInfo(winobj, btnRightArr);
}

/**
 * Tab     
 */
function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
    	if ("tab1div" == tab.getSelectEmbedTab())
    	{
    		doQueryMep();
    	}
    	else if ("tab2div" == tab.getSelectEmbedTab())
    	{
    		doQueryMip();
    	}
    }
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    if (selectedRowCount > 0) 
    {
        $("oambtn").disabled = !btnRightArr.oambtn.right;
    }
    else 
    {
        $("oambtn").disabled = true;
    }
}

/**
 *       
 * @param {Object} evt
 */
function popupMenuHandlermep(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (colid == "reversetunnel") 
    {
        return;
    }
    
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
        createPopupMenu(rows, evt);
        showMenu(evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createPopupMenu(rows)
{
    removejsDOMmenu();
    var startMenu = false;//      
    var stopMenu = false;//      
    var pingTestMenu = false;//          
    var lbMenu = false;//LB    
    for (var i = 0; i < rows.length; i++) 
    {
        var direction = st.getCellStoreValue(rows[i], "direction", "direction");

        var nodeType = st.getCellStoreValue(rows[i], "nodetype", "nodetype");//    

        if( nodeType == 3 && direction == 0 )		//    Egress       
        {
            pingTestMenu = false;
        }
        else
        {
            pingTestMenu = true;
        }
        
       
        if (nodeType != 1 && direction == 0)//Egress       
        {
            startMenu = false;
            stopMenu = false;
            break;
        }
        
        var oamStat = st.getCellStoreValue(rows[i], "oamstat", "oamstat");//OAM  
        if (oamStat == DISABLED || nodeType == 0)//OAM        LB    
        {
        	lbMenu = false;
        }
        else
        {
        	lbMenu = true;
        }
        
        var cvffdStat = st.getCellStoreValue(rows[i], "ccstatus", "ccstatus");//lsp  
        if (cvffdStat == ENABLED) 
        {
            if (startMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = false;
                stopMenu = true;
            }
        }
        else 
        {
            if (stopMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = true;
                stopMenu = false;
            }
        }
    }
    
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        menuSize = 200;
    }
    var cursorMenu1 = new jsDOMenu(menuSize);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["startccres"], "", doSetEnabledStat, ENABLED, startMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["stopccres"], "", doSetEnabledStat, DISABLED, stopMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["startlbres"], "", doLBTest, rows, (rows.length == 1) && lbMenu));
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryLSPStat"], "", doQueryLSPStat, rows, true));//          ping  
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tunnlePingTest"], "", doPingTest, rows, (rows.length == 1) && pingTestMenu));//          ping  
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tracerouteTest"], "", doTracerouteTest, rows, (rows.length == 1) && pingTestMenu));//          ping  
    setPopUpMenu(cursorMenu1);    
}

/**
 *     PW
 */
function doQueryMep()
{
    $("queryMepBtn").disabled = true;
    $("oambtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXML("1", "1");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_TUNNELMEP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

function doQueryMip()
{
    $("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
    
    var xml = createQueryXML("1", "2");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryMipCallBack, null, "inputdata=" + xml);
}

function doSetMip()
{
	$("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
    
	var xml = createSetMipXml("1");
	if (null == xml)
	{
		$("queryMipBtn").disabled = false;
	    $("createMipBtn").disabled = false;
	    $("deleteMipBtn").disabled = false;
	    $("applyMipBtn").disabled = false;
		return;	
	}
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, delMipCallBack, null, "inputdata=" + xml);
}

function doDelMip()
{
	$("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
    
	var xml = createDelMipXml("1");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, delMipCallBack, "1", "inputdata=" + xml);
}

/**
 *   PW     
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    $("queryMepBtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    processData(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, tableConfMep, data, RESOURCE);
		var ce = st.getHeadCell("tunnelid").element;
        st.sortRows(ce, 1);
        addCellEvent();
    }
}

function processData(data)
{
    for (var i = 0, size = data.getDataRowLength(); i < size; i++) 
    {
        var detectionMode = data.getDataRowParam(i, "detectionmode");//    
        var direction = data.getDataRowParam(i, "direction");
        if (detectionMode == 1 && direction ==0)//     
        {
            data.rows[i]["ccperiod"].value = INVALID_VALUE;//            
        }
        var reverseTunnel = data.getDataRowParam(i, "reversetunnel");//  Tunnel
        if (reverseTunnel != INVALID_TUNNLE_INDEX)//    Tunnel
        {
            var nodeType = data.getDataRowParam(i, "nodetype");//    
            data.rows[i]["reversetunnel"].value = getRevTunnelStr(data, reverseTunnel, nodeType);//        Tunnel   
        }
        else 
        {
            data.rows[i]["reversetunnel"].value = "";
        }
        
        var megidtype = data.rows[i]["megidtype"].value;
        if ("1" == megidtype)
        {
        	data.rows[i]["megid"].value = INVALID_VALUE;
        	data.rows[i]["mepormipid"].value = INVALID_VALUE;
        	data.rows[i]["rmepormipid"].value = INVALID_VALUE;
        }
    }
}

/**
 *           Tunnel   
 * @param {Object} data
 * @param {Object} nodeType
 */
function getRevTunnelStr(data, reverseTunnel, nodeType)
{
    for (var i = 0, size = data.getDataRowLength(); i < size; i++) 
    {
        var tunnelIndex = data.getDataRowParam(i, "tunnelindex");
        if (tunnelIndex == reverseTunnel)//  tunnelindex
        {
            var tempNodeType = data.getDataRowParam(i, "nodetype");
            if (tempNodeType != nodeType) //         
            {
                var tunnelID = data.getDataRowParam(i, "tunnelid");
                var srcNode = convertIP(data.getDataRowParam(i, "srcnode"));
                var snkNode = convertIP(data.getDataRowParam(i, "snknode"));
                return tunnelID + "(" + RESOURCE["srcnode"] + ":" + srcNode + "," + RESOURCE["snknode"] + ":" + snkNode + ")";
            }
        }
    }
    
    return reverseTunnel;//      tunnelindex 
}


/**
 *         
 */
function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCell(i, "detectionmode");//    
        var direction = st.getCellStoreValue(i, "direction", "direction");
        if (null != cell) 
        {
            var detectPeriodCell = st.getCell(i, "ccperiod");//      (ms)   
            var detectionModeValue = st.getCellStoreValue(i, "detectionmode", "detectionmode");
            if (detectionModeValue == 255) //        
            {
                st.setCellIsEdit(cell, 0);//           
            }
            else if (detectionModeValue == 1 && direction==0)//          
            {
                st.setCellIsEdit(detectPeriodCell, 0);//             
            }
            
            var cellEdit = st.getCellEdit(i, "detectionmode");
            cellEdit.element.onchange = function()
            {
                detectModeChange(this);
            }
        }
        
        cell = st.getCell(i, "megidtype");//    
        if (null != cell) 
        {
        	var megidtypeValue = st.getCellStoreValue(i, "megidtype", "megidtype");
        	var megidcell = st.getCell(i, "megid");
        	var mepormipidcell = st.getCell(i, "mepormipid");
        	var rmepormipidcell = st.getCell(i, "rmepormipid");
        	if (megidtypeValue == "1") 
            {
            	st.setCellIsEdit(megidcell, 0);//       
            	st.setCellIsEdit(mepormipidcell, 0);//       
            	st.setCellIsEdit(rmepormipidcell, 0);//       
            }
            
        	var cellEdit = st.getCellEdit(i, "megidtype");
            cellEdit.element.onchange = function()
            {
                megIDTypeChange(this);
            }
        }
        
        cell = st.getCell(i, "detectperiod");
        if (null != cell) 
        {
            var detectPeriodValue = st.getCellStoreValue(i, "detectperiod", "detectperiod");
            if (detectPeriodValue == 255) 
            {
                st.setCellIsEdit(cell, 0);//       
            }
        }
        
        cell = st.getCell(i, "ccpri");
        if (null != cell) 
        {
            var detectPeriodValue = st.getCellStoreValue(i, "ccpri", "ccpri");
            if (detectPeriodValue == 255) 
            {
                st.setCellIsEdit(cell, 0);//       
            }
        }
        
        var nodeType = st.getCellStoreValue(i, "nodetype", "nodetype");//      
        cell = st.getCell(i, "sdthreshold");
        if (null != cell) 
        {
            if (nodeType != 3 && direction ==0) 
            {
                st.setCellIsEdit(cell, 0);//             
            }
        }
        
        cell = st.getCell(i, "sfthreshold");
        if (null != cell) 
        {
            if (nodeType != 3 && direction ==0) 
            {
                st.setCellIsEdit(cell, 0);//             
            }
        }
        
        cell = st.getCell(i, "reversetunnel");
        if (null != cell) 
        {
            if(direction ==0)
            {
            	cell.element.ondblclick = function()
	            {
	                xshowModalDialog("chooserevtunnel.html", RESOURCE["chooserevtunnel"], 645, 315, "../../../../../images/");
	            }
            }
            else
            {
            	st.setCellIsEdit(cell, 0);
            	st.getCellShow(i, "reversetunnel").element.innerHTML = INVALID_VALUE;
    			st.setCellValue(cell, "reversetunnel", 255);
            }
        }
        
        var direction = st.getCellStoreValue(i,"direction","direction");
        var lockstatus = st.getCellStoreValue(i,"lockstatus","lockstatus");
        if(typeof(lockstatus) == "undefined" || lockstatus == "" || lockstatus == "-1")
        {
        	st.setCellIsEdit(st.getCell(i,"lockstatus"), 0);
        	st.getCellShow(i, "lockstatus").element.innerHTML = INVALID_VALUE;
        }else{
        	if(direction == 0)
        	{
        		st.setCellIsEdit(st.getCell(i,"lockstatus"), 0);
			    st.getCellShow(i, "lockstatus").element.innerHTML = INVALID_VALUE;
        	}else{
        		st.setCellIsEdit(st.getCell(i,"lockstatus"), 1);
        	}
        }
        
        cell = st.getCell(i, "aisstatus");
        if (null != cell) 
        {
            if (direction == 0)
            {
                setCellDisable(i, cell, INVALID_VALUE, "aisstatus")
            }
        }
        
    	var tempIndex = st.getCellStoreValue(i, "lmmode", "lmmode");
        var lmmode = st.getCell(i, "lmmode");
        if (tempIndex == INVALID_VALUE||(SpecialAttrMgr.isNENotSupport(neid,"TE_FUNC_CFG_IPPTN_PW","TE_ATTR_PW_NOT_SUPPORT_LMMODE"))) 
        {    	
        	var cellShow = st.getCellShow(i, "lmmode");   
            cellShow.element.innerHTML = "-";        
            st.setCellIsEdit(lmmode, 0);
        }
        else
        {
            st.setCellIsEdit(lmmode, 1);
        }
        
    	var tempIndex = st.getCellStoreValue(i, "lockstatus", "lockstatus");
        var lockstatus = st.getCell(i, "lockstatus");
        if (tempIndex == INVALID_VALUE||(SpecialAttrMgr.isNENotSupport(neid,"TE_FUNC_CFG_IPPTN_PW","TE_ATTR_PW_NOT_SUPPORT_LOCKSTATUS"))) 
        {    	
        	var cellShow = st.getCellShow(i, "lockstatus");   
            cellShow.element.innerHTML = "-";        
            st.setCellIsEdit(lockstatus, 0);
        }
        else
        {
            st.setCellIsEdit(lockstatus, 1);
        }
    }
}

/**
 * "    "       
 * @param {Object} selectObj
 */
function detectModeChange(selectObj)
{
    
    var rowIndex = selectObj.parentNode.parentNode.rowIndex;
    var detectPeriodCell = st.getCell(rowIndex, "ccperiod");//      (ms)   
    
    if(st.getCellStoreValue(rowIndex, "direction", "direction")=="1")
    {
    	return;
    }
    if ("1" == selectObj.value  ) //                      
    {
        st.setCellIsEdit(detectPeriodCell, 0);
        st.getCellShow(rowIndex, "ccperiod").element.innerHTML = INVALID_VALUE;
        st.setCellValue(detectPeriodCell, "ccperiod", 255);
    }
    else 
    {
        st.getCellShow(rowIndex, "ccperiod").element.innerHTML = 1000;
        st.setCellValue(detectPeriodCell, "ccperiod", 255);
    }
}



/**
 *   Tunnel OAM  
 */
function doApplyMep()
{
    removejsDOMmenu();
    $("queryMepBtn").disabled = true;
    $("oambtn").disabled = true;
    $("applybtn").disabled = true;
    var xml = createApplyMpeXML("1");
    if(null == xml)
    {
        $("queryMepBtn").disabled = false;
        $("oambtn").disabled = false;
        $("applybtn").disabled = false;
    	return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_TUNNELMEP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, applyCallBack, null, "inputdata=" + xml);
}

/**
 *   OAM    
 * @param {Object} doc
 */
function applyCallBack(doc)
{
    $("queryMepBtn").disabled = false;
    $("oambtn").disabled = false;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = false;
    }
    refreshTableState(st, tableConfMep, data);
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var xml = createSetEnabledXML(enableState, "1");
    var rows = st.getSelectedRows();
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_CCENABLE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, setEnabledCallBack, param, "inputdata=" + xml);
}

/**
 *   LSP  
 * @param {Object} rows
 */
function doQueryLSPStat(rows)
{
    removejsDOMmenu();
    var xml = createQueryLSPStatXML(rows, "1");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_OAMSTATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryLSPStatCallBack, rows, "inputdata=" + xml);
}

/**
 * Ping        
 * @param {Object} rows
 */
function doPingTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("pingtest.html", RESOURCE["pingTestTitle"], 525, 540, "../../../../../images/");
}

function doTracerouteTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("traceroutetest.html", RESOURCE["pingTestTitle"], 525, 540, "../../../../../images/");
}

/**
 *   
 */
function doPrint()
{
    openPrintPage("../../../../../page/", "", "st");
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "tunnelindex";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/*
 *        
 */
function createjsDOMenu()
{
    createPopupMenu(st.getSelectedRows());
}

window.onresize = function()
{
	mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
	mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
    
}

function doCreateMip()
{
	removejsDOMmenu();
    xshowModalDialog("tunnel_mplstp_oam_crtmip.html", RESOURCE["pingTestTitle"], 525, 180, "../../../../../images/", false);
}


function getExistTunnelID()
{
	var tunnelID = [];
	for(var i = 0,len = mipst.getDataRowLength();i < len;i++)
	{
		tunnelID[i] = mipst.getCellStoreValue(i,"tunnelid","tunnelid");
	}
	return tunnelID;
}
