var ct = null;
var st = null;

loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
	
var win = ((SYSTEMCONF.getStatus() == '0') ? window.dialogArguments : getParentWindow());
var neid = win.neid;
var nmUser = win.nmUser;
var indexName = "tunnelindex";//Index     (  pwIndex tunnelindex )
var idName = "tunnelid";//id    (  pwID,tunnelid )
var idNameRes = "tunnelidPing";//id    (  pwID,tunnelid )
var START_TRACEROUTE = TE_CMD_MPLSTUNNEL_LSPTRACEROUTE;//  Traceroute      
var NOTIFY_TRACEROUTE_STAT = TECMDCODE_NF_PTN_L3VPN_NTF_TRACEROUTE;//  Traceroute        
var STOP_TRACEROUTE = win.STOP_PING;//  Traceroute      
var TEST_TYPE = "traceroute";//     LSP Traceroute
var intervalID = 0;//     
var idValue;//    Tunnel PW ID 
var TRACEROUTE_RESULT_ATTR = ["lsrId", "time", "nodetype", "downstreamlsrid", "downstreamlabel", "ttl"];
var TRACEROUTE_TIMEOUT_ATTR = [];
var TRACEROUTE_STATISTIC_ATTR = ["sendNum", "revNum", "lostPer", "minTimeout", "maxTimeout", "averageTimeout"];
var isTesting = false;//       

var isSuppNewPackageLength = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_MPLS_PING_AND_TRACEROUTE", "TE_ATTR_MPLS_SUPPORT_NEW_PACKAGELENGTH");

function init()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    atom = new Atom("text");
    atom.setValue("7");
    checkText(atom.element, "0", "7");
    ct.addAttrRow("expValue", RESOURCE["expValue"], atom);
    
    atom = new Atom("text");
    atom.setValue("255");
    checkText(atom.element, "1", "255");
    ct.addAttrRow("ttl", RESOURCE["TTL"], atom);
    
    if(isSuppNewPackageLength)
    {
    	atom = new Atom("text");
        atom.setValue("100");
        checkText(atom.element, "89", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
    }
    else
    {
    	atom = new Atom("text");
        atom.setValue("84");
        checkText(atom.element, "84", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
    }
    
    atom = new Atom("text");
    atom.setValue("300");
    checkText(atom.element, "1", "6000");
    ct.addAttrRow("replyTimeout", RESOURCE["replyTimeout"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["noreply"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["udpreply"], "2");
    
    var nevs = win.winobj.neversion.split('.');
    var neType = win.winobj.neType;
    if(isRTN900NEtype(neType))
    {
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["apctlchlreply"], "4");
    }
    
    atom.element.selectedIndex = 1;
    ct.addAttrRow("replyModel", RESOURCE["replyModel"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
    
    $("starttest").value = RESOURCE["startTest"];
    $("stoptest").value = RESOURCE["stopTest"];
    $("stoptest").disabled = true;
    $("testResultShow").innerHTML = RESOURCE["testResult"];
    
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("testResultTable").appendChild(st.getTable());
}


function createStartXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    rowparams.appendChild(createTagElement("expValue", ct.getAtom("expValue").getValue()));
    rowparams.appendChild(createTagElement("ttl", ct.getAtom("ttl").getValue()));
    rowparams.appendChild(createTagElement("replyModel", ct.getAtom("replyModel").getValue()));
    rowparams.appendChild(createTagElement("packageLength", ct.getAtom("packageLength").getValue()));
    rowparams.appendChild(createTagElement("replyTimeout", ct.getAtom("replyTimeout").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStartTest()
{
    $("starttest").disabled = true;
    $("stoptest").disabled = true;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    idValue = win.st.getCellStoreValue(selectedPw[0], idName, idName);
    var xml = createStartXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + START_TRACEROUTE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, startCallBack, null, "inputdata=" + xml);
}

function startCallBack(doc)
{
	var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        $("stoptest").disabled = false;
        $("testresult").innerHTML = "";
        st.clearTableData();
        intervalID = setInterval(refreshTracerouteResult, 1000);
        isTesting = true;
    }
    else 
    {
        $("starttest").disabled = false;
        isTesting = false;
    }
}

function createRereshXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshTracerouteResult()
{
	var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createRereshXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + NOTIFY_TRACEROUTE_STAT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
}

function refreshBackHandler(doc)
{
    var data = EncapsulateData(doc);
	var tc = window.tableconf[0];
    if (st.element.isAppendEmptyTr) 
    {
        var tBody = st.bodyPack.firstChild.lastChild;
        tBody.removeChild(tBody.firstChild);
        st.element.isAppendEmptyTr = false;
    }

    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var eventType = data.getDataRowParam(i, "eventType");
    	if(eventType != "2")
    	{
    		var row = st.createRow();
    		
    		for (var j = 0,size = tc.getColsLength(); j < size; j++) 
    		{
    			var colid = tc.getColId(j);
                var cell = st.createCell(st.getHeadCell(colid).element.refreshWidth);
                cell.colid = colid;
                st.setCellIsEdit(cell, tc.getIsEdit(j));
                var atom = st.createAtom(tc.getColShowType(j));
                var value = data.getDataRowParam(i, tc.getColKeyArray(j)[0].getName());
                var conv = tc.getColKeyArray(j)[0].getConvert();
        		if (conv && RESOURCE[conv + "_" + value] != null)
        		{
        			value = RESOURCE[conv + "_" + value];
        		}
        		st.setCellValue(cell, colid, value);
                atom.setValue(value);
                st.addCellShow(cell, atom);
                st.addCell(row, colid, cell);
    		}
    		 st.addRow(row);
    		 st.adjustLayout(window.tableconf[0]); //    
    	}
    	else
    	{
    		var eventTypeRes = RESOURCE["splitStr"] + " " + RESOURCE[TEST_TYPE] + RESOURCE["eventType_" + eventType] + " " + RESOURCE["splitStr"];
            clearInterval(intervalID);
            var showInfo = getShowInfo(data, i, TRACEROUTE_STATISTIC_ATTR, eventType);
            $("starttest").disabled = false;
            $("stoptest").disabled = true;
            isTesting = false;
            
            if (showInfo != "") 
            {
                if (!document.getElementById("stopedByBtn"))
                {
                    var e = document.createElement("div");
                    e.align = "left";
                    e.id = "stoped";
                    e.innerHTML = showInfo;
                }
                $("testresult").appendChild(e);
            }
    	}
    }
}

function getShowInfo(data, index, attrArr, eventtype)
{
    var endRes = RESOURCE["splitStr"] + " " + RESOURCE[TEST_TYPE] + " " + RESOURCE["tracerouteend"] + " " + RESOURCE["splitStr"];
    return endRes + "<br/>";
}


function createStopXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStopTest()
{
    $("stoptest").disabled = true;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createStopXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + STOP_TRACEROUTE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, stopCallBack, null, "inputdata=" + xml);
}

function stopCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        clearInterval(intervalID);
        $("starttest").disabled = false;
        $("stoptest").disabled = true;
        
        /**
         *                    test            
         *                                 
         */            
        if (!document.getElementById("stoped"))
        {
            var endRes = RESOURCE["splitStr"] + " " + RESOURCE[TEST_TYPE] + " " + RESOURCE["tracerouteend"] + " " + RESOURCE["splitStr"];
            var e = document.createElement("div");
            e.align = "left";
            e.id = "stopedByBtn"
            e.innerHTML = endRes;
            $("testresult").appendChild(e);
        }
        isTesting = false;
    }
    else 
    {
        $("stoptest").disabled = false;
        isTesting = true;
    }
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *           
 */
if(SYSTEMCONF.getStatus() == '0') 
{
    window.onbeforeunload = actionOnBeforeUnload;
} else {
    win.subModelWins['ev_onClose'] = null;
    win.subModelWins.attachEvent('onClose', actionOnBeforeUnload);
}

function actionOnBeforeUnload()
{
    if (isTesting) 
    {
        if (confirm(RESOURCE["stopTestTips"])) 
        {
            doStopTest();
            
            if(SYSTEMCONF.getStatus() == '1')
            {
                
                return true;
            }
        } else {
            if(SYSTEMCONF.getStatus() == '1')
            {
                return false;
            }    
            
            return ""; //              
        }
    }
    
    if(SYSTEMCONF.getStatus() == '1')
    {
        return true;
    }
}
