var st = null;
var countObj = null;
var portRes = null;

var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var neversion = winobj.neversion;
var enableStatus = new Array();
enableStatus[0] = "disabled";
enableStatus[1] = "enabled";

var nodeType = new Array();
nodeType[1] = "ingress";
nodeType[2] = "transit";
nodeType[3] = "egress";

var directionType = new Array();
directionType[0] = "unidirectional";
directionType[1] = "bidirectional";

var tunnelType = new Array();
tunnelType[0] = "elsp";
tunnelType[1] = "llsp";

var exp = new Array();
exp[0] = "exp0";
exp[1] = "exp1";
exp[2] = "exp2";
exp[3] = "exp3";
exp[4] = "exp4";
exp[5] = "exp5";
exp[6] = "exp6";
exp[7] = "exp7";
exp[255] = "exp255";

var lspmode = new Array();
lspmode[1] = "Uniform";
lspmode[2] = "Pipe";

var isSupportTunnelLimitFlag = isSupportTunnelLimit();
var isSupportPirEditFlag = isSupportPirEdit();

function isSupportTunnelLimit()
{
	return SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_TUNNEL_BANDLIMIT", "RTN_ATTR_SUPPORT_TUNNEL_BANDLIMIT");
}

function isSupportPirEdit()
{
	return SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_TUNNEL", "TE_ATTR_SUPPORT_TUNNEL_PIR_EDIT");
}

function init()
{
    initTable();
    initCountObj();
    initButton();
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    tabSelectHandler();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
	if(!isSupportTunnelLimitFlag)
	{
		var col = window.tableconf[0].getColFromColId("tunnelBandwidthLimitEnable");
		if(null != col)
		{
			col.width = "0";
		}	
	}
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    st.element.oncontextmenu = popupMenuHandler;
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
	$("modifybtn").value = RESOURCE["modifybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("printbtn").value = RESOURCE["printbutton"];
    
    /**
     *          tunnel               
     
 	* 
 	*/
}

function createjsDOMenu()
{
    removejsDOMmenu();
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") {
        menuSize = 200;
    }
    var cursorMenu1 = new jsDOMenu(menuSize);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["unitunnel"], "", doCreate, "", ""));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["bitunnel"], "", doCreateBitTunnel, "", ""));
    setPopUpMenu(cursorMenu1);
}

function doCreateBitTunnel()
{
	removejsDOMmenu();
	getPortRes();
    if (portRes.length <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }
    xshowModalDialog("createbicasttunnel.html", RESOURCE["createbicasttunnel"], 650, 670, "../../../../../images/");
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_MPLSTUNNEL_QUERY_P2PTUNNEL);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_CMD_MPLSTUNNEL_DEL_P2PTUNNEL);
	btnRightArr.modifybtn = new BtnRightObj("modifybtn", TE_CMD_MPLSTUNNEL_DEL_P2PTUNNEL);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_MPLSTUNNEL_SET_P2PTUNNEL);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
		$("modifybtn").disabled = !btnRightArr.modifybtn.right;
    }
    else 
    {
        $("deletebtn").disabled = true;
		$("modifybtn").disabled = true;
    }
}

function cellEditHandler(param)
{
    if ((param.colid == "bandwidth" || param.colid == "pir")) 
    {
        var opsary = getDataArr();
        dm = st.getCellEdit(param.rowindex, param.colid).element.parent;
        dm.selview.options.length = 0;
        dm.initComboBox(opsary, "dm", 0, true);
        var textview = dm.txtview;
        textview.onkeypress = keypressHandler;
        textview.onkeyup = keyupHandler;
        textview.onblur = onblurHandler;
        textview.style.imeMode = "disabled";
        textview.onpaste = function()
        {
            return false;
        };
        textview.maxLength = 10;
    }
    
    if ((param.colid == "vlanid") && (param.stage == TABLE_CONSTANT.BEFOREEDIT)) 
    {
        var elem = st.getCellEdit(param.rowindex, param.colid).element;
        elem.value = "";
        elem = st.getCellShow(param.rowindex, param.colid).element;
        elem.innerText = "";
    }
    
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
	$("modifybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_QUERY_P2PTUNNEL + "&nmUser=" + nmUser;
	LoadingProcess.showWaitStatus("../../../../../images/");
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
	
	LoadingProcess.removeWaitStatus();
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("tunnelid").element;
        st.sortRows(ce, 1);
    }
	
	for (var i = 0; i < st.getDataRowLength(); i++)
	{
		if (isSupportTunnelLimitFlag)
		{
            var tunnelBandwidthLimitEnable = st.getCellStoreValue(i, "tunnelBandwidthLimitEnable", "tunnelBandwidthLimitEnable");
			if(tunnelBandwidthLimitEnable == undefined || tunnelBandwidthLimitEnable == null)
			{
				var cell = st.getCell(i, "tunnelBandwidthLimitEnable");
				cell.element.showElement.setValue("-");
            	st.setCellIsEdit(cell, 0);
			}
		}
	}	
    addCellListener();
}

function addCellListener()
{
	var bNotEditVlanid = isNotSupportVlanId();
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var cell = st.getCellElement(i, "name");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
        var nType = parseInt(st.getCellCurrentValue(i, "nodetype", "nodetype"));
        switch (nType)
        {
            case NODE_TYPE_EGRESS:
            	var direction = parseInt(st.getCellCurrentValue(i, "direction", "direction"));
            	
            	if (direction == 0)
                {
                    cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 0);
      			    st.setCellValue(cell, "bandwidth", INVALID_VALUE);
                    cell.element.showElement.element.innerHTML = "-";
                      
                    cell = st.getCell(i, "bandwidthremain");
                    cell.element.showElement.element.innerHTML = "-";
                }
            	else
            	{
            	    cell = st.getCell(i, "bandwidth");
                    st.setCellIsEdit(cell, 1);
                    var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                    if (bw == 0) 
                    {
                        cell.element.showElement.element.innerHTML = RESOURCE["nolimit"];
                        st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                    }
                    else
                    {
                        st.setCellValue(cell, "bandwidth", bw);
                        cell.element.showElement.element.innerHTML = bw;  
                        st.getCellShow(i, "bandwidthremain").element.innerHTML = bw;
                    }
            	}
                
                cell = st.getCell(i, "outport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "outlabel");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "nexthopaddr");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "snknode");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "vlanid");
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                
                 cell = st.getCell(i, "exp");
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                
                 cell = st.getCell(i, "enablestatus");
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                break;
            case NODE_TYPE_TRANSIT:
            	
            	var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                cell = st.getCell(i, "enablestatus");
                st.setCellIsEdit(cell, 0);
                st.setCellValue(cell, "enablestatus", 1);
                cell.element.showElement.element.innerHTML = RESOURCE["enabled"];
                
                cell = st.getCell(i, "exp");
                st.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                cell = st.getCell(i, "vlanid");
                
                if (bNotEditVlanid)  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
                	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, 1, 4094);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, 1, 4094);
                    }
                }
                
                cell = st.getCell(i, "lspmode");
                st.setCellIsEdit(cell, 0);
                cell.element.showElement.element.innerHTML = "-";
                
                break;
            case NODE_TYPE_INGRESS:
                var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
                if (bw == 0) 
                {
                    st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                    st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
                }
                
                cell = st.getCell(i, "inport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "inlabel");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = st.getCell(i, "srcnode");
                cell.element.showElement.element.innerHTML = "-";
                
                 cell = st.getCell(i, "lspmode");
                cell.element.showElement.element.innerHTML = "-";
                st.setCellIsEdit(cell, 0);
                
                cell = st.getCell(i, "vlanid");
                
                if (bNotEditVlanid)  //V1R1      VLANID   
                {
                	cell.element.showElement.element.innerHTML = "-";
                	st.setCellIsEdit(cell, 0);
                }
                else
                {
                	var vlanId = st.getCellCurrentValue(i, "vlanid", "vlanid");
                	if (vlanId == null || INVALID_VLAN_ID == parseInt(vlanId)) 
               		{
                    	cell.element.showElement.element.innerHTML = "/";
                    	textCheck(cell.element.editElement.element, 1, 4094);
               	    }
               	    else
                    {
                	    cell.element.showElement.element.innerHTML = vlanId;
                	    textCheck(cell.element.editElement.element, 1, 4094);
                    }
                }
                break;
            default:
                break;
        }
        
        var apsId = st.getCellCurrentValue(i, "apsid", "apsid");
        if (apsId == null) 
        {
            st.getCellShow(i, "apsid").element.innerHTML = "-";
        }
    }
}
function textCheck(obj, min, max, decimalCount,othervalue)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
		return false;
	}
	obj.onblur = function()
	{
		if (obj.value != "")
		{
			numCellOnBlur(obj, min, max, decimalCount,othervalue);
		}
		else
		{
			emptyCellOnBlur(obj);
		}
	}
	obj.onkeypress = function()
	{
		if (obj.value != "")
		{
			return digitalCheck(obj, min, max, decimalCount,othervalue,event);
		}
		else
		{
			return true;
		}
	}
}
function emptyCellOnBlur(obj)
{
	var hc = obj.parentNode.parent.getHeadCell(obj.parentNode.colid);
	var pnode = obj.parentNode;
	
	obj.style.position = "static";
	obj.style.border = "1px solid #999999";
	obj.style.width = obj.parentNode.offsetWidth;
	var rows = obj.parentNode.parent.getSelectedRows();
	for ( var j = 0; j < rows.length; j++)
	{
		var cell = pnode.parent.getCell(rows[j], pnode.colid);

		if (null == cell.element.editElement || cell.element.isEdit == 0)
		{
			continue;
		}
		cell.element.showElement.setValue(obj.value);

		cell.element.modify = true;
		cell.element.parentNode.modify = true;
		cell.element.style.backgroundColor = "#d0f946";
		cell.element.parent.setTdCellValue(cell.element, pnode.colid,
					obj.value);
		cell.element.showElement.element.style.display = "";

		handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
	}
		
	pnode.removeChild(pnode.lastChild);
	pnode.showElement.element.style.display = "";
	handleCellEdit(pnode, TABLE_CONSTANT.AFTEREDIT);
}
function doCreate()
{
	removejsDOMmenu();
    getPortRes();
    if (portRes.length <= 0) 
    {
        alert(RESOURCE["noportres"]);
        return;
    }
    xshowModalDialog("createunicasttunnel.html", RESOURCE["createunicasttunnel"], 650, 650, "../../../../../images/");
}

function createGetPortResXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getPortRes()
{
    var xml = createGetPortResXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVAILABLEPORT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, portResCallBack, null, "inputdata=" + xml);
}

function portResCallBack(doc)
{
    portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = portObj;
    }
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("tunnelid", st.getCellCurrentValue(indexes[i], "tunnelid", "tunnelid")));
        rowparams.appendChild(createTagElement("nodetype", st.getCellCurrentValue(indexes[i], "nodetype", "nodetype")));
        rowparams.appendChild(createTagElement("tunnelindex", st.getCellCurrentValue(indexes[i], "tunnelindex", "tunnelindex")));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["confirminfo"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
	$("modifybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_DEL_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObjStr";
    
    var oError = data.getError();
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = oError.getRowKey(i, "nename");
        var tunnelIndex = oError.getRowKey(i, "tunnelindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tunnel = st.getCellCurrentValue(indexes[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tunnel) 
            {
                tempErrObjStr += "-" + st.getCellCurrentValue(indexes[j], "tunnelid", "tunnelid");
                indexes.splice(j, 1);
                break;
            }
        }
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getDataRowLength() > 0) 
    {
        for (var i = 0, m = data.getBErrLength(); i < m; i++) 
        {
            if (st.getModify(i)) 
            {
                $("applybtn").disabled = !btnRightArr.applybtn.right;
                break;
            }
        }
        if (st.getSelectedRowCount() <= 0) 
        {
            st.setRowSelect(0);
        }
    }
    rowSelectHandler();
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("tunnelid", st.getCellCurrentValue(i, "tunnelid", "tunnelid")));
        row.appendChild(createTagElement("nodetype", st.getCellCurrentValue(i, "nodetype", "nodetype")));
        row.appendChild(createTagElement("autoassign", 0));
        row.appendChild(createTagElement("tunnelindex", st.getCellCurrentValue(i, "tunnelindex", "tunnelindex")));
        if (st.getCellModify(i, "name")) 
        {
            row.appendChild(createTagElement("name", st.getCellCurrentValue(i, "name", "name")));
        }
        if (st.getCellModify(i, "enablestatus")) 
        {
            row.appendChild(createTagElement("enablestatus", st.getCellCurrentValue(i, "enablestatus", "enablestatus")));
        }
        if (st.getCellModify(i, "bandwidth")) 
        {
            /**
             *       SortTable     BUG      storyvalue         
             *           ,             
             */
            var bandwidth = st.getCellShow(i, "bandwidth").element.innerText;
            row.appendChild(createTagElement("bw", bandwidth));
            row.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
			
            if(!isSupportPirEditFlag)
    		{
				row.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
    		}
        }
        if (st.getCellModify(i, "exp")) 
        {
            row.appendChild(createTagElement("exp", st.getCellCurrentValue(i, "exp", "exp")));
        }
         if (st.getCellModify(i, "lspmode")) 
        {
            row.appendChild(createTagElement("lspmode", st.getCellCurrentValue(i, "lspmode", "lspmode")));
        }
        if (st.getCellModify(i, "vlanid")) 
        {
        	var vlanid = st.getCellCurrentValue(i, "vlanid", "vlanid");
        	if (vlanid == "")
        	{
        		vlanid = INVALID_VLAN_ID;
        	}
            row.appendChild(createTagElement("vlanid", vlanid));
        }
		
		if(isSupportTunnelLimitFlag)
		{
			if (st.getCellModify(i, "tunnelBandwidthLimitEnable"))
			{
				row.appendChild(createTagElement("tunnelBandwidthLimitEnable", st.getCellCurrentValue(i, "tunnelBandwidthLimitEnable", "tunnelBandwidthLimitEnable")));
			}
		}
		
		if(isSupportPirEditFlag)
		{
			if (st.getCellModify(i, "pir"))
			{
				var bandwidth = st.getCellShow(i, "bandwidth").element.innerText;
	            row.appendChild(createTagElement("bw", bandwidth));
	            row.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
				var pir = st.getCellShow(i, "pir").element.innerText;
				row.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
			}
		}
		
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
	$("modifybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_SET_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        if (st.getCell(i, "bandwidth").element.isEdit && !st.getCellModify(i, "bandwidth")) 
        {
            var bandwidth = st.getCellCurrentValue(i, "bandwidth", "bandwidth");
            var bw = isNaN(bandwidth) ? 0 : parseInt(bandwidth);
            var bwused = parseInt(st.getCellCurrentValue(i, "bandwidthused", "bandwidthused"));
            if (bw != 0) 
            {
                st.getCellShow(i, "bandwidthremain").element.innerHTML = bw - bwused;
            }
            else 
            {
				st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
            }
        }
        
        if(isSupportPirEditFlag && st.getCell(i, "pir").element.isEdit && !st.getCellModify(i, "pir"))
        {
        	 var pir = st.getCellCurrentValue(i, "pir", "pir");
             var pirvalue = isNaN(pir) ? 0 : parseInt(pir);
             if(pirvalue == 0)
             {
            	 st.getCellShow(i, "pir").element.innerHTML = RESOURCE["nolimit"];
             }
        }
    }
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    if (st.getSelectedRowCount() > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
		$("modifybtn").disabled = !btnRightArr.modifybtn.right;
    }
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function doPrint()
{
    if (st.getDataRowLength() <= 0) 
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    
    openPrintPage("../../../../../page/", RESOURCE["statictunnel"], "st");
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "errObjStr";
    
    var oError = data.getError();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = oError.getRowKey(i, "nename");
        var tunnelIndex = oError.getRowKey(i, "tunnelindex");
        for (var j = 0, n = st.getDataRowLength(); j < n; j++) 
        {
            var tunnel = st.getCellCurrentValue(j, "tunnelindex", "tunnelindex");
            if (tunnelIndex == tunnel) 
            {
                tempErrObjStr += "-" + st.getCellCurrentValue(j, "tunnelid", "tunnelid");
                break;
            }
        }
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function setOptionValue(param)
{
    var showtext = param[0];
    var txtvalue = param[1];
    var elem = param[2];
    var colid = elem.colid;
    
    var rows = elem.parent.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var cell = elem.parent.getCell(rows[i], colid);
        if (cell.element.isEdit == 0) 
        {
            continue;
        }
        elem.parent.setCellValue(cell, colid, txtvalue);
        var showElement = cell.element.showElement;
        cell.element.modify = true;
        cell.element.parentNode.modify = true;
        cell.element.style.backgroundColor = "#d0f946";
        handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
        if (showElement.type == 'span' || showElement.type == 'text') 
        {
            if (colid == "bandwidth") 
            {
                showElement.element.innerText = txtvalue;
            }
            else 
            {
                showElement.element.innerText = showtext;
            }
        }
        else if (showElement.type == 'select') 
        {
            var options = showElement.element.options;
            for (var j = 0; j < options.length; j++) 
            {
                if (options[j].value == txtvalue) 
                {
                    showElement.element.selectedIndex = j;
                    break;
                }
            }
        }
        if (cell.element.editElement.element.onchange) 
        {
            cell.element.editElement.element.value = txtvalue;
            cell.element.editElement.element.onchange();
        }
    }
}

/**
 * RTN910 RTN950 V1R1         PNP        
 */
function isNotSupportVlanId()
{
	var neType = winobj.neType;
	var vers = neversion.split(".");
	
	if((neType == "76" || neType == "77") && ((vers[2] + "." + vers[3]) < "02.10"))
	{
		return true;
	}
	if(SpecialAttrMgr.isNESupport(winobj.neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTEDIT_VLANID"))
	{
		return true;
	}
	return false;
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
