var direction = [];
direction[0] = "unidirectional";
direction[1] = "bidirectional";
var signalType = [];
signalType[1] = "static";
signalType[2] = "dynamic";
var exp = [];
exp[0] = "exp0";
exp[1] = "exp1";
exp[2] = "exp2";
exp[3] = "exp3";
exp[4] = "exp4";
exp[5] = "exp5";
exp[6] = "exp6";
exp[7] = "exp7";
exp[255] = "None";
exp[-1] = "-";

var direction = [];
direction[0] = "unidirectional";
direction[1] = "bidirectional";

var nodeType = [];
nodeType[1] = "Ingress";
nodeType[3] = "Egress";

var PW_INFO_TABLE_TUNEL_INDEX = 9;//        "Tunnel"  
var PW_INFO_TABLE_LSRID_INDEX = 10;// PW      "  LSR ID"  
var PW_INFO_TABLE_OPTUNEL_INDEX = 11;// "  Tunnel"  
var NODE_TYPE_INGRESS = 1;//ingress  
var NODE_TYPE_EGRESS = 3;//egress  
var nePro = getNeProperty(self);
var st = null;

var win = getParentWindow();
if (!isIE) 
{
    win = win.frames[1];
}
var neid = win.neid;
var nmUser = win.nmUser;

var tunnelType = parseInt(nePro.tunnelType);
loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
loadXMLdoc("../../conf/mpls/mspw/selecttunneltable_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);

function init()
{
    initTable();
    initButton();
    queryTunnelData();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setSingleChoiceFlg(true);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    if(nePro["rowid"] == PW_INFO_TABLE_OPTUNEL_INDEX)
    {
        rowparams.appendChild(createTagElement("nodetype", NODE_TYPE_EGRESS)); 
    }
    else
    {
        rowparams.appendChild(createTagElement("nodetype", NODE_TYPE_INGRESS));
    }
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryTunnelData()
{
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, initTunnelData, null, "inputdata=" + xml);
}

function initTunnelData(doc)
{
    var data = EncapsulateData(doc);
    /*
    if(nePro["rowid"] == PW_INFO_TABLE_OPTUNEL_INDEX)
    {
        handleShowData(data);
    }*/
     for(var i = 0, size = data.getDataRowLength(); i < size; i++)
     {
     	 var tunnelname = data.getDataRowParam(i, "name");
     	 var newObj = new Object();
     	 newObj.value = tunnelname;
     	 newObj.options = null;
     	 data.rows[i]["tunnelname"] = newObj;
     }
     
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    for(var i = 0, size = st.getDataRowLength(); i < size; i++)
    {
        var row = st.getRow(i);
        row.element.ondblclick = rowOndbclick;//            
    }
}

/**
 *            inputport outputport           
 * @param data
 * @return
 */
function handleShowData(data)
{
    for(var i = 0, size = data.getDataRowLength(); i < size; i++)
    {
        var inslotid = data.getDataRowParam(i, "inslotid");
        var inboardname = data.getDataRowParam(i, "inboardname");
        var inportname = data.getDataRowParam(i, "inportname");
        data.rows[i]["outslotid"].value = inslotid;
        data.rows[i]["outboardname"].value = inboardname;
        data.rows[i]["outportname"].value = inportname;
        
        var srcNode = data.getDataRowParam(i, "srcnode");
        var snkNode = data.getDataRowParam(i, "snknode");
       
        data.rows[i]["srcnode"].value = snkNode;
        data.rows[i]["snknode"].value = srcNode;
        
    }
}

function rowOndbclick()
{
    doSelect();
}


function doSelect()
{
    var selectedRows = st.getSelectedRows();
    var tunnelStr = "";
    var tunnelIndex = "";
    var sinkNodeIP = "0.0.0.0";
    var sourceNode = 0;
    var sinkNode = 0;
    var sourceNodeIP = "0.0.0.0";
    var direction = "";
    var nodeType = "";

    if (selectedRows.length > 0) 
    {
        tunnelIndex = st.getCellStoreValue(selectedRows[0], "tunnelindex", "tunnelindex");
        var tunnId = st.getCellStoreValue(selectedRows[0], "tunnelid", "tunnelid");
        var tunnelName = st.getCellStoreValue(selectedRows[0], "tunnelname", "tunnelname");
        if(tunnelName != null && tunnelName != "")
        {
            tunnelStr = tunnId + "(" + tunnelName + ")";
        }
        else
        {
            tunnelStr = tunnId + "(" + RESOURCE["nonevalue"] + ")";
        }
        sourceNode = st.getCellStoreValue(selectedRows[0], "srcnode", "srcnode");
        sourceNodeIP = st.getCellShow(selectedRows[0], "srcnode").element.innerHTML;
     
        sinkNode = st.getCellStoreValue(selectedRows[0], "snknode", "snknode");
        sinkNodeIP = st.getCellShow(selectedRows[0], "snknode").element.innerHTML;
        direction  = st.getCellStoreValue(selectedRows[0], "direction", "direction");
        nodeType = st.getCellStoreValue(selectedRows[0], "nodetype", "nodetype");
    }
    
     

    if(direction == "1")
    {
    	var ingresstunnelCell = win.pwinfotable.getCell(PW_INFO_TABLE_TUNEL_INDEX, nePro["colid"]);
    	var egresstunnelCell = win.pwinfotable.getCell(PW_INFO_TABLE_OPTUNEL_INDEX, nePro["colid"]);
    	win.pwinfotable.getCellShow(PW_INFO_TABLE_TUNEL_INDEX, nePro["colid"]).element.innerHTML = tunnelStr;
    	win.pwinfotable.getCellShow(PW_INFO_TABLE_OPTUNEL_INDEX, nePro["colid"]).element.innerHTML = tunnelStr;
    	win.pwinfotable.setCellValue(ingresstunnelCell, nePro["colid"], tunnelIndex);
    	var lsridCell = win.pwinfotable.getCell(PW_INFO_TABLE_LSRID_INDEX, nePro["colid"]);
    	if(nodeType == 1)
    	{
      win.pwinfotable.setCellValue(lsridCell, nePro["colid"], sinkNode);
      win.pwinfotable.getCellShow(PW_INFO_TABLE_LSRID_INDEX, nePro["colid"]).element.innerHTML = sinkNodeIP; 
      }
      else 
      {
      win.pwinfotable.setCellValue(lsridCell, nePro["colid"], sourceNode);
      win.pwinfotable.getCellShow(PW_INFO_TABLE_LSRID_INDEX, nePro["colid"]).element.innerHTML = sourceNodeIP; 
      }
      srcNode = st.getCellStoreValue(selectedRows[0], "srcnode", "srcnode");
      var value = tunnelIndex + "-" + sinkNode + "-" + srcNode;
      win.pwinfotable.setCellValue(egresstunnelCell, nePro["colid"], value);
    }  
   else if(nePro["rowid"] == PW_INFO_TABLE_TUNEL_INDEX)
    {
         var tunnelCell = win.pwinfotable.getCell(nePro["rowid"], nePro["colid"]);
   		  win.pwinfotable.getCellShow(nePro["rowid"], nePro["colid"]).element.innerHTML = tunnelStr;
        win.pwinfotable.setCellValue(tunnelCell, nePro["colid"], tunnelIndex);
        var lsridCell = win.pwinfotable.getCell(PW_INFO_TABLE_LSRID_INDEX, nePro["colid"]);
        win.pwinfotable.setCellValue(lsridCell, nePro["colid"], sinkNode);
        win.pwinfotable.getCellShow(PW_INFO_TABLE_LSRID_INDEX, nePro["colid"]).element.innerHTML = sinkNodeIP; 
    }
    else//  Tunnel     lsrid         Tunnel egressid  
    {
        var tunnelCell = win.pwinfotable.getCell(nePro["rowid"], nePro["colid"]);
    		win.pwinfotable.getCellShow(nePro["rowid"], nePro["colid"]).element.innerHTML = tunnelStr;
        srcNode = st.getCellStoreValue(selectedRows[0], "srcnode", "srcnode");
        var value = tunnelIndex + "-" + sinkNode + "-" + srcNode;
        win.pwinfotable.setCellValue(tunnelCell, nePro["colid"], value);
    }
    
    xcloseDialog();
}

function convertBandwidth(param)
{
    if (parseInt(param) == 0) 
    {
        return RESOURCE["nolimit"];
    }
    return param;
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
