var st = null;
var Tab = null;
var tableConf = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var realRouteData = null;

var enableState = new Array();
enableState[0] = "disabled";
enableState[1] = "enabled";

var rsvforbindingConv = new Array();
rsvforbindingConv[0] = "bind";
rsvforbindingConv[1] = "unbind";

var nodeType = new Array();
nodeType[1] = "ingress";
nodeType[2] = "transit";
nodeType[3] = "egress";

var direction = new Array();
direction[0] = "unidirectional";
direction[1] = "bidirectional";

var protype = new Array();
protype[0] = "protecttype_0";
protype[1] = "protecttype_1";

var schedutype = new Array();
schedutype[0] = "elsp";
schedutype[1] = "llsp";

var exp = new Array();
exp[0] = "exp0";
exp[1] = "exp1";
exp[2] = "exp2";
exp[3] = "exp3";
exp[4] = "exp4";
exp[5] = "exp5";
exp[6] = "exp6";
exp[7] = "exp7";
exp[255] = "exp255";

var cosType = new Array();
cosType[1] = "BE";
cosType[2] = "AF1";
cosType[3] = "AF2";
cosType[4] = "AF3";
cosType[5] = "AF4";
cosType[6] = "EF";
cosType[7] = "CS6";
cosType[8] = "CS7";
cosType[255] = "-";

var runningState = new Array();
runningState[0] = "UP";
runningState[1] = "Down"
runningState[2] = "Fail";
runningState[3] = "Partial up";
runningState[255] = "Invalid";

var tunneltype = new Array();
tunneltype[0] = "tunneltype_0";
tunneltype[1] = "tunneltype_1";

var currentSelectRow = -1;
var isTableRefreshed = false;

var INDEX_ATTR_NAME = "tunnelindex";
var INDEX_ATTR_ID_NAME = "tunnelid";
var INDEX_ATTR_ID_RES_NAME = "tunnelidPing";
var TEST_TYPE = "lspPing";//     LSP Ping
var START_PING = TE_CMD_MPLSTUNNEL_LSPPING;//  LSP Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//  Ping        
var STOP_PING = TE_IPPTN_STOP_PWPING;//  Ping      

var countObj = null;

var isSupportEth = false;

var AUTOOPTPERIOD_MIN=60;
var AUTOOPTPERIOD_MAX=604800;

/**
 *      
 * @param  
 * @return  
 */
function initPage()
{ 	
	   isSupportEth = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_RSVP_TUNNEL_MGR", "TE_ATTR_RSVP_TUNNEL_AUTOOPTINFO");	
	   if(isSupportEth == false)
	   {	
		   var autoopten = window.tableconf[0].getColFromColId("autoopten");
		   autoopten.setWidth("0");
		   var autooptperiod = window.tableconf[0].getColFromColId("autooptperiod");
		   autooptperiod.setWidth("0");
		   var autooptperiod = window.tableconf[0].getColFromColId("rsvforbinding");
		   autooptperiod.setWidth("0");
	   }
	

	
    initTable();
    initCountObj();
    initButton();
    initTabs();
    initRight();
    if (btnRightArr.querybtn.right) 
    {
        timeoutQuery();
    }
}

/**
 **        
 **/
function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

/**
 *            Tab        
 * @param  
 * @return  
 */
function timeoutQuery()
{
    var tabWin = Tab.getTabWindow(1);
    if(tabWin && tabWin.document && tabWin.loadXMLdoc && tabWin.document.body)
    {
        doQuery();
    }
    else
    {
        window.setTimeout(timeoutQuery, 500);//    
    }

}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    tableConf = window.tableconf[0];
    createTableHead(st, tableConf);
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
    st.setBodyWidth(tableConf.width, tableConf.percent, 0);
    st.setOnCellEditHandler(cellEditHandler);
    st.setOnRowSelectHandler(rowSelectHandler);
    $("tablecomponent").oncontextmenu = popupMenuHandler1;
}

/**
 *      
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("createbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("modifybtn").value = RESOURCE["modifybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("printbtn").value = RESOURCE["printbutton"];
    $("modifybtn").style.display = "none";
    $("modifybtn").disabled = true;
}

/**
 *      Tab 
 */
function initTabs()
{
    Tab = new Tabs();
    Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    Tab.addTab(1, RESOURCE["routerestric"], "rsvproute.html");
    Tab.addTab(2, RESOURCE["protectattri"], "rsvpprotection.html");
    Tab.addTab(3, RESOURCE["bfdconver"], "rsvpbfd.html");
    hideBFD();
    
    Tab.setTabsHeight("200px");
    
    Tab.selectTab(1);
    $("down").appendChild(Tab.getTabs());
}

/**
 *          BFD  
 */
function hideBFD()
{
    Tab.TabHead.firstChild.children[2].disabled = true;
    Tab.TabHead.firstChild.children[2].style.display = "none";
}

/**
 *        
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_IPPTN_GET_RSVPTUNNEL);
    btnRightArr.createbtn = new BtnRightObj("createbtn", TECMDCODE_IPPTN_CREATE_RSVPTUNNEL);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_IPPTN_DEL_RSVPTUNNEL);
    btnRightArr.modifybtn = new BtnRightObj("modifybtn", TECMDCODE_IPPTN_MODIFY_RSVPTUNNEL);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_IPPTN_MODIFY_RSVPTUNNEL);
    getRightInfo(winobj, btnRightArr);
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0)
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("modifybtn").disabled = !btnRightArr.deletebtn.right;
        if(rowSelectChanged())
        {
            protectTypeChangedHandle();
        }
    }
    else
    {
        $("deletebtn").disabled = true;
        $("modifybtn").disabled = true;
        var selTabIndex = Tab.getSelectedTabID();
        Tab.getTabWindow(selTabIndex).st.clearTableData();
        Tab.getTabWindow(selTabIndex).tabSelectHandler();
    }
}

/**
 *             
 * @param
 * @return
 */
function rowSelectChanged()
{
    if(isTableRefreshed)
    {
        isTableRefreshed = false;
        currentSelectRow = st.getSelectedRows()[0];
        return true;
    }
    var selectedRow = st.getSelectedRows()[0];
    if(currentSelectRow == selectedRow)
    {
        return false;
    }
    else
    {
        currentSelectRow = selectedRow;
        return true;
    }
}

/**
 *              
 * @return
 */
function cellEditHandler(param)
{
    if ((param.colid == "bandwidth") && (param.stage == TABLE_CONSTANT.BEFOREEDIT)) 
    {
        var banddata = getDataArr();
        var cbx = st.getCellEdit(param.rowindex, param.colid).element.parent;
        cbx.selview.options.length = 0;
        cbx.initComboBox(banddata, "bandwidth", 0, true);
        var textview = cbx.txtview;
        textview.onkeypress = keypressHandler;
        textview.onkeyup = keyupHandler;
        textview.onblur = onblurHandler;
        textview.style.imeMode = "disabled";
        textview.onpaste = function()
        {
            return false;
        };
        textview.maxLength = 10;
    }
    if (param.colid == "autooptperiod" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
	{
		cell = st.getCell(param.rowindex, "autooptperiod");
		textCheck(cell.element.editElement.element, AUTOOPTPERIOD_MIN, AUTOOPTPERIOD_MAX);
	}
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

/**
 *        None/Hot Standby      
 * @param 
 * @return 
 */
function protectTypeChangedHandle()
{
    var nodeType = st.getCellStoreValue(st.getSelectedRows()[0], "nodetype", "nodetype");
    if(nodeType != 1)
    {
        showAllTab(false);
        
        return;
    }
    
    showAllTab(true);
        
    var protectType = st.getCellStoreValue(st.getSelectedRows()[0], "protype", "protype");
    if(parseInt(protectType) == 1)
    {
        Tab.getTabWindow(1).$("protectroute").disabled = false;
        Tab.getTabWindow(1).$("protectroute").style.display = "";
        Tab.TabHead.firstChild.children[1].disabled = false;
        Tab.TabHead.firstChild.children[1].style.display = "";
        var selTabIndex = Tab.getSelectedTabID();
        Tab.getTabWindow(selTabIndex).tabSelectHandler();//     Tab     
    }
    else
    {
        Tab.getTabWindow(1).$("protectroute").disabled = true;
        Tab.getTabWindow(1).$("protectroute").style.display = "none";
        Tab.TabHead.firstChild.children[1].disabled = true;
        Tab.TabHead.firstChild.children[1].style.display = "none";
        Tab.selectTab(1);
    }
}

/**
*        Tab
* @param flag true:  ;false:  
* @return
*/
function showAllTab(flag)
{
    var dis = null;
    if(flag)
    {
        dis = "";
    }
    else
    {
        dis = "none";
    }
    
    Tab.getTab(1).body.contentWindow.st.clearTableData();
    Tab.getTab(1).body.contentWindow.st1.clearTableData();
    if(Tab.getTab(2).body.contentWindow.st)
    {
        Tab.getTab(2).body.contentWindow.st.clearTableData();
    }
    if(Tab.getTab(3).body.contentWindow.st)
    {
        Tab.getTab(3).body.contentWindow.st.clearTableData();
    }
    
    Tab.TabHead.firstChild.children[0].disabled = !flag;
    Tab.TabHead.firstChild.children[0].style.display = dis;
    Tab.getTabWindow(1).$("routeContent").style.display = dis;
    Tab.TabHead.firstChild.children[1].disabled = !flag;
    Tab.TabHead.firstChild.children[1].style.display = dis;
    if(Tab.getTabWindow(2).document.getElementById("protectContent"))
    {
        Tab.getTabWindow(2).document.getElementById("protectContent").style.display = dis;
    }
    Tab.TabHead.firstChild.children[2].disabled = !flag;
    Tab.TabHead.firstChild.children[2].style.display = dis;
    if(Tab.getTabWindow(3).document.getElementById("bfdContent"))
    {
        Tab.getTabWindow(3).document.getElementById("bfdContent").style.display = dis;
    }
    hideBFD();
}

/**
*         
* @return
*/
function popupMenuHandler1(evt)
{
	if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }

    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
        createjsDOMenu(rows, evt);
        showMenu(evt);
    }
}

/**
*       
* @return
*/
function createjsDOMenu()
{
	removejsDOMmenu();
    
    if(isNodeTypeTransit())
    {
        return false;
    }
    
    var cursorMenu;
    if(SYSTEMCONF.getLanguage() == "en")
    {
        cursorMenu = new jsDOMenu(220);
    }
    else
    {
        cursorMenu = new jsDOMenu(180);
    }
    if(isIE)
    {
        cursorMenu.addMenuItem(new menuItem(RESOURCE["alarmbrowse"], "", goNEFuncBrowse, "3084", true));
        cursorMenu.addMenuItem(new menuItem(RESOURCE["alarmsuppression"], "", goNEFuncBrowse, "3091", true));
    }
    else
    {
        cursorMenu.addMenuItem(new menuItem(RESOURCE["currentalarmview"], "", goNEFuncBrowse, "1", true));
        cursorMenu.addMenuItem(new menuItem(RESOURCE["historyalarmview"], "", goNEFuncBrowse, "2", true));
        cursorMenu.addMenuItem(new menuItem(RESOURCE["alarmsuppression"], "", goNEFuncBrowse, "3", true));
        cursorMenu.addMenuItem(new menuItem(RESOURCE["performview"], "", goNEFuncBrowse, "4", true));
        cursorMenu.addMenuItem(new menuItem(RESOURCE["performcount"], "", goNEFuncBrowse, "5", true));
    }
    
    cursorMenu.addMenuItem(new menuItem("-"));
    
 
    cursorMenu.addMenuItem(new menuItem(RESOURCE["querytunnelstate"], "", queryRunningStatus, "", !isNodeTypeTransit()));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["queryrunningstate"], "", queryLSPStatus, "", isNodeTypeIngress()));
    cursorMenu.addMenuItem(new menuItem("-"));
    
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["querybindingPW"], "", queryPW, "", !isNodeTypeTransit()));
    cursorMenu.addMenuItem(new menuItem("-"));
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["confhotstandby"], "", cfgHotStandby, "", isNodeTypeIngress()));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["cancelhotstandby"], "", cancelCfgHotStandby, "", isNodeTypeIngress() && isHotStandbyEnable()));
    cursorMenu.addMenuItem(new menuItem("-"));
    
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["tunnelfaultreason"], "", queryError, "", !isNodeTypeTransit() && isQueryFaultEnable()));
    cursorMenu.addMenuItem(new menuItem("-"));
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["mainrealroute"], "", mainRealRoute, "", isNodeTypeIngress()));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["backuprealroute"], "", backupRealRoute, "", isNodeTypeIngress() && isHotStandbyEnable()));
    cursorMenu.addMenuItem(new menuItem("-"));
    
    cursorMenu.addMenuItem(new menuItem(RESOURCE["ping"], "", doPingTest, st.getSelectedRows(), isNodeTypeIngress()));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["traceroute"], "", doTracerouteTest, st.getSelectedRows(), isNodeTypeIngress()));
    
    setPopUpMenu(cursorMenu);
}

/**
 *     
 */
function doQuery()
{
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("modifybtn").disabled = true;
    $("applybtn").disabled = true;
    $("printbtn").disabled = true;
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_GET_RSVPTUNNEL + "&nmUser=" + nmUser;
    LoadingProcess.showWaitStatus("../../../../../images/");
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
    
}

/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("tunnelindex", "0"));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 *        
 * @param {Object}doc
 */
function queryCallBack(doc)
{
    LoadingProcess.removeWaitStatus();
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.querybtn.right;
    $("printbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        isTableRefreshed = true;
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        var ce = st.getHeadCell("tunnelid").element;
        st.sortRows(ce, 1);
        
        cellChangeEvent();
        if(Tab.getTab(1).body.contentWindow.st)
        {
            Tab.getTab(1).body.contentWindow.st.clearTableData();
            Tab.getTab(1).body.contentWindow.st1.clearTableData();
        }
        if(Tab.getTab(2).body.contentWindow.st)
        {
            Tab.getTab(2).body.contentWindow.st.clearTableData();
        }
        if(Tab.getTab(3).body.contentWindow.st)
        {
            Tab.getTab(3).body.contentWindow.st.clearTableData();
        }

        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
            rowSelectHandler();
        }
    }
    addCellShow();
    
    countObj.setTotalCount(st.getDataRowLength());
}

/**
 * 
 * @param {Object}doc
 */
function addCellShow()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
        if (bw == 0) 
        {
            st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
            st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
        }
        else
        {
            st.getCellShow(i, "bandwidthremain").element.innerHTML = bw;
        }
        
        cell = st.getCell(i, "committedburst");
        cell.element.showElement.element.innerHTML = "-";
        
        cell = st.getCell(i, "peakinfo");
        cell.element.showElement.element.innerHTML = "-";
        
        cell = st.getCell(i, "peakburst");
        cell.element.showElement.element.innerHTML = "-";
        
        var schedutype = st.getCellCurrentValue(i, "schedutype", "schedutype");
        if(schedutype == 0)
        {
            st.setCellIsEdit(st.getCell(i,"cos"), 0);
        }
        
        var color = st.getCellCurrentValue(i, "color", "affinityattr");
        if(color != "" && color != undefined)
        {
            color = addLength(tenToHex(color), 8);
            color = "0x" + color;
            st.getCell(i,"color").element.showElement.element.innerText = color;
        }
        
        var mask = st.getCellCurrentValue(i, "mask", "affinityattrmask");
        if(mask != "" && mask != undefined)
        {
            mask = addLength(tenToHex(mask), 8);
            mask = "0x" + mask;
            st.getCell(i,"mask").element.showElement.element.innerText = mask;
        }

        var nodeType = st.getCellCurrentValue(i, "nodetype", "nodetype");
        if(nodeType != 1)
        {
            var colID = null;
            for ( var j = 0; j < tableConf.getColsLength(); j++)
            {
                colID = tableConf.getColId(j);
                var cell = null;
                if(colID != "tunnelname" && (st.getCellShow(i,colID).getValue() == ""||st.getCellShow(i,colID).getValue() == "\xA0"||st.getCellShow(i,colID).getValue() == 255))
                {
                    cell = st.getCell(i, colID);
                    cell.element.showElement.element.innerHTML = "-";
                    st.setCellIsEdit(cell, 0);
                }
            }
            
            var limitCell = st.getCell(i, "tunnelBandwidthLimitEnable");
	        limitCell.element.showElement.setValue("-");
            st.setCellIsEdit(limitCell, 0);
            
            var autoopten = st.getCell(i, "autoopten");
            autoopten.element.showElement.setValue("-");
            st.setCellIsEdit(autoopten, 0);
            
            var autooptperiod = st.getCell(i, "autooptperiod");
            autooptperiod.element.showElement.setValue("-");
            st.setCellIsEdit(autooptperiod, 0);
                    
            var rsvforbinding = st.getCell(i, "rsvforbinding");
            rsvforbinding.element.showElement.setValue("-");
            st.setCellIsEdit(rsvforbinding, 0);
        }
        
    }
}

/**
 *     
 * @return
 */
function cellChangeEvent()
{
    var scheduCell = st.getCell(0, "schedutype");
    scheduCell.element.editElement.element.onchange = function()
    {
        var rowIndex = this.parentNode.parentNode.rowIndex;
        var schedutype = this.value;
        if(parseInt(schedutype) == 0)
        {
            st.getCell(rowIndex,"cos").element.showElement.element.innerText = "-";
            st.setCellValue(st.getCell(rowIndex,"cos"), "cos", "255");
            st.setCellIsEdit(st.getCell(rowIndex,"cos"), 0);
        }
        else
        {
            st.getCell(rowIndex,"cos").element.showElement.element.innerText = cosType[1];
            st.setCellValue(st.getCell(rowIndex,"cos"), "cos", 1);
            st.setCellIsEdit(st.getCell(rowIndex,"cos"), 1);
            st.getCell(rowIndex,"cos").element.style.backgroundColor = "#d0f946";
        }
    }
}

/**
 *   RSVP Tunnel
 * @return
 */
function doCreate()
{
    xshowModalDialog("rsvp_create.html", RESOURCE["rsvpcreatetitle"], 540, 655, "../../../../../images/", "no");
}

/**
 *   RSVP Tunnel
 * @return
 */
function doModify()
{
    xshowModalDialog("rsvp_modify.html", RESOURCE["rsvpmodifytitle"], 540, 500, "../../../../../images/", "no");
}

/**
 *   RSVP Tunnel
 */
function doDelete()
{
    removejsDOMmenu();
    if (!confirm(RESOURCE["confirminfo"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("modifybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDelXML();

    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_DEL_RSVPTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

/**
 *     RSVP Tunnel xml
 */
function createDelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createParamElement("neid", neid));
        var tunnelindex = st.getCellStoreValue(indexes[i], "tunnelindex", "tunnelindex");
        rowparams.appendChild(createParamElement("tunnelindex", tunnelindex));
        bussiness.appendChild(rowparams);
        
        var tunnelid = st.getCellStoreValue(indexes[i], "tunnelid", "tunnelid");
        rowparams.appendChild(createParamElement("tunnelid", tunnelid));
        var tunnelname = st.getCellStoreValue(indexes[i], "tunnelname", "tunnelname");
        rowparams.appendChild(createParamElement("tunnelname", tunnelname));
        var nodetype = st.getCellStoreValue(indexes[i], "nodetype", "nodetype");
        rowparams.appendChild(createParamElement("nodetype", nodetype));
        var srcnode = st.getCellStoreValue(indexes[i], "srcnode", "srcnode");
        rowparams.appendChild(createParamElement("srcnode", convertNumToIpaddr(srcnode)));
        var snknode = st.getCellStoreValue(indexes[i], "snknode", "snknode");
        rowparams.appendChild(createParamElement("snknode", convertNumToIpaddr(snknode)));
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *        
 * @param {Object}doc
 */
function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("createbtn").disabled = !btnRightArr.deletebtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tunnelIndex = data.getBErrParam(i, "tunnelindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(indexes[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tempIndex) 
            {
                indexes.splice(j, 1);//           
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);//              
    }
    st.adjustDataRows();
    
    if(Tab.getTab(1).body.contentWindow.st)
    {
        Tab.getTab(1).body.contentWindow.st.clearTableData();
        Tab.getTab(1).body.contentWindow.st1.clearTableData();
    }
    if(Tab.getTab(2).body.contentWindow.st)
    {
        Tab.getTab(2).body.contentWindow.st.clearTableData();
    }
    if(Tab.getTab(3).body.contentWindow.st)
    {
        Tab.getTab(3).body.contentWindow.st.clearTableData();
    }
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);//              
        rowSelectHandler();
    }
    if (st.getDataRowLength() <= 0)
    {
        rowSelectHandler();
    }
    
    countObj.setTotalCount(st.getDataRowLength());
}

/**
 *   
 * @return
 */
function doApply()
{
    var protectTypeChanged = false;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        if (st.getCellModify(i, "protype") && st.getCellStoreValue(i, "protype", "protype")==0) 
        {
            protectTypeChanged = true;
            break;
        }
    }
    
    if(protectTypeChanged)
    {
        if (!confirm(RESOURCE["RSVPModifyProtectType"])) 
        {
            return;
        }
    }
    
    var xml = createApplyXML();
    
    var flag = false;
    if(st.getCellModify(st.getSelectedRows()[0], "protype"))
    {
        flag =true;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_MODIFY_RSVPTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, doApplyCallBack, flag, "inputdata=" + xml);
}

/**
 *        xml
 * @return
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createParamElement("neid", neid));
        row.appendChild(createParamElement("autoassign", 0));
        row.appendChild(createParamElement("tunnelindex", st.getCellStoreValue(i, "tunnelindex", "tunnelindex")));
        if (st.getCellModify(i, "tunnelname")) 
        {
            var tunnelname = st.getCellStoreValue(i, "tunnelname", "tunnelname");
            row.appendChild(createParamElement("name", tunnelname));
        }
        
        if (st.getCellModify(i, "enablestatus")) 
        {
            var enablestatus = st.getCellStoreValue(i, "enablestatus", "enablestatus");
            row.appendChild(createParamElement("enablestatus", enablestatus));
        }
        
        if (st.getCellModify(i, "bandwidth")) 
        {
            var bandwidth = st.getCellStoreValue(i, "bandwidth", "bandwidth");
            bandwidth = isNaN(bandwidth) ? 0 : bandwidth;
            var bw = st.getCell(i,"bandwidth").element.showElement.element.innerText
            row.appendChild(createParamElement("bw", bw));
            row.appendChild(createParamElement("bandwidth", bandwidth));
        }
        
        if (st.getCellModify(i, "protype")) 
        {
            var protype = st.getCellStoreValue(i, "protype", "protype");
            row.appendChild(createParamElement("protype", protype));
        }
        
        if (st.getCellModify(i, "rerouteenable")) 
        {
            var reroustate = st.getCellStoreValue(i, "rerouteenable", "rerouteenable");
            row.appendChild(createParamElement("reroustate", reroustate));
        }
        
        if (st.getCellModify(i, "schedutype")) 
        {
            var schedutype = st.getCellStoreValue(i, "schedutype", "schedutype");
            row.appendChild(createParamElement("tunneltype", schedutype));
        }
        
        if (st.getCellModify(i, "exp")) 
        {
            var exp = st.getCellStoreValue(i, "exp", "exp");
            row.appendChild(createParamElement("exp", exp));
        }
        
        if (st.getCellModify(i, "cos")) 
        {
            var cos = st.getCellStoreValue(i, "cos", "cos");
            row.appendChild(createParamElement("cos", cos));
        }
        
        if (st.getCellModify(i, "createpri")) 
        {
            var createpri = st.getCellStoreValue(i, "createpri", "createpri");
            row.appendChild(createParamElement("createpri", createpri));
        }
        
        if (st.getCellModify(i, "keeppri")) 
        {
            var keeppri = st.getCellStoreValue(i, "keeppri", "keeppri");
            row.appendChild(createParamElement("keeppri", keeppri));
        }
        
        if (st.getCellModify(i, "color")) 
        {
            var color = st.getCellStoreValue(i, "color", "color");
            row.appendChild(createParamElement("affinityattr", color));
        }
        
        if (st.getCellModify(i, "mask")) 
        {
            var mask = st.getCellStoreValue(i, "mask", "mask");
            row.appendChild(createParamElement("affinityattrmask", mask));
        }
        
        if (st.getCellModify(i, "tunnelBandwidthLimitEnable")) 
        {
            var limit = st.getCellStoreValue(i, "tunnelBandwidthLimitEnable", "tunnelBandwidthLimitEnable");
            row.appendChild(createParamElement("tunnelBandwidthLimitEnable", limit));
        }
        
        if(isSupportEth)                     //
    	{
        	cellModifyFlag = st.getCellModify(i, "autoopten");//          
        	if(cellModifyFlag )
        	{
                param = new tagElement("param", "autoopten", st.getCellStoreValue(i, "autoopten", "autoopten"));
                row.appendChild(param);
        	}     	
        	
        	 param = new tagElement("param", "isAuto","0");
            row.appendChild(param);
        	cellModifyFlag = st.getCellModify(i, "autooptperiod");//        
        	if(cellModifyFlag )
        	{
                param = new tagElement("param", "autooptperiod", st.getCellStoreValue(i, "autooptperiod", "autooptperiod"));
                row.appendChild(param);
        	}     	
        	
        	cellModifyFlag = st.getCellModify(i, "rsvforbinding");//reserve for binding   
        	if(cellModifyFlag )
        	{
                param = new tagElement("param", "rsvforbinding", st.getCellStoreValue(i, "rsvforbinding", "rsvforbinding"));
                row.appendChild(param);
        	}     
    	}	
        
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *        
 * @param doc
 * @return
 */
function doApplyCallBack(doc, flag)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    else
    {
        $("applybtn").disabled = true;
        if(flag)
        {
            protectTypeChangedHandle();
        }
    }
}

/**
 *                
 * @param paramArr          ID         
 * @return  
 */
function goNEFuncBrowse(paramArr)
{
    removejsDOMmenu();
    
    var funcid = paramArr;
    
    if(SYSTEMCONF.getStatus() == 1)
    {
        var urlstr = "../../../../../linkInterFuncServlet?neid=" + neid + "&prohandler=0&switchtype=8";
        var xmlData = createLinkFunctionTreeXml(neid,winobj["sessionid"],funcid);
        loadXMLdoc(urlstr, "POST", true, linkFunctionTreeCallback, null, "inputdata="+xmlData);
    }
    else
    {
        var fun = window.top.frames["functiontree"].tree[funcid];
        if(null == fun)
        {
            return;
        }
        fun.expand();
        fun.isSelect();
        fun.onClick();
    }
}

function createLinkFunctionTreeXml(neid,sessionid,funcid)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    param = new tagElement("param","sessionid",sessionid);
    row.appendChild(param);
    param = new tagElement("param","funcid",funcid); 
    row.appendChild(param);
    var RSVP_Flag_True = 1;
    param = new tagElement("param","RSVP_Flag",RSVP_Flag_True); 
    row.appendChild(param);
    business.appendChild(row);
    
    var row1 = new tagElement("row-params");
    var selectedRowIndex = st.getSelectedRows()[0];
    var tunnelID = st.getCellStoreValue(selectedRowIndex, "tunnelid", "tunnelid");
    param = new tagElement("param","tunnelID",tunnelID); 
    row1.appendChild(param);
    var tunnelName = st.getCellStoreValue(selectedRowIndex, "tunnelname", "tunnelname");
    if(!tunnelName)
    {
        tunnelName = "";
    }
    param = new tagElement("param","tunnelName",tunnelName); 
    row1.appendChild(param);
    var nodeType = st.getCellStoreValue(selectedRowIndex, "nodetype", "nodetype");
    param = new tagElement("param","nodeType",nodeType); 
    row1.appendChild(param);
    var ENCAP_MPLS = 1;
    param = new tagElement("param","encapsulateType",ENCAP_MPLS); 
    row1.appendChild(param);
    var PROTO_RSVP_TE = 2;
    param = new tagElement("param","protocolType",PROTO_RSVP_TE); 
    row1.appendChild(param);
    var sourceNode = st.getCellStoreValue(selectedRowIndex, "srcnode", "srcnode");
    param = new tagElement("param","sourceNode",sourceNode); 
    row1.appendChild(param);
    var sinkNode = st.getCellStoreValue(selectedRowIndex, "snknode", "snknode");
    param = new tagElement("param","sinkNode",sinkNode); 
    row1.appendChild(param);
    var direction = st.getCellStoreValue(selectedRowIndex, "direction", "direction");
    param = new tagElement("param","direction",direction); 
    row1.appendChild(param);
    business.appendChild(row1);
    
    root.getRoot().appendChild(business);
    return root.toString();
}

function linkFunctionTreeCallback(doc)
{
    
}

/**
 *         Tunnel    
 * @param 
 * @return 
 */
function queryRunningStatus()
{
    removejsDOMmenu();
    
    var xml = createQueryStatusXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_GET_TUNNELSTATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackQueryStatus, null, "inputdata=" + xml);

}

/**
 * createXML
 * @param 
 * @return 
 */
function createQueryStatusXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    
    var tunnelindex = st.getCellStoreValue(st.getSelectedRows()[0], "tunnelindex", "tunnelindex");
    rowparams.appendChild(createParamElement("tunnelindex", tunnelindex));
    
    var tunnelid = st.getCellStoreValue(st.getSelectedRows()[0], "tunnelid", "tunnelid");
    rowparams.appendChild(createParamElement("tunnelid", tunnelid));
    var nodetype = st.getCellStoreValue(st.getSelectedRows()[0], "nodetype", "nodetype");
    rowparams.appendChild(createParamElement("nodetype", nodetype));
    var srcnode = st.getCellStoreValue(st.getSelectedRows()[0], "srcnode", "srcnode");
    rowparams.appendChild(createParamElement("srcnode", convertNumToIpaddr(srcnode)));
    var snknode = st.getCellStoreValue(st.getSelectedRows()[0], "snknode", "snknode");
    rowparams.appendChild(createParamElement("snknode", convertNumToIpaddr(snknode)));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackQueryStatus(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var runState = data.getDataRowParam(0, "runstat")
        if(runState == "" || runState == "undefined")
        {
            return;
        }
        var rowIndex = st.getSelectedRows()[0];
        st.getCell(rowIndex,"runstat").element.showElement.element.innerText = runningState[runState];
        st.setCellValue(st.getCell(rowIndex,"runstat"), "runstat", runState);
        
        alert(RESOURCE["optSucc"]);
    }
}

/**
 *           LSP    
 * @param 
 * @return 
 */
function queryLSPStatus()
{
    removejsDOMmenu();
    
    var xml = createQueryLSPStatusXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_GET_LSPSTATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackQueryLSPStatus, null, "inputdata=" + xml);
}

/**
 * createXML
 * @param 
 * @return 
 */
function createQueryLSPStatusXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    
    var tunnelindex = st.getCellStoreValue(st.getSelectedRows()[0], "tunnelindex", "tunnelindex");
    rowparams.appendChild(createParamElement("tunnelindex", tunnelindex));
    
    var tunnelid = st.getCellStoreValue(st.getSelectedRows()[0], "tunnelid", "tunnelid");
    rowparams.appendChild(createParamElement("tunnelid", tunnelid));
    var nodetype = st.getCellStoreValue(st.getSelectedRows()[0], "nodetype", "nodetype");
    rowparams.appendChild(createParamElement("nodetype", nodetype));
    var srcnode = st.getCellStoreValue(st.getSelectedRows()[0], "srcnode", "srcnode");
    rowparams.appendChild(createParamElement("srcnode", convertNumToIpaddr(srcnode)));
    var snknode = st.getCellStoreValue(st.getSelectedRows()[0], "snknode", "snknode");
    rowparams.appendChild(createParamElement("snknode", convertNumToIpaddr(snknode)));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackQueryLSPStatus(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var rowIndex = st.getSelectedRows()[0];
        
        var mainLSPstate = data.getDataRowParam(0, "mainlspstat");
        var backupLSPstate = data.getDataRowParam(0, "backuplspstat");
        if(mainLSPstate == "" || mainLSPstate == "undefined")
        {
            return;
        }
        st.getCell(rowIndex,"mainlspstat").element.showElement.element.innerText = runningState[mainLSPstate];
        st.setCellValue(st.getCell(rowIndex,"mainlspstat"), "mainlspstat", mainLSPstate);
        if(backupLSPstate == "" || backupLSPstate == "undefined")
        {
            return;
        }
        st.getCell(rowIndex,"backuplspstat").element.showElement.element.innerText = runningState[backupLSPstate];
        st.setCellValue(st.getCell(rowIndex,"backuplspstat"), "backuplspstat", backupLSPstate);
        
        alert(RESOURCE["optSucc"]);
    }
}

/**
 *     
 * @param 
 * @return 
 */
function switchBackup(type)
{
    removejsDOMmenu();
    
    Tab.getTab(2).body.contentWindow.forceSwitch(type);
}



/**
 *       
 * @param 
 * @return 
 */
function querySwitchingStatus()
{
    removejsDOMmenu();
    
    Tab.getTab(2).body.contentWindow.doQueryStat();
}

/**
 *      PW
 * @param 
 * @return 
 */
function queryPW()
{
    removejsDOMmenu();
    
    xshowModalDialog("rsvp_queryPW.html", RESOURCE["querybindingPW"], 650, 400, "../../../../../images/");
}

/**
 *       
 * @param 
 * @return 
 */
 function queryError()
 {
    removejsDOMmenu();
    
    xshowModalDialog("rsvp_queryFault.html", RESOURCE["tunnelfaultreason"], 550, 300, "../../../../../images/");
 }
 
/**
 *      
 * @param 
 * @return 
 */
function cfgHotStandby()
{
    removejsDOMmenu();
    
    if(!isHotStandbyEnable())
    {
        var xml = createCancelHotXML(false);
        var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_MODIFY_RSVPTUNNEL + "&nmUser=" + nmUser;
        loadXMLdoc(url, "POST", false, callbackCancelHot, false, "inputdata=" + xml);
    }
    
    if(isHotStandbyEnable())
    {
        xshowModalDialog("rsvp_hotstandby.html", RESOURCE["confhotstandby"], 450, 400, "../../../../../images/");
    }
}

/**
 *        
 * @param 
 * @return 
 */
function cancelCfgHotStandby()
{
    removejsDOMmenu();
    
    if (!confirm(RESOURCE["delPWTipsSecond"])) 
    {
        return;
    }
    
    var xml = createCancelHotXML(true);
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_CANCEL_HOTSTANDBY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackCancelHot, true, "inputdata=" + xml);
}

/**
 * createXML
 * @param 
 * @return 
 */
function createCancelHotXML(flag)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("autoassign", 0));
    var tunnelindex = st.getCellStoreValue(st.getSelectedRows()[0], "tunnelindex", "tunnelindex");
    rowparams.appendChild(createParamElement("tunnelindex", tunnelindex));
    if(flag)
    {
        rowparams.appendChild(createParamElement("protype", "0"));
    }
    else
    {
        rowparams.appendChild(createParamElement("protype", "1"));
    }
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackCancelHot(doc, flag)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var rowIndex = st.getSelectedRows()[0];
        if(flag)
        {
            st.getCell(rowIndex,"protype").element.showElement.element.innerText = RESOURCE["protecttype_0"];
            st.setCellValue(st.getCell(rowIndex,"protype"), "protype", "0");
        }
        else
        {
            st.getCell(rowIndex,"protype").element.showElement.element.innerText = RESOURCE["protecttype_1"];
            st.setCellValue(st.getCell(rowIndex,"protype"), "protype", "1");
        }
        
        protectTypeChangedHandle();
    }
}

/**
 *  LSP   
 * @param 
 * @return 
 */
function mainLSPReoptimize()
{
    removejsDOMmenu();
    
    Tab.getTab(1).body.contentWindow.doMainRestric();
}



/**
 *  LSP   
 * @param 
 * @return 
 */
function backupLSPReoptimize()
{
    removejsDOMmenu();
    
    Tab.getTab(1).body.contentWindow.doBackupRestric();
}



/**
 *      
 * @param 
 * @return 
 */
function mainRealRoute()
{
    removejsDOMmenu();
    
    var xml = createRealRouteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_GET_TUNNELREALROUTE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, MainRouteCallBack, null, "inputdata=" + xml);
}

/**
 * createXML
 * @param 
 * @return 
 */
function createRealRouteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    
    var indexes = st.getSelectedRows();
    var tunnelindex = st.getCellStoreValue(indexes[0], "tunnelindex", "tunnelindex");
    rowparams.appendChild(createParamElement("tunnelindex", tunnelindex));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function MainRouteCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var realroute = data.getDataRowParam(0, "realroute");
        if(realroute == null)
        {
            alert(RESOURCE["routenoexist"]);
        }
        else
        {
            realRouteData = data;
            xshowModalDialog("rsvp_realroute.html", RESOURCE["realroute"], 525, 540, "../../../../../images/");
        }
    }
}

/**
 *      
 * @param 
 * @return 
 */
function backupRealRoute()
{
    removejsDOMmenu();
    
    var xml = createRealRouteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_GET_BACKUPROUTE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackBakcupRoute, null, "inputdata=" + xml);
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackBakcupRoute(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        var realroute = data.getDataRowParam(0, "realroute");
        if(realroute == null)
        {
            alert(RESOURCE["routenoexist"]);
        }
        else
        {
            realRouteData = data;
            xshowModalDialog("rsvp_realroute.html", RESOURCE["realroute"], 525, 540, "../../../../../images/");
        }
    }
}

/**
 *          Ingress
 * @param 
 */
function isNodeTypeIngress()
{
    var nodeType = st.getCellStoreValue(st.getSelectedRows()[0], "nodetype", "nodetype");
    if(nodeType == 1)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**
 *          Transit
 * @param 
 */
function isNodeTypeTransit()
{
    var nodeType = st.getCellStoreValue(st.getSelectedRows()[0], "nodetype", "nodetype");
    if(nodeType == 2)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**
 *          
 * @param 
 */
function isHotStandbyEnable()
{
    var protectType = st.getCellStoreValue(st.getSelectedRows()[0], "protype", "protype");
    if(parseInt(protectType) == 1)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**
 *           
 * @param 
 */
function isQueryFaultEnable()
{
    var runState = st.getCellStoreValue(st.getSelectedRows()[0], "runstat", "runstat");
    if(parseInt(runState) == 0)
    {
        return false;
    }
    else
    {
        return true;
    }
}

/**
 * Ping        
 * @param {Object} rows
 */
function doPingTest(rows)
{

    removejsDOMmenu();
    if(SYSTEMCONF.getStatus() == '0')
    {
        var args = "dialogHeight:540px;dialogWidth:520px;";
    
        if(!isIE)
        {
            var leftArg = 'dialogLeft:' + (screen.width - 520)/2 + 'px;';
            var topArg = 'dialogTop:' + (screen.height - 540)/2 + 'px;';

            args += leftArg;
            args += topArg;
        }
    
        window.showModalDialog("pingtest.html", window, args);
    } else {
    
        xshowModalDialog("pingtest.html", RESOURCE["pingTestTitle"], 525, 540, "../../../../../images/");
    }
}

function doTracerouteTest(rows)
{
    removejsDOMmenu();
    
    if(SYSTEMCONF.status == '0')
    {
        var args = "dialogHeight:540px;dialogWidth:520px;";
    
        if(!isIE)
        {
            var leftArg = 'dialogLeft:' + (screen.width - 520)/2 + 'px;';
            var topArg = 'dialogTop:' + (screen.height - 540)/2 + 'px;';

            args += leftArg;
            args += topArg;
        }
    
        window.showModalDialog("traceroutetest.html", window, args);
    } else {
        xshowModalDialog("traceroutetest.html", RESOURCE["tracerouteTest"], 525, 540, "../../../../../images/");
    }
}

/**
 *   
 */
function doPrint()
{
    openPrintPage("../../../../../page/", "", "st");
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tablecomponent"), st) + "px");
    st.setBodyWidth(tableConf.width, tableConf.percent, 0);
}
