var st = null;
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var btnRightArr = new Object();

var tunnelIndex = null;
var tunnelid = null;
var nodetype = null;
var srcnode = null;
var snknode =null;

var rvtmode = new Array();
rvtmode[0] = "rvtmode_0";
rvtmode[1] = "rvtmode_1";

var switchstate =new Array();
switchstate[0] = "In-primary";
switchstate[1] = "in-secondary";

var switchreason = new Array();
switchreason[0] = "switchinfo_0";
switchreason[1] = "switchinfo_1";
switchreason[2] = "switchinfo_2";
switchreason[3] = "switchinfo_3";
switchreason[4] = "switchinfo_4";

var LSPState = new Array();
LSPState[0] = "Down";
LSPState[1] = "Up"

/**
 *      
 * @param  
 * @return  
 */
function init()
{
    initTable();
    initButton();
    initRight();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    tableConf = window.tableconf[0];
    createTableHead(st, tableConf);
    
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
    st.setOnCellEditHandler(cellEditHandler);
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

/**
 *      
 */
function initButton()
{
    $("qrystatbtn").value = RESOURCE["queryswitbutton"];
    $("funcbtn").value = RESOURCE["functionbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
    $("qrystatbtn").disabled = true;
    $("funcbtn").disabled = true;
    $("applybtn").disabled = true;
}

/**
 *        
 */
function initRight()
{
    btnRightArr.qrystatbtn = new BtnRightObj("qrystatbtn", TECMDCODE_IPPTN_RSVPTUNNEL_GET_SWITCHSTATE);
    btnRightArr.funcbtn = new BtnRightObj("funcbtn", TECMDCODE_IPPTN_RSVPTUNNEL_SWITCH_BACKUP);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_IPPTN_RSVPTUNNEL_SET_TUNNELBACKUPATTR);
    getRightInfo(winobj, btnRightArr);
}

/**
 * Tab     
 */
function tabSelectHandler()
{
    var selRows = parent.st.getSelectedRows();
    if (selRows.length == 0 || parent.st.getCellStoreValue(selRows[0], "nodetype", "nodetype") != 1) 
    {
        $("qrystatbtn").disabled = true;
        $("funcbtn").disabled = true;
        $("applybtn").disabled = true;
        return;
    }
    
    var selectRows = parent.st.getSelectedRows();
    tunnelIndex = parent.st.getCellStoreValue(selectRows[0], "tunnelindex", "tunnelindex");
    tunnelid = parent.st.getCellStoreValue(selectRows[0], "tunnelid", "tunnelid");
    nodetype = parent.st.getCellStoreValue(selectRows[0], "nodetype", "nodetype");
    srcnode = parent.st.getCellStoreValue(selectRows[0], "srcnode", "srcnode");
    snknode = parent.st.getCellStoreValue(selectRows[0], "snknode", "snknode");
    
    $("qrystatbtn").disabled = !btnRightArr.qrystatbtn.right;
    $("funcbtn").disabled = !btnRightArr.funcbtn.right;
    $("applybtn").disabled = !btnRightArr.applybtn.right;
    
    doQuery();
}

/**
 *      
 */
function rowSelectHandler()
{

}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 *            
 * @return
 */
function createjsDOMenu()
{
    removejsDOMmenu();
    
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") {
        menuSize = 200;
    }
    var cursorMenu = new jsDOMenu(menuSize);
    cursorMenu.addMenuItem(new menuItem(RESOURCE["switchtostandby"], "", forceSwitch, "1"));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["clearswitch"], "", forceSwitch, "0"));
    
    setPopUpMenu(cursorMenu);
}

/**
 *       
 * @return
 */
function doQueryStat()
{
    $("qrystatbtn").disabled = true;
    $("funcbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryStateXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_GET_SWITCHSTATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackQueryState, null, "inputdata=" + xml);
}

/**
 * createXML
 * @param 
 * @return 
 */
function createQueryStateXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("tunnelindex", tunnelIndex));
    
    rowparams.appendChild(createParamElement("tunnelid", tunnelid));
    rowparams.appendChild(createParamElement("nodetype", nodetype));
    rowparams.appendChild(createParamElement("srcnode", convertNumToIpaddr(srcnode)));
    rowparams.appendChild(createParamElement("snknode", convertNumToIpaddr(snknode)));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackQueryState(doc)
{
    $("qrystatbtn").disabled = !btnRightArr.qrystatbtn.right;
    $("funcbtn").disabled = !btnRightArr.funcbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshTableDataPartly(data);
    }
}

function refreshTableDataPartly(data)
{
    var rowData = data.getDataRow(0);
    for(key in rowData)
    {
        var currCellValue = rowData[key].value;
        
        if(key == "backupLSPstate" || key == "mainLSPstate")
        {
            st.getCellShow(0,key).setValue(LSPState[currCellValue]);
            st.setCellValue(st.getCell(0,key), key, currCellValue);
        }
        if(key =="switchreason" )
        {
            st.getCellShow(0,key).setValue(RESOURCE[switchreason[currCellValue]]);
            st.setCellValue(st.getCell(0,key), key, currCellValue);
        }
        if(key == "switchstate" )
        {
            st.getCellShow(0,key).setValue(switchstate[currCellValue]);
            st.setCellValue(st.getCell(0,key), key, currCellValue);
        }
    }
}

/**
 *     LSP &     
 * type = 1     LSP
 * type = 0     
 * @return
 */
function forceSwitch(type)
{
    var xml = createSwitchBackupXML(type);
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_SWITCH_BACKUP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callbackSwitchBackup, null, "inputdata=" + xml);
}

/**
 * createXML
 * @param 
 * @return 
 */
function createSwitchBackupXML(type)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("tunnelindex", tunnelIndex));
    
    rowparams.appendChild(createParamElement("switchtype", type));
    
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * callback
 * @param 
 * @return 
 */
function callbackSwitchBackup(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0) 
    {
        alert(RESOURCE["querySWStatus"]);
    }
}

/**
 *         
 */
function doQuery()
{
    $("qrystatbtn").disabled = true;
    $("funcbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_QUERY_TUNNELBACKUPATTR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("tunnelindex", tunnelIndex));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *        
 * @param {Object}doc
 */
function queryCallBack(doc)
{
    $("qrystatbtn").disabled = !btnRightArr.qrystatbtn.right;
    $("funcbtn").disabled = !btnRightArr.funcbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
}

/**
 *        xml
 * @return
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createParamElement("neid", neid));
        rowparams.appendChild(createParamElement("autoassign", 0));
        rowparams.appendChild(createParamElement("tunnelindex", tunnelIndex));
        
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        if (st.getCellModify(i, "rvtmode")) 
        {
            var rvtmode = st.getCellStoreValue(i, "rvtmode", "rvtmode");
            rowparams.appendChild(createParamElement("rvtmode", rvtmode));
        }
        if (st.getCellModify(i, "rvtwtr")) 
        {
            var rvtwtr = st.getCellStoreValue(i, "rvtwtr", "rvtwtr");
            rowparams.appendChild(createParamElement("rvtwtr", rvtwtr));
        }
        
        rowparams.appendChild(createParamElement("tunnelid", tunnelid));
        rowparams.appendChild(createParamElement("nodetype", nodetype));
        rowparams.appendChild(createParamElement("srcnode", convertNumToIpaddr(srcnode)));
        rowparams.appendChild(createParamElement("snknode", convertNumToIpaddr(snknode)));
    
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   
 * @return
 */
function doApply()
{
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_RSVPTUNNEL_SET_TUNNELBACKUPATTR + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, doApplyCallBack, null, "inputdata=" + xml);
}

/**
 *          
 * @param doc
 * @return
 */
function doApplyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog1(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    else
    {
        $("applybtn").disabled = true;
    }
}

