var ct = null;
var routetable = null;
var routetable1 = null;
var protecttable = null;
var tab = null;
var win = getDialogParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var tunnelindex;


/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initTable();
    initButton();
    initData();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom = new Atom("text");
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ingress"], 1);
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["unidirectional"], 0);
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    atom = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["cir"], atom);
    atom.element.parent.initComboBox(getDataArr(), "cb1", 17, true);
    atom.element.parent.txtview.onkeypress = keypressHandler;
    atom.element.parent.txtview.onkeyup = keyupHandler;
    atom.element.parent.txtview.onblur = onblurHandler;
    atom.element.parent.txtview.style.imeMode = "disabled";
    atom.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("committedburst", RESOURCE["cbs"], atom);
 
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("peakinfo", RESOURCE["pir"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("peakburst", RESOURCE["pbs"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["none"], "0");
    atom.addOption("Hot Standby", "1");
    ct.addAttrRow("protecttype", RESOURCE["protecttype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["disabled"], "0");
    atom.addOption(RESOURCE["enabled"], "1");
    ct.addAttrRow("reroutestate", RESOURCE["reroutingstat"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("color", RESOURCE["color"], atom);
    
    atom = new Atom("text");
    ct.addAttrRow("mask", RESOURCE["mask"], atom);
    checkAffinityData();
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    validateIp(atom.element);
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        scheduleTypeChanged();
    };
    atom.addOption(RESOURCE["elsp"], 0);
    var notSupport = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTSUPPORT_LLSP");
    if(!notSupport)
    {
        atom.addOption(RESOURCE["llsp"], 1);
    }
    ct.addAttrRow("schetype", RESOURCE["schetype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["exp0"], 0);
    atom.addOption(RESOURCE["exp1"], 1);
    atom.addOption(RESOURCE["exp2"], 2);
    atom.addOption(RESOURCE["exp3"], 3);
    atom.addOption(RESOURCE["exp4"], 4);
    atom.addOption(RESOURCE["exp5"], 5);
    atom.addOption(RESOURCE["exp6"], 6);
    atom.addOption(RESOURCE["exp7"], 7);
    atom.addOption(RESOURCE["exp255"], 255);
    ct.addAttrRow("exp", RESOURCE["exp"], atom);
    
    atom = new Atom("select");
    atom.addOption(7, 7);
    atom.addOption(6, 6);
    atom.addOption(5, 5);
    atom.addOption(4, 4);
    atom.addOption(3, 3);
    atom.addOption(2, 2);
    atom.addOption(1, 1);
    atom.addOption(0, 0);
    ct.addAttrRow("createpri", RESOURCE["createpri"], atom);
    
    atom = new Atom("select");
    atom.addOption(7, 7);
    atom.addOption(6, 6);
    atom.addOption(5, 5);
    atom.addOption(4, 4);
    atom.addOption(3, 3);
    atom.addOption(2, 2);
    atom.addOption(1, 1);
    atom.addOption(0, 0);
    ct.addAttrRow("keeppri", RESOURCE["keeppri"], atom);
    
    atom = new Atom("select");
    atom.addOption("-");
    ct.addAttrRow("cos", "CoS", atom);
}

function scheduleTypeChanged()
{
     switch (parseInt(ct.getAtom("schetype").element.value))
     {
         case 0:
         {
             var atom = ct.getAtom("cos");
             atom.element.options.length = 0;
             atom.addOption("-", "-");
             atom.element.disabled = true;
             
             break;
         }
         
         case 1:
         {
             var atom = ct.getAtom("cos");
             atom.element.options.length = 0;
             atom.addOption("BE", "1");
             atom.addOption("AF1", "2");
             atom.addOption("AF2", "3");
             atom.addOption("AF3", "4");
             atom.addOption("AF4", "5");
             atom.addOption("EF", "6");
             atom.addOption("CS6", "7");
             atom.addOption("CS7", "8");
             atom.element.disabled = false;
             atom.element.style.backgroundColor = "#ffffff";
             
             break;
         }
     }
}


function checkAffinityData()
{
    var cell = null;
    var colorElement = ct.getAtom("color").element;
    colorElement.onkeydown = function()
    {
        var colorvalue = colorElement.value;
        var index = colorvalue.indexOf("x"); 
        if(digitalTag_getPos(colorElement) > 8 + index ||
            digitalTag_getPos(colorElement) <= index) 
        {
            return false;
        }               
        hexTextKeyDownCheck(colorElement, "");
    }

    
    var maskElement = ct.getAtom("mask").element;
    maskElement.onkeydown = function()
    {
        var maskvalue = maskElement.value;
        var index = maskvalue.indexOf("x"); 
        if(digitalTag_getPos(maskElement) > 8 + index ||
            digitalTag_getPos(maskElement) <= index) 
        {
            return false;
        }               
        hexTextKeyDownCheck(maskElement, "");
    }
       
}


/**
 *      
 */
function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initData()
{
    var wintable = win.st;
    var index = wintable.getSelectedRows()[0];
    if(isNaN(index))
    {
        return;
    }
    tunnelindex = wintable.getCellStoreValue(index, "tunnelindex", "tunnelindex");
    
    var tunnelid = wintable.getCellStoreValue(index, "tunnelid", "tunnelid");
    ct.getAtom("tunnelid").setValue(tunnelid);
    
    var tunnelname = wintable.getCellStoreValue(index, "tunnelname", "tunnelname");
    if (!tunnelname) 
    {
        tunnelname = "";
    }
    ct.getAtom("tunnelname").setValue(tunnelname);
    
    var nodetype = wintable.getCellStoreValue(index, "nodetype", "nodetype");
    ct.getAtom("nodetype").element.selectedIndex = searchSelectedIndex(ct.getAtom("nodetype").element,nodetype);
    
    var direction = wintable.getCellStoreValue(index, "direction", "direction");
    ct.getAtom("direction").element.selectedIndex = searchSelectedIndex(ct.getAtom("direction").element,direction);
    
    var bandwidth = wintable.getCellStoreValue(index, "bandwidth", "bandwidth");
    if(0 == bandwidth)
    {
        ct.getAtom("bandwidth").element.parent.setSelectedIndex(17);
    }
    else
    {
        ct.getAtom("bandwidth").element.parent.setSelectedIndex(searchSelectedIndex(ct.getAtom("bandwidth").element.parent.selview,bandwidth,17));
    }
    
    var protecttype = wintable.getCellStoreValue(index, "protype", "protype");
    ct.getAtom("protecttype").element.selectedIndex = searchSelectedIndex(ct.getAtom("protecttype").element,protecttype);
    
    var reroutestate = wintable.getCellStoreValue(index, "reroustate", "rerouteenable");
    ct.getAtom("reroutestate").element.selectedIndex = searchSelectedIndex(ct.getAtom("reroutestate").element,reroutestate);
    
    var color = wintable.getCell(index,"color").element.showElement.element.innerText
    ct.getAtom("color").setValue(color);
    
    var mask = wintable.getCell(index,"mask").element.showElement.element.innerText
    ct.getAtom("mask").setValue(mask);
    
    var snknode = wintable.getCellStoreValue(index, "snknode", "snknode");
    ct.getAtom("snknode").setValue(convertIP(snknode));
    
    var schetype = wintable.getCellStoreValue(index, "schedutype", "schedutype");
    ct.getAtom("schetype").element.selectedIndex = searchSelectedIndex(ct.getAtom("schetype").element,schetype);
    
    var exp = wintable.getCellStoreValue(index, "exp", "exp");
    ct.getAtom("exp").element.selectedIndex = searchSelectedIndex(ct.getAtom("exp").element,exp);
    
    var createpri = wintable.getCellStoreValue(index, "createpri", "createpri");
    ct.getAtom("createpri").element.selectedIndex = searchSelectedIndex(ct.getAtom("createpri").element,createpri);
    
    var keeppri = wintable.getCellStoreValue(index, "keeppri", "keeppri");
    ct.getAtom("keeppri").element.selectedIndex = searchSelectedIndex(ct.getAtom("keeppri").element,keeppri);
    
    var cos = wintable.getCellStoreValue(index, "cos", "cos");
    ct.getAtom("cos").setValue(cos);
}

function searchSelectedIndex(optionObj, value, defaultIndex)
{
    if(!optionObj)
    {
        return -1;
    }
    var tempOption = optionObj.options;
    
    if(0 == tempOption.length)
    {
        return -1;
    }
    
    var selectedIndex = 0;

    for(var index = 0,len = tempOption.length;index<len;index++)
    {
        if(value == tempOption[index].value)
        {
            selectedIndex = index;
            return selectedIndex;
        }
    }
    if(defaultIndex)
    {
        selectedIndex = defaultIndex;
    }
    return selectedIndex;
}

/**
 *     tunnel
 * @return
 */
function doModify(flag)
{
    if (!validate()) 
    {
        return;
    }

    var xml = createModifyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_MODIFY_RSVPTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, flag, "inputdata=" + xml);
}

function validate()
{
    var atom = ct.getAtom("tunnelid");
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    

    atom = ct.getAtom("snknode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
    }
    
    return true;
}

function createModifyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    bussiness.appendChild(createRowParams());
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("autoassign", 0));
    rowparams.appendChild(createTagElement("tunnelindex", tunnelindex));
    
    var tunnelName = ct.getAtom("tunnelname").getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    
    var bandwidth = ct.getAtom("bandwidth").getValue();
    rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
    rowparams.appendChild(createTagElement("protype", ct.getAtom("protecttype").getValue()));
    rowparams.appendChild(createTagElement("reroustate", ct.getAtom("reroutestate").getValue()));
    
    var color = ct.getAtom("color").getValue();
    rowparams.appendChild(createTagElement("affinityattr", color.substring(2,color.length)));
    var mask = ct.getAtom("mask").getValue();
    rowparams.appendChild(createTagElement("affinityattrmask", mask.substring(2,mask.length)));
    
    rowparams.appendChild(createTagElement("exp", ct.getAtom("exp").getValue()));
    rowparams.appendChild(createTagElement("createpri", ct.getAtom("createpri").getValue()));
    rowparams.appendChild(createTagElement("keeppri", ct.getAtom("keeppri").getValue()));
    
    var schetype = parseInt(ct.getAtom("schetype").getValue());
    rowparams.appendChild(createTagElement("tunneltype", schetype));
    if(0 == schetype)
    {
        rowparams.appendChild(createTagElement("cos", 255));
    }
    else if(1 == schetype)
    {
        var cos = parseInt(ct.getAtom("cos").getValue());
        rowparams.appendChild(createTagElement("cos", cos));
    }
    
    return rowparams;
}

function createCallBack(doc, flag)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (flag && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";		
    errArr[1] = "mspwid";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object}param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object}param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

/**
 *        MTU    F      - 
 * @param {Object} param
 */
function convertMTU(param)
{
    return param == INVALID_MTU ? INVALID_VALUE : param;
}
