var winurlobj = getDialogParentWindow();
var reroutetable;
/**
 *      
 * @param  
 * @return  
 */
function init()
{
    initTable();
    initButton();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    reroutetable = new CTable();
    reroutetable.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("text");
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    reroutetable.addAttrRow("ipaddress", RESOURCE["restrictip"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["restricttype_1"], 1);
    atom.addOption(RESOURCE["restricttype_2"], 2);
    atom.addOption(RESOURCE["restricttype_3"], 3);
    reroutetable.addAttrRow("routerestrictype", RESOURCE["restricttype"], atom);
    
    $("tablecomponent").appendChild(reroutetable.getTable());
}

/**
 *      
 */
function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];

}

function do_ok()
{
    if (!createVerify())
    {
        return;
    }
    
    var dinterface = new DataInterface();
    var obj = new Object();
    var ptag;
    
    ptag = new ParamTag();
    var ipValue = reroutetable.getAtom("ipaddress").getValue();
    ptag.value = convertIPStrToLong(ipValue);
    obj["restrictip"] = ptag;
      
    ptag = new ParamTag();
    ptag.value = reroutetable.getAtom("routerestrictype").getValue();
    obj["restricttype"] = ptag;
    
    dinterface.rows.append(obj);
    winurlobj.addRerouteRestrict(dinterface);
    
    xcloseDialog();
}

function docancel()
{
    xcloseDialog();
}

/**
 *     
 */
function createVerify()
{
    atom = reroutetable.getAtom("ipaddress");
    v = atom.getValue().trim();
    if (v == "" || v == "0.0.0.0") 
    {
        alert(RESOURCE["inputrouteip"]);
        return false;
    }
    if(convertIPStrToLong(v) == 0)
    {
        alert(RESOURCE["invalidip"]);
        return false;
    }
    return true;
}
