var ct = null;
var routetable = null;
var routetable1 = null;
var protecttable = null;
var tab = null;
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;


/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initTable();
    initButton();
    initTabs();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom = new Atom("text");
    atom.setValue(1);
    checkText(atom.element, "1", "65535");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ingress"], 1);
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["unidirectional"], 0);
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("direction", RESOURCE["direction"], atom);
    
    atom = new Atom("combobox");
    ct.addAttrRow("committedinfo", RESOURCE["cir"], atom);
    atom.element.parent.initComboBox(getDataArr(), "cb1", 17, true);
    atom.element.parent.txtview.onkeypress = keypressHandler;
    atom.element.parent.txtview.onkeyup = keyupHandler;
    atom.element.parent.txtview.onblur = onblurHandler;
    atom.element.parent.txtview.style.imeMode = "disabled";
    atom.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("committedburst", RESOURCE["cbs"], atom);
 
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("peakinfo", RESOURCE["pir"], atom);
    
    atom = new Atom("text");
    atom.setValue("-");
    atom.element.disabled = true;
    ct.addAttrRow("peakburst", RESOURCE["pbs"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["none"], 0);
    atom.addOption(RESOURCE["protecttype_1"], 1);
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = protectTypeChange;
    ct.addAttrRow("protecttype", RESOURCE["protecttype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["disabled"], 0);
    atom.addOption(RESOURCE["enabled"], 1);
    atom.element.options.selectedIndex = 0;
    ct.addAttrRow("reroutestate", RESOURCE["reroutingstat"], atom);
    
    atom = new Atom("text");
    atom.setValue("0x00000000");
    ct.addAttrRow("color", RESOURCE["color"], atom);
    
    atom = new Atom("text");
    atom.setValue("0x00000000");
    ct.addAttrRow("mask", RESOURCE["mask"], atom);
    checkAffinityData();
    
    atom = new Atom("text");
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        scheduleTypeChanged();
    };
    atom.addOption(RESOURCE["elsp"], 0);
    var notSupport = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTSUPPORT_LLSP");
    if(!notSupport)
    {
        atom.addOption(RESOURCE["llsp"], 1);
    }
    ct.addAttrRow("schetype", RESOURCE["schetype"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["exp0"], 0);
    atom.addOption(RESOURCE["exp1"], 1);
    atom.addOption(RESOURCE["exp2"], 2);
    atom.addOption(RESOURCE["exp3"], 3);
    atom.addOption(RESOURCE["exp4"], 4);
    atom.addOption(RESOURCE["exp5"], 5);
    atom.addOption(RESOURCE["exp6"], 6);
    atom.addOption(RESOURCE["exp7"], 7);
    atom.addOption(RESOURCE["exp255"], 255);
    atom.element.options.selectedIndex = 8;
    ct.addAttrRow("exp", RESOURCE["exp"], atom);
    
    atom = new Atom("select");
    atom.addOption(7, 7);
    atom.addOption(6, 6);
    atom.addOption(5, 5);
    atom.addOption(4, 4);
    atom.addOption(3, 3);
    atom.addOption(2, 2);
    atom.addOption(1, 1);
    atom.addOption(0, 0);
    atom.element.options.selectedIndex = 0;
    ct.addAttrRow("createpri", RESOURCE["createpri"], atom);
    
    atom = new Atom("select");
    atom.addOption(7, 7);
    atom.addOption(6, 6);
    atom.addOption(5, 5);
    atom.addOption(4, 4);
    atom.addOption(3, 3);
    atom.addOption(2, 2);
    atom.addOption(1, 1);
    atom.addOption(0, 0);
    atom.element.options.selectedIndex = 7;
    ct.addAttrRow("keeppri", RESOURCE["keeppri"], atom);
    
    atom = new Atom("select");
    atom.addOption("-");
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    ct.addAttrRow("cos", "CoS", atom);
    
    routetable = new SortTable();
    routeconf = window.tableconf[0];
    routetable.setImage("../../../../../images/");
    routetable.isUsedForSelectList = true;
    createTableHead(routetable, routeconf);
    $("mainreroutediv").appendChild(routetable.getTable());
    routetable.setOnRowSelectHandler(rowSelectHandler);
    routetable.setBodyHeight(getComponetHeight($("mainreroutediv"), 320) + "px");
    
    routetable1 = new SortTable();
    routeconf = window.tableconf[0];
    routetable1.setImage("../../../../../images/");
    routetable1.isUsedForSelectList = true;
    createTableHead(routetable1, routeconf);
    $("backupreroutediv").appendChild(routetable1.getTable());
    routetable1.setOnRowSelectHandler(rowSelectHandler);
    routetable1.setBodyHeight(getComponetHeight($("backupreroutediv"), 320) + "px");
    
    swicthTab("workroute");
    
    protecttable = new CTable();
    protecttable.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    var atom = new Atom("select");
    atom.addOption(RESOURCE["rvtmode_0"],"0");
    atom.addOption(RESOURCE["rvtmode_1"],"1");
    atom.element.options.selectedIndex = 1;
    protecttable.addAttrRow("restoremode", RESOURCE["restoremode"], atom);
    atom = new Atom("text");
    checkText(atom.element,0 , 60);
    atom.element.value = 10;
    protecttable.addAttrRow("WTRtime", RESOURCE["WTRtime"], atom);
    $("protectionattrdiv").appendChild(protecttable.getTable());
    
    ct.getAtom("committedinfo").element.parent.adjustWidth();
}

function protectTypeChange()
{
    switch (parseInt(this.value))
    {
        case 0:
            $("protectroute").disabled = true;
            $("protectroute").style.display = "none";
            tabHeadList["tab2div"].disabled = true;
            tabHeadList["tab2div"].style.display = "none";
            setSelectedEmbedTab("tab1div");
            break;
        case 1:
            $("protectroute").disabled = false;
            $("protectroute").style.display = "";
            tabHeadList["tab2div"].disabled = false;
            tabHeadList["tab2div"].style.display = "";
            break;
        default:
            break;
    }
}

function scheduleTypeChanged()
{
     switch (parseInt(ct.getAtom("schetype").element.value))
     {
         case 0:
         {
             var atom = ct.getAtom("cos");
             atom.element.options.length = 0;
             atom.addOption("-", "-");
             atom.element.disabled = true;
             
             break;
         }
         
         case 1:
         {
             var atom = ct.getAtom("cos");
             atom.element.options.length = 0;
             atom.addOption("BE", "1");
             atom.addOption("AF1", "2");
             atom.addOption("AF2", "3");
             atom.addOption("AF3", "4");
             atom.addOption("AF4", "5");
             atom.addOption("EF", "6");
             atom.addOption("CS6", "7");
             atom.addOption("CS7", "8");
             atom.element.disabled = false;
             atom.element.style.backgroundColor = "#ffffff";
             
             break;
         }
     }
}


function setComboboxStyle()
{
    var cbx = ct.getAtom("committedinfo").element.parent;
    var wdt = cbx.view.parentNode.offsetWidth - 9;
    var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
    
    cbx.txtview.style.width = wdt;
    cbx.selview.style.width = wdt;
    cbx.selview.style.clip = clip;
}

function checkAffinityData()
{
    var colorElement = ct.getAtom("color").element;
    elementTextCheck(colorElement);

    var maskElement = ct.getAtom("mask").element;
    elementTextCheck(maskElement);

}

function elementTextCheck(elem)
{
    var elementValue = elem.value;
    var index = elementValue.indexOf("x"); 
    if(isIE)
    {
        elem.onkeydown = function()
        {
            if(digitalTag_getPos(elem) > 8 + index || digitalTag_getPos(elem) <= index) 
            {
                return false;
            }
            hexTextKeyDownCheck(elem, "");
        }
    }
    else
    {
        elem.onkeypress = function()
        {
            if(digitalTag_getPos(elem) > 8 + index || digitalTag_getPos(elem) <= index) 
            {
                return false;
            }
            elem.maxLength = 10;
            var evt=EventUtil.getEvent();
            hexTextKeyPressCheck(elem, "", evt);
        }
    }
}

/**
 *      
 */
function initButton()
{
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/**
 *      Tab 
 */
function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["routerestric"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["protectattri"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}


/**
 *      
 */
function rowSelectHandler()
{
    if(($("workroute").selected && routetable.getSelectedRowCount()>0) || ($("protectroute").selected && routetable1.getSelectedRowCount()>0))
    {
        $("deletebtn").disabled = false;
        $("forwardUpBtn").disabled = false;
        $("forwardDownBtn").disabled = false;
    }
    else
    {
        $("deletebtn").disabled = true;
        $("forwardUpBtn").disabled = true;
        $("forwardDownBtn").disabled = true;
    }
}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = false;
}

function swicthTab(tabStr)
{
    document.getElementById(tabStr).className = "tabSelect";
    document.getElementById(tabStr).selected = true;

    if("workroute" == tabStr)
    {
        $("protectroute").className = "tabUnselect";
        $("protectroute").selected = false;
        $("mainreroutediv").style.display = "inline";
        $("backupreroutediv").style.display = "none";
    }
    else if("protectroute" == tabStr)
    {
        $("workroute").className = "tabUnselectUp";
        $("workroute").selected = false;
        $("backupreroutediv").style.display = "inline";
        $("mainreroutediv").style.display = "none";
    }
    else
    {
        return;
    }
    
    rowSelectHandler();
}

/**
 *     tunnel
 * @return
 */
function doCreate(flag)
{
    if (!validate()) 
    {
        return;
    }

    var xml = createTunnelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_CREATE_RSVPTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, flag, "inputdata=" + xml);
}

function validate()
{
    var atom = ct.getAtom("tunnelid");
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    

    atom = ct.getAtom("snknode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
    }
    
    var createpri = ct.getAtom("createpri").getValue();
    var keeppri = ct.getAtom("keeppri").getValue();
    if(createpri < keeppri)
    {
        alert(RESOURCE["priorityerr"]);
        return false;
    }
    return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    bussiness.appendChild(createRowParams());
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createParamElement("neid", neid));
    rowparams.appendChild(createParamElement("auto", 1));
    rowparams.appendChild(createParamElement("autoassign", 2));
    rowparams.appendChild(createParamElement("tunnelindex", 0));
    rowparams.appendChild(createParamElement("tunnelid", ct.getAtom("tunnelid").getValue()));
    
    var tunnelName = ct.getAtom("tunnelname").getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createParamElement("name", tunnelName));
    }
    
    rowparams.appendChild(createParamElement("nodetype", ct.getAtom("nodetype").getValue()));
    rowparams.appendChild(createParamElement("direction", ct.getAtom("direction").getValue()));
    var bandwidth = ct.getAtom("committedinfo").getValue();
    rowparams.appendChild(createParamElement("bw", bandwidth));
    rowparams.appendChild(createParamElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
    rowparams.appendChild(createParamElement("protype", ct.getAtom("protecttype").getValue()));
    rowparams.appendChild(createParamElement("reroustate", ct.getAtom("reroutestate").getValue()));
    
    var color = ct.getAtom("color").getValue();
    rowparams.appendChild(createParamElement("affinityattr", color.substring(2,color.length)));
    var mask = ct.getAtom("mask").getValue();
    rowparams.appendChild(createParamElement("affinityattrmask", mask.substring(2,mask.length)));
    
    var snkNode = ct.getAtom("snknode").getValue();
    rowparams.appendChild(createParamElement("sinknode", snkNode));
    rowparams.appendChild(createParamElement("snknode", convertIPStrToLong(snkNode)));
    
    rowparams.appendChild(createParamElement("exp", ct.getAtom("exp").getValue()));
    rowparams.appendChild(createParamElement("createpri", ct.getAtom("createpri").getValue()));
    rowparams.appendChild(createParamElement("keeppri", ct.getAtom("keeppri").getValue()));
    
    var schetype = parseInt(ct.getAtom("schetype").getValue());
    rowparams.appendChild(createParamElement("tunneltype", schetype));
    if(0 == schetype)
    {
        rowparams.appendChild(createParamElement("cos", 255));
    }
    else if(1 == schetype)
    {
        var cos = parseInt(ct.getAtom("cos").getValue());
        rowparams.appendChild(createParamElement("cos", cos));
    }
    
    rowparams.appendChild(createParamElement("restrictnumA", routetable.getDataRowLength()));
    rowparams.appendChild(createParamElement("restrictvalueA", getRestrictValue(routetable)));
    
    if(parseInt(ct.getAtom("protecttype").getValue()) == 1)
    {
        rowparams.appendChild(createParamElement("restrictnumB", routetable1.getDataRowLength()));
        rowparams.appendChild(createParamElement("restrictvalueB", getRestrictValue(routetable1)));
        
        rowparams.appendChild(createParamElement("rvtmode", protecttable.getAtom("restoremode").getValue()));
        rowparams.appendChild(createParamElement("rvtwtr", protecttable.getAtom("WTRtime").getValue()));
    }
    
    return rowparams;
}

function createCallBack(doc, flag)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (flag && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
        else 
        {
            refreshData();
        }
    }
}

function refreshData()
{
    ct.getAtom("tunnelid", 0).setValue("");
}

function doCreateRoute()
{
    xshowModalDialog("rsvp_createreroute.html",RESOURCE["rsvpaddroute"],400,150,"../../../../images/");
}

function dodeleteRoute()
{
    if($("workroute").selected == true)
    {
        dodelete(routetable);
    }
    else
    {
        dodelete(routetable1);
    }
}

function forwardUp()
{
    if($("workroute").selected == true)
    {
        moveUp(routetable);
    }
    else
    {
        moveUp(routetable1);
    }
}

function forwardDown()
{
    if($("workroute").selected == true)
    {
        moveDown(routetable);
    }
    else
    {
        moveDown(routetable1)
    }
}

function dodelete(stable)
{
    var rowsize = stable.getDataRowLength();
    for(var i = 0; i < rowsize; i++)
    {
        if(stable.getRowSelFlag(i))
        {
           stable.deleteRow(i);
        }
    }
    stable.adjustDataRows();
}

function addRerouteRestrict(data)
{
    if($("workroute").selected == true)
    {
        insertTableRowAt(routetable, window.tableconf[0], data, RESOURCE);
        routetable.adjustDataRows();
    }
    else
    {
        insertTableRowAt(routetable1, window.tableconf[0], data, RESOURCE);
        routetable1.adjustDataRows();
    }
}

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
}
