var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var INVALID_QOS_VALUE = 4294967295;//   cir  
var INVALID_VALUE = "-";//      
var EXP_NONE = "255";//EXP none 
var currPWserviceType = 4;//                PW     (    ETH )

var TABLE_RES_MAP = [];//                    
TABLE_RES_MAP["ETH"] = "qosinfo_eth_table";//    
TABLE_RES_MAP["CES"] = "qosinfo_ces_table";//CES  
TABLE_RES_MAP["ATM"] = "qosinfo_atm_table";//ATM  

var serType2Domain = [];//              
serType2Domain[3] = "ATM";
serType2Domain[4] = "ETH";
serType2Domain[5] = "ETH";
serType2Domain[9] = "ATM";
serType2Domain[10] = "ATM";
serType2Domain[12] = "ATM";
serType2Domain[13] = "ATM";
serType2Domain[17] = "CES";
serType2Domain[21] = "CES";
serType2Domain[25] = "CES";

var pwSignalType = [];//PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = [];//PW  
pwType[4] = "pwType_4";//  Tag  
pwType[5] = "pwType_5";//  

var qosDirection = [];//  
qosDirection[1] = "qosDirection_1";
qosDirection[2] = "qosDirection_2";

var lspmode = [];//LSP  
lspmode[1] = "lspmode_1";//Uniform
lspmode[2] = "lspmode_2";//pipe
lspmode[3] = "lspmode_3";//short-pipe
lspmode[255] = "lspmode_255";//-

var ingressDirection = 1; // PW Ingress  
var egressDirection = 2; // PW Egress  

/**
 *      
 */
function init()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    st.setOnRowSelectHandler(rowQosSelectedHandler);

    $("checkpolicyinfo").value = RESOURCE["checkpolicyinfo"];
    
    $("checkpolicyinfo").onclick = queryPolicy;
}


/**
 * Tab     
 */
function tabSelectHandler()
{
    refreshTable();
}

/**
 *     
 */
function refreshTable()
{
    var selRows = parent.st.getSelectedRows();
    if (selRows.length == 0) 
    {
        return;
    }
    
    var serviceType = parent.st.getCellStoreValue(selRows[0], "serviceType", "serviceType");
    if (serType2Domain[currPWserviceType] != serType2Domain[serviceType]) 
    {
        currPWserviceType = serviceType;
        window.tableconf.length = 0;
        loadXMLdoc("../../conf/mpls/" + TABLE_RES_MAP[serType2Domain[serviceType]] + "_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
        var nodes = document.getElementById("tbdiv");
        for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
        {
            nodes.removeChild(nodes.childNodes[i]);
        }
        
        st = new SortTable();
        st.setImage("../../../../../images/");
        createTableHead(st, window.tableconf[0]);
        $("tbdiv").appendChild(st.getTable());
        
        st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    }
    
    doQuery();
}


/**
 *        xml
 */
function createQueryXml(pwIndex)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("pwIndex", pwIndex));//       
    rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
	
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
	var selRows = parent.st.getSelectedRows();
	if(selRows.length == 0)
	{
		return;
	}
	
	var pwIndex = parent.st.getCellStoreValue(selRows[0], "pwIndex", "pwIndex");
	var pwID = parent.st.getCellStoreValue(selRows[0], "pwID", "pwID");
    var xml = createQueryXml(pwIndex);
    var url = "../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW_QOS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, pwID, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc, pwID)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
		processData(data, pwID);
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
    }
    
    $("checkpolicyinfo").disabled = true;
}

/**
 *    Exp    
 * @return
 */
function addCellListener()
{
	for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
	{
	        if (st.getCellCurrentValue(i, "direction", "direction") == ingressDirection)
		{
			if (st.getCellCurrentValue(i, "exp", "exp") == EXP_NONE)
			{
				st.getCellShow(i, "exp").element.innerHTML = RESOURCE["EXP_NONE"];
			}
			else
			{
				st.getCellShow(i, "exp").element.innerHTML = st.getCellCurrentValue(i, "exp", "exp");
			}
		}
		if (st.getCellCurrentValue(i, "direction", "direction") == egressDirection)
		{
			st.getCellShow(i, "exp").element.innerHTML = "-";
		}
		
		var verArr = winobj.neversion.split('.')
		if(verArr[2] >= '05')
		{
		    var cellElement = st.getCellElement(i, "exp");
		    if(cellElement)
		    {
		        cellElement.showElement.element.innerText = "-";
		    }
		    
		    cellElement = st.getCellElement(i, "lspmode");
		    if(cellElement)
		    {
		        cellElement.showElement.element.innerText = "-";
		    }
		}
	}
	
}
/**
 *              
 * @param data        
 * @return  
 */
function processData(data, pwID)
{
	var cirPara = null;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null != data.getDataRowParam(i, "direction")) 
        {
            data.rows[i]["pwID"].value = pwID;
            
            cirPara = data.rows[i]["cir"];
            if((null != cirPara) && ("" != cirPara.value) && (INVALID_QOS_VALUE != cirPara.value))
            {
            	data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_1"];
            }else{
            	data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_0"];
            }
			
        }
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};

/**
 *   cir pir           0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertQoS(param)
{
    if (param == INVALID_QOS_VALUE) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function convertExp(param)
{
	/*
	if(param == EXP_NONE)
	{
		return RESOURCE["EXP_NONE"];
	}
	
	return param;*/
}

function rowQosSelectedHandler()
{
	if(st.getSelectedRows().length > 0)
	{
		$("checkpolicyinfo").disabled = false;
	}
	else
	{
		$("checkpolicyinfo").disabled = true;
	}
}

function queryPolicy()
{
    var policyType = 4; //  PW  

    var tmpIndex = st.getSelectedRows()[0];
    var policy = st.getCellStoreValue(tmpIndex, "policy", "policy");

    if (typeof(policy) == "undefined" || null == policy || "" == policy || INVALID_QOS_VALUE == policy) 
    {
        alert(RESOURCE["selectpolicy"]);
        return;
    }
    var url = "../ethservice/ethcommon/policyinfo.html?policyType=" + policyType + "&policyId=" + policy.substring(0, policy.indexOf("("));
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 580, 420, "../../../../../../images/");
}
