var st = null;
var Tab = null;
var countObj = null;
var INDEX_ATTR_NAME = "pwIndex";//PW Index         Ping      
var START_PING = TE_IPPTN_START_PWPING;//  Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//  Ping        
var STOP_PING = TE_IPPTN_STOP_PWPING;//  Ping      
var TEST_TYPE = "pwPing";//     PW Ping
var INDEX_ATTR_ID_RES_NAME = "pwIDPing";
var INDEX_ATTR_ID_NAME = "pwID";

var btnRightArr = new Object();
var memberInterface = new Array();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var INVALID_IP = 0;//  IP  
var INVALID_VALUE = "-";//      
var INVALID_LABEL_VALUE_1 = 0;//   label 
var INVALID_LABEL_VALUE_2 = 4294967295;//   label 
var DISABLED = 0;//   
var ENABLED = 1;//  

var pwSignalType = [];//PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = [];//PW  
pwType[3] = "pwType_3";//ATM  
pwType[4] = "pwType_4";//  Tag  
pwType[5] = "pwType_5";//  
pwType[9] = "pwType_9";//ATM n:1 VCC    
pwType[10] = "pwType_10";//ATM n:1 VPC    
pwType[12] = "pwType_12";//ATM 1:1 VCC    
pwType[13] = "pwType_13";//ATM 1:1 VPC    
pwType[17] = "pwType_17";//SATop
pwType[21] = "pwType_21";//CESoPSN
pwType[25] = "pwType_25";//ABIS

var pwDirection = [];//  
pwDirection[0] = "pwDirection_0";
pwDirection[1] = "pwDirection_1";
pwDirection[2] = "pwDirection_2";

var pwEncapsType = [];//PW    
pwEncapsType[1] = "pwEncapsType_1";//MPLS
pwEncapsType[2] = "pwEncapsType_2";//UDP
var enableState = [];//    
enableState[0] = "enableState_0";//  
enableState[1] = "enableState_1"//  
var workingStat = [];
workingStat[0] = "workingStat_0";//UP
workingStat[1] = "workingStat_1";//     
workingStat[2] = "workingStat_2";
workingStat[4] = "workingStat_4";
workingStat[6] = "workingStat_6";
workingStat[8] = "workingStat_8";
workingStat[10] = "workingStat_10";
workingStat[12] = "workingStat_12";
workingStat[14] = "workingStat_14";
workingStat[16] = "workingStat_16";
workingStat[18] = "workingStat_18";
workingStat[20] = "workingStat_20";
workingStat[22] = "workingStat_22";
workingStat[24] = "workingStat_24";
workingStat[26] = "workingStat_26";
workingStat[28] = "workingStat_28";
workingStat[30] = "workingStat_30";
workingStat[32] = "workingStat_32";
workingStat[64] = "workingStat_64";

var pwIndexArr = [];

/*
var tunnelType = [];
tunnelType["NSCMD_CFG_MPLS_GET_TUNNEL"] = "MPLS";
tunnelType["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = "IP";
tunnelType["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = "GRE";
*/
function tunnelType(val)
{
	var result = "MPLS";
	if( val == "NSCMD_CFG_MPLS_GET_TUNNEL" || val == "MPLS" )
	{
		result = "MPLS";
	}
	if( val == "NSCMD_CFG_IP_TNL_GET_TUNNEL" )
	{
		result = "IP";
	}
	if( val == "NSCMD_CFG_GRE_TNL_GET_TUNNEL" )
	{
		result = "GRE";
	}

	return result;
}


/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initTable();
    initButton();
    initTabs();
    
    initRight();
    if (btnRightArr.querybtn.right) 
    {
        window.setTimeout(doQuery, 1000);//    
    }
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    tableConf = window.tableconf[0];
    createTableHead(st, tableConf);
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
    st.setBodyWidth(tableConf.width, tableConf.percent, 0);
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

/**
 *      
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("printbtn").value = RESOURCE["printbutton"];
}

/**
 *      Tab 
 */
function initTabs()
{
    Tab = new Tabs();
    Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    Tab.addTab(1, RESOURCE["qosinfo"], "qosinfo.html");
    Tab.addTab(2, RESOURCE["advancedattr"], "advancedattr.html");
    Tab.tabNodes[1].body.style.height = "210px";
    Tab.tabNodes[2].body.style.height = "210px";
    
    Tab.selectTab(1);
    $("tabs").appendChild(Tab.getTabs());
}

/**
 *        
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_IPPTN_QUERY_PW);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_IPPTN_DEL_PW);
    
    getRightInfo(winobj, btnRightArr);
}

/**
 * Tab     
 */
function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    var selTabIndex = Tab.getSelectedTabID();
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        Tab.getTabWindow(selTabIndex).refreshTable();//    Tab     
    }
    else 
    {
        $("deletebtn").disabled = true;
        Tab.getTabWindow(selTabIndex).st.clearTableData();
    }
}

/**
 *       
 * @param {Object} evt
 */
function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        createTablePopupMenu(rows, evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createTablePopupMenu(rows, evt)
{
    removejsDOMmenu();
    var enableMenu = false;//      
    var disableMenu = false;//      
    var pingMenu = true;// PW Ping     
    for (var i = 0; i < rows.length; i++) 
    {
        var enableState = st.getCellStoreValue(rows[i], "enableState", "enableState");
        if (enableState == ENABLED) 
        {
            disableMenu = true;//                   
        }
        else 
        {
            enableMenu = true;
        }
    }
    
    if( winobj.neType == "76" || winobj.neType == "77" || winobj.neType == "83" )
    {
    	var versionArray = winobj.neversion.split(".");
    	if( (versionArray[2] + "." + versionArray[3]) >= "03.30" )
    	{
    		disableMenu = false;		
    	}
    }
	if(SpecialAttrMgr.isNESupport(winobj.neid,"TE_FUNC_CFG_IPPTN_PW","PW_ATTR_NOTSUPPORT_DISABLED_MENU"))
	{
		disableMenu = false;
	}
    
    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_1"], "", doSetEnabledStat, ENABLED, enableMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["enableState_0"], "", doSetEnabledStat, DISABLED, disableMenu));
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

/**
 *     PW
 */
function doQuery()
{
    $("querybtn").disabled = true;
    $("deletebtn").disabled = true;
    $("printbtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_IPPTN_QUERY_PW + "&nmUser=" + nmUser;
	LoadingProcess.showWaitStatus("../../../../../images/");
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
    
}

/**
 *       PW xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("pwIndex", "0"));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW     
 * @param {Object} doc
 */
function queryCallBack(doc)
{
	LoadingProcess.removeWaitStatus();
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("printbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        var ce = st.getHeadCell("pwID").element;
        st.sortRows(ce, 1);
		
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
            rowSelectHandler();
        }
        else
        {
            var selTabIndex = Tab.getSelectedTabID();
            Tab.getTabWindow(1).st.clearTableData();
            Tab.getTabWindow(2).st.clearTableData();
        }
    }
}

/**
 *     PW xml
 */
function createDelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
		var pwIndex = st.getCellStoreValue(indexes[i], "pwIndex", "pwIndex");
        rowparams.appendChild(createTagElement("pwIndex", pwIndex));
		var pwID = st.getCellStoreValue(indexes[i], "pwID", "pwID"); 
        rowparams.appendChild(createTagElement("pwID", pwID));
		pwIndexArr[pwIndex] = pwID;
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW
 */
function doDelete()
{
    removejsDOMmenu();
    if (!confirm(RESOURCE["delPWTips"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("deletebtn").disabled = true;
    $("printbtn").disabled = true;
    
    var xml = createDelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_IPPTN_DEL_PW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

/**
 *   PW     
 * @param {Object} doc
 */
function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    $("printbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempPwIndex = st.getCellCurrentValue(indexes[j], "pwIndex", "pwIndex");
            if (pwIndex == tempPwIndex) 
            {
                indexes.splice(j, 1);//          
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);//             
    }
    st.adjustDataRows();
    
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);//             
    }
    rowSelectHandler();
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = st.getCellCurrentValue(rows[i], "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
		var pwId = st.getCellCurrentValue(rows[i], "pwID", "pwID");
		row.appendChild(createTagElement("pwID", pwId));
        
        var rowEnableState = st.getCellCurrentValue(rows[i], "enableState", "enableState");
        if (rowEnableState != enableState) 
        {
            row.appendChild(createTagElement("enableState", enableState));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var rows = st.getSelectedRows();
    var xml = createSetEnabledXML(enableState, rows);
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_NF_PTN_PWTRIAL_ENABLE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, setEnabledCallBack, param, "inputdata=" + xml);
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "pwIndex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(rows[j], "pwIndex", "pwIndex");
            if (pwIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = st.getCell(rows[k], "enableState");
        st.setCellValue(enableStateCell, "enableState", param[1]);
        var cellShow = st.getCellShow(rows[k], "enableState");
        cellShow.element.innerHTML = RESOURCE["enableState_" + param[1]];
    }
}

/**
 * Ping        
 * @param {Object} rows
 */
function doPingTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("pingtest.html", RESOURCE["pingTestTitle"], 525, 540, "../../../../../images/");
}

/**
 *   
 */
function doPrint()
{
    openPrintPage("../../../../../page/", "", "st");
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";		
	for(var i = 0; i < data.errObj.rowErrors.length; i++)
	{
		var pwID = pwIndexArr[data.errObj.rowErrors[i].errorObj["pwIndex"]];
		if (pwID != null && pwID != "") 
		{
			data.errObj.rowErrors[i].errorObj["pwID"] = pwID;
		}
			
	}
	errArr[1] = "pwID";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

