
var neid = getNeProperty(self)["neid"];

var neName = getNeProperty(top)["neName"];

var winobj = getNeProperty(top);
var neid = winobj.neid;

var nmUser = winobj.nmUser;

var MIN_SDSF_VALUE = 0;// SD/SF      
var MAX_SDSF_VALUE = 100;// SD/SF      
var DISABLED = 0;//    
var ENABLED = 1;//   
var nodeType = [];//     
var INDEX_ATTR_NAME = "pwIndex";// PW Index         Ping      
var START_PING = TE_IPPTN_START_PWPING;//   Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//   Ping        
var STOP_PING = TE_IPPTN_STOP_PWOAMPING//   Ping      
var START_LB = TECMDCODE_START_MPLSTPOAM_LBTEST;//  LB      
var STOP_LB = TECMDCODE_STOP_MPLSTPOAM_LBTEST;//  LB      
var TEST_TYPE = "pwPing";//      PW Ping
var INDEX_ATTR_ID_RES_NAME = "pwIDPing";
var INDEX_ATTR_ID_NAME = "pwID";

var INVALID_IP = 0;//   IP  
var INVALID_VALUE = "-";//       
var INVALID_LABEL_VALUE_1 = 0;//    label 
var INVALID_LABEL_VALUE_2 = 4294967295;//    label 
var CV_PACKAGE_TYPE = 1;
var FD_PACKAGE_TYPE = 2;

var ENABLE_ENABLESTATE_TYPE = 0;
var UNENABLE_ENABLESTATE_TYPE = 1;

var sdcompsf = RESOURCE["sdcompsf"];

var st;
var mipst;
var tab;

var tableConfMep = null;
var tableConfMip = null;
var ismspwmip = true;//MIP            tunnel  PW  

function tabSelectHandler()
{
	if ("tab1div" == tab.getSelectEmbedTab())
	{
		doQueryMep();
	}
    else if ("tab2div" == tab.getSelectEmbedTab())
	{
		doQueryMip();
	}
}

function init()
{
    initTable();
    initTabs();
    initButton();
}

function initTable()
{
	tableConfMep = window.tableconf[0];
	if(!SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_BSCFG","MPLS_ATTR_SUPPORT_GALMODE"))
	{
		var col = tableConfMep.getColFromColId("galmode");
		if(col != null)
		{
			col.setWidth("0");
		}
	}
	st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    tableConfMep = window.tableconf[0];
    createTableHead(st, tableConfMep);
	st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    $("mepTbl").oncontextmenu = popupMenuHandlermep;
    $("mepTbl").appendChild(st.getTable());
    
    mipst = new SortTable();
    mipst.setImage("../../../../../images/");
    mipst.setOnRowSelectHandler(rowSelectHandlerMip);
    mipst.setOnCellEditHandler(cellEditHandler);
    tableConfMip = window.tableconf[1];
    createTableHead(mipst, tableConfMip);
	mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    $("mipTbl").oncontextmenu = popupMenuHandler;
    $("mipTbl").appendChild(mipst.getTable());
}

function initButton()
{
	$("qrybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("oambtnbutton").value = RESOURCE["oambtnbutton"];
    $("qrybtn").disabled = false;
    $("applybtn").disabled = true;
    
    $("queryMipBtn").value = RESOURCE["querybutton"];
    $("createMipBtn").value = RESOURCE["newbutton"];
    $("deleteMipBtn").value = RESOURCE["deletebutton"];
    $("applyMipBtn").value = RESOURCE["applybutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["mplstpoammep"], $("tab1div"));
    tab.addEmbedTab("tab2div", RESOURCE["mplstpoammip"], $("tab2div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedTab").appendChild(tab.getEmbedTabs());
}

function setBtnStatus()
{
    if (st.getSelectedRowCount() > 0) 
    {
    }
}

/* Part Query */
function doQueryMep()
{
    $("qrybtn").disabled = true;
    $("oambtnbutton").disabled = true;
    $("applybtn").disabled = true;
    var xml = createQueryXML("2", "1");
    var serverURL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_TUNNELMEP + "&flag=1" + "&nmUser=" + nmUser;
    loadXMLdoc(serverURL, "POST", true, callbackQuery, null, "inputdata=" + xml);
}

/**
 *     PW   xml
 */
function createQueryPWStatXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        var pwIndex = st.getCellStoreValue(indexes[i], "pwIndex", "pwIndex");
        rowparams.appendChild(createTagElement("pwIndex", pwIndex));
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callbackQuery(doc)
{
    $("qrybtn").disabled = false;
    $("oambtnbutton").disabled = false;
    $("applybtn").disabled = true;
    
    st.clearTableData();
    var dinterface = EncapsulateData(doc);
    
    if (0 != dinterface.getSErrorCode()) 
    {
    
        showErrorDialog(dinterface);
        $("oambtnbutton").disabled = true;
        return;
    }
    else 
    {
    	processData(dinterface);
        createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
    }
    handleTableCellEditable(); //           
    var rowCount = st.getDataRowLength();
    if (rowCount > 0) 
    {
        setRowsSelect(st, 0);//          
    }
    else 
    {
        $("oambtnbutton").disabled = true;
    }
    st.setOnRowSelectHandler(rowSelectHandler);//   OAM      
}

function processData(data)
{
	for (var i = 0, size = data.getDataRowLength(); i < size; i++) 
    {
    	var megidtype = data.rows[i]["megidtype"].value;
        if ("1" == megidtype)
        {
        	data.rows[i]["megid"].value = INVALID_VALUE;
        	data.rows[i]["mepormipid"].value = INVALID_VALUE;
        	data.rows[i]["rmepormipid"].value = INVALID_VALUE;
        }
    }
}

function callbackByQueryPWStat(doc)
{
    $("qrybtn").disabled = false;
    $("applybtn").disabled = true;
    
    var dinterface = EncapsulateData(doc);
    
    if (0 != dinterface.getSErrorCode()) 
    {
    
        showErrorDialog(dinterface);
        return;
    }
    else 
    {
        for (var i = 0; i < dinterface.getDataRowLength(); i++) 
        {
            var pwIndex = dinterface.getDataRowParam(i, "pwIndex");
            var stRowIndex = getSTRowIndexByPwIndex(pwIndex);
            
            st.setCellValue(st.getCell(stRowIndex, "localRunState"), "localRunState", dinterface.getDataRowParam(i, "localRunState"));
            var cellShow = st.getCellShow(stRowIndex, "localRunState");
            if (dinterface.getDataRowParam(i, "localRunState") == "-") {
                cellShow.element.innerHTML = "-";
            }
            else 
            {
                cellShow.element.innerHTML = RESOURCE["lspStat_" + dinterface.getDataRowParam(i, "localRunState")];
            }
            
            st.setCellValue(st.getCell(stRowIndex, "localTroubleType"), "localTroubleType", dinterface.getDataRowParam(i, "localTroubleType"));
            cellShow = st.getCellShow(stRowIndex, "localTroubleType");
            
            if (dinterface.getDataRowParam(i, "localRunState") == "-") {
                cellShow.element.innerHTML = "-";
            }
            else 
            {
                cellShow.element.innerHTML = RESOURCE["lspDetectType_" + dinterface.getDataRowParam(i, "localTroubleType")];
            }
            
            st.setCellValue(st.getCell(stRowIndex, "localDisableTime"), "localDisableTime", dinterface.getDataRowParam(i, "localDisableTime"));
            cellShow = st.getCellShow(stRowIndex, "localDisableTime");
            cellShow.element.innerHTML = dinterface.getDataRowParam(i, "localDisableTime");
            
            st.setCellValue(st.getCell(stRowIndex, "localTroublePosition"), "localTroublePosition", dinterface.getDataRowParam(i, "localTroublePosition"));
            cellShow = st.getCellShow(stRowIndex, "localTroublePosition");
            cellShow.element.innerHTML = dinterface.getDataRowParam(i, "localTroublePosition");
            
            st.setCellValue(st.getCell(stRowIndex, "remoteRunState"), "remoteRunState", dinterface.getDataRowParam(i, "remoteRunState"));
            cellShow = st.getCellShow(stRowIndex, "remoteRunState");
            if (dinterface.getDataRowParam(i, "remoteRunState") == "-") {
                cellShow.element.innerHTML = "-";
            }
            else 
            {
                cellShow.element.innerHTML = RESOURCE["lspStat_" + dinterface.getDataRowParam(i, "remoteRunState")];
            }
            
            st.setCellValue(st.getCell(stRowIndex, "remoteTroubleType"), "remoteTroubleType", dinterface.getDataRowParam(i, "remoteTroubleType"));
            cellShow = st.getCellShow(stRowIndex, "remoteTroubleType");
            if (dinterface.getDataRowParam(i, "remoteTroubleType") == "-") {
                cellShow.element.innerHTML = "-";
            }
            else 
            {
                cellShow.element.innerHTML = RESOURCE["lspDetectType_" + dinterface.getDataRowParam(i, "remoteTroubleType")];
            }
            st.setCellValue(st.getCell(stRowIndex, "remoteDisableTime"), "remoteDisableTime", dinterface.getDataRowParam(i, "remoteDisableTime"));
            cellShow = st.getCellShow(stRowIndex, "remoteDisableTime");
            cellShow.element.innerHTML = dinterface.getDataRowParam(i, "remoteDisableTime");
            
            st.setCellValue(st.getCell(stRowIndex, "remoteTroublePosition"), "remoteTroublePosition", dinterface.getDataRowParam(i, "remoteTroublePosition"));
            cellShow = st.getCellShow(stRowIndex, "remoteTroublePosition");
            cellShow.element.innerHTML = dinterface.getDataRowParam(i, "remoteTroublePosition");
            
        }
    }
    handleTableCellEditable(); //           
    st.setOnRowSelectHandler(rowSelectHandler);//   OAM      
}

function doQueryMip()
{
    $("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
    
    var xml = createQueryXML("4", "2");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryMipCallBack, null, "inputdata=" + xml);
}

function doDelMip()
{
	$("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
    
	var xml = createDelMipXml("4");
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_DEL_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, delMipCallBack, "1", "inputdata=" + xml);
}

function handleTableCellEditable()
{
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        handleIsrIdEditable(i);
        handlesendpwIDEditable(i);
        handleLmmodeEditable(i);
        handlelockstatusEditable(i);
        enableStatecell = st.getCellEdit(i, "oamstat");// OAM  
        if (null != enableStatecell) 
        {
            enableStatecell.element.onchange = function()
            {
                enableStateChange(this);
            }
        }
        
        megidtypecell = st.getCell(i, "megidtype");//    
        if (null != megidtypecell) 
        {
        	var megidtypeValue = st.getCellStoreValue(i, "megidtype", "megidtype");
        	var megidcell = st.getCell(i, "megid");
        	var mepormipidcell = st.getCell(i, "mepormipid");
        	var rmepormipidcell = st.getCell(i, "rmepormipid");
        	if (megidtypeValue == "1") 
            {
            	st.setCellIsEdit(megidcell, 0);//       
            	st.setCellIsEdit(mepormipidcell, 0);//       
            	st.setCellIsEdit(rmepormipidcell, 0);//       
            }
            
        	var cellEdit = st.getCellEdit(i, "megidtype");
            cellEdit.element.onchange = function()
            {
                megIDTypeChange(this);
            }
        }
        
        
    }
    
}

function handleIsrIdEditable(pos)
{
    var tempIndex = st.getCellStoreValue(pos, "oamstat", "oamstat");
    var lsrId = st.getCell(pos, "lsrId");
    if (tempIndex == ENABLE_ENABLESTATE_TYPE) 
    {
        st.setCellIsEdit(lsrId, 1);
    }
    else if (tempIndex == UNENABLE_ENABLESTATE_TYPE) 
    {
        st.setCellIsEdit(lsrId, 0);
    }
}

function handlesendpwIDEditable(pos)
{
    var tempIndex = st.getCellStoreValue(pos, "oamstat", "oamstat");
    var sendpwID = st.getCell(pos, "sendpwID");
    if (tempIndex == ENABLE_ENABLESTATE_TYPE) 
    {
        st.setCellIsEdit(sendpwID, 1);
    }
    else if (tempIndex == UNENABLE_ENABLESTATE_TYPE) 
    {
        st.setCellIsEdit(sendpwID, 0);
    }
}

function handleLmmodeEditable(pos)
{
	var tempIndex = st.getCellStoreValue(pos, "lmmode", "lmmode");
    var lmmode = st.getCell(pos, "lmmode");
    if (tempIndex == INVALID_VALUE||(SpecialAttrMgr.isNENotSupport(neid,"TE_FUNC_CFG_IPPTN_PW","TE_ATTR_PW_NOT_SUPPORT_LMMODE"))) 
    {    	
    	var cellShow = st.getCellShow(pos, "lmmode");   
        cellShow.element.innerHTML = "-";
        st.setCellIsEdit(lmmode, 0);
    }
    else
    {
        st.setCellIsEdit(lmmode, 1);
    }
}

function handlelockstatusEditable(pos)
{
	var tempIndex = st.getCellStoreValue(pos, "lockstatus", "lockstatus");
    var lockstatus = st.getCell(pos, "lockstatus");
    if (tempIndex == INVALID_VALUE||(SpecialAttrMgr.isNENotSupport(neid,"TE_FUNC_CFG_IPPTN_PW","TE_ATTR_PW_NOT_SUPPORT_LOCKSTATUS"))) 
    {    	
    	var cellShow = st.getCellShow(pos, "lockstatus");   
        cellShow.element.innerHTML = "-";
        st.setCellIsEdit(lockstatus, 0);
    }
    else
    {
        st.setCellIsEdit(lockstatus, 1);
    }
}

function handleGalmodeEditable(pos)
{
	var tempIndex = st.getCellStoreValue(pos, "galmode", "galmode");
    var galmode = st.getCell(pos, "galmode");
    if (tempIndex == INVALID_VALUE) 
    {
        st.setCellIsEdit(galmode, 0);
    }
    else
    {
        st.setCellIsEdit(galmode, 1);
    }
}
/**
 * "OAM  "       
 * 
 * @param {Object}
 *            selectObj
 */
function enableStateChange(selectObj)
{
    var rowIndex = selectObj.parentNode.parentNode.rowIndex;
    var lsrIdCell = st.getCell(rowIndex, "lsrId");// lsrId   
    if ("1" == selectObj.value) // OAM         lsrId      
    {
        st.setCellIsEdit(lsrIdCell, 0);
    }
    else 
    {
        st.setCellIsEdit(lsrIdCell, 1);
        st.getCell(rowIndex, "lsrId").element.modify = true;
        st.getCell(rowIndex, "lsrId").element.style.background = "#d0f946";
    }
    
    var sendpwIDCell = st.getCell(rowIndex, "sendpwID");// sendpwID   
    if ("1" == selectObj.value) // OAM         sendpwID      
    {
        st.setCellIsEdit(sendpwIDCell, 0);
    }
    else 
    {
        st.setCellIsEdit(sendpwIDCell, 1);
        st.getCell(rowIndex, "sendpwID").element.modify = true;
        st.getCell(rowIndex, "sendpwID").element.style.background = "#d0f946";
    }
}

/**
 * 10      IP  
 * 
 * @param {Object}
 *            param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * 
 * @param {Object}
 *            param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    for (var i = 0; i < data.errObj.rowErrors.length; i++) 
    {
        var pwID = getPWIDByPwIndex(data.errObj.rowErrors[i].errorObj["pwIndex"]);
        if (pwID != null && pwID != "") 
        {
            data.errObj.rowErrors[i].errorObj["pwID"] = pwID;
        }
    }
    errArr[1] = "pwID";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

function getSTRowIndexByPwIndex(pwIndex)
{
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        var tempIndex = st.getCellStoreValue(i, "pwIndex", "pwIndex");
        if (tempIndex == pwIndex) 
        {
            return i;
        }
    }
    return null;
}

function getPWIDByPwIndex(pwIndex)
{
    for (var i = 0; i < st.getDataRowLength(); i++) 
    {
        var tempIndex = st.getCellStoreValue(i, "pwIndex", "pwIndex");
        if (tempIndex == pwIndex) 
        {
            return st.getCellStoreValue(i, "pwID", "pwID");
        }
    }
    return null;
}

/*
 *        
 */
function createjsDOMenu()
{
    createPopupMenu(st.getSelectedRows());
}

function createPopupMenu(rows)
{
    removejsDOMmenu();
    var queryPWStatMenu = true;//    PW     
    var startMenu = false;//      
    var stopMenu = false;//      
    var lbMenu = false;//LB    
    for (var i = 0; i < rows.length; i++) 
    {
        var oamStat = st.getCellStoreValue(rows[i], "oamstat", "oamstat");//OAM  
        if (oamStat == DISABLED)//OAM        LB    
        {
        	lbMenu = false;
        }
        else
        {
        	lbMenu = true;
        }
        
        var cvffdStat = st.getCellStoreValue(rows[i], "ccstatus", "ccstatus");//lsp  
        if (cvffdStat == ENABLED) 
        {
            if (startMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = false;
                stopMenu = true;
            }
        }
        else 
        {
            if (stopMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = true;
                stopMenu = false;
            }
        }
    }
    var menuSize = 150;
    if (SYSTEMCONF.getLanguage() == "en") 
    {
        menuSize = 200;
    }
    var cursorMenu1 = new jsDOMenu(menuSize);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["startccres"], "", doSetEnabledStat, ENABLED, startMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["stopccres"], "", doSetEnabledStat, DISABLED, stopMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["startlbres"], "", doLBTest, rows, (rows.length == 1) && lbMenu));
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPWStat"], "", queryPWStat, rows, queryPWStatMenu));
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["pingTest"], "", doPingTest, rows, (rows.length == 1)));//           ping  
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tracerouteTest"], "", doTracerouteTest, rows, (rows.length == 1)));
    setPopUpMenu(cursorMenu1);
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var xml = createSetEnabledXML(enableState, "2");
    var rows = st.getSelectedRows();
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_CCENABLE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, setEnabledCallBack, param, "inputdata=" + xml);
}

/**
 *   PW  
 * 
 * @param  
 * @return  
 */
function queryPWStat(rows)
{
    var serverURL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_OAMSTATE + "&flag=1" + "&nmUser=" + nmUser;
    var xml = createQueryLSPStatXML(rows, "2");
    loadXMLdoc(serverURL, "POST", false, queryLSPStatCallBack, rows, "inputdata=" + xml);
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    
    if (selectedRowCount > 0) 
    {
        $("oambtnbutton").disabled = false;
    }
    else 
    {
        $("oambtnbutton").disabled = true;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function popupMenuHandlermep(evt)
{	
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;	
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
        createPopupMenu(rows, evt);
        showMenu(evt);
    }
}

/**
 *     
 * 
 * @param {Object}
 *            rows
 * @param {Object}
 *            evt
 */
function createTablePMenu(rows, evt)
{
    removejsDOMmenu();
    
    var queryPWStatMenu = true;//    PW     
    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryPWStat"], "", queryPWStat, rows, queryPWStatMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["pingTest"], "", doPingTest, rows, (rows.length == 1)));//           ping  
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tracerouteTest"], "", doTracerouteTest, rows, (rows.length == 1)));
    setPopUpMenu(cursorMenu1);
    showMenu(evt);
}

function checkDataValid()
{
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        if (st.getCellModify(rowindex, "lsrId")) 
        {
            var lsrIdValue = st.getCellShow(rowindex, "lsrId").element.innerText;
            if (!check_IPaddr(lsrIdValue)) 
            {
                return false;
            }
            else 
            {
                return true;
            }
            
        }
    }
    return true;
}

function validateSdSf()
{
    for (var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
        if (!st.getModify(rowindex)) 
        {
            continue;
        }
        if (st.getCellModify(rowindex, "sdthreshold") || st.getCellModify(rowindex, "sfthreshold")) 
        {
            var sdThCell = st.getCell(rowindex, "sdthreshold");
            var sdThValue = st.getCellStoreValue(rowindex, "sdthreshold", "sdthreshold");
            var sfThCell = st.getCell(rowindex, "sfthreshold");
            var sfThValue = st.getCellStoreValue(rowindex, "sfthreshold", "sfthreshold");            
            if (parseInt(sdThValue) > parseInt(sfThValue)) 
            {
                alert(sdcompsf);
                
                return false;
            }
            else 
            {
                return true;
            }
        }
    }
    return true;
}

function doApp()
{
    $("applybtn").disabled = true;
    $("qrybtn").disabled = true;
    $("oambtnbutton").disabled = true;
    
    removejsDOMmenu();
    
    if (!checkDataValid()) 
    {
    	$("applybtn").disabled = false;
	    $("qrybtn").disabled = false;
	    $("oambtnbutton").disabled = false;
        return;
    }
    
    if (!validateSdSf()) 
    {
    	$("applybtn").disabled = false;
	    $("qrybtn").disabled = false;
	    $("oambtnbutton").disabled = false;
        return;
    }
    var xml = createApplyMpeXML("2");
    if (null == xml)
    {
    	$("applybtn").disabled = false;
	    $("qrybtn").disabled = false;
	    $("oambtnbutton").disabled = false;
    	return;
    }
    
    var serverURL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_TUNNELMEP + "&nmUser=" + nmUser;
    loadXMLdoc(serverURL, "POST", true, callbackApply, null, "inputdata=" + xml);
}

function callbackApply(doc)
{
    var dinterface = EncapsulateData(doc);
    
    if (0 != dinterface.getSErrorCode()) 
    {
        showErrorDialog(dinterface);
    }
    
    if (2 != dinterface.getSErrorCode())
    {
    	doQueryMep();
    }
    else
    {
    	$("applybtn").disabled = false;
	    $("qrybtn").disabled = false;
	    $("oambtnbutton").disabled = false;
    }
}

function doSetMip()
{
	$("queryMipBtn").disabled = true;
    $("createMipBtn").disabled = true;
    $("deleteMipBtn").disabled = true;
    $("applyMipBtn").disabled = true;
	var xml = createSetMipXml("4");
	if (null == xml)
	{
		$("queryMipBtn").disabled = false;
	    $("createMipBtn").disabled = false;
	    $("deleteMipBtn").disabled = false;
	    $("applyMipBtn").disabled = false;
		return;	
	}
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_MIP + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, delMipCallBack, null, "inputdata=" + xml);
}

function doCreateMip()
{
	removejsDOMmenu();
    xshowModalDialog("tunnel_mplstp_oam_crtmip.html", RESOURCE["pingTestTitle"], 525, 180, "../../../../../images/", false);
}

/**
 * Ping        
 * 
 * @param {Object}
 *            rows
 */
function doPingTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("oampingtest.html", RESOURCE["pingTestTitle"], 525, 600, "../../../../../images/");
}

function doTracerouteTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("oamtraceroutetest.html", RESOURCE["pingTestTitle"], 525, 600, "../../../../../images/");
}

window.onresize = function()
{
	mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
	mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
    st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
}

function setSelectedEmbedTab(id)
{
	if ("tab1div" == id)
	{
		mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
		st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
		doQueryMep();
	}
	if ("tab2div" == id)
	{
		st.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		st.setBodyWidth(tableConfMep.width, tableConfMep.percent, 0);
		mipst.setBodyHeight(getComponetHeight($("tablecomponent"), 200) + "px");
		mipst.setBodyWidth(tableConfMip.width, tableConfMip.percent, 0);
		doQueryMip();
	}
	
	for (var key in tabList)
	{
		if (!tabList[key] || !tabList[key].tagName || tabList[key].tagName.toLowerCase() != "div")
		{
			continue;
		}
		
		if (key == id)
		{
			tabHeadList[key].className = "tabs_head_select";
			tabList[key].style.display = "";
		}
		else
		{
			tabHeadList[key].className = "tabs_head";
			tabList[key].style.display = "none";
		}
	}
	
	if (window.embedTabSelectHandler)
	{
		embedTabSelectHandler(id);
	}
}
