var ct = null;

loadXMLdoc("../../../../../conf/system.xml", "GET", false, EncapsulateSConf);

var win = ((SYSTEMCONF.getStatus() == '0') ? window.dialogArguments : getParentWindow());
var neid = win.neid;
var nmUser = win.nmUser;
var indexName = win.INDEX_ATTR_NAME;//Index     (  pwIndex tunnelindex )
var idName = win.INDEX_ATTR_ID_NAME;//id    (  pwID,tunnelid )
var idNameRes = win.INDEX_ATTR_ID_RES_NAME;//id    (  pwID,tunnelid )
var START_PING = win.START_PING;//  Ping      
var NOTIFY_PING_STAT = win.NOTIFY_PING_STAT;//  Ping        
var STOP_PING = win.STOP_PING;//  Ping      
var TEST_TYPE = win.TEST_TYPE;//     PW Ping   Tunnel Ping
var intervalID = 0;//     
var idValue;//    Tunnel PW ID 
var PING_RESULT_ATTR = ["lsrId", "packageNum", "serialNo", "time", "ttl", "rtnCode", "subRtnCode"];
var PING_TIMEOUT_ATTR = ["serialNo"];
var PING_STATISTIC_ATTR = ["sendNum", "revNum", "lostPer", "minTimeout", "maxTimeout", "averageTimeout"];
var isTesting = false;//       
var isBack = true;

var isSuppNewPackageLength = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_MPLS_PING_AND_TRACEROUTE", "TE_ATTR_MPLS_SUPPORT_NEW_PACKAGELENGTH");

function init()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("text");
    atom.setValue("3");
    checkText(atom.element, "1", "4294967295");
    ct.addAttrRow("packageCount", RESOURCE["packageCount"], atom);
    
    atom = new Atom("text");
    atom.setValue("7");
    checkText(atom.element, "0", "7");
    ct.addAttrRow("expValue", RESOURCE["expValue"], atom);
    
    atom = new Atom("text");
    atom.setValue("255");
    checkText(atom.element, "1", "255");
    ct.addAttrRow("ttl", RESOURCE["TTL"], atom);
    
    atom = new Atom("text");
    atom.setValue("100");
    checkText(atom.element, "1", "1000");
    ct.addAttrRow("sendPeriod", RESOURCE["sendPeriod"], atom);
    
    if(isSuppNewPackageLength)
    {
    	atom = new Atom("text");
        atom.setValue("100");
        checkText(atom.element, "65", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
    }
    else
    {
    	atom = new Atom("text");
        atom.setValue("64");
        checkText(atom.element, "64", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
    }
    
    atom = new Atom("text");
    atom.setValue("300");
    checkText(atom.element, "1", "6000");
    ct.addAttrRow("replyTimeout", RESOURCE["replyTimeout"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["noreply"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["udpreply"], "2");
    
    var nevs = win.winobj.neversion.split('.');
    var neType = win.winobj.neType;
    if(isRTN900NEtype(neType))
    {
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["apctlchlreply"], "4");
    }
    
    atom.element.selectedIndex = 1;
    ct.addAttrRow("replyModel", RESOURCE["replyModel"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
    
    $("starttest").value = RESOURCE["startTest"];
    $("stoptest").value = RESOURCE["stopTest"];
    $("stoptest").disabled = true;
    $("testResultShow").innerHTML = RESOURCE["testResult"];
}


function createStartXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    rowparams.appendChild(createTagElement("packageCount", ct.getAtom("packageCount").getValue()));
    rowparams.appendChild(createTagElement("expValue", ct.getAtom("expValue").getValue()));
    rowparams.appendChild(createTagElement("ttl", ct.getAtom("ttl").getValue()));
    rowparams.appendChild(createTagElement("sendPeriod", ct.getAtom("sendPeriod").getValue()));
    rowparams.appendChild(createTagElement("replyModel", ct.getAtom("replyModel").getValue()));
    rowparams.appendChild(createTagElement("packageLength", ct.getAtom("packageLength").getValue()));
    rowparams.appendChild(createTagElement("replyTimeout", ct.getAtom("replyTimeout").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStartTest()
{
    $("starttest").disabled = true;
    $("stoptest").disabled = true;
    isBack = true;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    idValue = win.st.getCellStoreValue(selectedPw[0], idName, idName);
    var xml = createStartXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + START_PING + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, startCallBack, null, "inputdata=" + xml);
}

function startCallBack(doc)
{
    var data = EncapsulateData(doc);
	
	var testRow = win.st.getSelectedRows()[0];
	var testId = win.st.getCellStoreValue(testRow, idName, idName);
	var errArr = [];
    errArr[0] = "nename";
	
	for(var i = 0; i < data.getError().rowErrors.length; i++)
	{
		var rowError = data.getError().rowErrors[i];
		rowError.errorObj["testId"] = RESOURCE[idNameRes] + testId;
		errArr[1] = "testId";
		break;
	}
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        $("stoptest").disabled = false;
        $("testresult").innerHTML = "";
        intervalID = setInterval(refreshPingResult, 1000);
		isTesting = true;
    }
    else 
    {
        $("starttest").disabled = false;
		isTesting = false;
    }
}

function createRereshXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshPingResult()
{
    if(!isBack)
    {
    	 return;
    }
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createRereshXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + NOTIFY_PING_STAT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
    isBack = false;
}

function refreshBackHandler(doc)
{
    var data = EncapsulateData(doc);
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var eventType = data.getDataRowParam(i, "eventType");
        var eventTypeRes = RESOURCE["splitStr"] + " " + RESOURCE[TEST_TYPE] + RESOURCE["eventType_" + eventType] + " " + RESOURCE["splitStr"];
        var showInfo = "";
        
        switch (eventType)
        {
            case "0":
                showInfo = getShowInfo(data, i, PING_RESULT_ATTR);
                break;
            case "1":
                showInfo = getShowInfo(data, i, PING_TIMEOUT_ATTR);
                break;
            case "2":
                clearInterval(intervalID);
                showInfo = getShowInfo(data, i, PING_STATISTIC_ATTR);
                $("starttest").disabled = false;
                $("stoptest").disabled = true;
				isTesting = false;
                break;
            default:
                break;
        }
        
        if (showInfo != "") 
        {
            showInfo = eventTypeRes + "<br/>" + showInfo;
            var e = document.createElement("div");
            e.align = "left";
            e.innerHTML = showInfo;
            $("testresult").appendChild(e);
        }
    }
    isBack = true;
}

function getShowInfo(data, index, attrArr)
{
    var tempInfo = RESOURCE[idNameRes] + idValue + "<br/>";
   
    for (var i = 0; i < attrArr.length; i++) 
    {
        var attrValue = data.getDataRowParam(index, attrArr[i]);
        
        /**lsrId IP                              IP   
         **    DTS2011081001243 
         **/
        if(attrArr[i] == 'lsrId' && attrValue.indexOf('.') < 0)
        {
            attrValue = convertNumToIpaddr(attrValue);
        }
        
        tempInfo = tempInfo + RESOURCE[attrArr[i]] + attrValue + "<br/>";
    }
    
    return tempInfo + "<br/>";
}


function createStopXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStopTest()
{
    $("stoptest").disabled = false;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createStopXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + STOP_PING + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, stopCallBack, null, "inputdata=" + xml);
}

function stopCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        clearInterval(intervalID);
        $("starttest").disabled = false;
        $("stoptest").disabled = true;
		isTesting = false;
    }
    else
    {
        $("stoptest").disabled = false;
    }
}

/**
 *           
 */
if(SYSTEMCONF.getStatus() == '0') 
{
    window.onbeforeunload = actionOnBeforeUnload;
} else {
    win.subModelWins['ev_onClose'] = null;
    win.subModelWins.attachEvent('onClose', actionOnBeforeUnload);
}

function actionOnBeforeUnload()
{
    if (isTesting) 
    {
        if (confirm(RESOURCE["stopTestTips"])) 
        {
            doStopTest();
            
            if(SYSTEMCONF.getStatus() == '1')
            {
                
                return true;
            }
        } else {
            
            if(SYSTEMCONF.getStatus() == '1')
            {
                return false;
            }                 
            
            return ""; //              
        }
    }
    
    if(SYSTEMCONF.getStatus() == '1')
    {
        return true;
    }
}
