var ct = null;
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var indexName = win.INDEX_ATTR_NAME;//Index     (  pwIndex tunnelindex )
var idName = win.INDEX_ATTR_ID_NAME;//id    (  pwID,tunnelid )
var idNameRes = win.INDEX_ATTR_ID_RES_NAME;//id    (  pwID,tunnelid )
var START_PING = win.START_PING;//  Ping      
var NOTIFY_PING_STAT = win.NOTIFY_PING_STAT;//  Ping        
var STOP_PING = win.STOP_PING;//  Ping      
var TEST_TYPE = win.TEST_TYPE;//     PW Ping   Tunnel Ping
var intervalID = 0;//     
var idValue;//    Tunnel PW ID 
var PING_RESULT_ATTR = ["lsrId", "packageNum", "serialNo", "time", "ttl", "rtnCode", "subRtnCode"];
var PING_TIMEOUT_ATTR = ["serialNo"];
var PING_STATISTIC_ATTR = ["sendNum", "revNum", "lostPer", "minTimeout", "maxTimeout", "averageTimeout"];
var isTesting = false;//       
var INVALID_IP = 0;//  IP  

var isSuppNewPackageLength = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_MPLS_PING_AND_TRACEROUTE", "TE_ATTR_MPLS_SUPPORT_NEW_PACKAGELENGTH");

function init()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("text");
    atom.setValue("3");
    checkText(atom.element, "1", "4294967295");
    ct.addAttrRow("packageCount", RESOURCE["packageCount"], atom);
    ct.setAttrValue("id", "packageCount");
    
    atom = new Atom("text");
    atom.setValue("7");
    checkText(atom.element, "0", "7");
    ct.addAttrRow("expValue", RESOURCE["expValue"], atom);
    ct.setAttrValue("id", "expValue");
    
    atom = new Atom("text");
    atom.setValue("255");
    checkText(atom.element, "1", "255");
    ct.addAttrRow("ttl", RESOURCE["TTL"], atom);
    ct.setAttrValue("id", "ttl");
    
    atom = new Atom("text");
    atom.setValue("100");
    checkText(atom.element, "1", "1000");
    ct.addAttrRow("sendPeriod", RESOURCE["sendPeriod"], atom);
    ct.setAttrValue("id", "sendPeriod");
    
    if(isSuppNewPackageLength)
    {
    	atom = new Atom("text");
        atom.setValue("100");
        checkText(atom.element, "65", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
        ct.setAttrValue("id", "packageLength");
    }
    else
    {
    	atom = new Atom("text");
        atom.setValue("64");
        checkText(atom.element, "64", "1400");
        ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
        ct.setAttrValue("id", "packageLength");
    }
    
    atom = new Atom("text");
    atom.setValue("300");
    checkText(atom.element, "1", "6000");
    ct.addAttrRow("replyTimeout", RESOURCE["replyTimeout"], atom);
    ct.setAttrValue("id", "replyTimeout");
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["noreply"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["udpreply"], "2");
   
    var nevs = win.winobj.neversion.split('.');
    var neType = win.winobj.neType;
    if(isRTN900NEtype(neType))
    {
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["apctlchlreply"], "4");
    }
    
    atom.element.selectedIndex = 1;
    ct.addAttrRow("replyModel", RESOURCE["replyModel"], atom);
    ct.setAttrValue("id", "replyModel");
    
    var selectedPw = win.st.getSelectedRows();
    var sendpwIDValue = win.st.getCellStoreValue(selectedPw[0], "sendpwID", "sendpwID");
    var lsrIdIPaddValue =  win.st.getCellStoreValue(selectedPw[0], "lsrId", "lsrId");
    
    if (isSupportIP())
    {
		var showAtom = win.st.getCellShow(selectedPw[0], "sendpwID");
		if(showAtom != null)
		{
			sendpwIDValue = showAtom.getValue();
		}
		else
		{
			sendpwIDValue = win.st.getCellStoreValue(selectedPw[0], "pwID","pwID");
		}
    	
    	lsrIdIPaddValue = win.st.getCellStoreValue(selectedPw[0], "lsrId", "lsrId");
    
        var lsrIdValue = convertNumToIpaddr(lsrIdIPaddValue);
        
        atom = new Atom("text");    
        atom.setValue(sendpwIDValue);
        checkText(atom.element, "0", "4294967295");
        ct.addAttrRow("sendpwID", RESOURCE["sendpwID"], atom);
        ct.setAttrValue("id", "sendpwID");
        
        atom = new Atom("text");
        atom.setValue(lsrIdValue);
        ct.addAttrRow("sendIP", RESOURCE["sendIP"], atom);
        ct.setAttrValue("id", "sendIP");
    }
    
    $("tbdiv").appendChild(ct.getTable());
    
    $("starttest").value = RESOURCE["startTest"];
    $("stoptest").value = RESOURCE["stopTest"];
    $("stoptest").disabled = true;
    $("testResultShow").innerHTML = RESOURCE["testResult"];
}

function validate()
{
    var atom = ct.getAtom("sendpwID");
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputlsrId"]);
        return false;
    }
    
    atom = ct.getAtom("sendIP");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsendpwID"]);
            return false;
        }
        
    }
    if (!check_IPaddr(v)) 
    {
        return false;
    }
    
    return true;
}

function isSupportIP()
{
	var versions = win.winobj.neversion.split(".");
	if((versions[1] == "76" && versions[2] < "03")
		&& versions[1] == "83" && versions[2] < "03")
	{
		return false;
	}
	return true;
}


function createStartXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
 
    if (isSupportIP())
    {
        var sendIP = convertIPToTen(ct.getAtom("sendIP").getValue());
        rowparams.appendChild(createTagElement("sendIP", sendIP));
        rowparams.appendChild(createTagElement("sendpwID", ct.getAtom("sendpwID").getValue()));
    }
    rowparams.appendChild(createTagElement("packageCount", ct.getAtom("packageCount").getValue()));
    rowparams.appendChild(createTagElement("expValue", ct.getAtom("expValue").getValue()));
    rowparams.appendChild(createTagElement("ttl", ct.getAtom("ttl").getValue()));
    rowparams.appendChild(createTagElement("sendPeriod", ct.getAtom("sendPeriod").getValue()));
    rowparams.appendChild(createTagElement("replyModel", ct.getAtom("replyModel").getValue()));
    rowparams.appendChild(createTagElement("packageLength", ct.getAtom("packageLength").getValue()));
    rowparams.appendChild(createTagElement("replyTimeout", ct.getAtom("replyTimeout").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStartTest()
{
    if ((win.winobj.neversion >= "5.76.03.10" && win.winobj.neversion <= "5.76.99.99")
        || (win.winobj.neversion >= "5.83.03.10" && win.winobj.neversion <= "5.83.99.99")
        || (win.winobj.neversion >= "5.95.05.10" && win.winobj.neversion <= "5.95.99.99"))
    {
        if (!validate()) 
        {
            return;
        }
    }
    $("starttest").disabled = true;
    $("stoptest").disabled = true;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    idValue = win.st.getCellStoreValue(selectedPw[0], idName, idName);
    var xml = createStartXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + START_PING + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, startCallBack, null, "inputdata=" + xml);
}

function startCallBack(doc)
{
    var data = EncapsulateData(doc);
    
    var testRow = win.st.getSelectedRows()[0];
    var testId = win.st.getCellStoreValue(testRow, idName, idName);
    var errArr = [];
    errArr[0] = "nename";
    
    for (var i = 0; i < data.getError().rowErrors.length; i++) 
    {
        var rowError = data.getError().rowErrors[i];
        rowError.errorObj["testId"] = RESOURCE[idNameRes] + testId;
        errArr[1] = "testId";
        break;
    }
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        $("stoptest").disabled = false;
        $("testresult").innerHTML = "";
        intervalID = setInterval(refreshPingResult, 1000);
        isTesting = true;
    }
    else 
    {
        $("starttest").disabled = false;
        isTesting = false;
    }
}

function createRereshXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshPingResult()
{
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createRereshXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + NOTIFY_PING_STAT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
}

function refreshBackHandler(doc)
{	
	
    var data = EncapsulateData(doc);
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var eventType = data.getDataRowParam(i, "eventType");
        var eventTypeRes = RESOURCE["splitStr"] + " " + RESOURCE[TEST_TYPE] + RESOURCE["eventType_" + eventType] + " " + RESOURCE["splitStr"];
        var showInfo = "";
        
        switch (eventType) 
        {
            case "0":
                showInfo = getShowInfo(data, i, PING_RESULT_ATTR);
                break;
            case "1":
                showInfo = getShowInfo(data, i, PING_TIMEOUT_ATTR);
                break;
            case "2":
                clearInterval(intervalID);
                showInfo = getShowInfo(data, i, PING_STATISTIC_ATTR);
                $("starttest").disabled = false;
                $("stoptest").disabled = true;
                isTesting = false;
                break;
            default:
                break;
        }
        
        if (showInfo != "") 
        {
            showInfo = eventTypeRes + "<br/>" + showInfo;
            var e = document.createElement("div");
            e.align = "left";
            e.innerHTML = showInfo;
            $("testresult").appendChild(e);
        }
    }
}

function getShowInfo(data, index, attrArr)
{
    var tempInfo = RESOURCE[idNameRes] + idValue + "<br/>";
    for (var i = 0; i < attrArr.length; i++) 
    {
        var attrValue = data.getDataRowParam(index, attrArr[i]);
        tempInfo = tempInfo + RESOURCE[attrArr[i]] + attrValue + "<br/>";
    }
    return tempInfo + "<br/>";
}


function createStopXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStopTest()
{
    $("stoptest").disabled = false;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createStopXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + STOP_PING + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, stopCallBack, null, "inputdata=" + xml);
}

function stopCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        clearInterval(intervalID);
        $("starttest").disabled = false;
        $("stoptest").disabled = true;
        isTesting = false;
    }
    else 
    {
        $("stoptest").disabled = false;
    }
}

/**
 *           
 */
window.onbeforeunload = function()
{
    if (isTesting) 
    {
        if (confirm(RESOURCE["stopTestTips"])) 
        {
            doStopTest();
        }
        else
        {
        	return RESOURCE["closewinalert"];
        }
    }
}

/**
 * 10      IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *   IP   10   
 * @param {Object} param
 */
function convertIPToTen(param)
{
    var hexIP = convertIpaddrToHexcode(param);
    
    return hexToTen(hexIP);
}
