var st = null;
var Tab = null;
var countObj = null;
var tableConf;
var INDEX_ATTR_NAME = "tunnelindex";////Tunnel Index         Ping      
var START_PING = TE_CMD_MPLSTUNNEL_LSPPING;//  LSP Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//  Ping        
var STOP_PING = TE_IPPTN_STOP_PWPING;//  Ping      
var TEST_TYPE = "lspPing";//     LSP Ping
var INDEX_ATTR_ID_NAME = "tunnelid";
var INDEX_ATTR_ID_RES_NAME = "tunnelidPing";

var btnRightArr = new Object();
var memberInterface = new Array();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var INVALID_TUNNLE_INDEX = 4294967295;//   Tunnel Index 
var MIN_SDSF_VALUE = 0;//SD/SF      
var MAX_SDSF_VALUE = 100;//SD/SF      
var DISABLED = 0;//   
var ENABLED = 1;//  
var nodeType = [];//    
nodeType[1] = "ingress";
nodeType[2] = "transit";
nodeType[3] = "egress";

var enableState = [];//OAM  
enableState[0] = "enableState_0";//  
enableState[1] = "enableState_1"//  
var detectionMode = [];//    
detectionMode[1] = "detectionMode_1";//   
detectionMode[2] = "detectionMode_2";//  
detectionMode[255] = "INVALID_VALUE";
var detectType = [];//      
detectType[1] = "detectType_1";//CV
detectType[2] = "detectType_2";//FFD
var detectPeriod = [];//    
detectPeriod[1] = "detectPeriod_1";//3.3
detectPeriod[2] = "detectPeriod_2";//10
detectPeriod[3] = "detectPeriod_3";//20
detectPeriod[4] = "detectPeriod_4";//50
detectPeriod[5] = "detectPeriod_5";//100
detectPeriod[6] = "detectPeriod_6";//200
detectPeriod[7] = "detectPeriod_7";//500
detectPeriod[255] = "detectPeriod_255";//1000
var cvFfd = [];//CV/FFD
cvFfd[0] = "cvFfd_0";//  
cvFfd[1] = "cvFfd_1";//  
cvFfd[255] = "INVALID_VALUE";
var lspStat = [];//LSP  
lspStat[0] = "lspStat_0";
lspStat[1] = "lspStat_1";
lspStat[2] = "lspStat_2";
lspStat[3] = "lspStat_3";
lspStat[4] = "lspStat_4";
lspStat[5] = "lspStat_5";
lspStat[6] = "lspStat_6";
lspStat[7] = "lspStat_7";
lspStat[8] = "lspStat_8";

var lspDetectType = [];//LSP    
lspDetectType[1] = "lspDetectType_1";
lspDetectType[2] = "lspDetectType_2";
lspDetectType[3] = "lspDetectType_3";
lspDetectType[4] = "lspDetectType_4";
lspDetectType[5] = "lspDetectType_5";
lspDetectType[6] = "lspDetectType_6";
lspDetectType[7] = "lspDetectType_7";
lspDetectType[255] = "INVALID_VALUE";

var tunnelDirection = [];
tunnelDirection[1] = "pwDirection_1";
tunnelDirection[0] = "pwDirection_2";
/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initTable();
    initButton();
    initRight();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    tableConf = window.tableconf[0];
    createTableHead(st, tableConf);
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
    st.setBodyWidth(tableConf.width, tableConf.percent, 0);
    
    $("tablecomponent").oncontextmenu = popupMenuHandler;
}

/**
 *      
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("oambtn").value = RESOURCE["oambtnbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}


/**
 *        
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_MPLSTUNNEL_QUERY_OAMSTATE);
    btnRightArr.oambtn = new BtnRightObj("oambtn", TE_IPPTN_DEL_PW);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_MPLSTUNNEL_SET_TUNNELOAM);
    
    getRightInfo(winobj, btnRightArr);
}

/**
 * Tab     
 */
function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function cellEditHandler(param)
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    if (selectedRowCount > 0) 
    {
        $("oambtn").disabled = !btnRightArr.oambtn.right;
    }
    else 
    {
        $("oambtn").disabled = true;
    }
}

/**
 *       
 * @param {Object} evt
 */
function popupMenuHandler(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    var elem = (evt.target) ? evt.target : evt.srcElement;
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (colid == "reversetunnel") 
    {
        return;
    }
    
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            createTablePopupMenu(elem, evt);
            return;
        }
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
        createPopupMenu(rows, evt);
        showMenu(evt);
    }
}

/**
 *     
 * @param {Object} rows
 * @param {Object} evt
 */
function createPopupMenu(rows)
{
    removejsDOMmenu();
    var startMenu = false;//      
    var stopMenu = false;//      
    var pingTestMenu = false;//          
    for (var i = 0; i < rows.length; i++) 
    {
        var direction = st.getCellStoreValue(rows[i], "direction", "direction");

        var nodeType = st.getCellStoreValue(rows[i], "nodetype", "nodetype");//    

        if( nodeType == 3 && direction == 0 )		//    Egress       
        {
            pingTestMenu = false;
        }
        else
        {
            pingTestMenu = true;
        }
        
       
        if (nodeType != 1 && direction == 0)//Egress       
        {
            startMenu = false;
            stopMenu = false;
            break;
        }
         
        var oamStat = st.getCellStoreValue(rows[i], "oamstat", "oamstat");//OAM  
        if (oamStat == DISABLED)//OAM              
        {
            startMenu = false;
            stopMenu = false;
            break;
        }
        
        var cvffdStat = st.getCellStoreValue(rows[i], "cvffdstat", "cvffdstat");//lsp  
        if (cvffdStat == ENABLED) 
        {
            if (startMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = false;
                stopMenu = true;
            }
        }
        else 
        {
            if (stopMenu)//                 
            {
                startMenu = false;
                stopMenu = false;
                break;
            }
            else 
            {
                startMenu = true;
                stopMenu = false;
            }
        }
    }
    
    var cursorMenu1 = new jsDOMenu(150);
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["startVcFFD"], "", doSetEnabledStat, ENABLED, startMenu));
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["stopVcFFD"], "", doSetEnabledStat, DISABLED, stopMenu));
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["queryLSPStat"], "", doQueryLSPStat, rows, true));//          ping  
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearOAM"], "", doClearOAM, rows, true));//          ping  
    cursorMenu1.addMenuItem(new menuItem("-"));//   
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tunnlePingTest"], "", doPingTest, rows, (rows.length == 1) && pingTestMenu));//          ping  
    cursorMenu1.addMenuItem(new menuItem(RESOURCE["tracerouteTest"], "", doTracerouteTest, rows, (rows.length == 1) && pingTestMenu));//          ping  
    setPopUpMenu(cursorMenu1);    
}

/**
 *     PW
 */
function doQuery()
{
    $("querybtn").disabled = true;
    $("oambtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_QUERY_OAMSTATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *       PW xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("tunnelindex", "0"));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW     
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    processData(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
		var ce = st.getHeadCell("tunnelid").element;
        st.sortRows(ce, 1);
        addCellEvent();
    }
}

function processData(data)
{
    for (var i = 0, size = data.getDataRowLength(); i < size; i++) 
    {
        var detectionMode = data.getDataRowParam(i, "detectionmode");//    
        var direction = data.getDataRowParam(i, "direction");
        if (detectionMode == 1 && direction ==0)//     
        {
            data.rows[i]["detecttype"].value = INVALID_VALUE;//            
            data.rows[i]["detectperiod"].value = INVALID_VALUE;//            
        }
        var reverseTunnel = data.getDataRowParam(i, "reversetunnel");//  Tunnel
        if (reverseTunnel != INVALID_TUNNLE_INDEX)//    Tunnel
        {
            var nodeType = data.getDataRowParam(i, "nodetype");//    
            data.rows[i]["reversetunnel"].value = getRevTunnelStr(data, reverseTunnel, nodeType);//        Tunnel   
        }
        else 
        {
            data.rows[i]["reversetunnel"].value = "";
        }
        data.rows[i]["lspstat"].value = INVALID_VALUE;
        data.rows[i]["lspdefecttype"].value = INVALID_VALUE;
        data.rows[i]["disablelspduration"].value = INVALID_VALUE;
        data.rows[i]["lspdefectloc"].value = INVALID_VALUE;
        
        data.rows[i]["lspstat_far"].value = INVALID_VALUE;
        data.rows[i]["lspdefecttype_far"].value = INVALID_VALUE;
        data.rows[i]["disablelspduration_far"].value = INVALID_VALUE;
        data.rows[i]["lspdefectloc_far"].value = INVALID_VALUE;
    }
}

/**
 *           Tunnel   
 * @param {Object} data
 * @param {Object} nodeType
 */
function getRevTunnelStr(data, reverseTunnel, nodeType)
{
    for (var i = 0, size = data.getDataRowLength(); i < size; i++) 
    {
        var tunnelIndex = data.getDataRowParam(i, "tunnelindex");
        if (tunnelIndex == reverseTunnel)//  tunnelindex
        {
            var tempNodeType = data.getDataRowParam(i, "nodetype");
            if (tempNodeType != nodeType) //         
            {
                var tunnelID = data.getDataRowParam(i, "tunnelid");
                var srcNode = convertIP(data.getDataRowParam(i, "srcnode"));
                var snkNode = convertIP(data.getDataRowParam(i, "snknode"));
                return tunnelID + "(" + RESOURCE["srcnode"] + ":" + srcNode + "," + RESOURCE["snknode"] + ":" + snkNode + ")";
            }
        }
    }
    
    return reverseTunnel;//      tunnelindex 
}


/**
 *         
 */
function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        cell = st.getCell(i, "detectionmode");//    
        var direction = st.getCellStoreValue(i, "direction", "direction");
        if (null != cell) 
        {
            var detectTypeCell = st.getCell(i, "detecttype");//         
            var detectPeriodCell = st.getCell(i, "detectperiod");//      (ms)   
            var detectionModeValue = st.getCellStoreValue(i, "detectionmode", "detectionmode");
            if (detectionModeValue == 255) //        
            {
                st.setCellIsEdit(cell, 0);//           
            }
            else if (detectionModeValue == 1 && direction==0)//          
            {
                st.setCellIsEdit(detectTypeCell, 0);//             
                st.setCellIsEdit(detectPeriodCell, 0);//             
            }
            
            var cellEdit = st.getCellEdit(i, "detectionmode");
            cellEdit.element.onchange = function()
            {
                detectModeChange(this);
            }
        }
        
        cell = st.getCellEdit(i, "detecttype");//      
        if (null != cell) 
        {
            cell.element.onchange = function()
            {
                detectTypeChange(this);
            }
        }
        
        cell = st.getCell(i, "detectperiod");
        if (null != cell) 
        {
            var detectPeriodValue = st.getCellStoreValue(i, "detectperiod", "detectperiod");
            if (detectPeriodValue == 255) 
            {
                st.setCellIsEdit(cell, 0);//       
            }
        }
        
        var nodeType = st.getCellStoreValue(i, "nodetype", "nodetype");//      
        cell = st.getCell(i, "sdthreshold");
        if (null != cell) 
        {
            if (nodeType != 3 && direction ==0) 
            {
                st.setCellIsEdit(cell, 0);//             
            }
            else 
            {
                textCheck(cell.element.editElement.element, MIN_SDSF_VALUE, MAX_SDSF_VALUE);
            }
        }
        
        cell = st.getCell(i, "sfthreshold");
        if (null != cell) 
        {
            if (nodeType != 3 && direction ==0) 
            {
                st.setCellIsEdit(cell, 0);//             
            }
            else 
            {
                textCheck(cell.element.editElement.element, MIN_SDSF_VALUE, MAX_SDSF_VALUE);
            }
        }
        
        cell = st.getCell(i, "reversetunnel");
        if (null != cell) 
        {
            if(direction ==0)
            {
            cell.element.ondblclick = function()
            {
                xshowModalDialog("chooserevtunnel.html", RESOURCE["chooserevtunnel"], 645, 315, "../../../../../images/");
            }
            }
            else
            {
            	st.setCellIsEdit(cell, 0);
            	st.getCellShow(i, "reversetunnel").element.innerHTML = INVALID_VALUE;
        			st.setCellValue(cell, "reversetunnel", 255);
            }
          
        }
    }
}

/**
 * "    "       
 * @param {Object} selectObj
 */
function detectModeChange(selectObj)
{
    
    var rowIndex = selectObj.parentNode.parentNode.rowIndex;
    var detectTypeCell = st.getCell(rowIndex, "detecttype");//         
    var detectPeriodCell = st.getCell(rowIndex, "detectperiod");//      (ms)   
    var directionCell = st.getCell(rowIndex, "direction");
    
    if(st.getCellStoreValue(rowIndex, "direction", "direction")=="1")
    {
    	return;
    }
    if ("1" == selectObj.value  ) //                      
    {
        st.setCellIsEdit(detectTypeCell, 0);
        st.setCellValue(detectTypeCell, "detecttype", INVALID_VALUE);
        st.getCellShow(rowIndex, "detecttype").element.innerHTML = INVALID_VALUE;
        st.setCellIsEdit(detectPeriodCell, 0);
        st.getCellShow(rowIndex, "detectperiod").element.innerHTML = INVALID_VALUE;
        st.setCellValue(detectPeriodCell, "detectperiod", 255);
    }
    else 
    {
        st.setCellIsEdit(detectTypeCell, 1);
        st.setCellValue(detectTypeCell, "detecttype", 1);
        st.getCellShow(rowIndex, "detecttype").element.innerHTML = RESOURCE["detectType_1"];
        st.getCell(rowIndex, "detecttype").element.modify = true;
        st.getCell(rowIndex, "detecttype").element.style.background = "#d0f946";
        st.getCellShow(rowIndex, "detectperiod").element.innerHTML = 1000;
        st.setCellValue(detectPeriodCell, "detectperiod", 255);
    }
}


/**
 * "      "       
 * @param {Object} selectObj
 */
function detectTypeChange(selectObj)
{
    var rowIndex = selectObj.parentNode.parentNode.rowIndex;
    var detectPeriodCell = st.getCell(rowIndex, "detectperiod");//      (ms)   
    if ("1" == selectObj.value) //      CV               
    {
        st.setCellIsEdit(detectPeriodCell, 0);
        st.getCellShow(rowIndex, "detectperiod").element.innerHTML = 1000;
        st.setCellValue(detectPeriodCell, "detectperiod", 255);
    }
    else 
    {
        st.setCellIsEdit(detectPeriodCell, 1);
        st.getCell(rowIndex, "detectperiod").element.modify = true;
        st.getCell(rowIndex, "detectperiod").element.style.background = "#d0f946";
        st.getCellShow(rowIndex, "detectperiod").element.innerHTML = 50;
        st.setCellValue(detectPeriodCell, "detectperiod", 4);
    }
}


/**
 *     Tunnel OAM   xml
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var tunnelIndex = st.getCellCurrentValue(i, "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        
        if (st.getCellModify(i, "oamstat"))//OAM  
        {
            var oamStat = st.getCellCurrentValue(i, "oamstat", "oamstat");
            row.appendChild(createTagElement("oamstat", oamStat));
        }
        
        if (st.getCellModify(i, "detectionmode"))//    
        {
            var detectionMode = st.getCellCurrentValue(i, "detectionmode", "detectionmode");
            row.appendChild(createTagElement("detectionmode", detectionMode));
        }
        
        if (st.getCellModify(i, "detecttype") || st.getCellModify(i, "detectperiod"))//      
        {
            var detectType = st.getCellCurrentValue(i, "detecttype", "detecttype");
            var detectPeriod = st.getCellCurrentValue(i, "detectperiod", "detectperiod");
            row.appendChild(createTagElement("detecttype", detectType));
            row.appendChild(createTagElement("detectperiod", detectPeriod));
        }
        
        if (st.getCellModify(i, "reversetunnel"))//  tunnel
        {
            var reverseTunnel = st.getCellStoreValue(i, "reversetunnel", "reversetunnel");
            if (reverseTunnel == null || reverseTunnel == "") 
            {
                reverseTunnel = INVALID_TUNNLE_INDEX;//     tunnelindex       tunnel
            }
            row.appendChild(createTagElement("reversetunnel", reverseTunnel));
        }
        
        if (st.getCellModify(i, "sdthreshold") || st.getCellModify(i, "sfthreshold"))//SD/SF  
        {
            var sfThreshold = parseInt(st.getCellCurrentValue(i, "sfthreshold", "sfthreshold"));
            var sdThreshold = parseInt(st.getCellCurrentValue(i, "sdthreshold", "sdthreshold"));
            if(sfThreshold < sdThreshold)
            {
            	alert(RESOURCE["sfsdalm"]);
            	return null;
            }
            row.appendChild(createTagElement("sfthreshold", sfThreshold));
            row.appendChild(createTagElement("sdthreshold", sdThreshold));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   Tunnel OAM  
 */
function doApply()
{
    removejsDOMmenu();
    $("querybtn").disabled = true;
    $("oambtn").disabled = true;
    $("applybtn").disabled = true;
    var xml = createApplyXML();
    if(null == xml)
    {
        $("querybtn").disabled = false;
        $("oambtn").disabled = false;
        $("applybtn").disabled = false;
    	return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_SET_TUNNELOAM + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, applyCallBack, null, "inputdata=" + xml);
}

/**
 *   OAM    
 * @param {Object} doc
 */
function applyCallBack(doc)
{
    $("querybtn").disabled = false;
    $("oambtn").disabled = false;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = false;
    }
    refreshTableState(st, tableConf, data);
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        row.appendChild(createTagElement("cvffdstat", enableState));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @param {Object} enableState
 */
function doSetEnabledStat(enableState)
{
    removejsDOMmenu();
    var rows = st.getSelectedRows();
    var xml = createSetEnabledXML(enableState, rows);
    var param = [];
    param[0] = rows;
    param[1] = enableState;
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_ENABLEOAMCC + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, setEnabledCallBack, param, "inputdata=" + xml);
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0 && param[1] == ENABLED)//     CV/FFD         
    {
        alert(RESOURCE["startVCFFDTips"]);
    }
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tunnelIndex = data.getBErrParam(i, "tunnelindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(rows[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = st.getCell(rows[k], "cvffdstat");
        st.setCellValue(enableStateCell, "cvffdstat", param[1]);
        var cellShow = st.getCellShow(rows[k], "cvffdstat");
        cellShow.element.innerHTML = RESOURCE["cvFfd_" + param[1]];
    }
}


/**
 *     LSP   xml
 */
function createQueryLSPStatXML(rows)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   LSP  
 * @param {Object} rows
 */
function doQueryLSPStat(rows)
{
    removejsDOMmenu();
    var xml = createQueryLSPStatXML(rows);
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_OAM_BYINDEX + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryLSPStatCallBack, rows, "inputdata=" + xml);
}

/**
 *   LSP      
 * @param {Object} doc
 * @param {Object} param
 */
function queryLSPStatCallBack(doc, rows)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tunnelIndex = data.getBErrParam(i, "tunnelindex");
        for (var j = rows.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(rows[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var tunnelIndex = st.getCellCurrentValue(rows[k], "tunnelindex", "tunnelindex");
        for (var m = data.getDataRowLength() - 1; m >= 0; m--) 
        {
            var tempIndex = data.getDataRowParam(m, "tunnelindex");
            if (tempIndex == tunnelIndex) 
            {
                var lspstat = data.getDataRowParam(m, "lspstat");
                if( lspstat != "" && lspstat != "-" )
                {
                	setShowValue(RESOURCE["lspStat_" + lspstat], rows[k], "lspstat");
                }
                
                var lspdefecttype = data.getDataRowParam(m, "lspdefecttype");
                if( lspdefecttype != "" && lspdefecttype != "-" )
                {
                	setShowValue(RESOURCE["lspDetectType_" + lspdefecttype], rows[k], "lspdefecttype");
                }
                
                var disablelspduration = data.getDataRowParam(m, "disablelspduration");
                if( disablelspduration != "" && disablelspduration != "-" )
                {
                	setShowValue(convertNumber(disablelspduration), rows[k], "disablelspduration");
                }
                
                var lspdefectloc = data.getDataRowParam(m, "lspdefectloc");
                if( lspdefectloc != "" && lspdefectloc != "-" )
                {
                	setShowValue(convertIP(lspdefectloc), rows[k], "lspdefectloc");
                }
                
                var lspstat_far = data.getDataRowParam(m, "lspstat_far");
                if( lspstat_far != "" && lspstat_far != "-" )
                {
                	setShowValue(RESOURCE["lspStat_" + lspstat_far], rows[k], "lspstat_far");
                }
                var lspdefecttype_far = data.getDataRowParam(m, "lspdefecttype_far");
                if( lspdefecttype_far != "" && lspdefecttype_far != "-" )
                {
                	setShowValue(RESOURCE["lspDetectType_" + lspdefecttype_far], rows[k], "lspdefecttype_far");
                }
                var disablelspduration_far = data.getDataRowParam(m, "disablelspduration_far");
                if( disablelspduration_far != "" && disablelspduration_far != "-" )
                {
                	setShowValue(convertNumber(disablelspduration_far), rows[k], "disablelspduration_far");
                }
                var lspdefectloc_far = data.getDataRowParam(m, "lspdefectloc_far");
                if( lspdefectloc_far != "" && lspdefectloc_far != "-" )
                {
                	setShowValue(convertIP(lspdefectloc_far), rows[k], "lspdefectloc_far");
                }
                break;
            }
        }
    }
}

/**
 *     OAM xml
 */
function createClearOAMXML(rows)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   OAM
 */
function doClearOAM(rows)
{
    removejsDOMmenu();
    var xml = createClearOAMXML(rows);
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_CLEAR_TUNNELOAM + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, clearOAMCallBack, null, "inputdata=" + xml);
}

/**
 *   OAM    
 * @param {Object} doc
 * @param {Object} param
 */
function clearOAMCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    doQuery();//  OAM           (  T2000   )
}

/**
 *        
 * @param {Object} value
 * @param {Object} row
 * @param {Object} colid
 */
function setShowValue(value, row, colid)
{
    var cell = st.getCell(row, colid);
    var cellShow = st.getCellShow(row, colid);
    cellShow.element.innerHTML = value;
}

/**
 * Ping        
 * @param {Object} rows
 */
function doPingTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("pingtest.html", RESOURCE["pingTestTitle"], 525, 540, "../../../../../images/");
}

function doTracerouteTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("traceroutetest.html", RESOURCE["pingTestTitle"], 825, 600, "../../../../../images/");
}

/**
 *   
 */
function doPrint()
{
    openPrintPage("../../../../../page/", "", "st");
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/*
 *        
 */
function createjsDOMenu()
{
    createPopupMenu(st.getSelectedRows());
}

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
}

