var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

var neType = winobj.neType;
var nevr =  winobj.neversion.split('.');

var INVALID_QOS_VALUE = 4294967295;//   cir  
var INVALID_VALUE = "-";//      
var EXP_NONE = "255";//EXP none 
var currPWserviceType = 4;//                PW     (    ETH )

var TABLE_RES_MAP = [];//                    
TABLE_RES_MAP["ETH"] = "mspw_qosinfo_table";//    
TABLE_RES_MAP["CES"] = "mspw_qosinfo_ces_table";//CES  
TABLE_RES_MAP["ATM"] = "mspw_qosinfo_atm_table";//ATM  

var serType2Domain = [];//              
serType2Domain[1] = "CES";
serType2Domain[2] = "ATM";
serType2Domain[3] = "ETH";
serType2Domain[4] = "PTP";
serType2Domain[5] = "TOP";

var SERVICR_TYPE_CES = 1;
var DIRECTION_INGRESS = "1";//PW ingress  
var DIRECTION_EGRESS = "2";//PW egress  
var CELL_DISABLED = "0";//        
var CELL_ENABLED = "1";

var pwSignalType = [];//PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = [];//PW  
pwType[4] = "pwType_4";//  Tag  
pwType[5] = "pwType_5";//  

var qosDirection = [];//  
qosDirection[1] = "qosDirection_1";
qosDirection[2] = "qosDirection_2";

var lspmode = [];//LSP  
lspmode[1] = "lspmode_1";//Uniform
lspmode[2] = "lspmode_2";//pipe
lspmode[3] = "lspmode_3";//short-pipe
lspmode[255] = "lspmode_255";//-

var queryData;

/**
 *      
 */
function init()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    st.setOnCellEditHandler(cellEditHandler);
    
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = true;
}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = false;
}


/**
 * Tab     
 */
function tabSelectHandler()
{
	st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    refreshTable();
}

/**
 *     
 */
function refreshTable()
{
	st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    var selRows = parent.st.getSelectedRows();
    if (selRows.length == 0) 
    {
        return;
    }
    
    var serviceType = parent.st.getCellStoreValue(selRows[0], "servicetype", "servicetype");
    if (serType2Domain[currPWserviceType] != serType2Domain[serviceType]) 
    {
        currPWserviceType = serviceType;
        window.tableconf.length = 0;
        loadXMLdoc("../../conf/mpls/mspw/" + TABLE_RES_MAP[serType2Domain[serviceType]] + "_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
        var nodes = document.getElementById("tbdiv");
        for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
        {
            nodes.removeChild(nodes.childNodes[i]);
        }
        
        st = new SortTable();
        st.setImage("../../../../../images/");
        createTableHead(st, window.tableconf[0]);
        $("tbdiv").appendChild(st.getTable());
        
        st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
        st.setOnCellEditHandler(cellEditHandler);
    }
    
    doQuery();
}


/**
 *        xml
 */
function createQueryXml(pwIndexArr)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for(var i = 0; i < pwIndexArr.length; i++)
    {
        var rowparams = new tagElement("row-params");
    
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", pwIndexArr[i]));//        
        rowparams.appendChild(createTagElement("isLogFlag", "0"));//      
	
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
	var selRows = parent.st.getSelectedRows();
	if(selRows.length == 0)
	{
		return;
	}
	
	var pwIndexArr = [];
    var forwardpwindex = parent.st.getCellStoreValue(selRows[0], "forwardpwindex", "forwardpwindex");
    var backwardpwindex = parent.st.getCellStoreValue(selRows[0], "backwardpwindex", "backwardpwindex");
    pwIndexArr.push(forwardpwindex);
    pwIndexArr.push(backwardpwindex);
    var xml = createQueryXml(pwIndexArr);
    var url = "../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW_QOS + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    queryData = data;
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
		processData(data);
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        setCellDisabled();
        
        for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
        {
            var bandwidthlimitCell = st.getCellEdit(i, "bandwidthLimit");
	        if(bandwidthlimitCell != null)
	        {
	        	var bandwidthlimitStoreValue = st.getCellStoreValue(i, "bandwidthLimit", "bandwidthLimit");
	        	if( bandwidthlimitStoreValue == RESOURCE["enableState_0"] )	//      
	        	{
	        		var cbsCellShow = st.getCellShow(i, "cbs");
	        		if( cbsCellShow != null )
	        		{
	        			cbsCellShow.setValue("-");
	        		}
	        		
	        		var pbsCellShow = st.getCellShow(i, "pbs");
	        		if( pbsCellShow != null )
	        		{
	        			pbsCellShow.setValue("-");
	        		}
	        	}

		        bandwidthlimitCell.element.onchange = function ()
		        {
		        	 var selectIndex = st.getSelectedRows()[0];
		        	 if(this.value ==1)
		        	 {
		        	 	 var cell = st.getCell(selectIndex, "cir");
		             st.setCellIsEdit(cell, 1);
		             st.getCellShow(selectIndex, "cir").element.innerHTML = "64";
		             
		             cell = st.getCell(selectIndex, "cbs");
		             st.setCellIsEdit(cell, 1);
		             st.getCellShow(selectIndex, "cbs").element.innerHTML = "";
		             
		             cell = st.getCell(selectIndex, "pir");
		             st.setCellIsEdit(cell, 1);
		             st.getCellShow(selectIndex, "pir").element.innerHTML = "64";
		             
		             cell = st.getCell(selectIndex, "pbs");
		             st.setCellIsEdit(cell, 1);
		             st.getCellShow(selectIndex, "pbs").element.innerHTML = "";
		        	 	
		        	 }
		        	 else
		        	 {
		        	 	  var cell = st.getCell(selectIndex, "cir");
		             st.setCellIsEdit(cell, 0);
		             st.getCellShow(selectIndex, "cir").element.innerHTML = "-";
		             
		             cell = st.getCell(selectIndex, "cbs");
		             st.setCellIsEdit(cell, 0);
		             st.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
		             
		             cell = st.getCell(selectIndex, "pir");
		             st.setCellIsEdit(cell, 0);
		             st.getCellShow(selectIndex, "pir").element.innerHTML = "-";
		             
		             cell = st.getCell(selectIndex, "pbs");
		             st.setCellIsEdit(cell, 0);
		             st.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
		        	 }
		        }
	        }
       
            if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0310') ||
               ( isOSN5X0NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510'))
		     {
			    textCheck(st.getCellEdit(i, "cbs").element,"0","4294967295");
			    textCheck(st.getCellEdit(i, "pbs").element,"0","4294967295");
			} else
			{
			    textCheck(st.getCellEdit(i, "cbs").element,"0","512000");
			    textCheck(st.getCellEdit(i, "pbs").element,"0","512000");
			} 
		    
		    
		    textCheckWithStepLen(st.getCellEdit(i, "cir").element,0,1000000,64);
			textCheckWithStepLen(st.getCellEdit(i, "pir").element,0,1000000,64);
        
        }
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    var pwIndexIdMap = [];
    var nullPWIdRows = [];
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var cir = data.getDataRowParam(i, "cir");
        
        if (null != data.getDataRowParam(i, "direction")) 
        {
						if(cir == INVALID_QOS_VALUE)
						{
							data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_0"];
						}
						else
						{
							data.rows[i]["bandwidthLimit"].value = RESOURCE["enableState_1"];
						}
        }
        
        var direction = data.getDataRowParam(i, "direction");
        if(direction == DIRECTION_EGRESS)
        {
            data.rows[i]["exp"].value = INVALID_VALUE;//egress   PW EXP    
        }
        
        var pwID = data.getDataRowParam(i, "pwID");
        if (pwID != null && pwID != "")
        {
            var pwIndex = data.getDataRowParam(i, "pwIndex");
            pwIndexIdMap[pwIndex] = pwID;
        }
        else
        {
            nullPWIdRows.push(i);
        }
    }
    
    for(var j = 0; j < nullPWIdRows.length; j++)
    {
        var rowIndex = nullPWIdRows[j];
        var pwIndex = data.getDataRowParam(rowIndex, "pwIndex");
        data.rows[rowIndex]["pwID"].value = pwIndexIdMap[pwIndex];
    }
}

function setCellDisabled()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var direction = st.getCellStoreValue(i, "direction", "direction");
        var cir = st.getCellStoreValue(i, "cir", "cir");
        
        if(direction == DIRECTION_EGRESS)
        {
            var expCell = st.getCell(i, "exp");
            if(expCell != null)
            {
                st.setCellIsEdit(expCell, CELL_DISABLED);
                expCell.element.style.cursor = "default";
            }
        }
        else
        {
            var lspmodeCell = st.getCell(i, "lspmode");
            if(lspmodeCell != null)
            {
                st.setCellIsEdit(lspmodeCell, CELL_DISABLED);
                lspmodeCell.element.style.cursor = "default";
            }
        }
        
        if(direction == DIRECTION_INGRESS)
        {
        	  var bandwidthLimitCell = st.getCell(i, "bandwidthLimit");
            if(bandwidthLimitCell != null)
            {
                st.setCellIsEdit(bandwidthLimitCell, CELL_ENABLED);
                bandwidthLimitCell.element.style.cursor = "default";
            }
 
        }
        
        if(cir != INVALID_QOS_VALUE)
        {
        	 	var cirCell = st.getCell(i, "cir");
            if(cirCell != null && currPWserviceType != SERVICR_TYPE_CES)
            {
                st.setCellIsEdit(cirCell, CELL_ENABLED);
                cirCell.element.style.cursor = "default";
            }
            
            var cbsCell = st.getCell(i, "cbs");
            if(cbsCell != null)
            {
                st.setCellIsEdit(cbsCell, CELL_ENABLED);
                cbsCell.element.style.cursor = "default";
            }
            
            
            var pbsCell = st.getCell(i, "pbs");
            if(pbsCell != null)
            {
                st.setCellIsEdit(pbsCell, CELL_ENABLED);
                pbsCell.element.style.cursor = "default";
            }
            
            var pirCell = st.getCell(i, "pir");
            if(pirCell != null)
            {
                st.setCellIsEdit(pirCell, CELL_ENABLED);
                pirCell.element.style.cursor = "default";
            }
        }
    }
}

/**
 *     PW QoS   xml
 * @return
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = st.getCellStoreValue(i, "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
        var pwID = st.getCellStoreValue(i, "pwID", "pwID");
        row.appendChild(createTagElement("pwID", pwID));
        var direction = st.getCellStoreValue(i, "direction", "direction");
        row.appendChild(createTagElement("direction", direction));
        row.appendChild(createTagElement("auto", 0));
        
        if(st.getCellEdit(i, "exp") != null && st.getCellModify(i, "exp"))
        {
            var exp = st.getCellStoreValue(i, "exp", "exp");
            row.appendChild(createTagElement("exp", exp));
        }
        
        if(st.getCellEdit(i, "lspmode") != null && st.getCellModify(i, "lspmode"))
        {
            var lspmode = st.getCellStoreValue(i, "lspmode", "lspmode");
            row.appendChild(createTagElement("lspmode", lspmode));
        }
        
         var initBandwidthLimit = queryData.getDataRowParam(i, "bandwidthLimit");
         var tableBandwidthLimit = st.getCellStoreValue(i, "bandwidthLimit", "bandwidthLimit");
         if ( initBandwidthLimit == RESOURCE["enableState_1"]    
         			&& (tableBandwidthLimit == RESOURCE["enableState_1"] || tableBandwidthLimit == 1)) //  
         {
                if(st.getCellStoreValue(i, "cbs", "cbs")=="" || st.getCellStoreValue(i, "cbs", "cbs")==null)
                {
                	 alert(RESOURCE["errcbs"]);
                	 return false;
                }
                
                if(st.getCellStoreValue(i, "pbs", "pbs")=="" || st.getCellStoreValue(i, "pbs", "pbs")==null)
                {
                	 alert(RESOURCE["errpbs"]);
                	 return false;
                }
                
                row.appendChild(createTagElement("cir", st.getCellStoreValue(i, "cir", "cir")));
                row.appendChild(createTagElement("cbs", st.getCellStoreValue(i, "cbs", "cbs")));
                row.appendChild(createTagElement("pir", st.getCellStoreValue(i, "pir", "pir")));
                row.appendChild(createTagElement("pbs", st.getCellStoreValue(i, "pbs", "pbs")));
         }
         else  if (initBandwidthLimit ==RESOURCE["enableState_0"] && tableBandwidthLimit == 1) //  
         {
                row.appendChild(createTagElement("createdirection", st.getCellStoreValue(i, "direction", "direction")));
                if(st.getCellShow(i, "cbs").element.innerHTML == "" || st.getCellShow(i, "cbs").element.innerHTML == null)
                {
                	alert(RESOURCE["errcbs"]);
                	 return false;
                }
                 if(st.getCellShow(i, "pbs").element.innerHTML == "" || st.getCellShow(i, "pbs").element.innerHTML == null)
                {
                	alert(RESOURCE["errpbs"]);
                	 return false;
                }
                row.appendChild(createTagElement("createcir",st.getCellShow(i, "cir").element.innerHTML));
                row.appendChild(createTagElement("createcbs", st.getCellShow(i, "cbs").element.innerHTML));
                row.appendChild(createTagElement("createpir",st.getCellShow(i, "pir").element.innerHTML ));
                row.appendChild(createTagElement("createpbs", st.getCellShow(i, "pbs").element.innerHTML));
         }
         else if (initBandwidthLimit ==RESOURCE["enableState_1"]  && tableBandwidthLimit == 2) //  
         {
                row.appendChild(createTagElement("deletedirection", st.getCellStoreValue(i, "direction", "direction")));
         }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW QoS  
 * @return
 */
function doApply()
{
    $("applybtn").disabled = true;
    var xml = createApplyXML();
    if(xml == false)
    {
    	return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_MODIFY_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, doApplyCallBack, null, "inputdata=" + xml);
}

/**
 *   PW QoS     
 * @param doc
 * @return
 */
function doApplyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;        
    }
    else
    {
    	doQuery();
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};

/**
 *   cir pir           0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertQoS(param)
{
    return param == INVALID_QOS_VALUE ?INVALID_VALUE:param ;
}

function convertExp(param)
{
	if(param == EXP_NONE)
	{
		return RESOURCE["EXP_NONE"];
	}
	
	return param;
}
