var mspwtable = null;
var pwinfotable = null;
var qostable = null;
var advancetable = null;
var forwardtunneltypetable = null;
var backwardtunneltypetable = null;

var pwinfotc = null;
var qostc = null;
var advancetc = null;
var forwardtunneltypetc = null;
var backwardtunneltypetc = null;

var tab = null;
var resources = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var neversion = win.winobj.neversion;

var neType = win.winobj.neType;
var nevr =  win.winobj.neversion.split('.');

var CES_SERVICE = "1";// CES  
var ATM_SERVICE = "2";// ATM  
var ETH_SERVICE = "3";// ETH  
var PTP_SERVICE = "4";// PTP    

var LINK_TYPE_TRANSPORT = "1";//  
var LINK_TYPE_PVP = "2";//PVP
var LINK_TYPE_PVC = "3";//PVC

var EXP_VALUE_COUNT = 8;//EXP     
var EXP_VALUE_INVALID = 255;//EXP None 
var BANDWIDTH_LIMIT_DISABLED = "0";//      
var BANDWIDTH_LIMIT_ENABLED = "1";//      

var CONTROLWORD_USED_FIRST = "2";//        
var CONTROLWORD_MUST_USE = "3";//        

var CELL_DISABLED = "0";//        
var CELL_ENABLED = "1";//       

var PW_SIGNAL_TYPE_STATIC = "1";//PW      
var PW_SIGNAL_TYPE_DYNAMIC = "2";//PW      
var PW_LABLE_INVALID = "4294967295";//PW      
var BAND_WIDTH_LIMIT_ENABLED = "1";

var INVALID_MTU_VALUE = 65535;//MTU    
var DEFAULT_MTU_VALUE = "-";//MTU     900 R3     MTN

var tunnelTypeArr = [];//    
tunnelTypeArr["1"] = "tunnelTypeCol_1";
tunnelTypeArr["2"] = "tunnelTypeCol_2";
tunnelTypeArr["3"] = "tunnelTypeCol_3";
tunnelTypeArr["4"] = "tunnelTypeCol_4";
tunnelTypeArr["5"] = "tunnelTypeCol_5";

var PW_INFO_TABLE_PWID_INDEX = 0;// "PW ID"  
var PW_INFO_TABLE_SIGNALTYPE_INDEX = 1;// "PW    "  
var PW_INFO_TABLE_PWTYPE_INDEX = 2;// "PW  "  
var PW_INFO_TABLE_DIRECTION_INDEX = 3;// "  "  
var PW_INFO_TABLE_ENCAPTYPE_INDEX = 4;// "PW    "  
var PW_INFO_TABLE_INGRESSLABEL_INDEX = 5;// "PW   /   "  
var PW_INFO_TABLE_EGRESSLABEL_INDEX = 6;// "PW   /   "  
var PW_INFO_TABLE_CHOOSETYPE_INDEX = 7;// "Tunnel    "  
var PW_INFO_TABLE_TUNNELTYPE_INDEX = 8;// "Tunnel  "  
var PW_INFO_TABLE_TUNEL_INDEX = 9;// "Tunnel"  
var PW_INFO_TABLE_LSRID_INDEX = 10;// "  LSR ID"  
var PW_INFO_TABLE_OPTUNEL_INDEX = 11;// "  Tunnel"  
var PW_INFO_TABLE_FORWARDPW_COL = "forwardpw";// "  PW" ID
var PW_INFO_TABLE_BACKWARDPW_COL = "backwardpw";// "  PW" ID

var QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX = 0;//"    "  
var QOS_INFO_TABLE_POLICY_INDEX = 1;//"  "  
var QOS_INFO_TABLE_CIR_INDEX = 2;//"     (kbit/s)"  
var QOS_INFO_TABLE_CBS_INDEX = 3;//"        (byte)"  
var QOS_INFO_TABLE_PIR_INDEX = 4;//"    (kbit/s)"  
var QOS_INFO_TABLE_PBS_INDEX = 5;//"          (byte)"  
var QOS_INFO_TABLE_EXP_INDEX = 6;//"EXP"  
var QOS_INFO_TABLE_LSPMODE_INDEX = 7;//"LSP  "  
var QOS_INFO_TABLE_ATTR_COL = "qosAtrr";//"  " ID
var QOS_INFO_TABLE_FORWARDPWINGRESS_COL = "forwardPWIngress";//"  PW Ingress " ID
var QOS_INFO_TABLE_FORWARDPWEGRESS_COL = "forwardPWEgress";//"  PW Egress " ID
var QOS_INFO_TABLE_BACKWARDPWINGRESS_COL = "backwardPWIngress";//"  PW Ingress " ID
var QOS_INFO_TABLE_BACKWARDPWEGRESS_COL = "backwardPWEgress";//"  PW Egress " ID

var ADVANCE_TABLE_CONTROLWORD_INDEX = 0;//"   "  
var ADVANCE_TABLE_CTRLCHANTYPE_INDEX = 1;//"      "  
var ADVANCE_TABLE_VCCV_INDEX = 2;//"VCCV    "  
var ADVANCE_TABLE_REQUESTVLAN_INDEX = 3;//"  VLAN"  
var ADVANCE_TABLE_TPID_INDEX = 4;//"TPID"  
var ADVANCE_TABLE_RTPHEAD_INDEX = 5;//"RTP "  
var ADVANCE_TABLE_BUFFTIME_INDEX = 6;//"      (us)"  
var ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX = 7;//"      "  
var ADVANCE_TABLE_PACKETLOADINGTIME_INDEX = 8;//"      (us)"  
var ADVANCE_TABLE_INGRESSCLOCKMODE_INDEX = 9;//"     "  
var ADVANCE_TABLE_EGRESSCLOCKMODE_INDEX = 10;//"     "  
var ADVANCE_TABLE_CTRLCHANTYPE_CES_INDEX = 11;//"      "  
var ADVANCE_TABLE_VCCV_CES_INDEX = 12;//"VCCV    "  
var ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX = 13;//"64K   "  
var ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX = 14;//"     "  
var ADVANCE_TABLE_ATTR_COL = "advanceAttr";//"  " ID
var ADVANCE_TABLE_FORWARDPW_COL = "forwardpw";// "  PW" ID
var ADVANCE_TABLE_BACKWARDPW_COL = "backwardpw";// "  PW" ID

var PW_TYPE_Ethernet ="5";
var PW_TYPE_TagMode ="4";


function init()
{
    initTable();
    initTableData();
    initButton();
    initTabs();
    
    serviceTypeChangeListener(ETH_SERVICE);//                          
}

function initTable()
{
    mspwtable = new CTable();
    mspwtable.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);
    
    var atom = new Atom("text");
    atom.setValue(1);
    checkText(atom.element, "1", "4294967295");
    mspwtable.addAttrRow("mspwid", "ID", atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    mspwtable.addAttrRow("mspwname", RESOURCE["mspwname"], atom);
    
    atom = new Atom("text");
    atom.setValue("1500");
    atom.element.disabled = true;
    atom.element.style.backgroundColor = "#C8C8C8";
    mspwtable.addAttrRow("mtu", RESOURCE["mtu"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ethservice"], "3");
    /**
     *   RTN   ATM,CES,PTP
     */
	var isNENotSp = SpecialAttrMgr.isNENotSupport(neid,"TE_FUNC_CFG_IPPTN_PW","RTN_ATTR_NOT_SUPPORT_CES_AND_ATM");
    if ((win.winobj.neType != 89 && win.winobj.neType != 90) &&(!isNENotSp))
    {
        atom.addOption(RESOURCE["atmservice"], "2");
        atom.addOption(RESOURCE["cesservice"], "1");
    }
    
    var isNESpCes = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_IPPTN_PW","RTN_ATTR_SUPPORT_CES");
    if (isNESpCes)
    {
        atom.addOption(RESOURCE["cesservice"], "1");
    }
    
    mspwtable.addAttrRow("servicetype", RESOURCE["servicetype"], atom);
    atom.element.onchange = function()
    {
    	serviceTypeChangeListener(this.value);//          
    }
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["transport"], "1");
    atom.addOption(RESOURCE["pvp"], "2");
    atom.addOption(RESOURCE["pvc"], "3");
    mspwtable.addAttrRow("linktype", RESOURCE["linktype"], atom);
    atom.element.onchange = function()
    {
        linkTypeChangeListener(this.value);//            
    }
    
    $("tbdiv").appendChild(mspwtable.getTable());
    
    pwinfotable = new SortTable();
    pwinfotc = window.tableconf[0];
    pwinfotable.setImage("../../../../../images/");
    createTableHead(pwinfotable, pwinfotc);
    $("pwinfotablediv").appendChild(pwinfotable.getTable());
    pwinfotable.setBodyHeight(getComponetHeight($("pwinfotablediv"), 80) + "px");
    pwinfotable.setOnCellEditHandler(cellEditHandler);
    
    qostable = new SortTable();
    qostc = window.tableconf[1];
    qostable.setImage("../../../../../images/");
    createTableHead(qostable, qostc);
    $("qostablediv").appendChild(qostable.getTable());
    qostable.setBodyHeight(getComponetHeight($("qostablediv"), 80) + "px");
    qostable.setOnCellEditHandler(cellEditHandler);
    
    advancetable = new SortTable();
    advancetc = window.tableconf[2];
    advancetable.setImage("../../../../../images/");
    createTableHead(advancetable, advancetc);
    $("advancetablediv").appendChild(advancetable.getTable());
    advancetable.setBodyHeight(getComponetHeight($("advancetablediv"), 80) + "px");
    advancetable.setOnCellEditHandler(cellEditHandler);
    
    forwardtunneltypetable = new SortTable();
    forwardtunneltypetc = window.tableconf[3];
    forwardtunneltypetable.setImage("../../../../../images/");
    createTableHead(forwardtunneltypetable, forwardtunneltypetc);
    $("forwardtunneltablediv").appendChild(forwardtunneltypetable.getTable());
    forwardtunneltypetable.setBodyHeight(getComponetHeight($("forwardtunneltablediv"), 122) + "px");
    forwardtunneltypetable.setSingleChoiceFlg(true);
    
    backwardtunneltypetable = new SortTable();
    backwardtunneltypetc = window.tableconf[4];
    backwardtunneltypetable.setImage("../../../../../images/");
    createTableHead(backwardtunneltypetable, backwardtunneltypetc);
    $("backwardtunneltablediv").appendChild(backwardtunneltypetable.getTable());
    backwardtunneltypetable.setBodyHeight(getComponetHeight($("backwardtunneltablediv"), 122) + "px");
    backwardtunneltypetable.setSingleChoiceFlg(true);
}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = false;
}

/**
 *         Tab                            
 * @return
 */
function initTableData()
{
	loadXMLdoc("../../conf/mpls/mspw/pwinfodata.xml", "GET", false, initPWInfoTableData);
	loadXMLdoc("../../conf/mpls/mspw/qosdata.xml", "GET", false, initQosTableData);
	if (neversion < "5.76.03.10")
    {
        loadXMLdoc("../../conf/mpls/mspw/advanceattrdata.xml", "GET", false, initAdvanAttrTableData);
    }
    else
    {
        loadXMLdoc("../../conf/mpls/mspw_u2kv1r5c00/advanceattrdata.xml", "GET", false, initAdvanAttrTableData);
    }
	
	loadXMLdoc("../../conf/mpls/mspw/tunneltypedata.xml", "GET", false, initTunnelTypeTableData);
}

/**
 *     PW     Tab      
 * @param doc
 * @return
 */
function initPWInfoTableData(doc)
{
	var data = EncapsulateData(doc);
    createTableBody(pwinfotable, pwinfotc, EncapsulateData(doc), RESOURCE);
    
    if(pwinfotable.getDataRowLength() == 0)
	{
		return;
	}
    
    convertPWInfoData(PW_INFO_TABLE_SIGNALTYPE_INDEX, "pwSignalType");
    convertPWInfoData(PW_INFO_TABLE_PWTYPE_INDEX, "pwType");
    convertPWInfoData(PW_INFO_TABLE_DIRECTION_INDEX, "pwDirection");
    convertPWInfoData(PW_INFO_TABLE_ENCAPTYPE_INDEX, "pwEncapsType");
    convertPWInfoData(PW_INFO_TABLE_CHOOSETYPE_INDEX, "tunnelchoosetype");
    convertPWInfoData(PW_INFO_TABLE_TUNNELTYPE_INDEX, "tunneltype");
    
    setCellEidtable(pwinfotable, PW_INFO_TABLE_DIRECTION_INDEX, PW_INFO_TABLE_FORWARDPW_COL, CELL_DISABLED);
    setCellEidtable(pwinfotable, PW_INFO_TABLE_ENCAPTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL, CELL_DISABLED);
    setCellEidtable(pwinfotable, PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, CELL_DISABLED);
    setCellEidtable(pwinfotable, PW_INFO_TABLE_DIRECTION_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, CELL_DISABLED);
    setCellEidtable(pwinfotable, PW_INFO_TABLE_ENCAPTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, CELL_DISABLED);
}

/**
 *     QoS Tab       
 * @param doc
 * @return
 */
function initQosTableData(doc)
{
	var data = EncapsulateData(doc);
    createTableBody(qostable, qostc, EncapsulateData(doc), RESOURCE);
    if(qostable.getDataRowLength() == 0)
	{
		return;
	}
    
    for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
    {
        var attrId = qostable.getCellStoreValue(i, QOS_INFO_TABLE_ATTR_COL, QOS_INFO_TABLE_ATTR_COL);
    	for(var j = 1, colLength = qostable.getColumnCount(); j < colLength; j++)//  0            
    	{
    	    var colid = qostc.getColId(j);
    		var cellValue = qostable.getCellStoreValue(i, colid, colid);
    		if(cellValue == "-")
    		{
    			setCellEidtable(qostable, i, colid, CELL_DISABLED);
    		}
    		else if(cellValue != null && cellValue != "")
    		{
    		    qostable.getCellShow(i, colid).element.innerHTML = RESOURCE[attrId + "_" + cellValue];
    		}
    	}
    }
    
    setCellEidtable(qostable, QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_FORWARDPWEGRESS_COL, CELL_DISABLED);
    setCellEidtable(qostable, QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL, CELL_ENABLED);
    setCellEidtable(qostable, QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_BACKWARDPWEGRESS_COL, CELL_DISABLED);
    setCellEidtable(qostable, QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL, CELL_ENABLED);
}

/**
 *          Tab      
 * @param doc
 * @return
 */
function initAdvanAttrTableData(doc)
{
	var data = EncapsulateData(doc);
    createTableBody(advancetable, advancetc, EncapsulateData(doc), RESOURCE);
    
    if(advancetable.getDataRowLength() == 0)
	{
		return;
	}
    var NOT_CONVERT_ATTR = [ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX];
    for(var i = 0, size = advancetable.getDataRowLength(); i < size; i++)
    {
        var attrId = advancetable.getCellStoreValue(i, ADVANCE_TABLE_ATTR_COL, ADVANCE_TABLE_ATTR_COL);
        for(var j = 1, colLength = advancetable.getColumnCount(); j < colLength; j++)//  0            
        {
            var colid = advancetc.getColId(j);
            var cellValue = advancetable.getCellStoreValue(i, colid, colid);
            if(cellValue == "-")
            {
                setCellEidtable(advancetable, i, colid, CELL_DISABLED);
            }
            else if(!NOT_CONVERT_ATTR.contains(i))
            {
                advancetable.getCellShow(i, colid).element.innerHTML = RESOURCE[attrId + "_" + cellValue];
            }
        }
    }
    
    
    
}

/**
 *         Tunnel  Tab      
 * @param doc
 * @return
 */
function initTunnelTypeTableData(doc)
{
    var data = EncapsulateData(doc);
    createTableBody(forwardtunneltypetable, forwardtunneltypetc, EncapsulateData(doc), RESOURCE);
    createTableBody(backwardtunneltypetable, backwardtunneltypetc, EncapsulateData(doc), RESOURCE);
}


function initButton()
{
	$("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/**
 *        Tab     5 
 * @return
 */
function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["pwbasicinfo"], $("tab1div"));
    tab.addEmbedTab("tab2div", "Qos", $("tab2div"));
    tab.addEmbedTab("tab3div", RESOURCE["advancedattr"], $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["forwardTunnelChoose"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["backwardTunnelChoose"], $("tab5div"));
    tab.removeEmbedTab("tab4div");
    tab.removeEmbedTab("tab5div");//    Tab             Tab           4 5   1   
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}


/**
 *  PW            
 * @return
 */
function addPWInfoCellListener()
{
    for(var i = 0, size = pwinfotable.getDataRowLength(); i < size; i++)
    {
         pwinfotable.getCell(i, PW_INFO_TABLE_FORWARDPW_COL).element.ondblclick = pwInfoTableCellondbclick;
         pwinfotable.getCell(i, PW_INFO_TABLE_BACKWARDPW_COL).element.ondblclick = pwInfoTableCellondbclick;
    }
}

/**
 *  QoS          
 * @return
 */
function addQoSCellListener()
{
    for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
    {
        qostable.getCell(i, QOS_INFO_TABLE_FORWARDPWINGRESS_COL).element.ondblclick = qosTableCellondbclick;
        qostable.getCell(i, QOS_INFO_TABLE_FORWARDPWEGRESS_COL).element.ondblclick = qosTableCellondbclick;
        qostable.getCell(i, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL).element.ondblclick = qosTableCellondbclick;
        qostable.getCell(i, QOS_INFO_TABLE_BACKWARDPWEGRESS_COL).element.ondblclick = qosTableCellondbclick;
    }
}

/**
 *              
 * @return
 */
function addAdvanceCellListener()
{
    for(var i = 0, size = advancetable.getDataRowLength(); i < size; i++)
    {
        advancetable.getCell(i, ADVANCE_TABLE_FORWARDPW_COL).element.ondblclick = advanceTableCellondbclick;
    }
}

/**
 *          PW          
 * @return
 */
function pwInfoTableCellondbclick()
{
    if(this.isEdit == CELL_DISABLED)
    {
        return;//            
    }
    
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none"; 
    var rowid = this.parentNode.rowIndex;
    var colid = this.colid;
    
    var atom = null;
    switch(rowid)
    {
        case PW_INFO_TABLE_PWID_INDEX:// PW ID
            atom = createTextAtom(pwinfotable, this);
            textCheck(atom.element, "1", "4294967295");
            break;
        case PW_INFO_TABLE_SIGNALTYPE_INDEX:// PW    
            atom = createSelectAtom(pwinfotable, this);
            atom.addOption(RESOURCE["pwSignalType_1"],"1");
            atom.element.onchange = function()
            {
                pwSignalTypeChange(this);
            }
            break;
        case PW_INFO_TABLE_PWTYPE_INDEX:// PW  
            atom = createSelectAtom(pwinfotable, this);
            var serviceType = mspwtable.getAtom("servicetype").getValue();
            if(serviceType == CES_SERVICE)//CES         
            {
                atom.addOption(RESOURCE["pwType_21"], "21");
                atom.addOption(RESOURCE["pwType_17"], "17");
            }
            else if(serviceType == ATM_SERVICE)
            {
                var linkType = mspwtable.getAtom("linktype").getValue();
                if(linkType == LINK_TYPE_TRANSPORT)
                {
                    atom.addOption(RESOURCE["pwType_3"], "3");
                }
                else if(linkType == LINK_TYPE_PVP)
                {
                    atom.addOption(RESOURCE["pwType_10"], "10");
                    atom.addOption(RESOURCE["pwType_13"], "13");
                }
                else
                {
                    atom.addOption(RESOURCE["pwType_9"], "9");
                    atom.addOption(RESOURCE["pwType_12"], "12");
                }
            }
            else
            {
                atom.addOption(RESOURCE["pwType_5"], "5");
                atom.addOption(RESOURCE["pwType_4"], "4");
            }
            atom.element.onchange = function()
            {
                pwTypeChange(this);
            }
            break;
        case PW_INFO_TABLE_INGRESSLABEL_INDEX:// PW   /   
        case PW_INFO_TABLE_EGRESSLABEL_INDEX:// PW   /   
            atom = createTextAtom(pwinfotable, this);
            textCheck(atom.element, "16", "1048575");
            break;
        case PW_INFO_TABLE_CHOOSETYPE_INDEX:// Tunnel    
            atom = createSelectAtom(pwinfotable, this);
            atom.addOption(RESOURCE["tunnelchoosetype_1"],"1");
            atom.element.onchange = function()
            {
                tunnelChooseTypeChange(this);
            }
            break;
        case PW_INFO_TABLE_TUNNELTYPE_INDEX:// Tunnel  
            atom = createSelectAtom(pwinfotable, this);
            atom.addOption(RESOURCE["tunneltype_1"],"1");
            break;
        case PW_INFO_TABLE_TUNEL_INDEX:// Tunnel
        case PW_INFO_TABLE_OPTUNEL_INDEX:// Tunnel    
            atom = createTextAtom(pwinfotable, this);
            break;
        case PW_INFO_TABLE_LSRID_INDEX://   LSR ID
            atom = createTextAtom(pwinfotable, this);
            validateIp(atom.element, pwinfotable);
            break;
        default:
            break;
    }
    
    if(atom == null)
    {
        return;
    }
    
    var cellOldValue = this.storeValue[this.colid];
    
    if(cellOldValue && rowid == PW_INFO_TABLE_LSRID_INDEX)
    {
        atom.setValue(convertIP(cellOldValue));
    }
    else if(cellOldValue && (rowid != PW_INFO_TABLE_TUNEL_INDEX) && (rowid != PW_INFO_TABLE_OPTUNEL_INDEX))
    {
        atom.setValue(cellOldValue);
    }
    
    atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
    
    if((rowid == PW_INFO_TABLE_TUNEL_INDEX) || (rowid == PW_INFO_TABLE_OPTUNEL_INDEX))
    {
        atom.element.onblur();
        tunnelCellOndbclick(rowid, colid);
    }
}


/**
 *          QoS        
 * @return
 */
function qosTableCellondbclick()
{
    if(this.isEdit == CELL_DISABLED)
    {
        return;//            
    }
    
    var rowid = this.parentNode.rowIndex;
    if(qostable.element.datarows[rowid].element.style.display == "none")
    {
        return;//           
    }
    
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    var atom = null;
    switch(rowid)
    {
        case QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX://     
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["bandwidthLimit_0"],"0");
            atom.addOption(RESOURCE["bandwidthLimit_1"],"1");
            atom.element.onchange = function()
            {
                bandwidthLimitChange(this);
            }
            break;
        case QOS_INFO_TABLE_EXP_INDEX:// EXP
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["exp_" + EXP_VALUE_INVALID], EXP_VALUE_INVALID);
            /*
            for(var i = 0; i < EXP_VALUE_COUNT; i++)
            {
                atom.addOption(RESOURCE["exp_" + i], i);
            }*/
            break;
        case QOS_INFO_TABLE_LSPMODE_INDEX:// LSP  
            atom = createSelectAtom(qostable, this);
            atom.addOption(RESOURCE["lspmode_2"],"2");
            break;
        case QOS_INFO_TABLE_CIR_INDEX:
            atom = createTextAtom(qostable, this);
            textCheckWithStepLen(atom.element,0,1000000,64);
            break;    
        case QOS_INFO_TABLE_CBS_INDEX:
            atom = createTextAtom(qostable, this);
            if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0310') ||
               ( isOSN5X0NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510'))
		     {
			    textCheck(atom.element,"0","4294967295");			   
			}
		    else
			{
			    textCheck(atom.element,"0","512000");			   
			}            
            break;
        case QOS_INFO_TABLE_PIR_INDEX:
            atom = createTextAtom(qostable, this);           
            textCheckWithStepLen(atom.element,0,1000000,64);
            break;
        case QOS_INFO_TABLE_PBS_INDEX:
            atom = createTextAtom(qostable, this);
            if(( isRTN900NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0310') ||
                ( isOSN5X0NEtype(neType) &&  (nevr[2] + nevr[3]) >= '0510'))
		     {
			    textCheck(atom.element,"0","4294967295");			   
			}
		    else
			{
			    textCheck(atom.element,"0","512000");			   
			} 
           
            break;         
        default:
            break;
    }
    
    if(atom == null)
    {
        return;
    }
    
    var cellOldValue = this.storeValue[this.colid];
    if(cellOldValue)//                       
    {
        atom.setValue(cellOldValue);
    }

    atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    
    
    if( rowid != QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX )
    {
	    this.width = "100%";
	    atom.element.width = "100%";
    }
    
    atom.element.focus();
}

/**
 *                      
 * @return
 */
function advanceTableCellondbclick()
{
    if(this.isEdit == CELL_DISABLED)
    {
        return;//            
    }
    
    var rowid = this.parentNode.rowIndex;
    if(advancetable.element.datarows[rowid].element.style.display == "none")
    {
        return;//           
    }
    
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;
    this.parentNode.modify = true;
    this.showElement.element.style.display = "none"; 
    
    var colid = this.colid;
    var atom = null;
    switch(rowid)
    {
        case ADVANCE_TABLE_CONTROLWORD_INDEX://    
            atom = createSelectAtom(advancetable, this);
            var serviceType = mspwtable.getAtom("servicetype").getValue();
            if(serviceType == ATM_SERVICE)
            {
                atom.addOption(RESOURCE["controlWord_1"],"1");
                atom.addOption(RESOURCE["controlWord_3"],"3");
            }
            else
            {
                atom.addOption(RESOURCE["controlWord_1"],"1");
                atom.addOption(RESOURCE["controlWord_2"],"2");
            }
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["controlWord_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
        case ADVANCE_TABLE_CTRLCHANTYPE_INDEX://       
            var serviceType = mspwtable.getAtom("servicetype").getValue();
            atom = createSelectAtom(advancetable, this);
            
            /**
             * TRANSU2000V1R7C00-3292 ,RTN905  CW
             * 
             *    qiugongkai                            
             *         
             */
            	 atom.addOption(RESOURCE["ctrlChanType_0"],"0");
            	 atom.addOption(RESOURCE["ctrlChanType_1"],"1");
            	 atom.addOption(RESOURCE["ctrlChanType_2"],"2");
           
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["ctrlChanType_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
        case ADVANCE_TABLE_VCCV_INDEX:// VCCV    
            atom = createSelectAtom(advancetable, this);
            atom.addOption(RESOURCE["vccv_0"],"0");
            atom.addOption(RESOURCE["vccv_1"],"1");
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_VCCV_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["vccv_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_VCCV_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
        case ADVANCE_TABLE_REQUESTVLAN_INDEX://   VLAN
            atom = createTextAtom(advancetable, this);
            textCheck(atom.element, "1", "4094");
            var blurHandle = atom.element.onblur;
            atom.element.onblur = function()
            {
                if(null == this.value || "" == this.value)
                {
                    this.value = "1";
                }
                
                advancetable.getCellShow(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = this.value;
                var cell = advancetable.getCell(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
                blurHandle();
            }
            break;    
        case ADVANCE_TABLE_RTPHEAD_INDEX:// RTP 
            atom = createSelectAtom(advancetable, this);
            atom.addOption(RESOURCE["rtpHead_0"],"0");
            atom.addOption(RESOURCE["rtpHead_1"],"1");
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_RTPHEAD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["rtpHead_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_RTPHEAD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
        case ADVANCE_TABLE_BUFFTIME_INDEX://       (us)
            atom = createTextAtom(advancetable, this);
            textCheckWithStepLen(atom.element, "375", "16000", "125");
           	var blurHandle = atom.element.onblur;
            atom.element.onblur = function()
            {
                if(null == this.value || "" == this.value || 375 > Number(this.value))
                {
                    this.value = "375";
                }
                
                advancetable.getCellShow(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = this.value;
                var cell = advancetable.getCell(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
                blurHandle();
                
                var fpwBufferTimeCell = advancetable.getCell(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
                var bpwBufferTimeCell = advancetable.getCell(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                var fpwBufferTime = advancetable.getCellStoreValue(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL, ADVANCE_TABLE_FORWARDPW_COL);
                var bpwBufferTime = advancetable.getCellStoreValue(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL, ADVANCE_TABLE_BACKWARDPW_COL);   
                if(fpwBufferTime!= bpwBufferTime)
                {
                	advancetable.setCellValue(bpwBufferTimeCell, ADVANCE_TABLE_BACKWARDPW_COL,fpwBufferTime);
                  advancetable.getCellShow(ADVANCE_TABLE_BUFFTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = fpwBufferTime;
                }
            }
            break;
        case ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX://       
            atom = createTextAtom(advancetable, this);
            textCheck(atom.element, "1", "31");
            var blurHandle = atom.element.onblur;
            atom.element.onblur = function()
            {
                if(null == this.value || "" == this.value || "0" == this.value)
                {
                    this.value = "1";
                }
                var fpwMaxCell = advancetable.getCell(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
                var bpwMaxCell = advancetable.getCell(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                if(this.value == "1")
                {
                    advancetable.setCellValue(fpwMaxCell, ADVANCE_TABLE_FORWARDPW_COL, "0");
                    advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = "0";
                    setCellEidtable(advancetable, ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL, CELL_DISABLED);
                    
                    advancetable.setCellValue(bpwMaxCell, ADVANCE_TABLE_BACKWARDPW_COL, "0");
                    advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = "0";
                }
                else
                {
                    advancetable.setCellValue(fpwMaxCell, ADVANCE_TABLE_FORWARDPW_COL, "1000");
                    advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = "1000";
                    setCellEidtable(advancetable, ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL, CELL_ENABLED);
                    
                    advancetable.setCellValue(bpwMaxCell, ADVANCE_TABLE_BACKWARDPW_COL, "1000");
                    advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = "1000";
                }
                
                advancetable.getCellShow(ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = this.value;
                var cell = advancetable.getCell(ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
                blurHandle();
                addAdvanceCellListener();//                                   
            }
            break;    
        case ADVANCE_TABLE_PACKETLOADINGTIME_INDEX://       (us)
            atom = createTextAtom(advancetable, this);
            var serviceType = mspwtable.getAtom("servicetype").getValue();
            if(serviceType == ATM_SERVICE)//                     
            {
                textCheckWithStepLen(atom.element, "100", "50000", "100");
            }
            else
            {
                textCheckWithStepLen(atom.element, "125", "5000", "125");
            }
            var blurHandle = atom.element.onblur;
            atom.element.onblur = function()
            {
                if(null == this.value || "" == this.value || 100 > Number(this.value))
                {
                    this.value = "100";
                }
                
                advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = this.value;
                var cell = advancetable.getCell(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
                blurHandle();
                
                 
                var fpwLoadingTimeCell = advancetable.getCell(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
                var bpwLoadingTimeCell = advancetable.getCell(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                var fpwLoadingTime = advancetable.getCellStoreValue(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_FORWARDPW_COL, ADVANCE_TABLE_FORWARDPW_COL);
                var bpwLoadingTime = advancetable.getCellStoreValue(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL, ADVANCE_TABLE_BACKWARDPW_COL);   
                if(fpwLoadingTime!= bpwLoadingTime)
                {
                	advancetable.setCellValue(bpwLoadingTimeCell, ADVANCE_TABLE_BACKWARDPW_COL,fpwLoadingTime);
                  advancetable.getCellShow(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = fpwLoadingTime;
                }
            }
            break;
        case ADVANCE_TABLE_INGRESSCLOCKMODE_INDEX://      
            atom = createSelectAtom(advancetable, this);
            atom.addOption(RESOURCE["clockmode_0"],"0");
            atom.addOption(RESOURCE["clockmode_1"],"1");
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_INGRESSCLOCKMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["clockmode_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_INGRESSCLOCKMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;    
        case ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX:// 64K   
            atom = createTextAtom(advancetable, this);
            textCheck(atom.element, "1", "31");
            var blurHandle = atom.element.onblur;
            atom.element.onblur = function()
            {
                if(null == this.value || "" == this.value || 1 > Number(this.value))
                {
                    this.value = "1";
                }
                
                advancetable.getCellShow(ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = this.value;
                var cell = advancetable.getCell(ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
                advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
                blurHandle();
            }
            break;
       case ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX:// 
            atom = createSelectAtom(advancetable, this);
            atom.addOption(RESOURCE["standardMode"],"0");
            atom.addOption(RESOURCE["huaweiMode"],"1");
         
          
            
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["sequenceNumberMode_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
       case ADVANCE_TABLE_CTRLCHANTYPE_CES_INDEX://       
            var serviceType = mspwtable.getAtom("servicetype").getValue();
            atom = createSelectAtom(advancetable, this); 
            atom.addOption(RESOURCE["ctrlChanType_0"],"0");
            atom.addOption(RESOURCE["ctrlChanType_1"],"1");
            atom.addOption(RESOURCE["ctrlChanType_2"],"2");

            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_CTRLCHANTYPE_CES_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["ctrlChanType_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_CTRLCHANTYPE_CES_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;
      case ADVANCE_TABLE_VCCV_CES_INDEX:// VCCV    
            atom = createSelectAtom(advancetable, this);
            atom.addOption(RESOURCE["vccv_0"],"0");
            atom.addOption(RESOURCE["vccv_1"],"1");
            atom.element.onchange = function()
            {
            	advancetable.getCellShow(ADVANCE_TABLE_VCCV_CES_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["vccv_" + this.value];
            	var cell = advancetable.getCell(ADVANCE_TABLE_VCCV_CES_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
            	advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, this.value);
            }
            break;    
        default:
            break;
    }
    
    if(atom == null)
    {
        return;
    }
    
    atom.element.onkeyup = function()
    {
        forwardPWParamChng(this);
    }
    
    var cellOldValue = this.storeValue[this.colid];
    if(cellOldValue)
    {
        atom.setValue(cellOldValue);
    }
    
    atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
}

/**
 *   text         
 * @param cell
 * @return
 */
function createTextAtom(st, cell)
{
    var atom = st.createAtom("text");
    cell.editElement.type = "text";
    atom.element.onblur= cellonblur;
    return atom;
}

/**
 *   select         
 * @param cell
 * @return
 */
function createSelectAtom(st, cell)
{
    var atom = st.createAtom("select");
    cell.editElement.type = "select";
    atom.element.onblur= cellonblur;
    return atom;
}

/**
 *   span         
 * @param cell
 * @return
 */
function createSpanAtom(st, cell)
{
    var atom = st.createAtom("span");
    cell.showElement.type = "span";
    return atom;
}

/**
 * PW         PW           
 * @param atom
 * @return
 */
function pwSignalTypeChange(atom)
{
    var colid = atom.parentNode.colid;
    if(atom.value == PW_SIGNAL_TYPE_STATIC) //      PW  PW   /    PW   /        
    {
        setCellEidtable(pwinfotable, PW_INFO_TABLE_INGRESSLABEL_INDEX, colid, CELL_ENABLED);//PW   /   
        pwinfotable.getCellShow(PW_INFO_TABLE_INGRESSLABEL_INDEX, colid).element.innerHTML = "";
        
        setCellEidtable(pwinfotable, PW_INFO_TABLE_EGRESSLABEL_INDEX, colid, CELL_ENABLED);//PW   /   
        pwinfotable.getCellShow(PW_INFO_TABLE_EGRESSLABEL_INDEX, colid).element.innerHTML = "";
        
        addPWInfoCellListener();//              
    }
    else //      PW  PW   /    PW   /        
    {
        setCellEidtable(pwinfotable, PW_INFO_TABLE_INGRESSLABEL_INDEX, colid, CELL_DISABLED);//PW   /   
        pwinfotable.getCellShow(PW_INFO_TABLE_INGRESSLABEL_INDEX, colid).element.innerHTML = "-";
        
        setCellEidtable(pwinfotable, PW_INFO_TABLE_EGRESSLABEL_INDEX, colid, CELL_DISABLED);//PW   /   
        pwinfotable.getCellShow(PW_INFO_TABLE_EGRESSLABEL_INDEX, colid).element.innerHTML = "-";
    }
}

/**
 * PW          PW   PW         
 * @param atom
 * @return
 */
function pwTypeChange(atom)
{
    var showValue = RESOURCE["pwType_" + atom.value];
    var backWardPwTypeCell = pwinfotable.getCell(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL);
    pwinfotable.setCellValue(backWardPwTypeCell, PW_INFO_TABLE_BACKWARDPW_COL, atom.value);
    pwinfotable.getCellShow(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML = showValue;
    
 
	if(atom.value == PW_TYPE_Ethernet)
	{
		var requestVlanCell = advancetable.getCell(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
		advancetable.setCellValue(requestVlanCell, ADVANCE_TABLE_FORWARDPW_COL, "-");
		advancetable.getCellShow(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = "-";
		setCellEidtable(advancetable, ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL, CELL_DISABLED);
		
		
		requestVlanCell = advancetable.getCell(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
		advancetable.setCellValue(requestVlanCell, ADVANCE_TABLE_BACKWARDPW_COL, "-");
		advancetable.getCellShow(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = "-";
		setCellEidtable(advancetable, ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL, CELL_DISABLED);
	}
	else if(atom.value == PW_TYPE_TagMode)
	{
		var requestVlanCell = advancetable.getCell(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
		advancetable.setCellValue(requestVlanCell, ADVANCE_TABLE_FORWARDPW_COL, "1");
		advancetable.getCellShow(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = "1";
		setCellEidtable(advancetable, ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_FORWARDPW_COL, CELL_ENABLED);
		
		
		requestVlanCell = advancetable.getCell(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
		advancetable.setCellValue(requestVlanCell, ADVANCE_TABLE_BACKWARDPW_COL, "1");
		advancetable.getCellShow(ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = "1";
		setCellEidtable(advancetable, ADVANCE_TABLE_REQUESTVLAN_INDEX, ADVANCE_TABLE_BACKWARDPW_COL, CELL_DISABLED);
	}
	
	addAdvanceCellListener();
}

/**
 * PW         Tunnel           
 * @param atom
 * @return
 */
function tunnelChooseTypeChange(atom)
{
    var colid = atom.parentNode.colid;
    if(atom.value == "1") //           Tunnel  Tab 
    {
        setCellEidtable(pwinfotable, PW_INFO_TABLE_TUNNELTYPE_INDEX, colid, CELL_ENABLED);//Tunnel  
        var storeValue = pwinfotable.getCellStoreValue(PW_INFO_TABLE_TUNNELTYPE_INDEX, colid ,colid);
        var showValue = RESOURCE["tunneltype_" + storeValue];
        pwinfotable.getCellShow(PW_INFO_TABLE_TUNNELTYPE_INDEX, colid).element.innerHTML = showValue;
        
        setCellEidtable(pwinfotable, PW_INFO_TABLE_TUNEL_INDEX, colid, CELL_ENABLED);//Tunnel
        pwinfotable.getCellShow(PW_INFO_TABLE_TUNEL_INDEX, colid).element.innerHTML = "";
        
        addPWInfoCellListener();//              
        
        if(colid == PW_INFO_TABLE_FORWARDPW_COL) //  PW 
        {
            tab.removeEmbedTab("tab4div");
        }
        else //  PW 
        {
            tab.removeEmbedTab("tab5div");
        }
    }
    else //    ,   Tunnel   Tunnel            Tunnel  Tab 
    {
        setCellEidtable(pwinfotable, PW_INFO_TABLE_TUNNELTYPE_INDEX, colid, CELL_DISABLED);//Tunnel  
        pwinfotable.getCellShow(PW_INFO_TABLE_TUNNELTYPE_INDEX, colid).element.innerHTML = "-";
        
        setCellEidtable(pwinfotable, PW_INFO_TABLE_TUNEL_INDEX, colid, CELL_DISABLED);//Tunnel
        pwinfotable.getCellShow(PW_INFO_TABLE_TUNEL_INDEX, colid).element.innerHTML = "-";
        
        if(colid == PW_INFO_TABLE_FORWARDPW_COL) //  PW 
        {
            tab.insertEmbedTab("tab4div", RESOURCE["forwardTunnelChoose"], $("tab4div"), "tab5div");
        }
        else //  PW 
        {
            tab.addEmbedTab("tab5div", RESOURCE["backwardTunnelChoose"], $("tab5div"));
        }
    }
}

/**
 * PW        tunnel       ,           
 * @return
 */
function tunnelCellOndbclick(rowid, colid)
{
    var tunnelType = pwinfotable.getCellStoreValue(PW_INFO_TABLE_TUNNELTYPE_INDEX, colid ,colid);
    xshowModalDialog("selecttunnel.html?tunnelType=" + tunnelType + "&rowid=" + rowid + "&colid=" + colid, RESOURCE["chooseTunnel"], 680, 420, "../../../../../images/");
}

/**
 * QoS                  
 * @return
 */
function bandwidthLimitChange(atom)
{
    var colid = atom.parentNode.colid;
    var defaultCBSValue = "";
    var serviceType = mspwtable.getAtom("servicetype").getValue();

    if(atom.value == BANDWIDTH_LIMIT_DISABLED)
    {
        setCellEidtable(qostable, QOS_INFO_TABLE_CIR_INDEX, colid, CELL_DISABLED);//     (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_CIR_INDEX, colid).element.innerHTML = "-";
        setCellEidtable(qostable, QOS_INFO_TABLE_CBS_INDEX, colid, CELL_DISABLED);//
        qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, colid).element.innerHTML = "-";
        setCellEidtable(qostable, QOS_INFO_TABLE_PIR_INDEX, colid, CELL_DISABLED);//    (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_PIR_INDEX, colid).element.innerHTML = "-";
        setCellEidtable(qostable, QOS_INFO_TABLE_PBS_INDEX, colid, CELL_DISABLED);//    (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, colid).element.innerHTML = "-";
    }
    else
    {
        setCellEidtable(qostable, QOS_INFO_TABLE_CIR_INDEX, colid, CELL_ENABLED);//     (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_CIR_INDEX, colid).element.innerHTML = "64";
        qostable.setCellValue(qostable.getCell(QOS_INFO_TABLE_CIR_INDEX, colid), colid, "64"); 
         
        setCellEidtable(qostable, QOS_INFO_TABLE_CBS_INDEX, colid, CELL_ENABLED);//
        qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, colid).element.innerHTML = defaultCBSValue;
        qostable.setCellValue(qostable.getCell(QOS_INFO_TABLE_CBS_INDEX, colid), colid, defaultCBSValue);
          
        setCellEidtable(qostable, QOS_INFO_TABLE_PIR_INDEX, colid, CELL_ENABLED);//    (kbit/s)
        qostable.getCellShow(QOS_INFO_TABLE_PIR_INDEX, colid).element.innerHTML = "64";
        qostable.setCellValue(qostable.getCell(QOS_INFO_TABLE_PIR_INDEX, colid), colid, "64"); 
         
        setCellEidtable(qostable, QOS_INFO_TABLE_CIR_INDEX, colid, CELL_ENABLED);//
        qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, colid).element.innerHTML = defaultCBSValue;
        qostable.setCellValue(qostable.getCell(QOS_INFO_TABLE_PBS_INDEX, colid), colid, defaultCBSValue); 
        setCellEidtable(qostable, QOS_INFO_TABLE_PBS_INDEX, colid, CELL_ENABLED); 
    }
    
    addQoSCellListener();//           
}

/**
 *           PW          
 * @param atom         
 * @return
 */
function forwardPWParamChng(atom)
{
    var rowIndex = advancetable.getSelectedRows()[0];
    advancetable.getCellShow(rowIndex, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = atom.value;
    var cell = advancetable.getCell(rowIndex, ADVANCE_TABLE_BACKWARDPW_COL);
    advancetable.setCellValue(cell, ADVANCE_TABLE_BACKWARDPW_COL, atom.value);
}

/**
 *     MSPW   
 * @return
 */
function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var forwardpwRow = createPWRowarams(PW_INFO_TABLE_FORWARDPW_COL, "0");
    bussiness.appendChild(forwardpwRow);
    var backwardpwRow = createPWRowarams(PW_INFO_TABLE_BACKWARDPW_COL, "1");
    bussiness.appendChild(backwardpwRow);
    
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("mspwindex", 0));
    rowparams.appendChild(createTagElement("mspwid", mspwtable.getAtom("mspwid").getValue()));
    rowparams.appendChild(createTagElement("mspwname", mspwtable.getAtom("mspwname").getValue()));
    
    var serviceType = mspwtable.getAtom("servicetype").getValue();

    var mtu = mspwtable.getAtom("mtu").getValue();
    if(mtu == "-")
    {
        mtu = 65535;
    }
    else
    {
        mtu = 1500;
    }
    rowparams.appendChild(createTagElement("mtu", mtu));
    var serviceType = mspwtable.getAtom("servicetype").getValue();
    rowparams.appendChild(createTagElement("servicetype", serviceType));
    
    var fpwid = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWID_INDEX, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL);
    var bpwid = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWID_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
    rowparams.appendChild(createTagElement("fpwid", 0));//  0    PW        
    rowparams.appendChild(createTagElement("bpwid", 0));
    
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     PW    
 * @param colid  ID
 * @param pwDirection      PW    PW
 * @return
 */
function createPWRowarams(colid, pwDirection)
{
    var serviceType = mspwtable.getAtom("servicetype").getValue();
    var rowparams = new tagElement("row-params");
    
    addPWBasicParam(rowparams, colid, pwDirection);//  PW         
    
    addQosAttrParam(rowparams, serviceType, colid);//  PW QoS       
    
    addAdvanceAttrParam(rowparams, serviceType, colid);//          
    
    return rowparams;
}

/**
 *   PW         
 * @param rowparams
 * @param serviceType
 * @param colid
 * @return
 */
function addPWBasicParam(rowparams, colid, pwDirection)
{
    rowparams.appendChild(createTagElement("neid", neid));
    var pwID = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWID_INDEX, colid, colid);
    rowparams.appendChild(createTagElement("pwID", pwID));
    rowparams.appendChild(createTagElement("pwIndex", pwDirection));
    var pwSignalType = pwinfotable.getCellStoreValue(PW_INFO_TABLE_SIGNALTYPE_INDEX, colid, colid);
    rowparams.appendChild(createTagElement("pwSignalType", pwSignalType));
    var pwType = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWTYPE_INDEX, colid, colid);
    rowparams.appendChild(createTagElement("pwType", pwType));
    rowparams.appendChild(createTagElement("direction", "1"));
    rowparams.appendChild(createTagElement("pwEncapsType", "1"));//     1 MPLS   2 UDP  
    
    var pwIngressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_INGRESSLABEL_INDEX, colid, colid);
    var pwEgressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_EGRESSLABEL_INDEX, colid, colid);
    if(pwSignalType == PW_SIGNAL_TYPE_DYNAMIC)
    {
        pwIngressLabel = PW_LABLE_INVALID;//     "0xFFFFFFFF";
        pwEgressLabel = PW_LABLE_INVALID;//     "0xFFFFFFFF";
    }
    rowparams.appendChild(createTagElement("pwIngressLabel", pwIngressLabel));
    rowparams.appendChild(createTagElement("pwEgressLabel", pwEgressLabel));
    
    var tunnelNum = 0;
    var tunnelIndexes = 0;
    var tunnelChooseType = pwinfotable.getCellStoreValue(PW_INFO_TABLE_CHOOSETYPE_INDEX, colid, colid);//Tunnel    
    if(tunnelChooseType == "1")
    {
        tunnelNum = "1";
        tunnelIndexes = pwinfotable.getCellStoreValue(PW_INFO_TABLE_TUNEL_INDEX, colid, colid);
    }
    
    var tunnelIndexHex = tenToHex(tunnelIndexes);
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowparams.appendChild(createTagElement("tunnelNum", tunnelNum));
    rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
    var oppositeLsrID = pwinfotable.getCellStoreValue(PW_INFO_TABLE_LSRID_INDEX, colid, colid);
    
    if (oppositeLsrID.indexOf(".") != -1)
    {
        oppositeLsrID = convertIpaddrToHexcode(oppositeLsrID);
        oppositeLsrID = hexToTen(oppositeLsrID);
    }
    
    rowparams.appendChild(createTagElement("oppositeLsrID", oppositeLsrID));
    rowparams.appendChild(createTagElement("pwDirection", pwDirection));
    
    var tunnelidStr = pwinfotable.getCellShow(PW_INFO_TABLE_OPTUNEL_INDEX, colid).element.innerHTML;
    var tunnelStr = pwinfotable.getCellStoreValue(PW_INFO_TABLE_OPTUNEL_INDEX, colid, colid);
    var tunnelId = tunnelidStr.substring(0, tunnelidStr.indexOf("("));
    var tempArr = tunnelStr.split("-");
 

    rowparams.appendChild(createTagElement("tunnelid", tunnelId));
    rowparams.appendChild(createTagElement("ingressid", tempArr[2]));
    rowparams.appendChild(createTagElement("egressid", tempArr[1]));
}

/**
 *   PW QoS       
 * @param rowparams
 * @param serviceType          
 * @param colid
 * @return
 */
function addQosAttrParam(rowparams, serviceType, colid)
{
    var qosPWIngressCol = QOS_INFO_TABLE_FORWARDPWINGRESS_COL;//QoS      "PW Ingress " ID
    var qosPWEgressCol = QOS_INFO_TABLE_FORWARDPWEGRESS_COL;//QoS      "PW Egress " ID
    if(colid == PW_INFO_TABLE_BACKWARDPW_COL)
    {
        qosPWIngressCol = QOS_INFO_TABLE_BACKWARDPWINGRESS_COL;
        qosPWEgressCol = QOS_INFO_TABLE_BACKWARDPWEGRESS_COL;
    }
    var expValue = qostable.getCellStoreValue(QOS_INFO_TABLE_EXP_INDEX, qosPWIngressCol, qosPWIngressCol);
    rowparams.appendChild(createTagElement("direction", "1"));//ingress     
    rowparams.appendChild(createTagElement("exp", expValue));
    
    if(serviceType == ETH_SERVICE || serviceType == PTP_SERVICE)// ETH   PTP       LSP  
    {
        var lspmode = qostable.getCellStoreValue(QOS_INFO_TABLE_LSPMODE_INDEX, qosPWEgressCol, qosPWEgressCol);
        rowparams.appendChild(createTagElement("lspmode", lspmode));//  egress           
    }
    
    if(serviceType == ETH_SERVICE || serviceType == ATM_SERVICE)
    {
    		var bandwidthLimit = qostable.getCellStoreValue(QOS_INFO_TABLE_BANDWIDTHLIMIT_INDEX, qosPWIngressCol, qosPWIngressCol);
    		
    		if(bandwidthLimit == 1)
    		{
    		var cir = qostable.getCellStoreValue(QOS_INFO_TABLE_CIR_INDEX, qosPWIngressCol, qosPWIngressCol);
        rowparams.appendChild(createTagElement("cir", cir));
        
        var cbs = qostable.getCellStoreValue(QOS_INFO_TABLE_CBS_INDEX, qosPWIngressCol, qosPWIngressCol);
        rowparams.appendChild(createTagElement("cbs", cbs));
        
        var pir = qostable.getCellStoreValue(QOS_INFO_TABLE_PIR_INDEX, qosPWIngressCol, qosPWIngressCol);
        rowparams.appendChild(createTagElement("pir", pir));
        
        var pbs = qostable.getCellStoreValue(QOS_INFO_TABLE_PBS_INDEX, qosPWIngressCol, qosPWIngressCol);
        rowparams.appendChild(createTagElement("pbs", pbs));
      }
    }
}

/**
 *   PW        
 * @param rowparams
 * @param serviceType          
 * @return
 */
function addAdvanceAttrParam(rowparams, serviceType, colid)
{
    var controlWord = advancetable.getCellStoreValue(ADVANCE_TABLE_CONTROLWORD_INDEX, colid, colid);
    var ctrlChanType = advancetable.getCellStoreValue(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, colid, colid);
    var vccv = advancetable.getCellStoreValue(ADVANCE_TABLE_VCCV_INDEX, colid, colid);
    var maxcount = advancetable.getCellStoreValue(ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, colid, colid);
    var loadtime = advancetable.getCellStoreValue(ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, colid, colid);
    var rtp = advancetable.getCellStoreValue(ADVANCE_TABLE_RTPHEAD_INDEX, colid, colid);
    var cachtime = advancetable.getCellStoreValue(ADVANCE_TABLE_BUFFTIME_INDEX, colid, colid);
    var clockmode = advancetable.getCellStoreValue(ADVANCE_TABLE_INGRESSCLOCKMODE_INDEX, colid, colid);
    var serialMode = advancetable.getCellStoreValue(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, colid, colid);
    var timeslotCount = advancetable.getCellStoreValue(ADVANCE_TABLE_TIMESLOTNUMBER64K_INDEX, colid, colid);
    var requestVLAN = advancetable.getCellStoreValue(ADVANCE_TABLE_REQUESTVLAN_INDEX, colid, colid);
    
    if(serviceType == ETH_SERVICE || serviceType == PTP_SERVICE)// ETH   PTP    
    {
        rowparams.appendChild(createTagElement("controlWord", controlWord));//    
        rowparams.appendChild(createTagElement("ctrlChanType", ctrlChanType));//       
        rowparams.appendChild(createTagElement("vccv", vccv));// VCCV    
        if(requestVLAN!="-"&& requestVLAN!="" && requestVLAN!=null)
        {
        	rowparams.appendChild(createTagElement("requestVLAN", requestVLAN));
        }
    }
    else if(serviceType == ATM_SERVICE)// ATM  
    {
        rowparams.appendChild(createTagElement("controlWord", controlWord));//    
        rowparams.appendChild(createTagElement("ctrlChanType", ctrlChanType));//       
        rowparams.appendChild(createTagElement("vccv", vccv));// VCCV    
        rowparams.appendChild(createTagElement("maxcount", maxcount));//       
        rowparams.appendChild(createTagElement("maxtime", loadtime));//       
    }
    else// CES  
    {
        rowparams.appendChild(createTagElement("rtpEnableState", rtp));// RTP 
        rowparams.appendChild(createTagElement("cachtime", cachtime));//       
        rowparams.appendChild(createTagElement("loadtime", loadtime));//       
        /**
         *      DTS2011070103007 
         *     q00119080
         *      MSPW  CES              64K                
         */
        rowparams.appendChild(createTagElement("serialMode", serialMode));//      
        rowparams.appendChild(createTagElement("validTimeslotNum", timeslotCount));// 64K   
    }
}

/**
 *     MSPW
 * @param arg
 * @return
 */
function doCreate(arg)
{
    if (!checkInput()) 
    {
        return;
    }
    
    var xml = createXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_ADD_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, arg, "inputdata=" + xml);
}

/**
 *           
 * @return
 */
function checkInput()
{
    var mspwid = mspwtable.getAtom("mspwid").getValue();
    if (typeof(mspwid) == "undefined" || mspwid == "") 
    {
        alert(RESOURCE["inputMSPWId"]);
        return false;
    }
    
    var fpwid = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWID_INDEX, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL);
    var bpwid = pwinfotable.getCellStoreValue(PW_INFO_TABLE_PWID_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
    if((fpwid == null || fpwid == "") || (bpwid == null || bpwid == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_PWID_INDEX);
        alert(RESOURCE["inputPWId"]);
        return false;
    }
    
    var fpwIngressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_INGRESSLABEL_INDEX, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL);
    var bpwIngressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_INGRESSLABEL_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
    if((fpwIngressLabel == null || fpwIngressLabel == "") || (bpwIngressLabel == null || bpwIngressLabel == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_INGRESSLABEL_INDEX);
        alert(RESOURCE["inputPWIngressLable"]);
        return false;
    }
    
    var fpwEgressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_EGRESSLABEL_INDEX, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL); 
    var bpwEgressLabel = pwinfotable.getCellStoreValue(PW_INFO_TABLE_EGRESSLABEL_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
    if((fpwEgressLabel == null || fpwEgressLabel == "") || (bpwEgressLabel == null || bpwEgressLabel == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_EGRESSLABEL_INDEX);
        alert(RESOURCE["inputPWEgressLable"]);
        return false;
    }
    
    var ftunnel = pwinfotable.getCellShow(PW_INFO_TABLE_TUNEL_INDEX, PW_INFO_TABLE_FORWARDPW_COL).element.innerHTML;
    var btunnel = pwinfotable.getCellShow(PW_INFO_TABLE_TUNEL_INDEX, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML;
    if((ftunnel == null || ftunnel == "") || (btunnel == null || btunnel == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_TUNEL_INDEX);
        alert(RESOURCE["chooseTunnel"]);
        return false;
    }
    
    var foppositeLsrID = pwinfotable.getCellStoreValue(PW_INFO_TABLE_LSRID_INDEX, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL);
    var boppositeLsrID = pwinfotable.getCellStoreValue(PW_INFO_TABLE_LSRID_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
    if((foppositeLsrID == null || foppositeLsrID == "") || (boppositeLsrID == null || boppositeLsrID == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_LSRID_INDEX);
        alert(RESOURCE["lsrIPErr"]);
        return false;
    }
    
    var foptunnel = pwinfotable.getCellShow(PW_INFO_TABLE_OPTUNEL_INDEX, PW_INFO_TABLE_FORWARDPW_COL).element.innerHTML;
    var boptunnel = pwinfotable.getCellShow(PW_INFO_TABLE_OPTUNEL_INDEX, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML;
    if((foptunnel == null || foptunnel == "") || (boptunnel == null || boptunnel == ""))
    {
        selectNeedInputRow(pwinfotable, PW_INFO_TABLE_OPTUNEL_INDEX);
        alert(RESOURCE["chooseOpTunnel"]);
        return false;
    }
    
    var fcbs = qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_FORWARDPWEGRESS_COL).element.innerHTML;
    var bcbs = qostable.getCellShow(QOS_INFO_TABLE_CBS_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL).element.innerHTML;
    if((fcbs == null || fcbs == "") || (bcbs == null || bcbs == ""))
    {
        selectNeedInputRow(qostable, QOS_INFO_TABLE_CBS_INDEX);
        alert(RESOURCE["errcbs"]);
        return false;
    }
    
    var fpbs = qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_FORWARDPWEGRESS_COL).element.innerHTML;
    var bpbs = qostable.getCellShow(QOS_INFO_TABLE_PBS_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL).element.innerHTML;
    if((fpbs == null || fpbs == "") || (bpbs == null || bpbs == ""))
    {
        selectNeedInputRow(qostable, QOS_INFO_TABLE_PBS_INDEX);
        alert(RESOURCE["errpbs"]);
        return false;
    }
    return true;
}

/**
 *               
 * @param table     
 * @param rowIndex           
 * @return
 */
function selectNeedInputRow(table, rowIndex)
{
    var selectedRows = table.getSelectedRows();
    for(var i = 0; i < selectedRows.length; i++)
    {
        table.setRowNoneSelect(selectedRows[i]);
    }
    
    table.setRowSelect(rowIndex);
}

/**
 *           
 * @param doc
 * @param arg
 * @return
 */
function createCallBack(doc, arg)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        $("applybtn").disabled = true;
        win.doQuery();

        if (arg) 
        {
            xcloseDialog();
        }
    }
    
}

/**
 *       
 * @param value
 * @return
 */
function attrConvert(value)
{
	var attrRes = RESOURCE[value];
	if(attrRes == null)
	{
		return value;
	}
	return attrRes;
}

/**
 * PW          
 * @param row
 * @param resKey
 * @return
 */
function convertPWInfoData(row, resKey)
{
	var cellShowValue = pwinfotable.getCellStoreValue(row, PW_INFO_TABLE_FORWARDPW_COL, PW_INFO_TABLE_FORWARDPW_COL);
	pwinfotable.getCellShow(row, PW_INFO_TABLE_FORWARDPW_COL).element.innerHTML = RESOURCE[resKey + "_" + cellShowValue];
	cellShowValue = pwinfotable.getCellStoreValue(row, PW_INFO_TABLE_BACKWARDPW_COL, PW_INFO_TABLE_BACKWARDPW_COL);
	pwinfotable.getCellShow(row, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE[resKey + "_" + cellShowValue];
}

/**
 *         
 * @param serviceType    
 * @return
 */
function serviceTypeChangeListener(serviceType)
{
    var mtuAtom = mspwtable.getAtom("mtu");
    if(serviceType == CES_SERVICE || serviceType == ATM_SERVICE)//CES    ,    MTU(byte)     
    {
        mspwtable.setAttrValue("mtu", "-");
    }
    else//         MTU(byte)         1500
    {
        mspwtable.setAttrValue("mtu", DEFAULT_MTU_VALUE);
    }
    
    if(serviceType == ATM_SERVICE)//ATM              
    {
        mspwtable.element.childNodes[1].lastChild.style.display = "";
    }
    else
    {
        mspwtable.element.childNodes[1].lastChild.style.display = "none";
    }
    
	pwInfoTableSwitch(serviceType);// PW        
	qosInfoTableSwitch(serviceType);// QoS    
	advanceTableSwitch(serviceType);//         
}

function linkTypeChangeListener(linkType)
{
    var pwTypeValue = "";
    switch(linkType)
    {
        case LINK_TYPE_TRANSPORT://  
            pwTypeValue = 3;//ATM  
            break;
            
        case LINK_TYPE_PVP:
            pwTypeValue = 10;//ATM n:1 VPC    
            break;
            
        case LINK_TYPE_PVC:
            pwTypeValue = 9;//ATM n:1 VCC    
            break;
            
        default:
            break;
    }
    
    var showValue = RESOURCE["pwType_" + pwTypeValue];
    var forwardPwTypeCell = pwinfotable.getCell(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL);
    pwinfotable.setCellValue(forwardPwTypeCell, PW_INFO_TABLE_FORWARDPW_COL, pwTypeValue);
    pwinfotable.getCellShow(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL).element.innerHTML = showValue;
    
    var backwardPwTypeCell = pwinfotable.getCell(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL);
    pwinfotable.setCellValue(backwardPwTypeCell, PW_INFO_TABLE_BACKWARDPW_COL, pwTypeValue);
    pwinfotable.getCellShow(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML = showValue;
    
}

/**
 * PW        
 * @param serviceType
 * @return
 */
function pwInfoTableSwitch(serviceType)
{
	if(serviceType == PTP_SERVICE)//PTP          PW       PW       
	{
        setCellEidtable(pwinfotable, PW_INFO_TABLE_SIGNALTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL, CELL_DISABLED);
        setCellEidtable(pwinfotable, PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL, CELL_DISABLED);
        setCellEidtable(pwinfotable, PW_INFO_TABLE_SIGNALTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL, CELL_DISABLED);
	}
	else
	{
	    setCellEidtable(pwinfotable, PW_INFO_TABLE_SIGNALTYPE_INDEX,PW_INFO_TABLE_FORWARDPW_COL, CELL_ENABLED);
        setCellEidtable(pwinfotable, PW_INFO_TABLE_PWTYPE_INDEX,PW_INFO_TABLE_FORWARDPW_COL, CELL_ENABLED);
        setCellEidtable(pwinfotable, PW_INFO_TABLE_SIGNALTYPE_INDEX,PW_INFO_TABLE_BACKWARDPW_COL, CELL_ENABLED);
	}
	
    var defalutPwType = "5";//PW       
	if(serviceType == CES_SERVICE)//CES   PW    
    {
	    defalutPwType = "21";//PW    CESoPSN 
    }
	else if(serviceType == ATM_SERVICE)//ATM    ,PW         
    {
	    defalutPwType = "3";//ATM  
    }
	
	var showValue = RESOURCE["pwType_" + defalutPwType];
	var forwardPwTypeCell = pwinfotable.getCell(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL);
    pwinfotable.setCellValue(forwardPwTypeCell, PW_INFO_TABLE_FORWARDPW_COL, defalutPwType);
    pwinfotable.getCellShow(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_FORWARDPW_COL).element.innerHTML = showValue;
    
	var backwardPwTypeCell = pwinfotable.getCell(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL);
    pwinfotable.setCellValue(backwardPwTypeCell, PW_INFO_TABLE_BACKWARDPW_COL, defalutPwType);
    pwinfotable.getCellShow(PW_INFO_TABLE_PWTYPE_INDEX, PW_INFO_TABLE_BACKWARDPW_COL).element.innerHTML = showValue;
	
	addPWInfoCellListener();//           
}

/**
 * QoS             
 * @param serviceType
 * @return
 */
function qosInfoTableSwitch(serviceType)
{
    if(serviceType == CES_SERVICE)//CES    ,   EXP  
    {
        for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
        {
            if(i != QOS_INFO_TABLE_EXP_INDEX)
            {
                setRowShow(qostable, i, false);
            }
        }
        
        setCellEidtable(qostable, QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL, CELL_DISABLED);
        setCellEidtable(qostable, QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL, CELL_DISABLED);
        
        qostable.getCellShow(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL).element.innerHTML = "-"; 
        qostable.getCellShow(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL).element.innerHTML = "-";   

    }
    else //            
    {
        for(var i = 0, size = qostable.getDataRowLength(); i < size; i++)
        {
            setRowShow(qostable, i, true);
        }
        
        var bandwidthValue = "-";
        if(serviceType == ATM_SERVICE)//ATM    ,           
        {
            bandwidthValue = RESOURCE["disabled"];
            setRowShow(qostable, QOS_INFO_TABLE_LSPMODE_INDEX, false);
        }
        
        qostable.getCellShow(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL).element.innerHTML = RESOURCE["exp_" + EXP_VALUE_INVALID]; 
        qostable.getCellShow(QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL).element.innerHTML = RESOURCE["exp_" + EXP_VALUE_INVALID]; 
     }
    setCellEidtable(qostable, QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_FORWARDPWINGRESS_COL, CELL_DISABLED);
    setCellEidtable(qostable, QOS_INFO_TABLE_EXP_INDEX, QOS_INFO_TABLE_BACKWARDPWINGRESS_COL, CELL_DISABLED);
    
    addQoSCellListener();//           
}

/**
 *                  
 * @param serviceType
 * @return
 */
function advanceTableSwitch(serviceType)
{
    var isShowCESSerTypeTable = (serviceType == CES_SERVICE);
    
    for(var i = 0, size = advancetable.getDataRowLength(); i < size; i++)
    {
        if(i < ADVANCE_TABLE_RTPHEAD_INDEX)//RTP      
        {
            setRowShow(advancetable, i, !isShowCESSerTypeTable);
        }
        else
        {
            setRowShow(advancetable, i, isShowCESSerTypeTable);
        }
    }
    
    if(serviceType == ATM_SERVICE)
    {
        setRowShow(advancetable, ADVANCE_TABLE_REQUESTVLAN_INDEX, false);
        setRowShow(advancetable, ADVANCE_TABLE_TPID_INDEX, false);
        setRowShow(advancetable, ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, true);
        setRowShow(advancetable, ADVANCE_TABLE_PACKETLOADINGTIME_INDEX, true);
        
        advancetable.getCellShow(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = RESOURCE["controlWord_3"];
        var controlWordCell = advancetable.getCell(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
        advancetable.setCellValue(controlWordCell, ADVANCE_TABLE_FORWARDPW_COL, CONTROLWORD_MUST_USE);
        
        advancetable.getCellShow(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["controlWord_3"];
        controlWordCell = advancetable.getCell(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
        advancetable.setCellValue(controlWordCell, ADVANCE_TABLE_BACKWARDPW_COL, CONTROLWORD_MUST_USE);
        
        advancetable.getCellShow(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = RESOURCE["ctrlChanType_1"];
        var controlTpyeCell = advancetable.getCell(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
        advancetable.setCellValue(controlTpyeCell, ADVANCE_TABLE_FORWARDPW_COL, 1);
        
        advancetable.getCellShow(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["ctrlChanType_1"];
        var controlTpyeCell = advancetable.getCell(ADVANCE_TABLE_CTRLCHANTYPE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
        advancetable.setCellValue(controlTpyeCell, ADVANCE_TABLE_BACKWARDPW_COL, 1);
    }
    else if(serviceType == CES_SERVICE)
    {
        setRowShow(advancetable, ADVANCE_TABLE_MAXCONCATENATEDCELLCOUNT_INDEX, false);
       
        advancetable.getCellShow(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["huaweiMode"];
        var modecell = advancetable.getCell(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
        advancetable.setCellValue(modecell, ADVANCE_TABLE_BACKWARDPW_COL, "1");
        
        advancetable.getCellShow(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = RESOURCE["huaweiMode"];
        var modecell = advancetable.getCell(ADVANCE_TABLE_SEQUENCENUMBERMODE_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
        advancetable.setCellValue(modecell, ADVANCE_TABLE_FORWARDPW_COL, "1");
        
    }
    else
    {
        advancetable.getCellShow(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_FORWARDPW_COL).element.innerHTML = RESOURCE["controlWord_1"];
        var controlWordCell = advancetable.getCell(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_FORWARDPW_COL);
        advancetable.setCellValue(controlWordCell, ADVANCE_TABLE_FORWARDPW_COL, CONTROLWORD_USED_FIRST);
        
        advancetable.getCellShow(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL).element.innerHTML = RESOURCE["controlWord_1"];
        controlWordCell = advancetable.getCell(ADVANCE_TABLE_CONTROLWORD_INDEX, ADVANCE_TABLE_BACKWARDPW_COL);
        advancetable.setCellValue(controlWordCell, ADVANCE_TABLE_BACKWARDPW_COL, CONTROLWORD_USED_FIRST);
       
    }
    
    addAdvanceCellListener();//           	
}

/**
 *           
 * @param row
 * @param colid
 * @param isEdit
 * @return
 */
function setCellEidtable(st, row, colid, isEdit)
{
	var cell = st.getCell(row, colid);
	st.setCellIsEdit(cell , isEdit);
	if(isEdit == CELL_DISABLED)
	{
		cell.element.style.cursor = "default";
	}
	else
	{
		cell.element.style.cursor = "hand";
	}
	
}

/**
 *               
 * @param st
 * @param rowIndex
 * @param isShow       true   
 * @return
 */
function setRowShow(st, rowIndex, isShow)
{
    if(!isShow)
    {
        st.element.datarows[rowIndex].element.style.display = "none";
    }
    else
    {
        st.element.datarows[rowIndex].element.style.display = "";
    }
}

/**
 *   Tunnel             
 * @return
 */
function forwardUp()
{
    moveUp(forwardtunneltypetable);
}

/**
 *   Tunnel             
 * @return
 */
function forwardDown()
{
    moveDown(forwardtunneltypetable);
}

/**
 *   Tunnel             
 * @return
 */
function backwardUp()
{
    moveUp(backwardtunneltypetable);
}

/**
 *   Tunnel             
 * @return
 */
function backwardDown()
{
    moveDown(backwardtunneltypetable);
}

/**
 *         
 * @param tunnelTable        
 * @return
 */
function moveUp(tunnelTable)
{
    var rowsize = tunnelTable.getDataRowLength();
    for(var i = 0; i < rowsize; i++)
    {
        if(tunnelTable.getRowSelFlag(i))
        {
            if(tunnelTable.getRowSelFlag(i))
            {
               if ( i == 0)//            
               {
                  return;
               }
               else
               {
                  swapTableRow(tunnelTable, i, i - 1);//        
                  break;
               }
            }
        }
    }
}

/**
 *         
 * @param tunnelTable        
 * @return
 */
function moveDown(tunnelTable)
{
    var rowsize = tunnelTable.getDataRowLength();
    for(var i = 0; i < rowsize; i++)
    {
        if(tunnelTable.getRowSelFlag(i))
        {
            if (i == (rowsize - 1))//             
            {
               return ;
            }
            else
            {
               swapTableRow(tunnelTable, i + 1, i);//        
               i = i+ rowsize;
            }
         }
     } 
}

/**
 *             
 * @param tunnelTable        
 * @param src   
 * @param snk   
 * @return
 */
function swapTableRow(tunnelTable, src, snk)
{
    var srcrow = tunnelTable.getRow(src);
    var snkrow = tunnelTable.getRow(snk);
             
    tunnelTable.element.datarows[snk] = srcrow;
    tunnelTable.element.datarows[src] = snkrow;
             
    srcrow.element.swapNode(snkrow.element);
}
