var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var currPWserviceType = 4;//                PW     (    ETH )
var INVALID = "-";
var INVALID_64K = "32";//64K        
var CELL_DISABLED = "0";//        
var CELL_ENABLED = "1";//       

var TABLE_RES_MAP = [];//                    
TABLE_RES_MAP["ETH"] = "mspw_advancedattr_eth_table";//    
TABLE_RES_MAP["CES"] = "mspw_advancedattr_ces_table";//CES  
TABLE_RES_MAP["ATM"] = "mspw_advancedattr_atm_table";//ATM  

var serType2Domain = [];//              
serType2Domain[1] = "CES";
serType2Domain[2] = "ATM";
serType2Domain[3] = "ETH";
serType2Domain[4] = "PTP";
serType2Domain[5] = "TOP";

var SERVICE_ETH = "3";//ETH  
var SERVICE_PTP = "4";//PTP  

var pwSignalType = [];//PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = [];//PW  
pwType[4] = "pwType_4";//  Tag  
pwType[5] = "pwType_5";//  
var pwDirection = [];//  
pwDirection[1] = "pwDirection";

var controlWord = [];//   
controlWord[1] = "controlWord_1";//   
controlWord[2] = "controlWord_2";//    
controlWord[3] = "controlWord_3";//    

var ctrlChanType = [];//      
ctrlChanType[0] = "ctrlChanType_0";//None
ctrlChanType[1] = "ctrlChanType_1";//CW
ctrlChanType[2] = "ctrlChanType_2";//Alert
ctrlChanType[3] = "ctrlChanType_3";//TTL 1

var vccv = [];//VCCV    
vccv[0] = "vccv_0";//None
vccv[1] = "vccv_1";//Ping
vccv[2] = "vccv_2";//BFD

var requestVLAN = [];//  VLAN
requestVLAN[0] = "enableState_0";//  
requestVLAN[1] = "enableState_1";//  

var rtpEnableState = [];//RTP   
rtpEnableState[0] = "enableState_0";
rtpEnableState[1] = "enableState_1";

var clockMode = [];//    
clockMode["0"] = "clockmode_0";//NULL
clockMode["1"] = "clockmode_1";//LINE    
clockMode["2"] = "clockmode_2";//      
clockMode["3"] = "clockMdoe_3";//       

var SNMode = [];//     
SNMode["0"] = "standardMode";//    
SNMode["1"] = "huaweiMode";//    
/**
 *      
 */
function init()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    st.setOnCellEditHandler(cellEditHandler);
    
    $("applybtn").value = RESOURCE["applybutton"];
    $("applybtn").disabled = true;
}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = false;
}


/**
 * Tab     
 */
function tabSelectHandler()
{
	st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    refreshTable();
}

/**
 *     
 */
function refreshTable()
{
	st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    var selRows = parent.st.getSelectedRows();
    if (selRows.length == 0) 
    {
        return;
    }
    
    var serviceType = parent.st.getCellStoreValue(selRows[0], "servicetype", "servicetype");
    if (serType2Domain[currPWserviceType] != serType2Domain[serviceType]) 
    {
        currPWserviceType = serviceType;
        window.tableconf.length = 0;
        loadXMLdoc("../../conf/mpls/mspw/" + TABLE_RES_MAP[serType2Domain[serviceType]] + "_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
        var nodes = document.getElementById("tbdiv");
        for (var i = nodes.childNodes.length - 1; i >= 0; i--) 
        {
            nodes.removeChild(nodes.childNodes[i]);
        }
        
        st = new SortTable();
        st.setImage("../../../../../images/");
        createTableHead(st, window.tableconf[0]);
        $("tbdiv").appendChild(st.getTable());
        st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
        st.setOnCellEditHandler(cellEditHandler);
    }
    
    if(SERVICE_ETH == serviceType || SERVICE_PTP == serviceType)
    {
        $("applybtn").style.display = "none";
    }
    else
    {
        $("applybtn").style.display = "";
    }
    
    doQuery();
}

/**
 *        xml
 */
function createQueryXml(pwIndexArr)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for(var i = 0; i < pwIndexArr.length; i++)
    {
        var rowparams = new tagElement("row-params");
    
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", pwIndexArr[i]));//       
        rowparams.appendChild(createTagElement("pwdomain", serType2Domain[currPWserviceType]));//pw       
        rowparams.appendChild(createTagElement("isLogFlag", "0"));//     
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
    var selRows = parent.st.getSelectedRows();
    if (selRows.length == 0) 
    {
        return;
    }
    
    var pwIndexArr = [];
    var forwardpwindex = parent.st.getCellStoreValue(selRows[0], "forwardpwindex", "forwardpwindex");
    var backwardpwindex = parent.st.getCellStoreValue(selRows[0], "backwardpwindex", "backwardpwindex");
    pwIndexArr.push(forwardpwindex);
    pwIndexArr.push(backwardpwindex);
    var xml = createQueryXml(pwIndexArr);
    var url = "../../../../../neExlorerServlet?sfid=" + TE_IPPTN_GET_PW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        processData(data);
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addListener();
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    var pwIndexIdMap = [];
    var nullPWIdRows = [];
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null == data.getDataRowParam(i, "requestVLAN") || "" == data.getDataRowParam(i, "requestVLAN")) 
        {
            data.rows[i]["requestVLAN"].value = INVALID;
            data.rows[i]["tpid"].value = INVALID;
        }
        
        if(null != data.getDataRowParam(i, "egressclockmode"))
        {
            data.rows[i]["egressclockmode"].value = INVALID;//         
        }
        
        if(null != data.getDataRowParam(i, "clockmode"))
        {
            data.rows[i]["clockmode"].value = INVALID;//         
        }
        
        var pwID = data.getDataRowParam(i, "pwID");
        if (pwID != null && pwID != "")
        {
            var pwIndex = data.getDataRowParam(i, "pwIndex");
            pwIndexIdMap[pwIndex] = pwID;
        }
        else
        {
            nullPWIdRows.push(i);
        }
    }
    
    for(var j = 0; j < nullPWIdRows.length; j++)
    {
        var rowIndex = nullPWIdRows[j];
        var pwIndex = data.getDataRowParam(rowIndex, "pwIndex");
        data.rows[rowIndex]["pwID"].value = pwIndexIdMap[pwIndex];
    }
}

/**
 *                   
 * @return
 */
function addListener()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        var cell = st.getCellEdit(i, "cachtime");//       (us)
        if(cell != null)
        {
            textCheckWithStepLen(cell.element, "375", "16000", "125");
        }
        
        cell = st.getCellEdit(i, "maxtime");//       
        if(cell != null)
        {
            textCheckWithStepLen(cell.element, "100", "50000", "100");
        }
        
        cell = st.getCellEdit(i, "maxcount");//       
        if(cell != null)
        {
            textCheck(cell.element, "1", "31");
            var blurHandle = cell.element.onblur;
            cell.element.onblur = function()
            {
                var rowIndex = this.parentNode.parentNode.rowIndex;
                var maxtimeCell = st.getCell(rowIndex, "maxtime");
                if(maxtimeCell != null)
                {
                    if(this.value == "1" || this.value == "")
                    {
                        st.setCellValue(maxtimeCell, "maxtime", "0");
                        st.getCellShow(rowIndex, "maxtime").element.innerHTML = "0";
                        st.setCellIsEdit(maxtimeCell, CELL_DISABLED);
                        maxtimeCell.element.style.cursor = "default";
                    }
                    else
                    {
                        st.setCellValue(maxtimeCell, "maxtime", "1000");
                        st.getCellShow(rowIndex, "maxtime").element.innerHTML = "1000";
                        st.setCellIsEdit(maxtimeCell, CELL_ENABLED);
                        maxtimeCell.element.style.cursor = "hand";
                    }
                }
                
                blurHandle();
            }
        }
    }
}

/**
 *     PW     xml
 * @return
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        var pwIndex = st.getCellStoreValue(i, "pwIndex", "pwIndex");
        row.appendChild(createTagElement("pwIndex", pwIndex));
        var pwID = st.getCellStoreValue(i, "pwID", "pwID");
        row.appendChild(createTagElement("pwID", pwID));
        
        if(st.getCellEdit(i, "maxcount") != null && st.getCellModify(i, "maxtime"))
        {
            var maxtime = st.getCellStoreValue(i, "maxtime", "maxtime");
            row.appendChild(createTagElement("maxtime", maxtime));
            var maxcount = st.getCellStoreValue(i, "maxcount", "maxcount");
            row.appendChild(createTagElement("maxcount", maxcount));
        }
        
        if(st.getCellEdit(i, "cachtime") != null && st.getCellModify(i, "cachtime"))
        {
            var cachtime = st.getCellStoreValue(i, "cachtime", "cachtime");
            row.appendChild(createTagElement("cachtime", cachtime));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW    
 * @return
 */
function doApply()
{
    $("applybtn").disabled = true;
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_MODIFY_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, doApplyCallBack, null, "inputdata=" + xml);
}

/**
 *   PW         
 * @param doc
 * @return
 */
function doApplyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = false;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};


function convertClockMode(param)
{
	if(param == null || param == "")
	{
		return INVALID;
	}
	return RESOURCE[clockMode[param]];
}

/**
 *                       
 */
function convertValue(param)
{
    return INVALID;
}

/**
 *   64K    
 */
function convert64KMode(param)
{
    if(param == null || param == INVALID_64K)
    {
        return INVALID;
    }
    return param;
}
