var st = null;
var Tab = null;
var countObj = null;
var INDEX_ATTR_NAME = "pwIndex";// PW Index         Ping      
var START_PING = TE_IPPTN_START_PWPING;//   Ping      
var NOTIFY_PING_STAT = TE_IPPTN_PWPING_NOTIFY_STAT;//   Ping        
var STOP_PING = TE_IPPTN_STOP_PWPING;//   Ping      
var TEST_TYPE = "pwPing";//      PW Ping
var INDEX_ATTR_ID_RES_NAME = "pwIDPing";
var INDEX_ATTR_ID_NAME = "pwID";

var btnRightArr = new Object();
var memberInterface = new Array();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var INVALID_IP = 0;//   IP  
var INVALID_VALUE = "-";//       
var INVALID_LABEL_VALUE_1 = 0;//    label 
var INVALID_LABEL_VALUE_2 = 4294967295;//    label 
var DISABLED = 0;//    
var ENABLED = 1;//   
var INVALID_MTU = "65535";//MTU    

var serviceType = [];//     
serviceType["1"] = "cesservice";// CES  
serviceType["2"] = "atmservice";// ATM  
serviceType["3"] = "ethservice";// ETH  
serviceType["4"] = "ptpservice";// PTP    
serviceType["5"] = "topservice";// TOP    


function tabSelectHandler()
{
    doQuery();
}

/**
 *      
 * @param  
 * @return  
 */
function initPage()
{
    initTable();
    initButton();
    initTabs();
    
    initRight();
}

/**
 *      
 * @param  
 * @return  
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    tableConf = window.tableconf[0];
    createTableHead(st, tableConf);
    
    document.getElementById("tablecomponent").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
    st.setBodyWidth(tableConf.width, tableConf.percent, 0);
    st.setOnCellEditHandler(cellEditHandler);
}

/**
 *      
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/**
 *      Tab 
 */
function initTabs()
{
    Tab = new Tabs();
    Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    Tab.addTab(1, RESOURCE["pwbasicinfo"], "mspw_pwbasicinfo.html");
    Tab.addTab(2, RESOURCE["qosinfo"], "mspw_qosinfo.html");
    Tab.addTab(3, RESOURCE["advancedattr"], "mspw_advancedattr.html");
    
    Tab.tabNodes[1].body.style.height = "200px";
    Tab.tabNodes[2].body.style.height = "200px";
    Tab.tabNodes[3].body.style.height = "200px";
    
    Tab.selectTab(1);
    $("tabs").appendChild(Tab.getTabs());
}

/**
 *        
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_IPPTN_QUERY_PW);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TE_IPPTN_DEL_PW);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TE_IPPTN_QUERY_PW);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_IPPTN_DEL_PW);
    getRightInfo(winobj, btnRightArr);
}

/**
 * Tab     
 */
function tabSelectHandler()
{
	st.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
	var selTabIndex = Tab.getSelectedTabID();
    Tab.getTabWindow(selTabIndex).refreshTable();//     Tab     
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

/**
 *      
 */
function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    var selTabIndex = Tab.getSelectedTabID();
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        Tab.getTabWindow(selTabIndex).refreshTable();//     Tab     
    }
    else
    {
        $("deletebtn").disabled = true;
        Tab.getTabWindow(selTabIndex).st.clearTableData();
    }
}

/**
 *              
 * @return
 */
function cellEditHandler()
{
    $("applybtn").disabled = false;
}

/**
 *     PW
 */
function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_QUERY_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *       PW xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("mspwindex", "0"));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW     
 * @param {Object}doc
 */
function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        var ce = st.getHeadCell("mspwid").element;
        st.sortRows(ce, 1);

        /**
         * DTS2011062402539 
         *            tab        
         */
        Tab.getTab(1).body.contentWindow.st.clearTableData();
        Tab.getTab(2).body.contentWindow.st.clearTableData();
        Tab.getTab(3).body.contentWindow.st.clearTableData();

        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
            rowSelectHandler();
        }
    }
    
    for(var i = 0, size = st.getDataRowLength(); i < size; i++)
    {
        st.getCellEdit(i, "mspwname").element.maxLength = 64;
    }
}

/**
 *   MSPW
 * @return
 */
function doCreate()
{
	removejsDOMmenu();
    xshowModalDialog("mspw_create.html", RESOURCE["mspwcreate"], 540, 560, "../../../../../images/", "no");
}

/**
 *     MSPW xml
 */
function createDelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
	var mspwindex = st.getCellStoreValue(indexes[i], "mspwindex", "mspwindex");
        rowparams.appendChild(createTagElement("mspwindex", mspwindex));
        bussiness.appendChild(rowparams);
        
        
        var pwIndex = st.getCellStoreValue(indexes[i], "forwardpwindex", "forwardpwindex");
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", pwIndex));
        bussiness.appendChild(rowparams);
        
        pwIndex = st.getCellStoreValue(indexes[i], "backwardpwindex", "backwardpwindex");
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("pwIndex", pwIndex));
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   PW
 */
function doDelete()
{
    removejsDOMmenu();
    if (!confirm(RESOURCE["delmspw"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createDelXML();

    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_DEL_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

/**
 *   PW     
 * @param {Object}doc
 */
function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.deletebtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var pwIndex = data.getBErrParam(i, "mspwindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempPwIndex = st.getCellCurrentValue(indexes[j], "mspwindex", "mspwindex");
            if (pwIndex == tempPwIndex) 
            {
                indexes.splice(j, 1);//           
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);//              
    }
    st.adjustDataRows();
    
    Tab.getTab(1).body.contentWindow.st.clearTableData();
    Tab.getTab(2).body.contentWindow.st.clearTableData();
    Tab.getTab(3).body.contentWindow.st.clearTableData();
    
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);//              
    }
    
    rowSelectHandler();
}

/**
 *     MSPW   xml
 * @return
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        if (st.getCellModify(i, "mspwname")) 
        {
            row.appendChild(createTagElement("mspwindexallotmode", 0));
            var mspwindex = st.getCellStoreValue(i, "mspwindex", "mspwindex");
            row.appendChild(createTagElement("mspwindex", mspwindex));
            var mspwid = st.getCellStoreValue(i, "mspwid", "mspwid");
            row.appendChild(createTagElement("mspwid", mspwid));
            var mspwname = st.getCellStoreValue(i, "mspwname", "mspwname");
            row.appendChild(createTagElement("mspwname", mspwname));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *   MSPW  
 * @return
 */
function doApply()
{
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_F_CMD_PTN_PW_MODIFY_MSPW + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, doApplyCallBack, null, "inputdata=" + xml);
}

/**
 *   MSPW       
 * @param doc
 * @return
 */
function doApplyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
    else
    {
        $("applybtn").disabled = true;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";		
	errArr[1] = "mspwid";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object}param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object}param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

/**
 *        MTU    F      - 
 * @param {Object} param
 */
function convertMTU(param)
{
    return param == INVALID_MTU ? INVALID_VALUE : param;
}

window.onresize = function()
{
	st.setBodyHeight(getComponetHeight($("tablecomponent"), 320) + "px");
};
