var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var netype = winobj.neType;
var STARTOFGLS_MIN = 0;//                
var STARTOFGLS_MAX = 1048064;
var STARTOFGLS_MAX_NA = 1015808;
var STARTOFGLS_STEP = 512;
var STARTOFGLS_STEP_NA = 2048;
var never = winobj.neversion.split('.');

/**
 *      
 */
function init()
{
    initTable();
    initButton();
    initRight();//    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    doQuery();
}

/**
 *      
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

/**
 *     
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/**
 *       
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_MPLSTPOAM_GLOBALPARA);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_MPLSTPOAM_GLOBALPARA);
    
    getRightInfo(winobj, btnRightArr);
}

/**
 *               
 * @param {Object} param
 */
function cellEditHandler(param)
{
	var rowIndex = param.rowindex;
	var colid = param.colid;
	
    if (colid == "channeltype" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var textview = st.getCellEdit(rowIndex, colid).element;
        hexCellEvent(textview);
        textview.style.imeMode = "disabled";
	    textview.onblur = onblurHandler;
	    textview.onpaste = function()
		{
			return false;
		}
		textview.maxLength = 5;
    }
    
    if (colid == "carrierid" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
    	var textview = st.getCellEdit(rowIndex, colid).element;
    	textview.maxLength = 6;
    }
    
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    rowparams.appendChild(thirdlevel);
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
    if ($("querybtn").disabled) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_MPLSTPOAM_GLOBALPARA + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    processData(data);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
    	/**
    	 * CSF       
    	 */
        if (null != data.getDataRowParam(i, "csfstatus")) 
        {
            if(!isAfterRTN900R5C01())
            {
                data.rows[i]["csfstatus"].value = "-";
            }
        }
    }
}

/**
 *          
 */
function addCellListener()
{
    
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        /** validateIp(st.getCellEdit(i, "lsrId").element, true);
        if (isRTN900NEtype(netype) && (never[2] + never[3]) >= '0310')
        {
            textCheckWithStepLen(st.getCellEdit(i, "startOfGls").element, STARTOFGLS_MIN, STARTOFGLS_MAX_NA, STARTOFGLS_STEP_NA);
        }
        else
        {
            textCheckWithStepLen(st.getCellEdit(i, "startOfGls").element, STARTOFGLS_MIN, STARTOFGLS_MAX, STARTOFGLS_STEP);
        }
        **/
        
        if(isAfterRTN900R5C01())
        {
        	if(!isRTN900R6C00())
        	{
        		st.setCellEdit(i, 'csfstatus', 1);
        	}
        }
    }
}

/**
 *        xml  
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        
        if (st.getCellModify(i, "carrierid")) 
        {
            var carrierid = st.getCellStoreValue(i, "carrierid", "carrierid");
			row.appendChild(createTagElement("carrierid", carrierid));
        }
        
        if (st.getCellModify(i, "portaisstatus")) 
        {
            var portaisstatus = st.getCellStoreValue(i, "portaisstatus", "portaisstatus");
			row.appendChild(createTagElement("portaisstatus", portaisstatus));
        }
        
        if (st.getCellModify(i, "channeltype")) 
        {
            var channeltype = st.getCellStoreValue(i, "channeltype", "channeltype");
			row.appendChild(createTagElement("channeltype", trimChannelType(channeltype)));
        }
        
        if (st.getCellModify(i, "csfstatus")) 
        {
            var csfstatus = st.getCellStoreValue(i, "csfstatus", "csfstatus");
			row.appendChild(createTagElement("csfstatus", csfstatus));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    if (xml == null) 
    {
        return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_MPLSTPOAM_GLOBALPARA + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

/**
 *       
 * @param {Object} doc
 */
function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};

function onblurHandler(event)
{
	if (!event)
	{
		event = window.event;
	}	
	var numobj = event.target ? event.target : event.srcElement;
	
	if(numobj.value == "")
	{
		numobj.value = "7F FA";
	}
	else if (numobj.value.length < 5)
	{
		var strlen = numobj.value.length;
		var tmpvalue = "";
		if (strlen == 4)
		{
			var string11 = numobj.value.substring(0, 2);
			var string22 = numobj.value.substring(3, numobj.value.length);
			var tmpstr = "0" + string11 + string22;
			
			var string1 = tmpstr.substring(0, 2);
			var string2 = tmpstr.substring(2, tmpstr.length);
			tmpvalue = string1 + " " + string2
		}
		else if (strlen == 3)
		{
			tmpvalue = "00" + numobj.value;
		}
		else if (strlen == 2)
		{
			tmpvalue = "00" + " " + numobj.value;
		}
		else if (strlen == 1)
		{
			tmpvalue = "00 0" + numobj.value;
		}
		
		numobj.value = tmpvalue;
	}
	cellonblur(this);			
}

function isAfterRTN900R5C01()
{	
	var isSupportCSFEN = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CSF", "TE_ATTR_MPLS_SUPPORT_CSFEN");
	if (isSupportCSFEN)
	{
		return true;
	}
	
	if((netype != "114") && (never[2] >= '05' || (never[2] == '05' && never[3] >= '20')))
    {
        return true;
    } else {
        return false;
    }
    
}

function isRTN900R6C00()
{
	if(never[2] == '06' && (never[3] >= '10' && never[3] <= '20'))
    {
        return true;
    } else {
        return false;
    }
}
