

function createQueryXML(megtype, locationvar)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("megtype", megtype));
    rowparams.appendChild(createTagElement("megindex", "0"));
    rowparams.appendChild(createTagElement("location", locationvar));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     LSP   xml
 */
function createQueryLSPStatXML(rows, megtype)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        
        row.appendChild(createTagElement("megtype", megtype));
        
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("megindex", tunnelIndex));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     Tunnel OAM   xml
 */
function createApplyMpeXML(megtype)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        
        row.appendChild(createTagElement("megtype", megtype));
        
        var tunnelIndex = st.getCellStoreValue(i, "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        
        if (st.getCell(i, "reversetunnel") != null && st.getCellModify(i, "reversetunnel"))//  tunnel
        {
            var reverseTunnel = st.getCellStoreValue(i, "reversetunnel", "reversetunnel");
            if (reverseTunnel == null || reverseTunnel == "") 
            {
                reverseTunnel = INVALID_TUNNLE_INDEX;//     tunnelindex       tunnel
            }
            row.appendChild(createTagElement("reversetunnel", reverseTunnel));
        }
        
        if (st.getCellModify(i, "oamstat"))//OAM  
        {
            var oamStat = st.getCellStoreValue(i, "oamstat", "oamstat");
            row.appendChild(createTagElement("oamstat", oamStat));
            
            /**
             * icc   customer       IP         megid  
             */
            var megidtype1 = st.getCellStoreValue(i, "megidtype", "megidtype");
            row.appendChild(createTagElement("temmegidtype", megidtype1));
        }
        
        if (st.getCellModify(i, "megidtype"))//MEG ID  
        {
        	var megidtype = st.getCellStoreValue(i, "megidtype", "megidtype");
            row.appendChild(createTagElement("megidtype", megidtype));
        }
        
        if (st.getCellModify(i, "megid"))//MEG ID
        {
        	var megid = st.getCellStoreValue(i, "megid", "megid");
        	var megidtype1 = st.getCellStoreValue(i, "megidtype", "megidtype");
        	if (megid == "")
        	{
        		var alertstr = "megidcustomer";
        		if (megidtype1 == "2")//ICC
        		{
        			alertstr = "megidicc";
        		}
        		alert(RESOURCE[alertstr]);
            	return null;
        	}
        	else if (megidtype1 == "3" && megid.length < 96)
        	{
        		alert(RESOURCE["customeralert3"]);
            	return null;
        	}
        	
            row.appendChild(createTagElement("megid", megid));
        }
        
        if (st.getCellModify(i, "meglevel"))//MEG  
        {
        	var meglevel = st.getCellStoreValue(i, "meglevel", "meglevel");
            row.appendChild(createTagElement("meglevel", meglevel));
        }
        
        if (st.getCellModify(i, "mepormipid"))//MEP ID
        {
        	var mepormipid = st.getCellStoreValue(i, "mepormipid", "mepormipid");
        	if (mepormipid == "")
        	{
        		alert(RESOURCE["mepidalert"]);
            	return null;
        	}
            row.appendChild(createTagElement("mepormipid", mepormipid));
        }
            
        if (st.getCellModify(i, "rmepormipid"))//RMEP ID
        {
        	var rmepormipid = st.getCellStoreValue(i, "rmepormipid", "rmepormipid");
        	if (rmepormipid == "")
        	{
        		alert(RESOURCE["rmepidalert"]);
            	return null;
        	}
            row.appendChild(createTagElement("rmepormipid", rmepormipid));
        }
            
        if (st.getCellModify(i, "detectionmode"))//    
        {
            var detectionMode = st.getCellStoreValue(i, "detectionmode", "detectionmode");
            row.appendChild(createTagElement("detectionmode", detectionMode));
        }
        
        if (st.getCellModify(i, "ccpri") || st.getCellModify(i, "ccperiod"))//CC     ,CC    
        {
        	var ccpri = st.getCellStoreValue(i, "ccpri", "ccpri");
            row.appendChild(createTagElement("ccpri", ccpri));
            
            var ccperiod = st.getCellStoreValue(i, "ccperiod", "ccperiod");
            row.appendChild(createTagElement("ccperiod", ccperiod));
        }
        
        if (st.getCell(i, "aisstatus") != null && st.getCellModify(i, "aisstatus"))//AIS    
        {
        	var aisstatus = st.getCellStoreValue(i, "aisstatus", "aisstatus");
            row.appendChild(createTagElement("aisstatus", aisstatus));
        }
        
        if (st.getCell(i, "lockstatus") != null && st.getCellModify(i, "lockstatus"))//Lock  
        {
        	var lockstatus = st.getCellStoreValue(i, "lockstatus", "lockstatus");
            row.appendChild(createTagElement("lockstatus", lockstatus));
        }
        
        if (st.getCellModify(i, "sdthreshold") || st.getCellModify(i, "sfthreshold"))//SD/SF  
        {
            var sfThreshold = parseInt(st.getCellCurrentValue(i, "sfthreshold", "sfthreshold"));
            var sdThreshold = parseInt(st.getCellCurrentValue(i, "sdthreshold", "sdthreshold"));
            if(sfThreshold < sdThreshold)
            {
            	alert(RESOURCE["sfsdalm"]);
            	return null;
            }
            row.appendChild(createTagElement("sfthreshold", sfThreshold));
            row.appendChild(createTagElement("sdthreshold", sdThreshold));
        }
        
        if ((st.getCell(i, "lsrId") != null && st.getCellModify(i, "lsrId")) || (st.getCell(i, "sendpwID") != null && st.getCellModify(i, "sendpwID")))
        {
        	var lsrId = convertIPToTen(st.getCellCurrentValue(i, "lsrId", "lsrId"));
            var sendpwID = st.getCellCurrentValue(i, "sendpwID", "sendpwID");
            row.appendChild(createTagElement("lsrId", lsrId));
            row.appendChild(createTagElement("sendpwID", sendpwID));
        }
        
        if (st.getCell(i, "galenable") != null && st.getCellModify(i, "galenable"))
        {
        	var galenable = parseInt(st.getCellCurrentValue(i, "galenable", "galenable"));
            row.appendChild(createTagElement("galenable", galenable));
        }
        
        if (st.getCell(i, "lmmode") != null && st.getCellModify(i, "lmmode"))
        {
        	var lmmode = parseInt(st.getCellCurrentValue(i, "lmmode", "lmmode"));
            row.appendChild(createTagElement("lmmode", lmmode));
        }
        
        if (st.getCell(i, "galmode") != null && st.getCellModify(i, "galmode"))
        {
        	var galmode = parseInt(st.getCellCurrentValue(i, "galmode", "galmode"));
            row.appendChild(createTagElement("galmode", galmode));
        }
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createDelMipXml(megtype)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var selectedrows = mipst.getSelectedRows();
    var tunnelindex = null
    for (var i = 0, len = selectedrows.length; i < len; i++)
    {
    	rowparams.appendChild(createTagElement("neid", neid));
	    rowparams.appendChild(createTagElement("megtype", megtype));
	    tunnelindex = mipst.getCellStoreValue(selectedrows[i], "tunnelindex", "tunnelindex")
	    rowparams.appendChild(createTagElement("tunnelindex", tunnelindex));
	    bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createSetMipXml(megtype)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = null;
    var tmpTunnelindex = null
    var tmpMegid = null;
    var tmpMepormipid = null;
    for (var i = 0, len = mipst.getDataRowLength(); i < len; i++)
    {
    	if (!mipst.getModify(i))
    	{
    		continue
    	}
    	rowparams = new tagElement("row-params");
    	
    	rowparams.appendChild(createTagElement("neid", neid));
	    rowparams.appendChild(createTagElement("megtype", megtype));
	    
	    tmpTunnelindex = mipst.getCellStoreValue(i, "tunnelindex", "tunnelindex")
	    rowparams.appendChild(createTagElement("tunnelindex", tmpTunnelindex));
	    
	    if (mipst.getCellModify(i, "megid"))
	    {
	    	var megidtype = mipst.getCellStoreValue(i, "megidtype", "megidtype");
	    	tmpMegid = mipst.getCellStoreValue(i, "megid", "megid")
	    	if (megidtype == "3" && tmpMegid.length < 96)
	    	{
	    		alert(RESOURCE["customeralert3"]);
            	return null;
	    	}
	    	rowparams.appendChild(createTagElement("megid", tmpMegid));
	    }
	    
	    if (mipst.getCellModify(i, "mepormipid"))
	    {
	    	tmpMepormipid = mipst.getCellStoreValue(i, "mepormipid", "mepormipid")
	    	rowparams.appendChild(createTagElement("mepormipid", tmpMepormipid));
	    }
	    
	    bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function delMipCallBack(doc, isdel)
{
	$("queryMipBtn").disabled = false;
	$("createMipBtn").disabled = false;
	rowSelectHandlerMip();
	var dinterface = EncapsulateData(doc);
	
	if (0 != dinterface.getSErrorCode())
	{
		showErrorDialog(dinterface);
		return;
	}
	
	if ("1" == isdel)
	{
		doQueryMip();
	}
	else
	{
		refreshTableState(mipst, tableConfMip, dinterface);
	}
}

function rowSelectHandlerMip()
{
	if (mipst.getSelectedRowCount() > 0)
	{
		$("deleteMipBtn").disabled = false;	
	}
	else
	{
		$("deleteMipBtn").disabled = true;	
	}
}

/**
 *   LSP      
 * @param {Object} doc
 * @param {Object} param
 */
function queryLSPStatCallBack(doc, rows)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tunnelIndex = data.getBErrParam(i, "tunnelindex");
        for (var j = rows.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(rows[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var tunnelIndex = st.getCellCurrentValue(rows[k], "tunnelindex", "tunnelindex");
        for (var m = data.getDataRowLength() - 1; m >= 0; m--) 
        {
            var tempIndex = data.getDataRowParam(m, "tunnelindex");
            if (tempIndex == tunnelIndex) 
            {
                var lspstat = data.getDataRowParam(m, "lspstat");
                if( lspstat != "" && lspstat != "-" )
                {
                	setShowValue(RESOURCE["lspStat_" + lspstat], rows[k], "lspstat");
                }
                
                var lspdefecttype = data.getDataRowParam(m, "lspdefecttype");
                if( lspdefecttype != "" && lspdefecttype != "-" )
                {
                	setShowValue(RESOURCE["lspDetectType_" + lspdefecttype], rows[k], "lspdefecttype");
                }
                
                var disablelspduration = data.getDataRowParam(m, "disablelspduration");
                if( disablelspduration != "" && disablelspduration != "-" )
                {
                	setShowValue(convertNumber(disablelspduration), rows[k], "disablelspduration");
                }
                
                var lspdefectloc = data.getDataRowParam(m, "lspdefectloc");
                if( lspdefectloc != "" && lspdefectloc != "-" )
                {
                	setShowValue(convertIP(lspdefectloc), rows[k], "lspdefectloc");
                }
                
                var lspstat_far = data.getDataRowParam(m, "lspstat_far");
                if( lspstat_far != "" && lspstat_far != "-" )
                {
                	setShowValue(RESOURCE["lspStat_" + lspstat_far], rows[k], "lspstat_far");
                }
                var lspdefecttype_far = data.getDataRowParam(m, "lspdefecttype_far");
                if( lspdefecttype_far != "" && lspdefecttype_far != "-" )
                {
                	setShowValue(RESOURCE["lspDetectType_" + lspdefecttype_far], rows[k], "lspdefecttype_far");
                }
                var disablelspduration_far = data.getDataRowParam(m, "disablelspduration_far");
                if( disablelspduration_far != "" && disablelspduration_far != "-" )
                {
                	setShowValue(convertNumber(disablelspduration_far), rows[k], "disablelspduration_far");
                }
                var lspdefectloc_far = data.getDataRowParam(m, "lspdefectloc_far");
                if( lspdefectloc_far != "" && lspdefectloc_far != "-" )
                {
                	setShowValue(convertIP(lspdefectloc_far), rows[k], "lspdefectloc_far");
                }
                break;
            }
        }
    }
}

function queryMipCallBack(doc)
{
    $("queryMipBtn").disabled = false;
    $("createMipBtn").disabled = false;
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        mipst.clearTableData();
        createTableBody(mipst, tableConfMip, data, RESOURCE);
		var ce = mipst.getHeadCell("tunnelid").element;
        mipst.sortRows(ce, 1);
    }
}

/**
 * Ping        
 * @param {Object} rows
 */
function doLBTest(rows)
{
    removejsDOMmenu();
    xshowModalDialog("lbtest_mplstp_oam.html", RESOURCE["lbTestTitle"], 525, 540, "../../../../../images/");
}

function setEnabledCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0 && param[1] == ENABLED)//     CV/FFD         
    {
        alert(RESOURCE["startVCFFDTips"]);
    }
    
    var rows = param[0];
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tunnelIndex = data.getBErrParam(i, "tunnelindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tempIndex = st.getCellCurrentValue(rows[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tempIndex) 
            {
                rows.splice(j, 1);
                break;
            }
        }
    }
    for (var k = rows.length - 1; k >= 0; k--) 
    {
        var enableStateCell = st.getCell(rows[k], "ccstatus");
        st.setCellValue(enableStateCell, "ccstatus", param[1]);
        var cellShow = st.getCellShow(rows[k], "ccstatus");
        cellShow.element.innerHTML = RESOURCE[convertccstatus[param[1]]];
    }
}

/**
 *          xml
 * @param {Object} enableState
 */
function createSetEnabledXML(enableState, megtype)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var rows = st.getSelectedRows();
    for (var i = 0; i < rows.length; i++) 
    {
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("megtype", megtype));
        var tunnelIndex = st.getCellCurrentValue(rows[i], "tunnelindex", "tunnelindex");
        row.appendChild(createTagElement("tunnelindex", tunnelIndex));
        row.appendChild(createTagElement("ccstatus", enableState));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function megIDTypeChange(curObj)
{
	var rowIndex = curObj.parentNode.parentNode.rowIndex;
	var megidCell = st.getCell(rowIndex, "megid");
	var mepormipidCell = st.getCell(rowIndex, "mepormipid");
	var rmepormipidCell = st.getCell(rowIndex, "rmepormipid");
	
	if ("1" == curObj.value)//IP Based    MEGID  
	{
        setCellDisable(rowIndex, megidCell, INVALID_VALUE, "megid");
        setCellDisable(rowIndex, mepormipidCell, INVALID_VALUE, "mepormipid");
        setCellDisable(rowIndex, rmepormipidCell, INVALID_VALUE, "rmepormipid");
	}
	else if ("3" == curObj.value)
	{
		setCellEnable(rowIndex, megidCell, "", "megid");
		setCellEnable(rowIndex, mepormipidCell, "", "mepormipid");
		setCellEnable(rowIndex, rmepormipidCell, "", "rmepormipid");
	}
	else
	{
		getDefaultCarrierID(rowIndex);
	}
}

function getDefaultCarrierID(rowIndex)
{
	var xml = createQueryCarrierIDXml();
    var url = "../../../../../neExlorerServlet?sfid=2012051011&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCarrierIDCallBack, rowIndex, "inputdata=" + xml);
}

function queryCarrierIDCallBack(doc, rowIndex)
{
    var data = EncapsulateData(doc);
	
	var carrieridvar = "";	
    if (null != data.getDataRowParam(0, "carrierid")
    	&& null != data.rows[0]["carrierid"].value
    	&& "" != data.rows[0]["carrierid"].value)
    {
    	carrieridvar = data.rows[0]["carrierid"].value;
    }
    
    var megidCell = st.getCell(rowIndex, "megid");
	var mepormipidCell = st.getCell(rowIndex, "mepormipid");
	var rmepormipidCell = st.getCell(rowIndex, "rmepormipid");
	
    setCellEnable(rowIndex, megidCell, carrieridvar, "megid");
    setCellEnable(rowIndex, mepormipidCell, "", "mepormipid");
	setCellEnable(rowIndex, rmepormipidCell, "", "rmepormipid");
}

function createQueryCarrierIDXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    rowparams.appendChild(thirdlevel);
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function setCellDisable(index, cell, value, colid)
{
	st.setCellIsEdit(cell, 0);
    st.getCellShow(index, colid).element.innerHTML = value;
    st.setCellValue(cell, colid, value);
}

function setCellEnable(index, cell, value, colid)
{
	st.setCellIsEdit(cell, 1);
	st.getCellShow(index, colid).element.innerHTML = value;
    st.setCellValue(cell, colid, value);
    cell.element.modify = true;
	cell.element.parentNode.modify = true;
	cell.element.style.backgroundColor = "#d0f946";
}

function cellEditHandler(param)
{
	var colid = param.colid;
	var rowIndex = param.rowindex;
	var currentST = param.st;
	if (colid == "megid" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
	{
		var megidtype = currentST.getCellStoreValue(rowIndex, "megidtype", "megidtype");
		var megidtypeEdit = currentST.getCellEdit(rowIndex, colid).element;
		if (megidtype == "2")//ICC  
		{
			megidtypeEdit.maxLength = 13;
			megidtypeEdit.onblur = function()
			{
				if ("" == this.value) 
				{
					alert(RESOURCE["megidicc"]);
				}
				cellonblur(this);
			}
		}
		else if (megidtype == "3")//Customer  
		{
			megidtypeEdit.maxLength = 96;
			checkMegidtype(megidtypeEdit, "");
		}
	}
    
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        var selectedtab = tab.getSelectEmbedTab();
        if (selectedtab == "tab1div") 
        {
            $("applybtn").disabled = false;
        }
        else 
        {
            $("applyMipBtn").disabled = false;
        }
    }
}

/**
 *        
 * @param {Object} value
 * @param {Object} row
 * @param {Object} colid
 */
function setShowValue(value, row, colid)
{
    var cell = st.getCell(row, colid);
    var cellShow = st.getCellShow(row, colid);
    cellShow.element.innerHTML = value;
}

function checkMegidtype(obj, flag)
{
	if (isIE)
	{
		obj.onkeydown = function()
		{			
			hexTextKeyDownCheck(obj,"");
		}
		obj.onkeypress = function()
		{
			var event=EventUtil.getEvent();
			var code = (event.keyCode!=0?event.keyCode:event.charCode);
		    if(code>255)
		    {
		    	event.returnValue=false;
		    	return false;
		    }
		}
	}
	else
	{
		obj.onkeypress = function()
		{
			hexTextKeyPressCheck(obj,"");
	  	}
	}
	
	obj.onblur = function()
	{
		if (this.value.length < 96)
		{
			if (confirm(RESOURCE["customeralert1"] + this.value.length + RESOURCE["customeralert2"]))
			{
				var filledvar = fillMegidLength(this.value);
				this.value = filledvar;
			}
		}
		
		if ("crt" != flag)
		{
			cellonblur(this);
		}
	}
}

function fillMegidLength(str)
{
	var len = 96 -  str.length;
	for (var i = 0; i < len; i++)
	{
		str = str + "0";
	}
	
	return str;
}

function hexTextKeyDownCheck(obj,splitChar)
{
	var event=EventUtil.getEvent();
	if(null == splitChar)
	{
		splitChar = " ";
	}
    var code = event.keyCode;
    if(code>255)
    {
    	event.returnValue=false;
    	return false;
    }
	var ch = String.fromCharCode(code).toLocaleUpperCase();
	var cursorindex = digitalTag_getPos(obj);
	var selectlen = selectionLen(obj);
	var endpos = cursorindex+selectlen;

	if(code == 13 && obj.blur)
  	{  	
	    obj.blur();
	    return true;	
  	}
    if(code > 36 && code < 41)
    {
    	event.returnValue=true;
    	return;        
    }
    if(event.ctrlKey)
    {
    	if(ch == 'c' || ch == 'a')
    	{  //X C V A
    	   event.returnValue=true;        	   
    	}
        else
        {
            event.returnValue=false;
        }
        return false;
   	}
	var curValue = obj.value;
    var len = curValue.length;
    if((code >= 48 && code <=57)  || (code >= 65 && code <= 70) || (code >= 96 && code <= 105))
    {
    	return true;
    }
    
	if(code == 8 || event.keyCode == 46)
	{
	    event.returnValue=true;
		return true;	
  	} 	
 
	event.returnValue=false;
	return false;		   
}

/**
 * 16        OnkeyPress  ,  Mozilla
 * @param obj      splitChar:       
 * @return  
 */
function hexTextKeyPressCheck(obj,splitChar)
{
	var event=EventUtil.getEvent();
    var code = (event.keyCode!=0?event.keyCode:event.charCode);
    if(code>255)
    {
    	event.returnValue=false;
    	return false;
    }
	var ch = String.fromCharCode(code)
	var cursorindex = digitalTag_getPos(obj);
	var selectlen = selectionLen(obj);
	var endpos = cursorindex+selectlen;
	if(code == 13 && obj.blur)
  	{  	
	    obj.blur();
	    return true;	
  	}
    if(code > 36 && code < 41)
    {
    	event.returnValue=true;
    	return;        
    }
   
    if(event.ctrlKey)
    {
    	if(ch == 'c' || ch == 'a')
    	{  //X C V A
    	   event.returnValue=true;        	   
    	}
        else
        {
            event.returnValue=false;
        }
        return false;
   	}
	var curValue = obj.value;
    var len = curValue.length;
    
    if((code >= 48 && code <=57) || (code >= 65 && code <= 70) || (code >= 97 && code <= 102)) 
    {
    	return true;
    }
    
	if(code == 8 || (event.keyCode == 46 && event.charCode == 0))
	{
	    event.returnValue=true;
		return true;	
  	} 	
 
	event.returnValue=false;
	return false;	
}
