var NODE_TYPE_INGRESS = 1; //Ingress    
var NODE_TYPE_TRANSIT = 2; //Transit    
var NODE_TYPE_EGRESS = 3; //Egress    
var INVALID_VLAN_ID = 0xFFFF;
var MIN_BANDWIDTH = 0;
var MAX_BANDWIDTH = 4294967295;
var INVALID_IP = 0;//  IP  
var INVALID_IP_255 = 4294967295;// 255  
var INVALID_VALUE = "-";//      
var INVALID_NUMBER = 4294967295;//     
var INVALID_LABEL_VALUE = 0;//   label 

var DIRECTION_UNI = 0;//  
var DIRECTION_BI = 1;//  
var INVALID_VALUE_NUM = -1;
var MIN_VLANID = "1";
var MAX_VLANID = "4094";
function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function getDataArr()
{
    var opsary = new Array();
    opsary[0] = new Option("1Mbit/s", 1000);
    opsary[1] = new Option("2Mbit/s", 2000);
    opsary[2] = new Option("3Mbit/s", 3000);
    opsary[3] = new Option("4Mbit/s", 4000);
    opsary[4] = new Option("5Mbit/s", 5000);
    opsary[5] = new Option("6Mbit/s", 6000);
    opsary[6] = new Option("7Mbit/s", 7000);
    opsary[7] = new Option("8Mbit/s", 8000);
    opsary[8] = new Option("9Mbit/s", 9000);
    opsary[9] = new Option("10Mbit/s", 10000);
    opsary[10] = new Option("20Mbit/s", 20000);
    opsary[11] = new Option("30Mbit/s", 30000);
    opsary[12] = new Option("40Mbit/s", 40000);
    opsary[13] = new Option("50Mbit/s", 50000);
    opsary[14] = new Option("100Mbit/s", 100000);
    opsary[15] = new Option("1000Mbit/s", 1000000);
    opsary[16] = new Option("10Gbits/s", 10000000);
    opsary[17] =  new Option(RESOURCE["nolimit"], RESOURCE["nolimit"]);
    return opsary;
}

function onblurHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = MIN_BANDWIDTH;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || numobj.value < MIN_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MIN_BANDWIDTH;
        return;
    }
}

function keyupHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return;
    }
}

function keypressHandler(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return false;
    }
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP || param == INVALID_IP_255) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *             F      - 
 * @param {Object} param
 */
function convertNumber(param)
{
    return param == INVALID_NUMBER ? INVALID_VALUE : param;
}

/**
 *               0      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    return param == INVALID_LABEL_VALUE ? INVALID_VALUE : param;
}
