var ct = null;
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var indexName = win.INDEX_ATTR_NAME;//Index     (  pwIndex tunnelindex )
var idName = win.INDEX_ATTR_ID_NAME;//id    (  pwID,tunnelid )
var idNameRes = win.INDEX_ATTR_ID_RES_NAME;//id    (  pwID,tunnelid )
var START_PING = win.START_PING;//  Ping      
var NOTIFY_PING_STAT = win.NOTIFY_PING_STAT;//  Ping        
var STOP_PING = win.STOP_PING;//  Ping      
var TEST_TYPE = win.TEST_TYPE;//     PW Ping   Tunnel Ping
var START_LB = win.START_LB;//  LB      
var STOP_LB = win.STOP_LB;//  LB      
var intervalID = 0;//     
var idValue;//    Tunnel PW ID 
var PING_RESULT_ATTR = ["mipormipidip", "packageNum", "serialNo", "time", "ttl", "rtnCode", "subRtnCode"];
var PING_TIMEOUT_ATTR = [];
var PING_STATISTIC_ATTR = ["sendNum", "revNum", "lostPer", "minTimeout", "maxTimeout", "averageTimeout"];
var isTesting = false;//       
var isBack = true;
var megtype = "";
if (indexName == "tunnelindex")
{
	megtype = "1";
}
else
{
	megtype = "2";
}

function init()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attributeName"], RESOURCE["attributeValue"]);

    var atom = new Atom("text");
    ct.addAttrRow("megid", RESOURCE["megidres"], atom);
    atom.element.disabled = true;
    if( isID_AccordingTo_MegIdType() )
    {
    	var shortname = getMegID();
    	if( shortname.length > 13 )
    	{
    		shortname = shortname.substring(0, 12) + "...";
    	}
    	atom.setValue( shortname );
    }
    else
    {
    	atom.setValue( "-" );
    }
    
    atom = new Atom("text");
    ct.addAttrRow("localmegid", RESOURCE["localmegidres"], atom);
    atom.element.disabled = true;
    if( isID_AccordingTo_MegIdType() )
    {
    	atom.setValue( getLocalMegID() );
    }
    else
    {
    	atom.setValue( "-" );
    }

    
    atom = new Atom("select");
    atom.addOption(RESOURCE["mplstpoammep"], "1");
    atom.addOption(RESOURCE["mplstpoammip"], "2");
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom);
    
    atom = new Atom("text");
    if( isID_AccordingTo_MegIdType() )
    {
        atom.setValue("1");
        checkText(atom.element, "1", "8191");
    }
    else
    {
      atom.setValue("0.0.0.0");
      validateIpForU2000Style(atom.element);    	
    }
    ct.addAttrRow("mipormipidip", RESOURCE["mipormipidipres"], atom);
    
    atom = new Atom("text");
    atom.setValue("3");
    checkText(atom.element, "1", "65535");
    ct.addAttrRow("packageCount", RESOURCE["packageCount"], atom);
    
    atom = new Atom("select");
    atom.addOption("1", "1");
    atom.addOption("2", "2");
    atom.addOption("3", "3");
    atom.addOption("4", "4");
    atom.addOption("5", "5");
    atom.addOption("6", "6");
    atom.addOption("7", "7");
    atom.element.options.selectedIndex = 6;
    ct.addAttrRow("packagePri", RESOURCE["packagePri"], atom);
    
    atom = new Atom("text");
    atom.setValue("255");
    checkText(atom.element, "1", "255");
    ct.addAttrRow("ttl", RESOURCE["TTL"], atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["sendPeriodLB1"], "1");
    atom.addOption(RESOURCE["sendPeriodLB2"], "2");
    atom.addOption(RESOURCE["sendPeriodLB3"], "3");
    ct.addAttrRow("sendPeriod", RESOURCE["sendPeriodLB"], atom);
    
    atom = new Atom("text");
    atom.setValue("128");
    checkText(atom.element, "128", "1450");
    ct.addAttrRow("packageLength", RESOURCE["packageLength"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
    
    $("starttest").value = RESOURCE["startTest"];
    $("stoptest").value = RESOURCE["stopTest"];
    $("stoptest").disabled = true;
    $("testResultShow").innerHTML = RESOURCE["testResult"];
}


function createStartXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("tunnelindex", indexValue));
    rowparams.appendChild(createTagElement("indexName", "tunnelindex"));
    rowparams.appendChild(createTagElement("megtype", megtype));
    rowparams.appendChild(createTagElement("nodetype", ct.getAtom("nodetype").getValue()));
    
    var mipormipidip = isID_AccordingTo_MegIdType() ? ct.getAtom("mipormipidip").getValue() : convertIPToTen(ct.getAtom("mipormipidip").getValue());
    rowparams.appendChild(createTagElement("mipormipidip", mipormipidip));
    
    rowparams.appendChild(createTagElement("ttl", ct.getAtom("ttl").getValue()));
    rowparams.appendChild(createTagElement("packageCount", ct.getAtom("packageCount").getValue()));
    rowparams.appendChild(createTagElement("packageLength", ct.getAtom("packageLength").getValue()));
    rowparams.appendChild(createTagElement("sendPeriod", ct.getAtom("sendPeriod").getValue()));
    rowparams.appendChild(createTagElement("packagePri", ct.getAtom("packagePri").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStartTest()
{
    $("starttest").disabled = true;
    $("stoptest").disabled = true;
    isBack = true;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    idValue = win.st.getCellStoreValue(selectedPw[0], idName, idName);
    var xml = createStartXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + START_LB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, startCallBack, null, "inputdata=" + xml);
}

function startCallBack(doc)
{
    var data = EncapsulateData(doc);
	
	var testRow = win.st.getSelectedRows()[0];
	var testId = win.st.getCellStoreValue(testRow, idName, idName);
	var errArr = [];
    errArr[0] = "nename";
	
	for(var i = 0; i < data.getError().rowErrors.length; i++)
	{
		var rowError = data.getError().rowErrors[i];
		rowError.errorObj["testId"] = RESOURCE[idNameRes] + testId;
		errArr[1] = "testId";
		break;
	}
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        $("stoptest").disabled = false;
        $("testresult").innerHTML = "";
        intervalID = setInterval(refreshPingResult, 1000);
		isTesting = true;
    }
    else 
    {
        $("starttest").disabled = false;
		isTesting = false;
    }
}

function createRereshXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", "tunnelindex"));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function refreshPingResult()
{
    if(!isBack)
    {
    	 return;
    }
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createRereshXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=2012042616&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
    isBack = false;
}

function refreshBackHandler(doc)
{
    var data = EncapsulateData(doc);
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var eventType = data.getDataRowParam(i, "eventType");
        var eventTypeRes = RESOURCE["splitStr"] + " " + RESOURCE["lbtesttype"] + RESOURCE["eventType_" + eventType] + " " + RESOURCE["splitStr"];
        var showInfo = "";
        
        switch (eventType)
        {
            case "0":
                showInfo = getShowInfo(data, i, PING_RESULT_ATTR);
                break;
            case "1":
                showInfo = getShowInfo(data, i, PING_TIMEOUT_ATTR);
                break;
            case "2":
                clearInterval(intervalID);
                showInfo = getShowInfo(data, i, PING_STATISTIC_ATTR);
                $("starttest").disabled = false;
                $("stoptest").disabled = true;
				isTesting = false;
                break;
            default:
                break;
        }
        
        if (showInfo != "") 
        {
            showInfo = eventTypeRes + "<br/>" + showInfo;
            var e = document.createElement("div");
            e.align = "left";
            e.innerHTML = showInfo;
            $("testresult").appendChild(e);
        }
    }
    isBack = true;
}

function getShowInfo(data, index, attrArr)
{
    var tempInfo = RESOURCE[idNameRes] + idValue + "<br/>";
   
    for (var i = 0; i < attrArr.length; i++) 
    {
        var attrValue = data.getDataRowParam(index, attrArr[i]);
        
        /**lsrId IP                              IP   
         **    DTS2011081001243 
         **/
         /**
          * DTS2012122805074 
          *          IP      MEG ID Type IP         IP  
          */
        if(attrArr[i] == 'mipormipidip' && !isID_AccordingTo_MegIdType())
        {
            attrValue = convertNumToIpaddr(attrValue);
        }
        
        tempInfo = tempInfo + RESOURCE[attrArr[i]] + attrValue + "<br/>";
    }
    
    return tempInfo + "<br/>";
}


function createStopXML(indexValue)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("index", indexValue));
    rowparams.appendChild(createTagElement("indexName", indexName));
    rowparams.appendChild(createTagElement("tunnelindex", indexValue));
    rowparams.appendChild(createTagElement("megtype", megtype));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doStopTest()
{
    $("stoptest").disabled = false;
    var selectedPw = win.st.getSelectedRows();
    var indexValue = win.st.getCellStoreValue(selectedPw[0], indexName, indexName);
    var xml = createStopXML(indexValue);
    var url = "../../../../../neExlorerServlet?sfid=" + STOP_LB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, stopCallBack, null, "inputdata=" + xml);
}

function stopCallBack(doc)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0) 
    {
        clearInterval(intervalID);
        $("starttest").disabled = false;
        $("stoptest").disabled = true;
		isTesting = false;
    }
    else
    {
        $("stoptest").disabled = false;
    }
}

/**
 *           
 */
window.onbeforeunload = function()
{
    if (isTesting) 
    {
        if (confirm(RESOURCE["stopTestTips"])) 
        {
            doStopTest();
        }
    }
}

/**
 * 
 * @return
 */
function isID_AccordingTo_MegIdType()
{
    var selectedRecord = win.st.getSelectedRows();
    var value = win.st.getCellStoreValue(selectedRecord[0], "megidtype", "megidtype");
    if( value == 2 || value == 3 )
    {
    	return true;
    }
    else
    {
    	return false;
    }
}

function getMegID()
{
    var selectedRecord = win.st.getSelectedRows();
    var value = win.st.getCellStoreValue(selectedRecord[0], "megid", "megid");
    return value;
}

function getLocalMegID()
{
    var selectedRecord = win.st.getSelectedRows();
    var value = win.st.getCellStoreValue(selectedRecord[0], "mepormipid", "mepormipid");
    return value;
}
