var ct = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var portRes = win.portRes;

var INVALID_SLOT = 0xFFFF;

var thisneversion = getParentWindow().winobj.neversion;
var versionArr = thisneversion.split(".");
var isR1C03 = false;
var isR3C03 = false;
if( versionArr[2] == "01" && versionArr[3] >= "30" )
{
	isR1C03 = true;
}
if( (versionArr[2] + "." + versionArr[3]) >= "03.40" && (versionArr[2] + "." + versionArr[3]) <= "05.10")
{
	isR3C03 = true;
}

var isSupportPirEditFlag = isSupportPirEdit();

function isSupportPirEdit()
{
	return SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_TUNNEL", "TE_ATTR_SUPPORT_TUNNEL_PIR_EDIT");
}

function init()
{
    initTable();
    initText();
    
    fillBoard("outboard");
    changeBoard("outboard", "inboard", "outport", "inport");
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"], RESOURCE["negativevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "65535");
    var atom2 = new Atom("text");
    checkText(atom2.element, "1", "65535");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkTextData(atom1.element, 64);
    atom2 = new Atom("text");
    checkTextData(atom2.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["ingress"], 1);
    atom1.addOption(RESOURCE["transit"], 2);
    atom1.addOption(RESOURCE["egress"], 3);
    atom1.element.onchange = changeNodeType;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["ingress"], 1);
    atom2.addOption(RESOURCE["transit"], 2);
    atom2.addOption(RESOURCE["egress"], 3);
    atom2.element.onchange = changeNodeType;
    atom2.element.options.selectedIndex = 2;
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["unidirectional"], 0);
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["unidirectional"], 0);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1, atom2);
    
   
    atom1 = new Atom("combobox");
    atom2 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["cir"], atom1, atom2);
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    
    atom2.element.parent.selview.disabled = true;
    atom2.element.parent.txtview.disabled = true;
    atom2.element.parent.initComboBox(getDataArr(), "dm1", 0, true);
    addOptionToSelect(atom2.element.parent.selview, new Option("-", "-"));
    atom2.element.parent.setSelectedIndex(18);
    atom2.element.parent.txtview.onkeypress = keypressHandler;
    atom2.element.parent.txtview.onkeyup = keyupHandler;
    atom2.element.parent.txtview.onblur = onblurHandler;
    atom2.element.parent.txtview.style.imeMode = "disabled";
    atom2.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom1 = new Atom("combobox");
    atom2 = new Atom("combobox");
    ct.addAttrRow("pir", RESOURCE["pir"], atom1, atom2);
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    if(!isSupportPirEditFlag)
    {
    	atom1.element.parent.selview.disabled = true;
        atom1.element.parent.txtview.disabled = true;
    	addOptionToSelect(atom1.element.parent.selview, new Option("-", "-"));
    	atom1.element.parent.setSelectedIndex(18);
    }
    
    atom2.element.parent.selview.disabled = true;
    atom2.element.parent.txtview.disabled = true;
    atom2.element.parent.initComboBox(getDataArr(), "dm1", 0, true);
    addOptionToSelect(atom2.element.parent.selview, new Option("-", "-"));
    atom2.element.parent.setSelectedIndex(18);
    atom2.element.parent.txtview.onkeypress = keypressHandler;
    atom2.element.parent.txtview.onkeyup = keyupHandler;
    atom2.element.parent.txtview.onblur = onblurHandler;
    atom2.element.parent.txtview.style.imeMode = "disabled";
    atom2.element.parent.txtview.onpaste = function()
    {
        return false;
    };

    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
		atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
		atom2.setValue("-");
    ct.addAttrRow("cbs", RESOURCE["cbs"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
		atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
		atom2.setValue("-");
    ct.addAttrRow("pbs", RESOURCE["pbs"], atom1, atom2);
    
     
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changeBoard("inboard", "outboard", "inport", "outport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changePort("inport", "outport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("inport", RESOURCE["inport"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("inlabel", RESOURCE["inlabel"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changeBoard("outboard", "inboard", "outport", "inport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("outboard", RESOURCE["outboard"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changePort("outport", "inport");
    };
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    ct.addAttrRow("outport", RESOURCE["outport"], atom1, atom2);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    checkText(atom2.element, "16", "1048575");
    ct.addAttrRow("outlabel", RESOURCE["outlabel"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateIp(atom1.element);
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("nexthopaddr", RESOURCE["nexthopaddr"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    validateNode(atom1.element, false, "snknode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1, atom2);
    
    atom1 = new Atom("text");
    validateNode(atom1.element, false, "srcnode");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["elsp"], 0);
	var notSupport = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTSUPPORT_LLSP");
    if( !isR1C03 && !isR3C03 && !notSupport)
    {
    	atom1.addOption(RESOURCE["llsp"], 1);
    }
    atom2 = new Atom("select");
    atom2.addOption(RESOURCE["elsp"], 0);
    if( !isR1C03 && !isR3C03 && !notSupport)
    {
    	atom2.addOption(RESOURCE["llsp"], 1);
    }
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["exp0"], 0);
    atom1.addOption(RESOURCE["exp1"], 1);
    atom1.addOption(RESOURCE["exp2"], 2);
    atom1.addOption(RESOURCE["exp3"], 3);
    atom1.addOption(RESOURCE["exp4"], 4);
    atom1.addOption(RESOURCE["exp5"], 5);
    atom1.addOption(RESOURCE["exp6"], 6);
    atom1.addOption(RESOURCE["exp7"], 7);
    atom1.addOption(RESOURCE["exp255"], 255);
    atom1.element.options.selectedIndex = 8;
    atom2 = new Atom("select");
    atom2.element.disabled = true;
    atom2.addOption(RESOURCE["exp0"], 0);
    atom2.addOption(RESOURCE["exp1"], 1);
    atom2.addOption(RESOURCE["exp2"], 2);
    atom2.addOption(RESOURCE["exp3"], 3);
    atom2.addOption(RESOURCE["exp4"], 4);
    atom2.addOption(RESOURCE["exp5"], 5);
    atom2.addOption(RESOURCE["exp6"], 6);
    atom2.addOption(RESOURCE["exp7"], 7);
    atom2.addOption(RESOURCE["exp255"], 255);
    atom2.addOption("-", 0);
    atom2.element.options.selectedIndex = 9;
    ct.addAttrRow("exp", RESOURCE["exp"], atom1, atom2);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
	atom1.addOption("-", "-");
    atom2 = new Atom("select");
    atom2.addOption(RESOURCE["lspmode_1"], 1);
    atom2.addOption(RESOURCE["lspmode_2"], 2);
    ct.addAttrRow("lspmode", RESOURCE["lspmode"], atom1, atom2);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    atom2 = new Atom("text");
    atom2.element.disabled = true;
	atom2.setValue("-");
    ct.addAttrRow("mtu", "MTU", atom1, atom2);

}

function initText()
{
    $("reverse").innerHTML = RESOURCE["newreversetunnel"];
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("copybtn").value = RESOURCE["copybutton"];
}

function reverse()
{
    if ($("isreverse").checked) 
    {
        setDisplay("33%", "");
        setComboboxStyle(0);
        setComboboxStyle(1);
    }
    else 
    {
        setDisplay("50%", "none");
        setComboboxStyle(0);
    }
}

function setDisplay(width, display)
{
    ct.element.childNodes[0].childNodes[0].childNodes[0].style.width = width;
    ct.element.childNodes[0].childNodes[0].childNodes[1].style.width = width;
    ct.element.childNodes[0].childNodes[0].childNodes[2].style.display = display;
    
    var childNodes = ct.element.childNodes[1].childNodes;
    for (var i = 0, m = childNodes.length; i < m; i++) 
    {
        childNodes[i].childNodes[0].style.width = width;
        childNodes[i].childNodes[1].style.width = width;
        childNodes[i].childNodes[2].style.display = display;
    }
}

function setComboboxStyle(index)
{
    var elem = ct.getAtom("bandwidth", index).element.parent;
    var wdt = elem.view.parentNode.offsetWidth - 2;
    var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
    
    elem.txtview.style.width = wdt;
    elem.selview.style.width = wdt;
    elem.selview.style.clip = clip;
    
    var elempir = ct.getAtom("pir", index).element.parent;
    var wdtpir = elempir.view.parentNode.offsetWidth - 2;
    var clippir = "rect(1px," + (wdtpir - 1) + "px,19px," + (wdtpir - 18) + "px)";
    
    elempir.txtview.style.width = wdtpir;
    elempir.selview.style.width = wdtpir;
    elempir.selview.style.clip = clippir;
}

function changeNodeType()
{
    var atom = null;
    var tmpAtom = null;
    var selView = null;
    var sIndex = -1;
    var option = null;
    switch (parseInt(this.value))
    {
        case NODE_TYPE_INGRESS:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 0);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("outboard", 0);
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp", 0);
            atom.element.options.length -= 1;
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = false;
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 2;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
            atom = ct.getAtom("pir", 1);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("lspmode", 0);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
   			
            atom = ct.getAtom("lspmode", 1);
            atom.element.options.length = 0;
            atom.addOption(RESOURCE["lspmode_1"], 1);
   			atom.addOption(RESOURCE["lspmode_2"], 2);
   			atom.element.disabled = false;
            break;
        case NODE_TYPE_TRANSIT:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 0);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 0);
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 0);
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp", 0);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 1;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 1);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 1);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("outport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("lspmode", 0);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
   			atom.element.disabled = true;
   			
            atom = ct.getAtom("lspmode", 1);
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.disabled = true;
            
            break;
        case NODE_TYPE_EGRESS:
            atom = ct.getAtom("bandwidth", 0);
            selView = atom.element.parent.selview;
            if (!selView.disabled) 
            {
                selView.disabled = true;
                atom.element.parent.txtview.disabled = true;
                
                addOptionToSelect(selView, new Option("-", "-"));
                atom.element.parent.setSelectedIndex(18);
            }
            
                atom = ct.getAtom("pir", 0);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            
            atom = ct.getAtom("inboard", 0);
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport", 0);
            atom.element.disabled = false;
            
            atom = ct.getAtom("inlabel", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 0);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("nexthopaddr", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("srcnode", 0);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode", 0);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 0);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            
            atom = ct.getAtom("nodetype", 1);
            atom.element.options.selectedIndex = 0;
            
            atom = ct.getAtom("bandwidth", 1);
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir", 1);
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir", 1);
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport", 1);
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inlabel", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("outboard", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inboard", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport", 1);
            atom.element.options.length = 0;
            tmpAtom = ct.getAtom("inport", 0);
            sIndex = tmpAtom.element.options.selectedIndex;
            if (sIndex >= 0) 
            {
                option = tmpAtom.element.options[sIndex];
                atom.addOption(option.text, option.value);
            }
            atom.element.disabled = true;
            
            atom = ct.getAtom("outlabel", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("nexthopaddr", 1);
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode", 1);
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp", 1);
            atom.element.options.length -= 1;
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = false;
            
            atom = ct.getAtom("lspmode", 0);
            atom.element.options.length = 0;
            atom.addOption(RESOURCE["lspmode_1"], 1);
   			atom.addOption(RESOURCE["lspmode_2"], 2);
   			atom.element.disabled = false;
   			
            atom = ct.getAtom("lspmode", 1);
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            break;
        default:
            break;
    }
}

function changeBoard(b1, b2, p1, p2)
{
    var atom = ct.getAtom(b1, 0);
    var index = atom.element.options.selectedIndex;
    if (index < 0) 
    {
        return;
    }
    var option = atom.element.options[index];
    var slotId = option.value;
    var board = option.text;
    
    var bdName = null;
    atom = ct.getAtom(p1, 0);
    atom.element.options.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        if (board == bdName) 
        {
            atom.addOption(portObj.portName, portObj.portId);
        }
    }
    
    ct.getAtom(b2, 1).element.options.length = 0;
    ct.getAtom(b2, 1).addOption(board, slotId);
    
    changePort(p1, p2);
}

function changePort(p1, p2)
{
    var atom = ct.getAtom(p1, 0);
    var option = atom.element.options[atom.element.options.selectedIndex];
    
    ct.getAtom(p2, 1).element.options.length = 0;
    ct.getAtom(p2, 1).addOption(option.text, option.value);
}

function changeSrcNode()
{
    ct.getAtom("snknode", 1).setValue(ct.getAtom("srcnode", 0).getValue());
}

function changeSnkNode()
{
    ct.getAtom("srcnode", 1).setValue(ct.getAtom("snknode", 0).getValue());
}

function fillBoard(board)
{
    var atom = ct.getAtom(board, 0);
    atom.element.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.addOption(bdName, portObj.slotId);
        }
    }
}

function validate(index)
{
    var atom = ct.getAtom("tunnelid", index);
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    atom = ct.getAtom("inlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("outlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    
    atom = ct.getAtom("nexthopaddr", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
        /*
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }*/
    }
    
    atom = ct.getAtom("srcnode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsrcnode"]);
            return false;
        }
        
        /*DTS2010081202095 
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }*/
    }
    
    atom = ct.getAtom("snknode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
         /*DTS2010081202095 
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }*/
    }
    
    return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    bussiness.appendChild(createRowParams(0));
    if ($("isreverse").checked) 
    {
        bussiness.appendChild(createRowParams(1));
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("auto", 1));
    rowparams.appendChild(createTagElement("autoassign", 2));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    rowparams.appendChild(createTagElement("tunnelid", ct.getAtom("tunnelid", index).getValue()));
    var tunnelName = ct.getAtom("tunnelname", index).getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction", index).getValue()));
	var tunneltype = parseInt(ct.getAtom("tunneltype", index).getValue());
	rowparams.appendChild(createTagElement("tunneltype", tunneltype));
    if(0 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 255));//     ?lsp,      (0xFF)
	}
	else if(1 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 1));//     ?lsp,1 be,2 af1,3 af2,4 af3,5 af4,6 ef,7 cs6,8 cs7
	}
	
    var nodeType = parseInt(ct.getAtom("nodetype", index).getValue());
    rowparams.appendChild(createTagElement("nodetype", nodeType));
    
    var slotId = -1;
    var atom = null;
    var bandwidth = ct.getAtom("bandwidth", index).getValue();
    var pir = ct.getAtom("pir", index).getValue();
    var nextHopAddr = ct.getAtom("nexthopaddr", index).getValue();
    var srcNode = ct.getAtom("srcnode", index).getValue();
    var snkNode = ct.getAtom("snknode", index).getValue();
    var iOptions = ct.getAtom("inboard", index).element.options;
    var oOptions = ct.getAtom("outboard", index).element.options;
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            rowparams.appendChild(createTagElement("insubslotid", 0));
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport", index);
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp", index).getValue()));       
            break;
        case NODE_TYPE_TRANSIT:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport", index);
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("outlabel", index).getValue()));
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport", index);
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            break;
        case NODE_TYPE_EGRESS:
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport", index);
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel", index).getValue()));
            rowparams.appendChild(createTagElement("outsubslotid", 0));
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            rowparams.appendChild(createTagElement("lspmode", ct.getAtom("lspmode", index).getValue()));
            break;
        default:
            break;
    }
    return rowparams;
}

function doCreate(param)
{
    if (!validate(0)) 
    {
        return;
    }
    else if ($("isreverse").checked && !validate(1)) 
    {
        return;
    }
    var xml = createTunnelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (param && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
        else 
        {
            refreshData();
        }
    }
}

function refreshData()
{
    ct.getAtom("tunnelid", 0).setValue("");
    ct.getAtom("tunnelid", 1).setValue("");
}

function CTable()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid)
    {
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index)
    {
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value)
    {
        if (this.attrArray[attrid][index]) 
        {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index)
    {
        if (this.attrArray[attrid][index]) 
        {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function()
    {
        return this.element;
    }
}

function validateNode(obj)
{
    var stCall = false;
    var nodeType = "";
    if (arguments.length > 1) 
    {
        stCall = arguments[1];
        nodeType = arguments[2];
    }
    
    var oedit = obj;
    oedit.maxLength = maxbyte;
    oedit.style.imeMode = "disabled"; //       ?
    oedit.onpaste = function()
    {
        return false;
    }
    
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        if (code == 8) 
        {
            return true;
        }
        
        var objIp = oedit;
        var existstring = objIp.value;
        var curInput = String.fromCharCode(code);
        if (event.keyCode == 13) 
        {
            objIp.onblur();
        }
        if (((code < 48 || code > 57) && code != splitcharcode) ||
        (code == splitcharcode && existstring.charCodeAt(existstring.length - 1) == splitcharcode) ||
        (code == splitcharcode && existstring.length == 0)) 
        {
            return false;
        }
        
        var tagPosition = digitalTag_getPos(objIp);
        
        var str1 = existstring.substring(0, tagPosition);
        var str2 = existstring.substring(tagPosition, existstring.length);
        existstring = str1 + curInput + str2;
        
        var aryIp = existstring.split(splitchar);
        
        if (aryIp.length > 4) 
        {
            return false;
        }
        
        /* a.b.c.d                    ? ?*/
        var dot1 = existstring.indexOf(splitchar);
        var dot2 = existstring.indexOf(splitchar, dot1 + 1);
        var dot3 = existstring.indexOf(splitchar, dot2 + 1);
        var dot4 = existstring.indexOf(splitchar, dot3 + 1);
        
        if (dot1 < 0) 
        {
            if (existstring.length == 3) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > 3 && (selectionLen(ojbIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot2 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot1 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot1 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot3 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot2 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot2 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot4 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot3 && existstring.substring(dot2 + 1, dot3).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length > maxbyte) 
            {
                if ((selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
            else if (existstring.length == dot3 + 5) 
            {
                tagPosition = digitalTag_getPos(objIp);
                if (tagPosition > dot3 && (selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
        }
    }
    
    /**
     *     P                           255           ?55
     */
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var objIp = event.srcElement;
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] != "") 
            {
                aryIp[i] = parseInt(aryIp[i], 10);
            }
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue;
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
    }
    
    oedit.onblur = function()
    {
        var event = EventUtil.getEvent();
        
        var objIp = event.srcElement;
        if (objIp.value == "") 
        {
            alert(RESOURCE["format"]);
            objIp.value = "0.0.0.0";
            if (stCall) 
            {
                cellonblur(objIp);
            }
            ct.getAtom(nodeType, 1).setValue(objIp.value);
            return;
        }
        
        objIp.value = formFullAddr(objIp.value);
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
        
        if (stCall) 
        {
            cellonblur(objIp);
        }
        ct.getAtom(nodeType, 1).setValue(objIp.value);
    }
}


function resizeComponentWidth()
{
	if ($("isreverse").checked) 
    {
        setDisplay("33%", "");
        setComboboxStyle(0);
        setComboboxStyle(1);
    }
    else 
    {
        setDisplay("50%", "none");
        setComboboxStyle(0);
    }

}
